/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.remote.RemoteProcess;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.BaseOutputReader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseRemoteProcessHandler<T extends RemoteProcess>
extends BaseProcessHandler<T> {
    private static final Logger LOG = Logger.getInstance(BaseRemoteProcessHandler.class);
    private final ModalityState myModality;

    public BaseRemoteProcessHandler(@NotNull T process, String commandLine, @Nullable Charset charset) {
        if (process == null) {
            BaseRemoteProcessHandler.$$$reportNull$$$0(0);
        }
        super(process, commandLine, charset);
        this.myModality = OSProcessHandler.getDefaultModality();
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        return new BaseOutputReader.Options();
    }

    protected void destroyProcessImpl() {
        if (!((RemoteProcess)this.myProcess).killProcessTree()) {
            super.destroyProcessImpl();
        }
    }

    protected void onOSProcessTerminated(int exitCode) {
        if (this.myModality != ModalityState.nonModal()) {
            ProgressManager.getInstance().runProcess(() -> super.onOSProcessTerminated(exitCode), (ProgressIndicator)new EmptyProgressIndicator(this.myModality));
        } else {
            super.onOSProcessTerminated(exitCode);
        }
    }

    public void startNotify() {
        this.notifyTextAvailable(this.getCommandLineForLog() + "\n", ProcessOutputTypes.SYSTEM);
        this.addProcessListener(new ProcessListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    RemoteOutputReader stdoutReader = new RemoteOutputReader(((RemoteProcess)BaseRemoteProcessHandler.this.myProcess).getInputStream(), BaseRemoteProcessHandler.this.getCharset(), (RemoteProcess)BaseRemoteProcessHandler.this.myProcess, BaseRemoteProcessHandler.this.getCommandLineForLog(), BaseRemoteProcessHandler.this.readerOptions()){

                        protected void onTextAvailable(@NotNull String text2) {
                            if (text2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            BaseRemoteProcessHandler.this.notifyTextAvailable(text2, ProcessOutputTypes.STDOUT);
                        }

                        @NotNull
                        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
                            if (runnable == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            Future<?> future = BaseRemoteProcessHandler.this.executeTask(runnable);
                            if (future == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return future;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 2 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "text";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "runnable";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/remote/BaseRemoteProcessHandler$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/remote/BaseRemoteProcessHandler$1$1";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "executeOnPooledThread";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "onTextAvailable";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray;
                                    objectArray[2] = "executeOnPooledThread";
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string);
                                case 2 -> new IllegalStateException(string);
                            };
                        }
                    };
                    RemoteOutputReader stderrReader = new RemoteOutputReader(((RemoteProcess)BaseRemoteProcessHandler.this.myProcess).getErrorStream(), BaseRemoteProcessHandler.this.getCharset(), (RemoteProcess)BaseRemoteProcessHandler.this.myProcess, BaseRemoteProcessHandler.this.getCommandLineForLog(), BaseRemoteProcessHandler.this.readerOptions()){

                        protected void onTextAvailable(@NotNull String text2) {
                            if (text2 == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            BaseRemoteProcessHandler.this.notifyTextAvailable(text2, ProcessOutputTypes.STDERR);
                        }

                        @NotNull
                        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
                            if (runnable == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            Future<?> future = BaseRemoteProcessHandler.this.executeTask(runnable);
                            if (future == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            return future;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 2 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "text";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "runnable";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/remote/BaseRemoteProcessHandler$1$2";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/remote/BaseRemoteProcessHandler$1$2";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "executeOnPooledThread";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "onTextAvailable";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray;
                                    objectArray[2] = "executeOnPooledThread";
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string);
                                case 2 -> new IllegalStateException(string);
                            };
                        }
                    };
                    BaseRemoteProcessHandler.this.myWaitFor.setTerminationCallback(arg_0 -> this.lambda$startNotified$0(stderrReader, stdoutReader, arg_0));
                }
                finally {
                    BaseRemoteProcessHandler.this.removeProcessListener(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private /* synthetic */ void lambda$startNotified$0(2 stderrReader, 1 stdoutReader, Integer exitCode) {
                try {
                    try {
                        stderrReader.waitFor();
                        stdoutReader.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                finally {
                    BaseRemoteProcessHandler.this.onOSProcessTerminated(exitCode);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/remote/BaseRemoteProcessHandler$1", "startNotified"));
            }
        });
        super.startNotify();
    }

    @NotNull
    public Future<?> executeTask(@NotNull Runnable task2) {
        if (task2 == null) {
            BaseRemoteProcessHandler.$$$reportNull$$$0(1);
        }
        Future<?> future = AppExecutorUtil.getAppExecutorService().submit(task2);
        if (future == null) {
            BaseRemoteProcessHandler.$$$reportNull$$$0(2);
        }
        return future;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/BaseRemoteProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/BaseRemoteProcessHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "executeTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static abstract class RemoteOutputReader
    extends BaseOutputReader {
        private final RemoteProcess myRemoteProcess;
        private boolean myClosed;

        RemoteOutputReader(InputStream inputStream, @Nullable Charset charset, RemoteProcess remoteProcess, String commandLine, BaseOutputReader.Options options) {
            super(inputStream, charset, options);
            this.myRemoteProcess = remoteProcess;
            this.start(CommandLineUtil.extractPresentableName((String)commandLine));
        }

        protected void doRun() {
            try {
                this.setClosed(false);
                while (true) {
                    boolean read = this.readAvailable();
                    if (this.myRemoteProcess.isDisconnected()) {
                        this.myReader.close();
                        break;
                    }
                    if (this.isStopped) {
                        break;
                    }
                    Thread.sleep(this.mySleepingPolicy.getTimeToSleep(read));
                }
            }
            catch (InterruptedException read) {
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            finally {
                this.setClosed(true);
            }
        }

        protected synchronized void setClosed(boolean closed) {
            this.myClosed = closed;
        }

        public void waitFor() throws InterruptedException {
            while (!this.isClosed()) {
                Thread.sleep(100L);
            }
        }

        private synchronized boolean isClosed() {
            return this.myClosed;
        }
    }
}

