/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.remoteDev.downloader.EmbeddedClientLauncher;
import com.intellij.remoteDev.downloader.FrontendInstallation;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/remoteDev/downloader/EmbeddedFrontendInstallation;", "Lcom/intellij/remoteDev/downloader/FrontendInstallation;", "frontendLauncher", "Lcom/intellij/remoteDev/downloader/EmbeddedClientLauncher;", "<init>", "(Lcom/intellij/remoteDev/downloader/EmbeddedClientLauncher;)V", "getFrontendLauncher", "()Lcom/intellij/remoteDev/downloader/EmbeddedClientLauncher;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "getBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "installationHome", "Ljava/nio/file/Path;", "getInstallationHome", "()Ljava/nio/file/Path;", "intellij.remoteDev.util"})
public final class EmbeddedFrontendInstallation
implements FrontendInstallation {
    @NotNull
    private final EmbeddedClientLauncher frontendLauncher;

    public EmbeddedFrontendInstallation(@NotNull EmbeddedClientLauncher frontendLauncher) {
        Intrinsics.checkNotNullParameter((Object)frontendLauncher, (String)"frontendLauncher");
        this.frontendLauncher = frontendLauncher;
    }

    @NotNull
    public final EmbeddedClientLauncher getFrontendLauncher() {
        return this.frontendLauncher;
    }

    @Override
    @NotNull
    public BuildNumber getBuildNumber() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild().withoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"withoutProductCode(...)");
        return buildNumber;
    }

    @Override
    @NotNull
    public Path getInstallationHome() {
        String string = PathManager.getHomePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHomePath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }
}

