/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.RemoteServerComboWithAutoDetect;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.util.Comparator;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeployToServerSettingsEditor<S extends ServerConfiguration, D extends DeploymentConfiguration>
extends SettingsEditor<DeployToServerRunConfiguration<S, D>> {
    private final DeploymentConfigurator<D, S> myDeploymentConfigurator;
    private final Project myProject;
    private final RemoteServerComboWithAutoDetect<S> myServerCombo;
    private final JPanel myDeploymentSettingsComponent;
    private SettingsEditor<D> myDeploymentSettingsEditor;
    private DeploymentSource myLastSelectedSource;
    private RemoteServer<S> myLastSelectedServer;
    private D myDeploymentConfiguration;

    public DeployToServerSettingsEditor(@NotNull ServerType<S> type, @NotNull DeploymentConfigurator<D, S> deploymentConfigurator, @NotNull Project project) {
        if (type == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(0);
        }
        if (deploymentConfigurator == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(2);
        }
        this.myDeploymentConfigurator = deploymentConfigurator;
        this.myProject = project;
        this.myServerCombo = new RemoteServerComboWithAutoDetect<S>(type);
        Disposer.register((Disposable)this, this.myServerCombo);
        this.myServerCombo.addChangeListener(e -> this.updateDeploymentSettingsEditor());
        this.myDeploymentSettingsComponent = new JPanel(new BorderLayout());
    }

    protected abstract DeploymentSource getSelectedSource();

    protected abstract void resetSelectedSourceFrom(@NotNull DeployToServerRunConfiguration<S, D> var1);

    protected final void updateDeploymentSettingsEditor() {
        RemoteServer selectedServer = this.myServerCombo.getSelectedServer();
        DeploymentSource selectedSource = this.getSelectedSource();
        if (Comparing.equal((Object)selectedSource, (Object)this.myLastSelectedSource) && Comparing.equal(selectedServer, this.myLastSelectedServer)) {
            return;
        }
        if (!Comparing.equal((Object)selectedSource, (Object)this.myLastSelectedSource)) {
            this.updateBeforeRunOptions(this.myLastSelectedSource, false);
            this.updateBeforeRunOptions(selectedSource, true);
        }
        if (selectedSource != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!Disposer.isDisposed((Disposable)this)) {
                    this.myDeploymentSettingsEditor = this.myDeploymentConfigurator.createEditor(selectedSource, selectedServer);
                    if (this.myDeploymentSettingsEditor != null) {
                        if (this.myDeploymentConfiguration != null) {
                            this.myDeploymentSettingsEditor.resetFrom(this.myDeploymentConfiguration);
                        }
                        this.myDeploymentSettingsEditor.addSettingsEditorListener(e -> this.fireEditorStateChanged());
                        Disposer.register((Disposable)this, this.myDeploymentSettingsEditor);
                        this.myDeploymentSettingsComponent.removeAll();
                        this.myDeploymentSettingsComponent.add("Center", this.myDeploymentSettingsEditor.getComponent());
                    }
                }
            });
        }
        this.myLastSelectedSource = selectedSource;
        this.myLastSelectedServer = selectedServer;
    }

    private void updateBeforeRunOptions(@Nullable DeploymentSource source, boolean selected) {
        if (source != null) {
            DeploymentSourceType<?> type = source.getType();
            type.updateBuildBeforeRunOption((JComponent)((Object)this.myServerCombo), this.myProject, source, selected);
        }
    }

    protected void resetEditorFrom(@NotNull DeployToServerRunConfiguration<S, D> configuration) {
        if (configuration == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(3);
        }
        this.myServerCombo.selectServerInCombo(configuration.getServerName());
        this.resetSelectedSourceFrom(configuration);
        D deploymentConfiguration = configuration.getDeploymentConfiguration();
        this.myDeploymentConfiguration = deploymentConfiguration;
        this.updateDeploymentSettingsEditor();
        if (deploymentConfiguration != null && this.myDeploymentSettingsEditor != null) {
            this.myDeploymentSettingsEditor.resetFrom(deploymentConfiguration);
        }
    }

    protected void applyEditorTo(@NotNull DeployToServerRunConfiguration<S, D> configuration) throws ConfigurationException {
        if (configuration == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(4);
        }
        this.updateDeploymentSettingsEditor();
        this.myServerCombo.validateAutoDetectedItem();
        configuration.setServerName(Optional.ofNullable(this.myServerCombo.getSelectedServer()).map(RemoteServer::getName).orElse(null));
        DeploymentSource deploymentSource = this.getSelectedSource();
        configuration.setDeploymentSource(deploymentSource);
        if (deploymentSource != null) {
            D deployment = configuration.getDeploymentConfiguration();
            if (deployment == null) {
                deployment = this.myDeploymentConfigurator.createDefaultConfiguration(deploymentSource);
                configuration.setDeploymentConfiguration(deployment);
            }
            this.myDeploymentConfiguration = deployment;
            if (this.myDeploymentSettingsEditor != null) {
                this.myDeploymentSettingsEditor.applyTo(deployment);
            }
        } else {
            configuration.setDeploymentConfiguration(null);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        FormBuilder builder = FormBuilder.createFormBuilder().addLabeledComponent(CloudBundle.message("label.text.server", new Object[0]), this.myServerCombo);
        this.addDeploymentSourceUi(builder);
        JPanel jPanel = builder.addComponentFillVertically((JComponent)this.myDeploymentSettingsComponent, 4).getPanel();
        if (jPanel == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    protected abstract void addDeploymentSourceUi(FormBuilder var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentConfigurator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class LockedSource<S extends ServerConfiguration, D extends DeploymentConfiguration>
    extends DeployToServerSettingsEditor<S, D> {
        private final DeploymentSource myLockedSource;

        public LockedSource(@NotNull ServerType<S> type, @NotNull DeploymentConfigurator<D, S> deploymentConfigurator, @NotNull Project project, @NotNull DeploymentSource lockedSource) {
            if (type == null) {
                LockedSource.$$$reportNull$$$0(0);
            }
            if (deploymentConfigurator == null) {
                LockedSource.$$$reportNull$$$0(1);
            }
            if (project == null) {
                LockedSource.$$$reportNull$$$0(2);
            }
            if (lockedSource == null) {
                LockedSource.$$$reportNull$$$0(3);
            }
            super(type, deploymentConfigurator, project);
            this.myLockedSource = lockedSource;
        }

        @Override
        protected void addDeploymentSourceUi(FormBuilder formBuilder) {
        }

        @Override
        protected void resetSelectedSourceFrom(@NotNull DeployToServerRunConfiguration<S, D> configuration) {
            if (configuration == null) {
                LockedSource.$$$reportNull$$$0(4);
            }
            assert (configuration.getDeploymentSource() == this.myLockedSource);
        }

        @Override
        protected DeploymentSource getSelectedSource() {
            return this.myLockedSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentConfigurator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lockedSource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor$LockedSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resetSelectedSourceFrom";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AnySource<S extends ServerConfiguration, D extends DeploymentConfiguration>
    extends DeployToServerSettingsEditor<S, D> {
        private final ComboBox<DeploymentSource> mySourceComboBox;
        private final SortedComboBoxModel<DeploymentSource> mySourceListModel = new SortedComboBoxModel(Comparator.comparing(DeploymentSource::getPresentableName, String.CASE_INSENSITIVE_ORDER));

        public AnySource(ServerType<S> type, DeploymentConfigurator<D, S> deploymentConfigurator, Project project) {
            super(type, deploymentConfigurator, project);
            this.mySourceListModel.addAll(deploymentConfigurator.getAvailableDeploymentSources());
            this.mySourceComboBox = new ComboBox(this.mySourceListModel);
            this.mySourceComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
                if (value == null) {
                    return;
                }
                label.setIcon(value.getIcon());
                label.setText(value.getPresentableName());
            }));
            this.mySourceComboBox.addActionListener(e -> this.updateDeploymentSettingsEditor());
        }

        @Override
        protected DeploymentSource getSelectedSource() {
            return (DeploymentSource)this.mySourceListModel.getSelectedItem();
        }

        @Override
        protected void resetSelectedSourceFrom(@NotNull DeployToServerRunConfiguration<S, D> configuration) {
            if (configuration == null) {
                AnySource.$$$reportNull$$$0(0);
            }
            this.mySourceComboBox.setSelectedItem((Object)configuration.getDeploymentSource());
        }

        @Override
        protected void addDeploymentSourceUi(FormBuilder formBuilder) {
            formBuilder.addLabeledComponent(CloudBundle.message("label.text.deployment", new Object[0]), this.mySourceComboBox);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor$AnySource", "resetSelectedSourceFrom"));
        }
    }
}

