/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.pom.Navigatable;
import com.intellij.usages.UsagePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Usage
extends Navigatable {
    public static final Usage[] EMPTY_ARRAY = new Usage[0];

    @NotNull
    public UsagePresentation getPresentation();

    public boolean isValid();

    public boolean isReadOnly();

    @Nullable
    public FileEditorLocation getLocation();

    public void selectInEditor();

    public void highlightInEditor();

    default public int getNavigationOffset() {
        FileEditorLocation location = this.getLocation();
        if (location instanceof TextEditorLocation) {
            TextEditorLocation tel = (TextEditorLocation)location;
            LogicalPosition position = tel.getPosition();
            return ((TextEditor)location.getEditor()).getEditor().logicalPositionToOffset(position);
        }
        return -1;
    }
}

