/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usages.NamedPresentably;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.rules.UsageGroupingRulesDefaultRanks;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.IconUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileGroupingRule
extends SingleParentUsageGroupingRule
implements DumbAware,
UsageGroupingRuleEx {
    private final Project myProject;
    private final boolean myShowShortFilePath;

    public FileGroupingRule(Project project, boolean showShortFilePath) {
        this.myProject = project;
        this.myShowShortFilePath = showShortFilePath;
    }

    @Override
    @Nullable
    public UsageGroup getParentGroupFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
        VirtualFile virtualFile;
        if (usage == null) {
            FileGroupingRule.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            FileGroupingRule.$$$reportNull$$$0(1);
        }
        if (usage instanceof UsageInFile && (virtualFile = ((UsageInFile)usage).getFile()) != null) {
            return new FileUsageGroup(this.myProject, virtualFile, this.myShowShortFilePath);
        }
        return null;
    }

    @Override
    public int getRank() {
        return UsageGroupingRulesDefaultRanks.FILE_STRUCTURE.getAbsoluteRank();
    }

    @Override
    @Nullable
    public String getGroupingActionId() {
        return "UsageGrouping.FileStructure";
    }

    @Override
    public boolean isGroupingActionInverted() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "usage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "targets";
                break;
            }
        }
        objectArray[1] = "com/intellij/usages/impl/rules/FileGroupingRule";
        objectArray[2] = "getParentGroupFor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FileUsageGroup
    implements UsageGroup,
    UiDataProvider,
    NamedPresentably {
        private final Project myProject;
        private final VirtualFile myFile;
        @NlsSafe
        private String myPresentableName;
        private Icon myIcon;
        private final boolean myShowShortFilePath;

        public FileUsageGroup(@NotNull Project project, @NotNull VirtualFile file, boolean showShortFilePath) {
            if (project == null) {
                FileUsageGroup.$$$reportNull$$$0(0);
            }
            if (file == null) {
                FileUsageGroup.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myFile = file instanceof VirtualFileWindow ? ((VirtualFileWindow)file).getDelegate() : file;
            this.myShowShortFilePath = showShortFilePath;
            this.myPresentableName = this.getAdjustedName();
            this.update();
        }

        private Icon getIconImpl() {
            return IconUtil.getIcon((VirtualFile)this.myFile, (int)2, (Project)this.myProject);
        }

        @Override
        public void update() {
            if (this.isValid()) {
                this.myIcon = this.getIconImpl();
                this.myPresentableName = this.getAdjustedName();
            }
        }

        @NlsSafe
        private String getAdjustedName() {
            return this.myShowShortFilePath ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(this.myProject, this.myFile) : this.myFile.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileUsageGroup)) {
                return false;
            }
            FileUsageGroup fileUsageGroup = (FileUsageGroup)o;
            return this.myFile.equals(fileUsageGroup.myFile);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        @Override
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        @NotNull
        public String getPresentableGroupText() {
            String string = this.myPresentableName;
            if (string == null) {
                FileUsageGroup.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return !this.myProject.isDisposed() && this.isValid() ? FileStatusManager.getInstance(this.myProject).getStatus(this.myFile) : null;
        }

        @Override
        public boolean isValid() {
            return this.myFile.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (!this.myProject.isDisposed()) {
                FileEditorManager.getInstance((Project)this.myProject).openFile(this.myFile, focus);
            }
        }

        public boolean canNavigate() {
            return this.myFile.isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        @Override
        public int compareTo(@NotNull UsageGroup otherGroup) {
            int compareTexts;
            if (otherGroup == null) {
                FileUsageGroup.$$$reportNull$$$0(3);
            }
            if ((compareTexts = this.getPresentableGroupText().compareToIgnoreCase(otherGroup.getPresentableGroupText())) != 0) {
                return compareTexts;
            }
            if (otherGroup instanceof FileUsageGroup) {
                return this.myFile.getPath().compareTo(((FileUsageGroup)otherGroup).myFile.getPath());
            }
            return 0;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                FileUsageGroup.$$$reportNull$$$0(4);
            }
            sink.set(CommonDataKeys.VIRTUAL_FILE, (Object)this.myFile);
            sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> this.getPsiFile());
        }

        @ApiStatus.Internal
        @Nullable
        public PsiFile getPsiFile() {
            return this.myFile.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(this.myFile) : null;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            String string = this.myPresentableName;
            if (string == null) {
                FileUsageGroup.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/FileGroupingRule$FileUsageGroup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherGroup";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/FileGroupingRule$FileUsageGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableGroupText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }
}

