/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.similarity.clustering;

import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.similarity.usageAdapter.SimilarUsage;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class UsageCluster {
    @NotNull
    private final @NotNull Set<@NotNull SimilarUsage> myUsages;

    public UsageCluster() {
        this.myUsages = new CopyOnWriteArraySet<SimilarUsage>();
    }

    public UsageCluster(@NotNull @NotNull Set<@NotNull SimilarUsage> usages) {
        if (usages == null) {
            UsageCluster.$$$reportNull$$$0(0);
        }
        this.myUsages = usages;
    }

    public void addUsage(@NotNull SimilarUsage usage) {
        if (usage == null) {
            UsageCluster.$$$reportNull$$$0(1);
        }
        this.myUsages.add(usage);
    }

    @NotNull
    public @NotNull @Unmodifiable Set<@NotNull SimilarUsage> getUsages() {
        Set<SimilarUsage> set = this.myUsages;
        if (set == null) {
            UsageCluster.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean contains(@Nullable UsageInfo usageInfo) {
        for (SimilarUsage usage : this.myUsages) {
            if (!usage.getUsageInfo().equals((Object)usageInfo)) continue;
            return true;
        }
        return false;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public @NotNull @Unmodifiable Set<@NotNull SimilarUsage> getOnlySelectedUsages(@NotNull @NotNull Set<@NotNull Usage> selectedUsages2) {
        if (selectedUsages2 == null) {
            UsageCluster.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertBackgroundThread();
        Set<SimilarUsage> set = this.myUsages.stream().filter(e -> selectedUsages2.contains(e)).collect(Collectors.toSet());
        if (set == null) {
            UsageCluster.$$$reportNull$$$0(4);
        }
        return set;
    }

    public String toString() {
        return "{\n" + this.myUsages.stream().map(usage -> usage.toString()).collect(Collectors.joining(",\n")) + "}\n";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/similarity/clustering/UsageCluster";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/similarity/clustering/UsageCluster";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnlySelectedUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addUsage";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOnlySelectedUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

