/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.errorAutoReport;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.ExceptionAutoReportUtil;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.errorAutoReport.ExceptionAutoReporter;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ApplicationKt;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.ThreadPoolDispatcherKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "exceptionHashMutex", "Lkotlinx/coroutines/sync/Mutex;", "exceptionHashSet", "Lit/unimi/dsi/fastutil/longs/LongLinkedOpenHashSet;", "numberOfReportedExceptions", "Ljava/util/concurrent/atomic/AtomicInteger;", "resendAttempts", "pluginIdToExceptionNumber", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "", "messages", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter$Message;", "sendMessages", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAlreadyReported", "", "message", "(Lcom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter$Message;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "newEntryConsumed", "Lcom/intellij/diagnostic/AbstractMessage;", "Companion", "Message", "Starter", "ErrorAutoReporterStateInternalAction", "intellij.platform.diagnostic.errorAutoReport"})
@SourceDebugExtension(value={"SMAP\nExceptionAutoReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionAutoReporter.kt\ncom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,227:1\n1696#2,8:228\n116#3,11:236\n116#3,11:247\n116#3,11:258\n23#4:269\n*S KotlinDebug\n*F\n+ 1 ExceptionAutoReporter.kt\ncom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter\n*L\n100#1:228,8\n128#1:236,11\n134#1:247,11\n146#1:258,11\n43#1:269\n*E\n"})
public final class ExceptionAutoReporter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Mutex exceptionHashMutex;
    @NotNull
    private final LongLinkedOpenHashSet exceptionHashSet;
    @NotNull
    private AtomicInteger numberOfReportedExceptions;
    @NotNull
    private final AtomicInteger resendAttempts;
    @NotNull
    private final Object2IntOpenHashMap<String> pluginIdToExceptionNumber;
    @NotNull
    private final Channel<Message> messages;
    private static final int HASH_SET_SIZE_LIMIT = 1000;
    private static final int ERRORS_BUFFER_SIZE = 1000;
    private static final long DEFAULT_SENDING_DELAY = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
    private static final long MAX_SENDING_DELAY = DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.HOURS);
    @NotNull
    private static final Logger LOG;

    public ExceptionAutoReporter(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.exceptionHashMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.exceptionHashSet = new LongLinkedOpenHashSet();
        this.numberOfReportedExceptions = new AtomicInteger(0);
        this.resendAttempts = new AtomicInteger(-1);
        this.pluginIdToExceptionNumber = new Object2IntOpenHashMap();
        this.messages = ChannelKt.Channel$default((int)1000, (BufferOverflow)BufferOverflow.SUSPEND, null, (int)4, null);
        if (ExceptionAutoReportUtil.INSTANCE.getAutoReportIsForbiddenForProduct()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
        CoroutineContext context = new CoroutineName("Reporting exceptions in background").plus((CoroutineContext)ThreadPoolDispatcherKt.newSingleThreadContext((String)"Context for reporting exceptions"));
        BuildersKt.launch$default((CoroutineScope)cs, (CoroutineContext)context, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            long J$0;
            Object L$0;
            int I$0;
            int label;
            final /* synthetic */ ExceptionAutoReporter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        delay = ExceptionAutoReporter.access$getDEFAULT_SENDING_DELAY$cp();
lbl7:
                        // 4 sources

                        while (true) {
                            this.L$0 = null;
                            this.J$0 = delay;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)delay, (Continuation)((Continuation)this));
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl19
                            break;
                        }
                    }
                    case 1: {
                        delay = this.J$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        toSend = new ArrayList<Message>(1000);
                        limit = 1000;
                        while (limit-- > 0 && (Message)ChannelResult.getOrNull-impl((Object)ExceptionAutoReporter.access$getMessages$p(this.this$0).tryReceive-PtdJZtk()) != null) {
                            toSend.add(message);
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable(toSend);
                        this.J$0 = delay;
                        this.I$0 = limit;
                        this.label = 2;
                        v1 = ExceptionAutoReporter.access$sendMessages(this.this$0, toSend, (Continuation)this);
                        if (v1 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl39
                    }
                    case 2: {
                        limit = this.I$0;
                        delay = this.J$0;
                        toSend = (ArrayList<Message>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl39:
                        // 2 sources

                        if (!(unsentMessages = (List)v1).isEmpty()) ** GOTO lbl43
                        delay = ExceptionAutoReporter.access$getDEFAULT_SENDING_DELAY$cp();
                        ExceptionAutoReporter.access$getResendAttempts$p(this.this$0).set(0);
                        ** GOTO lbl7
lbl43:
                        // 1 sources

                        delay = ((Duration)RangesKt.coerceAtMost((Comparable)Duration.box-impl((long)Duration.times-UwyO8pc((long)delay, (int)2)), (Comparable)Duration.box-impl((long)ExceptionAutoReporter.access$getMAX_SENDING_DELAY$cp()))).unbox-impl();
                        ExceptionAutoReporter.access$getResendAttempts$p(this.this$0).incrementAndGet();
                        var7_7 = unsentMessages.iterator();
                        do {
                            if (!var7_7.hasNext()) ** GOTO lbl7
                            message = (Message)var7_7.next();
                        } while (!ChannelResult.isFailure-impl((Object)(result = ExceptionAutoReporter.access$getMessages$p(this.this$0).trySend-JP2dKIU((Object)message))));
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object sendMessages(List<Message> messages, Continuation<? super List<Message>> $completion) {
        if (!($completion instanceof sendMessages.1)) ** GOTO lbl-1000
        var17_3 = $completion;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ ExceptionAutoReporter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ExceptionAutoReporter.access$sendMessages(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (messages.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                $this$distinctBy$iv = messages;
                $i$f$distinctBy = false;
                set$iv = new HashSet<E>();
                list$iv = new ArrayList<T>();
                for (T e$iv : $this$distinctBy$iv) {
                    it = (Message)e$iv;
                    $i$a$-distinctBy-ExceptionAutoReporter$sendMessages$distinctMessages$1 = false;
                    key$iv = Boxing.boxLong((long)it.getHash());
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                distinctMessages = list$iv;
                reportFailed = 0;
                unsentMessages = new ArrayList<E>();
                set$iv = distinctMessages.iterator();
lbl30:
                // 6 sources

                while (set$iv.hasNext()) {
                    message = (Message)set$iv.next();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)messages);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distinctMessages);
                    $continuation.L$2 = unsentMessages;
                    $continuation.L$3 = set$iv;
                    $continuation.L$4 = message;
                    $continuation.L$5 = null;
                    $continuation.L$6 = null;
                    $continuation.L$7 = null;
                    $continuation.I$0 = reportFailed;
                    $continuation.label = 1;
                    v0 = this.isAlreadyReported(message, (Continuation<? super Boolean>)$continuation);
                    if (v0 == var18_5) {
                        return var18_5;
                    }
                    ** GOTO lbl56
                }
                break;
            }
            case 1: {
                reportFailed = $continuation.I$0;
                message = (Message)$continuation.L$4;
                set$iv = (Iterator)$continuation.L$3;
                unsentMessages = (List)$continuation.L$2;
                distinctMessages = (List)$continuation.L$1;
                messages = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl56:
                // 2 sources

                if (((Boolean)v0).booleanValue()) ** GOTO lbl30
                if (reportFailed == 0) ** GOTO lbl61
                unsentMessages.add(message);
                ** GOTO lbl30
lbl61:
                // 1 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)messages);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distinctMessages);
                $continuation.L$2 = unsentMessages;
                $continuation.L$3 = set$iv;
                $continuation.L$4 = message;
                $continuation.I$0 = reportFailed;
                $continuation.label = 2;
                v1 = message.getSubmitter().submitAutomated(message.toLoggingEvent(), (Continuation)$continuation);
                if (v1 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl81
            }
            case 2: {
                reportFailed = $continuation.I$0;
                message = (Message)$continuation.L$4;
                set$iv = (Iterator)$continuation.L$3;
                unsentMessages = (List)$continuation.L$2;
                distinctMessages = (List)$continuation.L$1;
                messages = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl81:
                // 2 sources

                result = (SubmittedReportInfo)v1;
                v2 = status = result.getStatus();
                switch (v2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v2.ordinal()]) {
                    case 1: {
                        ExceptionAutoReporter.LOG.info("Reported exception with id " + result.getLinkText());
                        break;
                    }
                    case 2: {
                        ExceptionAutoReporter.LOG.info("Reported duplicate exception with id " + result.getLinkText());
                        break;
                    }
                    case 3: {
                        ExceptionAutoReporter.LOG.info("Failed to send exception report");
                        unsentMessages.add(message);
                        reportFailed = 1;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if (status == SubmittedReportInfo.SubmissionStatus.FAILED) ** GOTO lbl30
                $this$withLock_u24default$iv = this.exceptionHashMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)messages);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distinctMessages);
                $continuation.L$2 = unsentMessages;
                $continuation.L$3 = set$iv;
                $continuation.L$4 = message;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)result);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)status);
                $continuation.L$7 = $this$withLock_u24default$iv;
                $continuation.I$0 = reportFailed;
                $continuation.I$1 = $i$f$withLock;
                $continuation.label = 3;
                v3 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v3 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl131
            }
            case 3: {
                $i$f$withLock = $continuation.I$1;
                reportFailed = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$7;
                status = (SubmittedReportInfo.SubmissionStatus)$continuation.L$6;
                result = (SubmittedReportInfo)$continuation.L$5;
                message = (Message)$continuation.L$4;
                set$iv = (Iterator)$continuation.L$3;
                unsentMessages = (List)$continuation.L$2;
                distinctMessages = (List)$continuation.L$1;
                messages = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl131:
                // 2 sources

                try {
                    $i$a$-withLock$default-ExceptionAutoReporter$sendMessages$2 = false;
                    var14_24 = this.exceptionHashSet.add(message.getHash());
                    ** GOTO lbl30
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                    ** GOTO lbl30
                }
            }
        }
        $this$withLock_u24default$iv = this.exceptionHashMutex;
        owner$iv = null;
        $i$f$withLock = 0;
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)messages);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distinctMessages);
        $continuation.L$2 = unsentMessages;
        $continuation.L$3 = $this$withLock_u24default$iv;
        $continuation.L$4 = null;
        $continuation.L$5 = null;
        $continuation.L$6 = null;
        $continuation.L$7 = null;
        $continuation.I$0 = reportFailed;
        $continuation.I$1 = $i$f$withLock;
        $continuation.label = 4;
        v4 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
        if (v4 == var18_5) {
            return var18_5;
        }
        ** GOTO lbl167
        {
            case 4: {
                $i$f$withLock = $continuation.I$1;
                reportFailed = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                unsentMessages = (List)$continuation.L$2;
                distinctMessages = (List)$continuation.L$1;
                messages = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl167:
                // 2 sources

                try {
                    $i$a$-withLock$default-ExceptionAutoReporter$sendMessages$3 = false;
                    if (this.exceptionHashSet.size() > 1000) {
                        var10_18 = this.exceptionHashSet.size() - 500;
                        var11_19 = 0;
                        while (var11_19 < var10_18) {
                            it = var11_19++;
                            $i$a$-repeat-ExceptionAutoReporter$sendMessages$3$1 = false;
                            this.exceptionHashSet.removeFirstLong();
                        }
                        this.exceptionHashSet.trim();
                    }
                    var14_25 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return unsentMessages;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object isAlreadyReported(Message message, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isAlreadyReported.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ExceptionAutoReporter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ExceptionAutoReporter.access$isAlreadyReported(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.exceptionHashMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = message;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                message = (Message)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                try {
                    $i$a$-withLock$default-ExceptionAutoReporter$isAlreadyReported$2 = false;
                    var7_11 = Boxing.boxBoolean((boolean)this.exceptionHashSet.contains(message.getHash()));
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var7_11;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean newEntryConsumed(AbstractMessage message) {
        int n;
        if (!ExceptionAutoReportUtil.isAutoReportEnabled()) {
            return false;
        }
        Pair relevantData = ExceptionAutoReportUtil.INSTANCE.getRelevantData(message);
        if (relevantData == null) {
            return false;
        }
        this.messages.trySend-JP2dKIU((Object)new Message(message, (ITNReporter)relevantData.getFirst(), (IdeaPluginDescriptor)relevantData.getSecond()));
        LifecycleUsageTriggerCollector.onExceptionHappened((int)this.numberOfReportedExceptions.incrementAndGet());
        Object object = (IdeaPluginDescriptor)relevantData.getSecond();
        if (object == null || (object = object.getPluginId()) == null || (object = object.getIdString()) == null) {
            object = "com.intellij";
        }
        Object pluginId = object;
        Object2IntOpenHashMap<String> object2IntOpenHashMap = this.pluginIdToExceptionNumber;
        synchronized (object2IntOpenHashMap) {
            boolean bl = false;
            n = this.pluginIdToExceptionNumber.computeInt(pluginId, (arg_0, arg_1) -> ExceptionAutoReporter.newEntryConsumed$lambda$0$1(ExceptionAutoReporter::newEntryConsumed$lambda$0$0, arg_0, arg_1));
        }
        int exceptionNumber = n;
        IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)relevantData.getSecond();
        LifecycleUsageTriggerCollector.onExceptionInPluginHappened((int)exceptionNumber, (PluginId)(ideaPluginDescriptor != null ? ideaPluginDescriptor.getPluginId() : null));
        return true;
    }

    private static final Integer newEntryConsumed$lambda$0$0(String string, Integer oldReportNumber) {
        Integer n = oldReportNumber;
        return (n != null ? n : 0) + 1;
    }

    private static final Integer newEntryConsumed$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Object access$sendMessages(ExceptionAutoReporter $this, List messages, Continuation $completion) {
        return $this.sendMessages(messages, (Continuation<? super List<Message>>)$completion);
    }

    public static final /* synthetic */ Object access$isAlreadyReported(ExceptionAutoReporter $this, Message message, Continuation $completion) {
        return $this.isAlreadyReported(message, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ boolean access$newEntryConsumed(ExceptionAutoReporter $this, AbstractMessage message) {
        return $this.newEntryConsumed(message);
    }

    public static final /* synthetic */ long access$getDEFAULT_SENDING_DELAY$cp() {
        return DEFAULT_SENDING_DELAY;
    }

    public static final /* synthetic */ Channel access$getMessages$p(ExceptionAutoReporter $this) {
        return $this.messages;
    }

    public static final /* synthetic */ long access$getMAX_SENDING_DELAY$cp() {
        return MAX_SENDING_DELAY;
    }

    static {
        Companion $this$thisLogger$iv = Companion;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter$Companion;", "", "<init>", "()V", "HASH_SET_SIZE_LIMIT", "", "ERRORS_BUFFER_SIZE", "DEFAULT_SENDING_DELAY", "Lkotlin/time/Duration;", "J", "MAX_SENDING_DELAY", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.diagnostic.errorAutoReport"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter$ErrorAutoReporterStateInternalAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "computeMessage", "", "intellij.platform.diagnostic.errorAutoReport"})
    public static final class ErrorAutoReporterStateInternalAction
    extends AnAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setVisible(ApplicationKt.getApplication().isInternal() && e.getProject() != null);
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            String message = this.computeMessage();
            LightVirtualFile file = new LightVirtualFile("Error reporting status", (FileType)PlainTextFileType.INSTANCE, (CharSequence)message);
            FileEditorManager.getInstance((Project)project2).openFile((VirtualFile)file, true, true);
        }

        private final String computeMessage() {
            if (ExceptionAutoReportUtil.INSTANCE.getAutoReportIsForbiddenForProduct()) {
                return "Auto report is forbidden for this product";
            }
            if (!ExceptionAutoReportUtil.isAutoReportVisible()) {
                return "Auto report feature is invisible";
            }
            if (!ExceptionAutoReportUtil.isAutoReportEnabled()) {
                return "Auto report is disabled";
            }
            Object object = ApplicationKt.getApplication().getService(ExceptionAutoReporter.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            AtomicInteger resendAttempts = ((ExceptionAutoReporter)object).resendAttempts;
            int value = resendAttempts.get();
            return switch (value) {
                case -1 -> "No attempts to send exceptions have been made by now";
                case 0 -> "The latest batch of exceptions was successfully sent";
                default -> value + " attempts to send made";
            };
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020 H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter$Message;", "", "message", "Lcom/intellij/diagnostic/AbstractMessage;", "submitter", "Lcom/intellij/diagnostic/ITNReporter;", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "<init>", "(Lcom/intellij/diagnostic/AbstractMessage;Lcom/intellij/diagnostic/ITNReporter;Lcom/intellij/ide/plugins/IdeaPluginDescriptor;)V", "getMessage", "()Lcom/intellij/diagnostic/AbstractMessage;", "getSubmitter", "()Lcom/intellij/diagnostic/ITNReporter;", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "hash", "", "getHash", "()J", "toLoggingEvent", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.diagnostic.errorAutoReport"})
    private static final class Message {
        @NotNull
        private final AbstractMessage message;
        @NotNull
        private final ITNReporter submitter;
        @Nullable
        private final IdeaPluginDescriptor plugin;
        private final long hash;

        public Message(@NotNull AbstractMessage message, @NotNull ITNReporter submitter, @Nullable IdeaPluginDescriptor plugin) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)submitter, (String)"submitter");
            this.message = message;
            this.submitter = submitter;
            this.plugin = plugin;
            this.hash = IdeErrorsDialog.Companion.hashMessage(this.message);
        }

        @NotNull
        public final AbstractMessage getMessage() {
            return this.message;
        }

        @NotNull
        public final ITNReporter getSubmitter() {
            return this.submitter;
        }

        @Nullable
        public final IdeaPluginDescriptor getPlugin() {
            return this.plugin;
        }

        public final long getHash() {
            return this.hash;
        }

        @NotNull
        public final IdeaLoggingEvent toLoggingEvent() {
            return new IdeaLoggingEvent(this.message.getMessage(), this.message.getThrowable(), this.message.getAllAttachments(), this.plugin, (Object)this);
        }

        @NotNull
        public final AbstractMessage component1() {
            return this.message;
        }

        @NotNull
        public final ITNReporter component2() {
            return this.submitter;
        }

        @Nullable
        public final IdeaPluginDescriptor component3() {
            return this.plugin;
        }

        @NotNull
        public final Message copy(@NotNull AbstractMessage message, @NotNull ITNReporter submitter, @Nullable IdeaPluginDescriptor plugin) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)submitter, (String)"submitter");
            return new Message(message, submitter, plugin);
        }

        public static /* synthetic */ Message copy$default(Message message, AbstractMessage abstractMessage, ITNReporter iTNReporter, IdeaPluginDescriptor ideaPluginDescriptor, int n, Object object) {
            if ((n & 1) != 0) {
                abstractMessage = message.message;
            }
            if ((n & 2) != 0) {
                iTNReporter = message.submitter;
            }
            if ((n & 4) != 0) {
                ideaPluginDescriptor = message.plugin;
            }
            return message.copy(abstractMessage, iTNReporter, ideaPluginDescriptor);
        }

        @NotNull
        public String toString() {
            return "Message(message=" + this.message + ", submitter=" + this.submitter + ", plugin=" + this.plugin + ")";
        }

        public int hashCode() {
            int result = this.message.hashCode();
            result = result * 31 + this.submitter.hashCode();
            result = result * 31 + (this.plugin == null ? 0 : this.plugin.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Message)) {
                return false;
            }
            Message message = (Message)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)message.message)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.submitter, (Object)message.submitter)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.plugin, (Object)message.plugin);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter$Starter;", "Lcom/intellij/ide/ApplicationInitializedListener;", "<init>", "()V", "execute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.diagnostic.errorAutoReport"})
    @SourceDebugExtension(value={"SMAP\nExceptionAutoReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionAutoReporter.kt\ncom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter$Starter\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,227:1\n74#2,10:228\n*S KotlinDebug\n*F\n+ 1 ExceptionAutoReporter.kt\ncom/intellij/platform/diagnostic/errorAutoReport/ExceptionAutoReporter$Starter\n*L\n173#1:228,10\n*E\n"})
    public static final class Starter
    implements ApplicationInitializedListener {
        public Starter() {
            if (ExceptionAutoReportUtil.INSTANCE.getAutoReportIsForbiddenForProduct()) {
                ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
                Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
                throw (Throwable)extensionNotApplicableException;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public Object execute(@NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var8_2 = $completion;
            if ((var8_2.label & -2147483648) != 0) {
                var8_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    int I$0;
                    int I$1;
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Starter this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $i$f$serviceAsync = 0;
                    v0 = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                    $this$serviceAsync$iv$iv = (ComponentManager)v0;
                    $i$f$serviceAsync = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                    $continuation.I$0 = $i$f$serviceAsync;
                    $continuation.I$1 = $i$f$serviceAsync;
                    $continuation.label = 1;
                    v1 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(ExceptionAutoReporter.class, (Continuation)$continuation);
                    if (v1 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl33
                }
                case 1: {
                    $i$f$serviceAsync = $continuation.I$1;
                    $i$f$serviceAsync = $continuation.I$0;
                    $this$serviceAsync$iv$iv = (ComponentManager)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl33:
                    // 2 sources

                    reporter = (ExceptionAutoReporter)v1;
                    messagePool = MessagePool.getInstance();
                    messagePool.addListener(new MessagePoolListener(reporter){
                        final /* synthetic */ ExceptionAutoReporter $reporter;
                        {
                            this.$reporter = $reporter;
                        }

                        public boolean beforeEntryAdded(AbstractMessage message) {
                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                            return !ExceptionAutoReporter.access$newEntryConsumed(this.$reporter, message);
                        }

                        public void newEntryAdded() {
                        }
                    });
                    if (ExceptionAutoReportUtil.isAutoReportEnabled() && messagePool.getState() != MessagePool.State.NoErrors) {
                        v2 = messagePool.getFatalErrors(false, false);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getFatalErrors(...)");
                        errors = v2;
                        for (AbstractMessage message : errors) {
                            Intrinsics.checkNotNull((Object)message);
                            if (!ExceptionAutoReporter.access$newEntryConsumed(reporter, message)) continue;
                            message.setSubmitted(new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.NEW_ISSUE));
                            message.setRead(true);
                        }
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SubmittedReportInfo.SubmissionStatus.values().length];
            try {
                nArray[SubmittedReportInfo.SubmissionStatus.NEW_ISSUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubmittedReportInfo.SubmissionStatus.DUPLICATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubmittedReportInfo.SubmissionStatus.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

