/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoDirNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoTreeHelper {
    private final Project myProject;

    public static TodoTreeHelper getInstance(Project project) {
        return (TodoTreeHelper)project.getService(TodoTreeHelper.class);
    }

    public TodoTreeHelper(Project project) {
        this.myProject = project;
    }

    public void addPackagesToChildren(@NotNull ArrayList<? super AbstractTreeNode<?>> children, @Nullable Module module, @NotNull TodoTreeBuilder builder) {
        if (children == null) {
            TodoTreeHelper.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            TodoTreeHelper.$$$reportNull$$$0(1);
        }
        this.addDirsToChildren(this.collectContentRoots(module), children, builder);
    }

    @NotNull
    protected List<? extends VirtualFile> collectContentRoots(@Nullable Module module) {
        ArrayList roots = new ArrayList();
        ContainerUtil.addAll(roots, (Object[])(module != null ? ModuleRootManager.getInstance((Module)module).getContentRoots() : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()));
        ArrayList arrayList = roots;
        if (arrayList == null) {
            TodoTreeHelper.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected void addDirsToChildren(@NotNull List<? extends VirtualFile> roots, @NotNull ArrayList<? super AbstractTreeNode<?>> children, @NotNull TodoTreeBuilder builder) {
        if (roots == null) {
            TodoTreeHelper.$$$reportNull$$$0(3);
        }
        if (children == null) {
            TodoTreeHelper.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            TodoTreeHelper.$$$reportNull$$$0(5);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile virtualFile : roots) {
            TodoDirNode dirNode;
            Iterator<PsiFile> files;
            PsiDirectory directory = psiManager.findDirectory(virtualFile);
            if (directory == null || !(files = builder.getFiles(directory)).hasNext() || children.contains((Object)(dirNode = new TodoDirNode(this.myProject, directory, builder)))) continue;
            children.add((AbstractTreeNode<?>)dirNode);
        }
    }

    public Collection<AbstractTreeNode<?>> getDirectoryChildren(PsiDirectory psiDirectory, TodoTreeBuilder builder, boolean isFlatten) {
        ArrayList children = new ArrayList();
        if (!isFlatten || !this.skipDirectory(psiDirectory)) {
            Iterator<PsiFile> iterator = builder.getFiles(psiDirectory);
            block0: while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder, false);
                if (psiDirectory.equals((Object)containingDirectory) && !children.contains((Object)todoFileNode)) {
                    children.add((AbstractTreeNode<?>)todoFileNode);
                    continue;
                }
                PsiDirectory _dir = psiFile.getContainingDirectory();
                while (_dir != null && !this.skipDirectory(_dir)) {
                    PsiDirectory parentDirectory = _dir.getParentDirectory();
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder);
                    if (parentDirectory != null && psiDirectory.equals((Object)parentDirectory) && !children.contains((Object)todoDirNode)) {
                        children.add((AbstractTreeNode<?>)todoDirNode);
                        continue block0;
                    }
                    _dir = parentDirectory;
                }
            }
        } else {
            PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
            if (parentDirectory == null || !this.skipDirectory(parentDirectory) || !ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInContent(parentDirectory.getVirtualFile())) {
                Iterator<PsiFile> iterator = builder.getFiles(psiDirectory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = iterator.next();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder, false);
                    if (psiDirectory.equals((Object)psiFile.getContainingDirectory()) && !children.contains((Object)todoFileNode)) {
                        children.add((AbstractTreeNode<?>)todoFileNode);
                        continue;
                    }
                    PsiDirectory _dir = psiFile.getContainingDirectory();
                    if (_dir == null || this.skipDirectory(_dir)) continue;
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder);
                    if (!PsiTreeUtil.isAncestor((PsiElement)psiDirectory, (PsiElement)_dir, (boolean)true) || children.contains((Object)todoDirNode) || builder.isDirectoryEmpty(_dir)) continue;
                    children.add((AbstractTreeNode<?>)todoDirNode);
                }
            } else {
                Iterator<PsiFile> iterator = builder.getFiles(psiDirectory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = iterator.next();
                    PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder, false);
                    if (!psiDirectory.equals((Object)containingDirectory) || children.contains((Object)todoFileNode)) continue;
                    children.add((AbstractTreeNode<?>)todoFileNode);
                }
            }
        }
        children.sort(TodoFileDirAndModuleComparator.INSTANCE);
        return children;
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return false;
    }

    @Nullable
    public PsiElement getSelectedElement(Object userObject) {
        if (userObject instanceof TodoDirNode) {
            TodoDirNode descriptor = (TodoDirNode)((Object)userObject);
            return (PsiElement)descriptor.getValue();
        }
        if (userObject instanceof TodoFileNode) {
            TodoFileNode descriptor = (TodoFileNode)((Object)userObject);
            return (PsiElement)descriptor.getValue();
        }
        return null;
    }

    public boolean contains(ProjectViewNode node, Object element) {
        return false;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/nodes/TodoTreeHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/nodes/TodoTreeHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectContentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPackagesToChildren";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDirsToChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

