/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexScanUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexingStamp;
import java.util.Map;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexTodoCacheManagerImpl
implements TodoCacheManager {
    private final Project myProject;

    public IndexTodoCacheManagerImpl(@NotNull Project project) {
        if (project == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public boolean processFilesWithTodoItems(@NotNull Processor<? super PsiFile> processor) {
        if (processor == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.myProject.isDefault()) {
            return true;
        }
        GlobalSearchScope scope = new GlobalSearchScope(this.myProject){

            public boolean isSearchInModuleContent(@NotNull Module module) {
                if (module == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                return TodoIndexers.belongsToProject((Project)IndexTodoCacheManagerImpl.this.myProject, (VirtualFile)file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ConcurrentBitSet idSet = ConcurrentBitSet.create();
        ManagingFS fs = ManagingFS.getInstance();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        IntPredicate consumer = fileId -> {
            VirtualFile file = fs.findFileById(fileId);
            if (file == null || !file.isValid() || !scope.contains(file)) {
                return true;
            }
            PsiFile psiFile = psiManager.findFile(file);
            return psiFile == null || processor.process((Object)psiFile);
        };
        DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> FileBasedIndex.getInstance().processAllKeys(TodoIndex.NAME, fileId -> {
            idSet.set(fileId.intValue());
            return true;
        }, scope, null));
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        fileDocumentManager.processUnsavedDocuments(document -> {
            VirtualFile file = fileDocumentManager.getFile(document);
            if (file instanceof VirtualFileWithId) {
                idSet.clear(((VirtualFileWithId)file).getId());
            }
            return true;
        });
        int fileId2 = idSet.nextSetBit(0);
        while (fileId2 > 0) {
            if (IndexingStamp.isFileIndexedStateCurrent((int)fileId2, TodoIndex.NAME).updateRequired()) {
                idSet.clear(fileId2);
            } else if (!consumer.test(fileId2)) {
                return false;
            }
            fileId2 = idSet.nextSetBit(fileId2 + 1);
        }
        IdFilter filter = ((FileBasedIndexEx)FileBasedIndex.getInstance()).extractIdFilter(scope, this.myProject);
        return FileBasedIndexScanUtil.doProcessAllKeys(TodoIndex.NAME, fileId -> idSet.set(fileId.intValue()) || consumer.test((int)fileId), (GlobalSearchScope)scope, (IdFilter)filter);
    }

    public int getTodoCount(@NotNull VirtualFile file, @NotNull IndexPatternProvider patternProvider) {
        if (file == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(2);
        }
        if (patternProvider == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(3);
        }
        return this.getTodoCountImpl(file, patternProvider.getIndexPatterns());
    }

    public int getTodoCount(@NotNull VirtualFile file, @NotNull IndexPattern pattern) {
        if (file == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(5);
        }
        return this.getTodoCountImpl(file, pattern);
    }

    private int getTodoCountImpl(@NotNull VirtualFile file, IndexPattern ... indexPatterns) {
        if (file == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(6);
        }
        if (indexPatterns == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(7);
        }
        if (file instanceof VirtualFileWindow) {
            return -1;
        }
        Map<TodoIndexEntry, Integer> data = IndexTodoCacheManagerImpl.getTodoMap(this.myProject, file);
        if (data == null || data.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (IndexPattern pattern : indexPatterns) {
            result += data.getOrDefault(new TodoIndexEntry(pattern.getPatternString(), pattern.isCaseSensitive()), 0).intValue();
        }
        return result;
    }

    @Nullable
    public static Map<TodoIndexEntry, Integer> getTodoMap(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(8);
        }
        if (file == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(9);
        }
        if (project.isDefault()) {
            return null;
        }
        if (file instanceof VirtualFileWindow) {
            return null;
        }
        return file instanceof LightVirtualFile ? IndexTodoCacheManagerImpl.calcTodoMap(project, (LightVirtualFile)file) : (TodoIndexers.belongsToProject((Project)project, (VirtualFile)file) ? IndexTodoCacheManagerImpl.getTodoMapFromIndex(project, file) : null);
    }

    @Nullable
    private static Map<TodoIndexEntry, Integer> calcTodoMap(@NotNull Project project, @NotNull LightVirtualFile file) {
        CharSequence content;
        if (project == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(10);
        }
        if (file == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmpty((CharSequence)(content = file.getContent()))) {
            return null;
        }
        TodoIndex extension = (TodoIndex)((Object)FileBasedIndexExtension.EXTENSION_POINT_NAME.findExtension(TodoIndex.class));
        if (extension == null) {
            return null;
        }
        FileContent fc = FileContentImpl.createByText((VirtualFile)file, (CharSequence)content, (Project)project);
        Map data = extension.getIndexer().map(fc);
        return (Map)ContainerUtil.getFirstItem(data.values());
    }

    @Nullable
    private static Map<TodoIndexEntry, Integer> getTodoMapFromIndex(@NotNull Project project, @NotNull VirtualFile file) {
        Map map;
        if (project == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(12);
        }
        if (file == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(13);
        }
        return (map = FileBasedIndexScanUtil.getIndexData(TodoIndex.NAME, (Project)project, (VirtualFile)file)) == null || map.isEmpty() ? null : (Map)ContainerUtil.getFirstItem(map.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexPatterns";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processFilesWithTodoItems";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTodoCount";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getTodoCountImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getTodoMap";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "calcTodoMap";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getTodoMapFromIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

