/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.ApplicationKt;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.gateway.ssh.AvailableIde;
import com.jetbrains.gateway.ssh.CachingProductsJsonWrapperConfiguration;
import com.jetbrains.gateway.ssh.CachingProductsJsonWrapperKt;
import com.jetbrains.gateway.ssh.DefaultCachingProductsJsonWrapperConfiguration;
import com.jetbrains.gateway.ssh.DeployTargetOS;
import com.jetbrains.gateway.ssh.Download;
import com.jetbrains.gateway.ssh.IntelliJPlatformProduct;
import com.jetbrains.gateway.ssh.ProductBuild;
import com.jetbrains.gateway.ssh.ProductData;
import com.jetbrains.gateway.ssh.ReleaseType;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.time.TimeKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000eJ \u0010\u001e\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/gateway/ssh/CachingProductsJsonWrapper;", "", "configuration", "Lcom/jetbrains/gateway/ssh/CachingProductsJsonWrapperConfiguration;", "currentApplicationBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "<init>", "(Lcom/jetbrains/gateway/ssh/CachingProductsJsonWrapperConfiguration;Lcom/intellij/openapi/util/BuildNumber;)V", "threeReleasesAgoBuildNumber", "majorVersion", "", "nextMajorVersion", "cachedResponse", "", "", "Lcom/jetbrains/gateway/ssh/ProductData;", "parseResponse", "content", "productsJsonSource", "Ljava/net/URI;", "getReleasesResponseForProductCode", "productCode", "getDownloadForIde", "Lcom/jetbrains/gateway/ssh/AvailableIde;", "product", "Lcom/jetbrains/gateway/ssh/IntelliJPlatformProduct;", "deployTargetOs", "Lcom/jetbrains/gateway/ssh/DeployTargetOS;", "buildNumber", "getRemoteDevType", "getDownloadPlatformId", "Lcom/jetbrains/gateway/ssh/PlatformID;", "getAvailableIdes", "", "buildMajorVersionsLatestEAPAndFallback", "availableIdes", "getReleaseType", "type", "Lcom/jetbrains/gateway/ssh/ReleaseType;", "printableReleaseType", "trimSuffix", "version", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nCachingProductsJsonWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingProductsJsonWrapper.kt\ncom/jetbrains/gateway/ssh/CachingProductsJsonWrapper\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,453:1\n222#2:454\n1642#3,10:455\n1915#3:465\n1916#3:487\n1652#3:488\n1642#3,10:489\n1915#3:499\n1916#3:501\n1652#3:502\n777#3:503\n873#3,2:504\n777#3:506\n873#3,2:507\n777#3:509\n873#3,2:510\n296#3,2:512\n296#3,2:514\n296#3,2:516\n139#4,10:466\n221#4:476\n222#4:479\n149#4:480\n1#5:477\n1#5:478\n1#5:486\n1#5:500\n60#6,5:481\n13#6:518\n*S KotlinDebug\n*F\n+ 1 CachingProductsJsonWrapper.kt\ncom/jetbrains/gateway/ssh/CachingProductsJsonWrapper\n*L\n152#1:454\n174#1:455,10\n174#1:465\n174#1:487\n174#1:488\n339#1:489,10\n339#1:499\n339#1:501\n339#1:502\n357#1:503\n357#1:504,2\n374#1:506\n374#1:507,2\n385#1:509\n385#1:510,2\n393#1:512,2\n394#1:514,2\n403#1:516,2\n179#1:466,10\n179#1:476\n179#1:479\n179#1:480\n179#1:478\n174#1:486\n339#1:500\n203#1:481,5\n133#1:518\n*E\n"})
public final class CachingProductsJsonWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CachingProductsJsonWrapperConfiguration configuration;
    @NotNull
    private final BuildNumber currentApplicationBuildNumber;
    @NotNull
    private final BuildNumber threeReleasesAgoBuildNumber;
    private final int majorVersion;
    private final int nextMajorVersion;
    @NotNull
    private Map<String, ProductData> cachedResponse;
    @NotNull
    private static final Lazy<CachingProductsJsonWrapper> ourInstance$delegate = LazyKt.lazy(CachingProductsJsonWrapper::ourInstance_delegate$lambda$0);
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Map<DeployTargetOS, String> deployTargetAvailableSince;

    public CachingProductsJsonWrapper(@NotNull CachingProductsJsonWrapperConfiguration configuration, @NotNull BuildNumber currentApplicationBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)currentApplicationBuildNumber, (String)"currentApplicationBuildNumber");
        this.configuration = configuration;
        BuildNumber buildNumber = this.currentApplicationBuildNumber = currentApplicationBuildNumber;
        CachingProductsJsonWrapper cachingProductsJsonWrapper = this;
        boolean bl = false;
        int[] nArray = this.currentApplicationBuildNumber.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getComponents(...)");
        int[] currentApplicationBuildNumberComponents = nArray;
        currentApplicationBuildNumberComponents[0] = currentApplicationBuildNumberComponents[0] - 10;
        cachingProductsJsonWrapper.threeReleasesAgoBuildNumber = new BuildNumber(this.currentApplicationBuildNumber.getProductCode(), Arrays.copyOf(currentApplicationBuildNumberComponents, currentApplicationBuildNumberComponents.length));
        int[] nArray2 = this.currentApplicationBuildNumber.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"getComponents(...)");
        int n = this.majorVersion = ArraysKt.first((int[])nArray2);
        int n2 = 10;
        int n3 = n % n2;
        this.nextMajorVersion = switch (n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31)) {
            case 1 -> this.majorVersion + 1;
            case 2 -> this.majorVersion + 1;
            case 3 -> this.majorVersion + 8;
            default -> throw new IllegalStateException(("Unexpected application major version: " + this.majorVersion + ". Expected major version ending in 1, 2 or 3").toString());
        };
        this.cachedResponse = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    private final ProductData parseResponse(String content, URI productsJsonSource) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List this_$iv;
        try {
            Json json = CachingProductsJsonWrapperKt.getJsonFormat();
            String string$iv = content;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            this_$iv = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(ProductData.Companion.serializer()), string$iv);
        }
        catch (Exception e) {
            logger.warn("Failed to decode product data from '" + productsJsonSource + "'", (Throwable)e);
            logger.info("content: " + content);
            return null;
        }
        List productDataList = this_$iv;
        if (productDataList.isEmpty()) {
            logger.warn("'" + productsJsonSource + "' response is empty");
            logger.info("content: " + content);
            return null;
        }
        if (productDataList.size() != 1) {
            logger.warn(productsJsonSource + " returns more than 1 list. This is strange");
            logger.info("content: " + content);
        }
        ProductData productData = (ProductData)CollectionsKt.first((List)productDataList);
        String productCode = productData.getCode();
        URI baseLocation = new URI(productsJsonSource.getScheme(), productsJsonSource.getAuthority(), productsJsonSource.getPath(), null, null);
        Iterable iterable = productData.getReleases();
        ProductData productData2 = productData;
        boolean $i$f$mapNotNull = false;
        void var9_12 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProductBuild productBuild;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ProductBuild release = (ProductBuild)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)productCode, (Object)IntelliJPlatformProduct.FLEET.getProductCode()) && VersionComparatorUtil.compare((String)release.getBuild(), (String)this.threeReleasesAgoBuildNumber.asStringWithoutProductCode()) < 0) {
                logger.debug("Permanently filtering out build release.build");
                productBuild = null;
            } else {
                void $this$mapNotNullTo$iv$iv2;
                Map<String, Download> $this$mapNotNull$iv2 = release.getDownloads();
                boolean $i$f$mapNotNull2 = false;
                Map<String, Download> map = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Pair it$iv$iv;
                    Map.Entry element$iv$iv$iv2;
                    Map.Entry element$iv$iv2 = element$iv$iv$iv2 = iterator2.next();
                    boolean bl3 = false;
                    Map.Entry platform = element$iv$iv2;
                    boolean bl4 = false;
                    String link = ((Download)platform.getValue()).getLink();
                    boolean isHttpScheme = StringsKt.startsWith$default((String)link, (String)"http://", (boolean)false, (int)2, null);
                    boolean isHttpsScheme = StringsKt.startsWith$default((String)link, (String)"https://", (boolean)false, (int)2, null);
                    if (isHttpScheme) {
                        logger.info("Link " + ((Download)platform.getValue()).getLink() + " is insecure. Be mindful.");
                    }
                    Download valueToReturn = (Download)platform.getValue();
                    if (!isHttpScheme && !isHttpsScheme) {
                        String string;
                        Download download2 = (Download)platform.getValue();
                        String string2 = baseLocation.resolve(valueToReturn.getLink()).toString();
                        String string3 = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        Long l = null;
                        if (valueToReturn.getChecksumLink() != null) {
                            void it;
                            Long l2 = l;
                            String string4 = string3;
                            Download download3 = download2;
                            boolean bl5 = false;
                            String string5 = baseLocation.resolve((String)it).toString();
                            download2 = download3;
                            string3 = string4;
                            l = l2;
                            string = string5;
                        } else {
                            string = null;
                        }
                        valueToReturn = Download.copy$default(download2, string3, l, string, 2, null);
                    }
                    if (TuplesKt.to(platform.getKey(), (Object)valueToReturn) == null) continue;
                    boolean bl6 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Map newDownloads = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
                if (newDownloads.isEmpty()) {
                    Logger $this$debug_u24default$iv = logger;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl7 = false;
                        logger.debug("Product/build " + productCode + "/" + release.getBuild() + " has no downloads, excluding from list", t$iv);
                    }
                    productBuild = null;
                } else {
                    productBuild = ProductBuild.copy$default(release, null, null, null, null, null, null, newDownloads, 63, null);
                }
            }
            if (productBuild == null) continue;
            ProductBuild it$iv$iv = productBuild;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return ProductData.copy$default(productData2, (List)destination$iv$iv, null, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final ProductData getReleasesResponseForProductCode(String productCode) {
        block12: {
            ApplicationKt.getApplication().assertIsNonDispatchThread();
            if (this.cachedResponse.get(productCode) != null) {
                return this.cachedResponse.get(productCode);
            }
            targetUrlString = this.configuration.getProductsJsonUrl(productCode);
            CachingProductsJsonWrapper.logger.debug("Getting product list from " + targetUrlString);
            try {
                block13: {
                    targetUrl = new URI(targetUrlString);
                    var4_4 = targetUrl.getScheme();
                    if (var4_4 == null) break block13;
                    switch (var4_4.hashCode()) {
                        case 3143036: {
                            if (var4_4.equals("file")) break;
                            ** break;
                        }
                        case 3213448: {
                            if (!var4_4.equals("http")) {
                                ** break;
                            }
                            ** GOTO lbl21
                        }
                        case 99617003: {
                            if (!var4_4.equals("https")) ** break;
lbl21:
                            // 2 sources

                            try {
                                v0 = HttpRequests.request((String)targetUrl.toString()).readString();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"readString(...)");
                                response = v0;
                                v1 = this.parseResponse(response, targetUrl);
                                if (v1 == null) {
                                    return null;
                                }
                                parsedResponse = v1;
                                this.cachedResponse.put(productCode, parsedResponse);
                                response = RdCoroutinesUtilKt.launchNonUrgentBackground$default((Lifetime)Lifetime.Companion.getEternal(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, productCode, null){
                                    int label;
                                    final /* synthetic */ CachingProductsJsonWrapper this$0;
                                    final /* synthetic */ String $productCode;
                                    {
                                        this.this$0 = $receiver;
                                        this.$productCode = $productCode;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = Duration.ofDays(1L);
                                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ofDays(...)");
                                                this.label = 1;
                                                v1 = TimeKt.delay((Duration)v0, (Continuation)((Continuation)this));
                                                if (v1 == var2_2) {
                                                    return var2_2;
                                                }
                                                ** GOTO lbl15
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v1 = $result;
lbl15:
                                                // 2 sources

                                                CachingProductsJsonWrapper.access$getCachedResponse$p(this.this$0).remove(this.$productCode);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                break block12;
                            }
                            catch (IOException e) {
                                CachingProductsJsonWrapper.logger.warn("Failed to read products from '" + targetUrl + "'", (Throwable)e);
                                return null;
                            }
                        }
                    }
                    v2 = Paths.get(targetUrl);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                    contents = PathsKt.readText$default((Path)v2, null, (int)1, null);
                    return this.parseResponse(contents, targetUrl);
                }
                CachingProductsJsonWrapper.logger.warn("Failed to get products from " + targetUrl);
                throw new IllegalStateException((targetUrl + " url is not applicable. Only 'file', 'http' and 'https' links are supported").toString());
            }
            catch (Throwable e) {
                CachingProductsJsonWrapper.logger.error(e);
                return null;
            }
        }
        return this.cachedResponse.get(productCode);
    }

    @Nullable
    public final AvailableIde getDownloadForIde(@NotNull IntelliJPlatformProduct product, @NotNull DeployTargetOS deployTargetOs, @Nullable String buildNumber) {
        Intrinsics.checkNotNullParameter((Object)((Object)product), (String)"product");
        Intrinsics.checkNotNullParameter((Object)deployTargetOs, (String)"deployTargetOs");
        String string = this.getDownloadPlatformId(deployTargetOs, product);
        if (string == null) {
            return null;
        }
        String downloadPlatformId = string;
        ProductData productData = this.getReleasesResponseForProductCode(product.getProductCode());
        if (productData == null) {
            return null;
        }
        ProductData response = productData;
        for (ProductBuild release : response.getReleases()) {
            Download download2;
            Map<String, Download> downloads;
            String releaseBuildNumber;
            String string2 = release.getBuild();
            if (string2 == null) {
                string2 = releaseBuildNumber = release.getVersion();
            }
            if ((downloads = release.getDownloads()).get(downloadPlatformId) == null || buildNumber != null && !Intrinsics.areEqual((Object)buildNumber, (Object)releaseBuildNumber)) continue;
            ReleaseType releaseType = ReleaseType.Companion.fromSerializedName(release.getType());
            String versionSuffix = this.getReleaseType(releaseType, release.getPrintableReleaseType());
            return new AvailableIde(product, releaseBuildNumber, download2, this.trimSuffix(release.getVersion()) + versionSuffix, release.getRemoteDevType(), releaseType);
        }
        return null;
    }

    @Nullable
    public final String getRemoteDevType(@NotNull IntelliJPlatformProduct product, @NotNull String buildNumber) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)product), (String)"product");
            Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
            ProductData productData = this.getReleasesResponseForProductCode(product.getProductCode());
            if (productData == null) {
                return null;
            }
            ProductData response = productData;
            Iterable iterable = response.getReleases();
            for (Object t : iterable) {
                ProductBuild it = (ProductBuild)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBuild(), (Object)buildNumber)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        ProductBuild productBuild = v1;
        if (productBuild == null) {
            return null;
        }
        ProductBuild build = productBuild;
        return build.getRemoteDevType();
    }

    private final String getDownloadPlatformId(DeployTargetOS deployTargetOs, IntelliJPlatformProduct product) {
        if (product == IntelliJPlatformProduct.FLEET) {
            return "linux_x64";
        }
        return switch (WhenMappings.$EnumSwitchMapping$1[deployTargetOs.getOsArch().ordinal()]) {
            case 1 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[deployTargetOs.getOsKind().ordinal()]) {
                    case 1: {
                        yield "linuxARM64";
                    }
                    case 2: {
                        yield "macM1";
                    }
                    case 3: {
                        yield "windowsZipARM64";
                    }
                }
                yield null;
            }
            case 2 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[deployTargetOs.getOsKind().ordinal()]) {
                    case 1: {
                        yield "linux";
                    }
                    case 2: {
                        yield "mac";
                    }
                    case 3: {
                        yield "windowsZip";
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<AvailableIde> getAvailableIdes(@NotNull IntelliJPlatformProduct product, @NotNull DeployTargetOS deployTargetOs) {
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)product, (String)"product");
                Intrinsics.checkNotNullParameter((Object)deployTargetOs, (String)"deployTargetOs");
                downloadPlatformId = this.getDownloadPlatformId(deployTargetOs, product);
                if (downloadPlatformId == null) {
                    CachingProductsJsonWrapper.logger.warn("Os/Arch combination is not supported, returning an empty list of downloads: " + deployTargetOs);
                    return CollectionsKt.emptyList();
                }
                response = this.getReleasesResponseForProductCode(product.getProductCode());
                if (response == null) {
                    CachingProductsJsonWrapper.logger.warn("Failed to get releases for " + product.getProductCode() + ". Returning empty list");
                    return CollectionsKt.emptyList();
                }
                shouldShowOnlyLatestVersion = this.configuration.shouldShowOnlyLatestVersion();
                releasePattern = this.configuration.getReleasePatternRegex();
                if (releasePattern != null) {
                    CachingProductsJsonWrapper.logger.warn("Release pattern is not null. Ignoring all other download settings");
                }
                $this$mapNotNull$iv = response.getReleases();
                $i$f$mapNotNull = false;
                var10_11 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var15_24 = $this$forEach$iv$iv$iv.iterator();
                while (var15_24.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var15_24.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    release = (ProductBuild)element$iv$iv;
                    $i$a$-mapNotNull-CachingProductsJsonWrapper$getAvailableIdes$feedIdes$1 = false;
                    v0 = release.getBuild();
                    if (v0 == null) {
                        v0 = buildNumber = release.getVersion();
                    }
                    if ((download = (downloads = release.getDownloads()).get(downloadPlatformId)) == null) {
                        CachingProductsJsonWrapper.logger.warn("download for (" + product + " " + buildNumber + " " + deployTargetOs.getOsKind() + ") is null");
                        v1 = null;
                    } else {
                        releaseType = ReleaseType.Companion.fromSerializedName(release.getType());
                        versionSuffix = this.getReleaseType(releaseType, release.getPrintableReleaseType());
                        v1 = new AvailableIde(product, buildNumber, download, this.trimSuffix(release.getVersion()) + versionSuffix, release.getRemoteDevType(), releaseType);
                    }
                    if (v1 == null) continue;
                    it$iv$iv = v1;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                feedIdes = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)(Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, getAvailableIdes$lambda$2(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)I)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getAvailableIdes$lambda$1(com.jetbrains.gateway.ssh.AvailableIde com.jetbrains.gateway.ssh.AvailableIde ), (Lcom/jetbrains/gateway/ssh/AvailableIde;Lcom/jetbrains/gateway/ssh/AvailableIde;)Ljava/lang/Integer;)()));
                if (releasePattern == null && this.configuration.getReleaseTypes() == null) break block12;
                $this$filter$iv = feedIdes;
                $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AvailableIde)element$iv$iv;
                    $i$a$-filter-CachingProductsJsonWrapper$getAvailableIdes$availableIdes$1 = false;
                    v2 = releasePattern;
                    if (!(v2 != null ? v2.matches((CharSequence)it.getBuildNumber()) : true)) ** GOTO lbl-1000
                    v3 = this.configuration.getReleaseTypes();
                    if (v3 != null ? v3.contains((Object)it.getReleaseType()) : true) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    if (!v4) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v5 = (List)destination$iv$iv;
                break block13;
            }
            v5 = shouldShowOnlyLatestVersion != false ? this.buildMajorVersionsLatestEAPAndFallback(feedIdes, product) : feedIdes;
        }
        availableIdes = v5;
        minimalVersionForDeployTarget = CachingProductsJsonWrapper.deployTargetAvailableSince.get(deployTargetOs);
        if (minimalVersionForDeployTarget == null) {
            CachingProductsJsonWrapper.logger.info("Deploy target " + deployTargetOs + " is not supported, returning empty list of available IDEs");
            return CollectionsKt.emptyList();
        }
        $this$filter$iv = availableIdes;
        $i$f$filter = false;
        $i$f$filterTo = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (AvailableIde)element$iv$iv;
            $i$a$-filter-CachingProductsJsonWrapper$getAvailableIdes$resultIdes$1 = false;
            if (!(it.getProduct() == IntelliJPlatformProduct.FLEET || VersionComparatorUtil.compare((String)it.getBuildNumber(), (String)minimalVersionForDeployTarget) >= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        resultIdes = (List)destination$iv$iv;
        CachingProductsJsonWrapper.logger.info("Resulting available IDEs for " + product.getProductCode() + " (" + resultIdes.size() + "): " + resultIdes);
        return resultIdes;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AvailableIde> buildMajorVersionsLatestEAPAndFallback(List<AvailableIde> availableIdes, IntelliJPlatformProduct product) {
        Object v3;
        AvailableIde latestMajorMatchingEap;
        AvailableIde latestMajorMatchingRelease;
        block9: {
            Object v2;
            block8: {
                Object v1;
                List majorVersionMatchingIdes;
                block7: {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = availableIdes;
                    boolean $i$f$filter = false;
                    void var6_6 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        boolean bl;
                        AvailableIde it = (AvailableIde)element$iv$iv;
                        boolean bl2 = false;
                        if (it.getProduct() != IntelliJPlatformProduct.FLEET && !StringsKt.startsWith$default((String)it.getBuildNumber(), (String)(this.majorVersion + "."), (boolean)false, (int)2, null)) {
                            logger.debug("Release (" + product + " " + it + ".buildNumber) was filtered out by major version filter (" + this.majorVersion + ")");
                            bl = false;
                        } else {
                            bl = true;
                        }
                        if (!bl) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    majorVersionMatchingIdes = (List)destination$iv$iv;
                    Iterable $this$firstOrNull$iv = majorVersionMatchingIdes;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        AvailableIde it = (AvailableIde)element$iv;
                        boolean bl = false;
                        if (!(it.getReleaseType() == ReleaseType.RELEASE)) continue;
                        v1 = element$iv;
                        break block7;
                    }
                    v1 = null;
                }
                latestMajorMatchingRelease = v1;
                Iterable $this$firstOrNull$iv = majorVersionMatchingIdes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AvailableIde it = (AvailableIde)element$iv;
                    boolean bl = false;
                    if (!(it.getReleaseType() != ReleaseType.RELEASE)) continue;
                    v2 = element$iv;
                    break block8;
                }
                v2 = null;
            }
            latestMajorMatchingEap = v2;
            if (latestMajorMatchingRelease != null && latestMajorMatchingEap != null && VersionComparatorUtil.compare((String)latestMajorMatchingEap.getBuildNumber(), (String)latestMajorMatchingRelease.getBuildNumber()) < 0) {
                latestMajorMatchingEap = null;
            }
            Iterable $this$firstOrNull$iv = availableIdes;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AvailableIde it = (AvailableIde)element$iv;
                boolean bl = false;
                if (!(it.getReleaseType() != ReleaseType.RELEASE && StringsKt.startsWith$default((String)it.getBuildNumber(), (String)(this.nextMajorVersion + "."), (boolean)false, (int)2, null))) continue;
                v3 = element$iv;
                break block9;
            }
            v3 = null;
        }
        AvailableIde latestEapForNextRelease = v3;
        AvailableIde fallbackVersionFromPrevRelease = latestMajorMatchingRelease == null && latestMajorMatchingEap == null && latestEapForNextRelease == null ? (AvailableIde)CollectionsKt.firstOrNull(availableIdes) : null;
        Object[] objectArray = new AvailableIde[]{latestMajorMatchingRelease, latestMajorMatchingEap, latestEapForNextRelease, fallbackVersionFromPrevRelease};
        List resultAvailableIdes = CollectionsKt.distinct((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        logger.info("Ready to show 3 latest versions (2 major " + this.majorVersion + " eap/release + " + this.nextMajorVersion + " eap) (" + product + ") before filtering by deploy target: " + resultAvailableIdes);
        return resultAvailableIdes;
    }

    private final String getReleaseType(ReleaseType type, String printableReleaseType) {
        logger.debug("Get release type for type: '" + type + "' and printableReleaseType '" + printableReleaseType + "'");
        if (printableReleaseType != null) {
            return " " + printableReleaseType;
        }
        return switch (WhenMappings.$EnumSwitchMapping$2[type.ordinal()]) {
            case 1 -> " RC";
            case 2 -> " EAP";
            default -> "";
        };
    }

    private final String trimSuffix(String version) {
        if (StringsKt.contains$default((CharSequence)version, (char)'-', (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{'-'};
            return (String)StringsKt.split$default((CharSequence)version, (char[])cArray, (boolean)false, (int)0, (int)6, null).get(0);
        }
        return version;
    }

    private static final int getAvailableIdes$lambda$1(AvailableIde l, AvailableIde r) {
        return VersionComparatorUtil.compare((String)r.getBuildNumber(), (String)l.getBuildNumber());
    }

    private static final int getAvailableIdes$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final CachingProductsJsonWrapper ourInstance_delegate$lambda$0() {
        CachingProductsJsonWrapperConfiguration cachingProductsJsonWrapperConfiguration = new DefaultCachingProductsJsonWrapperConfiguration();
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        return new CachingProductsJsonWrapper(cachingProductsJsonWrapperConfiguration, buildNumber);
    }

    public static final /* synthetic */ Map access$getCachedResponse$p(CachingProductsJsonWrapper $this) {
        return $this.cachedResponse;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CachingProductsJsonWrapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CachingProductsJsonWrapper.logger = logger;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new DeployTargetOS(DeployTargetOS.OSKind.Linux, DeployTargetOS.OSArch.X86_64), (Object)"213.5744.223"), TuplesKt.to((Object)new DeployTargetOS(DeployTargetOS.OSKind.Linux, DeployTargetOS.OSArch.ARM_64), (Object)"222.3345.118"), TuplesKt.to((Object)new DeployTargetOS(DeployTargetOS.OSKind.Windows, DeployTargetOS.OSArch.X86_64), (Object)"231"), TuplesKt.to((Object)new DeployTargetOS(DeployTargetOS.OSKind.Windows, DeployTargetOS.OSArch.ARM_64), (Object)"231"), TuplesKt.to((Object)new DeployTargetOS(DeployTargetOS.OSKind.MacOs, DeployTargetOS.OSArch.X86_64), (Object)"231"), TuplesKt.to((Object)new DeployTargetOS(DeployTargetOS.OSKind.MacOs, DeployTargetOS.OSArch.ARM_64), (Object)"231")};
        deployTargetAvailableSince = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0005R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/gateway/ssh/CachingProductsJsonWrapper$Companion;", "", "<init>", "()V", "ourInstance", "Lcom/jetbrains/gateway/ssh/CachingProductsJsonWrapper;", "getOurInstance", "()Lcom/jetbrains/gateway/ssh/CachingProductsJsonWrapper;", "ourInstance$delegate", "Lkotlin/Lazy;", "getInstance", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$intellij_gateway_core", "()Lcom/intellij/openapi/diagnostic/Logger;", "deployTargetAvailableSince", "", "Lcom/jetbrains/gateway/ssh/DeployTargetOS;", "", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        private final CachingProductsJsonWrapper getOurInstance() {
            Lazy lazy = ourInstance$delegate;
            return (CachingProductsJsonWrapper)lazy.getValue();
        }

        @NotNull
        public final CachingProductsJsonWrapper getInstance() {
            return this.getOurInstance();
        }

        @NotNull
        public final Logger getLogger$intellij_gateway_core() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[DeployTargetOS.OSKind.values().length];
            try {
                nArray[DeployTargetOS.OSKind.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeployTargetOS.OSKind.MacOs.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeployTargetOS.OSKind.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DeployTargetOS.OSArch.values().length];
            try {
                nArray[DeployTargetOS.OSArch.ARM_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeployTargetOS.OSArch.X86_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ReleaseType.values().length];
            try {
                nArray[ReleaseType.RC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReleaseType.EAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

