/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.following;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.following.ClientFollowMeManager;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.codeWithMe.model.RdFocusLocation;
import com.jetbrains.codeWithMe.model.RdToolWindowFocusLocation;
import com.jetbrains.rd.platform.codeWithMe.focus.UserFocusManager;
import com.jetbrains.rdserver.fileEditors.BackendFileEditorHandler;
import com.jetbrains.rdserver.ui.BackendUserFocusHost;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/cwm/plugin/following/BackendUserOperations;", "", "<init>", "()V", "jump", "", "who", "Lcom/intellij/openapi/client/ClientProjectSession;", "toWhom", "jumpTo", "session", "userFocus", "Lcom/jetbrains/codeWithMe/model/RdToolWindowFocusLocation;", "requestFollowing", "whom", "force", "", "requestStopFollowing", "intellij.cwm.plugin"})
@SourceDebugExtension(value={"SMAP\nBackendUserOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendUserOperations.kt\ncom/intellij/cwm/plugin/following/BackendUserOperations\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n23#2:71\n23#2:72\n23#2:73\n23#2:74\n23#2:75\n23#2:76\n23#2:77\n23#2:78\n*S KotlinDebug\n*F\n+ 1 BackendUserOperations.kt\ncom/intellij/cwm/plugin/following/BackendUserOperations\n*L\n18#1:71\n22#1:72\n29#1:73\n35#1:74\n43#1:75\n51#1:76\n61#1:77\n66#1:78\n*E\n"})
public final class BackendUserOperations {
    @NotNull
    public static final BackendUserOperations INSTANCE = new BackendUserOperations();

    private BackendUserOperations() {
    }

    public final void jump(@NotNull ClientProjectSession who, @NotNull ClientProjectSession toWhom) {
        RdToolWindowFocusLocation userFocus;
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Intrinsics.checkNotNullParameter((Object)toWhom, (String)"toWhom");
        Project project = who.getProject();
        BackendUserOperations $this$thisLogger$iv = this;
        boolean $i$f$thisLogger22 = false;
        Logger logger = Logger.getInstance(BackendUserOperations.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("[" + who + "] Jump to user " + toWhom);
        RdFocusLocation $i$f$thisLogger22 = BackendUserFocusHost.Companion.getCurrentFocus(toWhom);
        RdToolWindowFocusLocation rdToolWindowFocusLocation = userFocus = $i$f$thisLogger22 instanceof RdToolWindowFocusLocation ? (RdToolWindowFocusLocation)$i$f$thisLogger22 : null;
        if (userFocus != null) {
            this.jumpTo(who, userFocus);
            BackendUserOperations $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(BackendUserOperations.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.debug("[" + who + "] Jump was handled by BackendUserFocusManager");
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditor selectedEditor = (FileEditor)ClientId.Companion.withExplicitClientId(toWhom.getClientId(), () -> BackendUserOperations.jump$lambda$0(fileEditorManager));
        if (selectedEditor == null) {
            BackendUserOperations $this$thisLogger$iv3 = this;
            boolean $i$f$thisLogger = false;
            Logger logger3 = Logger.getInstance(BackendUserOperations.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.debug("[" + who + "] There is no selected editor");
            return;
        }
        VirtualFile fileToNavigate = selectedEditor.getFile();
        if (fileToNavigate == null) {
            BackendUserOperations $this$thisLogger$iv4 = this;
            boolean $i$f$thisLogger = false;
            Logger logger4 = Logger.getInstance(BackendUserOperations.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
            logger4.debug("[" + who + "] There is no file in selected editor");
            return;
        }
        FileEditorNavigatable fileEditorNavigatable = (FileEditorNavigatable)BackendFileEditorHandler.Companion.getEP_NAME().computeSafeIfAny(arg_0 -> BackendUserOperations.jump$lambda$1(project, selectedEditor, arg_0));
        if (fileEditorNavigatable == null) {
            fileEditorNavigatable = (FileEditorNavigatable)new OpenFileDescriptor(project, fileToNavigate);
        }
        FileEditorNavigatable navigatable = fileEditorNavigatable;
        BackendUserOperations $this$thisLogger$iv5 = this;
        boolean $i$f$thisLogger = false;
        Logger logger5 = Logger.getInstance(BackendUserOperations.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"getInstance(...)");
        logger5.info("jumping from " + who + " to " + toWhom + ". File: " + fileToNavigate);
        ClientId.Companion.withClientId(who.getClientId(), () -> BackendUserOperations.jump$lambda$2(fileEditorManager, navigatable));
    }

    public final void jumpTo(@NotNull ClientProjectSession session, @NotNull RdToolWindowFocusLocation userFocus) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)userFocus, (String)"userFocus");
        BackendUserOperations $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BackendUserOperations.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Object object = userFocus.getContentTabName();
        if (object == null) {
            object = "NULL";
        }
        logger.debug("[" + session + "] Jump to tab " + object + " with path " + CollectionsKt.joinToString$default((Iterable)userFocus.getPath(), null, null, null, (int)0, null, null, (int)63, null));
        if (session.isLocal()) {
            UserFocusManager.Companion.getInstance(session.getProject()).highlightFocus(userFocus);
        } else {
            BackendUserFocusHost.Companion.getInstance(session).jumpTo(userFocus);
        }
    }

    public final void requestFollowing(@NotNull ClientProjectSession who, @NotNull ClientProjectSession whom, boolean force) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Intrinsics.checkNotNullParameter((Object)whom, (String)"whom");
        BackendUserOperations $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BackendUserOperations.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("[" + who + "] Ask user " + whom.getClientId() + ":'" + whom.getName() + "' for following...");
        ClientFollowMeManager.Companion.getInstance(whom).requestFollowing(who, force);
    }

    public final void requestStopFollowing(@NotNull ClientProjectSession who, @NotNull ClientProjectSession whom) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Intrinsics.checkNotNullParameter((Object)whom, (String)"whom");
        BackendUserOperations $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BackendUserOperations.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("[" + who + "] Tell user " + whom.getClientId() + ":'" + whom.getName() + "' to stop following user...");
        ClientProjectSession session = ClientSessionsUtil.session((Project)who.getProject(), (ClientId)whom.getClientId());
        ClientFollowMeManager.Companion.getInstance(session).requestStopFollowing();
    }

    private static final FileEditor jump$lambda$0(FileEditorManager $fileEditorManager) {
        return $fileEditorManager.getSelectedEditor();
    }

    private static final FileEditorNavigatable jump$lambda$1(Project $project, FileEditor $selectedEditor, BackendFileEditorHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createFollowNavigatable($project, $selectedEditor);
    }

    private static final List jump$lambda$2(FileEditorManager $fileEditorManager, FileEditorNavigatable $navigatable) {
        return $fileEditorManager.openFileEditor($navigatable, true);
    }
}

