/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.permissions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.cwm.plugin.permissions.OsRegistryPermissionRestrictions;
import com.intellij.cwm.plugin.permissions.PermissionStore;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.FileVisibilityProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import com.jetbrains.rd.platform.codeWithMe.permissions.FileAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.RunAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.TerminalAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.ToolWindowAccessLevel;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.permissions.ClientPermissionListener;
import com.jetbrains.rdserver.permissions.PermissionModel;
import com.jetbrains.rdserver.permissions.SharedPermissionManagerListener;
import com.jetbrains.rdserver.permissions.impl.PermissionVisibility;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 92\u00020\u0001:\u00029:B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000bJ$\u0010\u0018\u001a\u00020\u00152\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0016\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eJ\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\nJ\u0016\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\u0006\u0010$\u001a\u00020%J\u001f\u0010&\u001a\u0004\u0018\u00010 2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020%H\u0002\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020\u000bH\u0002J\u0016\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\u0006\u0010,\u001a\u00020-J\u0016\u0010.\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\u0006\u0010$\u001a\u00020%J\u0016\u0010.\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\u0006\u0010,\u001a\u00020-J\u000e\u0010/\u001a\u0002002\u0006\u0010!\u001a\u00020\nJ\u000e\u00101\u001a\u0002022\u0006\u0010!\u001a\u00020\nJ\u000e\u00103\u001a\u0002042\u0006\u0010!\u001a\u00020\nJ\u000e\u00105\u001a\u00020 2\u0006\u0010!\u001a\u00020\nJ\u000e\u00106\u001a\u0002072\u0006\u0010!\u001a\u00020\nJ\u0010\u00108\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/cwm/plugin/permissions/CwmSharedPermissionManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "locker", "Ljava/lang/Object;", "userPermissions", "", "Lcom/intellij/codeWithMe/ClientId;", "Lcom/jetbrains/rdserver/permissions/PermissionModel;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jetbrains/rdserver/permissions/SharedPermissionManagerListener;", "getProjectPermissionModel", "getMaximumPossiblePermissionModel", "getClientPermissionModel", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "applyProjectPermissionModel", "", "model", "applyClientPermissionModel", "applyModel", "addListener", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "listener", "logRestrictions", "adjusted", "hasFullAccess", "", "client", "hasFileWriteAccess", "isVisible", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isVisibleInternal", "clientId", "file", "(Lcom/intellij/codeWithMe/ClientId;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Boolean;", "isHiddenInPermissionSettings", "permissions", "document", "Lcom/intellij/openapi/editor/Document;", "isWritable", "getTerminalAccess", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/TerminalAccessLevel;", "getRunAccess", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/RunAccessLevel;", "getToolWindowAccess", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/ToolWindowAccessLevel;", "hasStatusBarWidgetAccess", "getFileAccess", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/FileAccessLevel;", "getPermissionModelInternal", "Companion", "MyFileVisibilityProvider", "intellij.cwm.plugin"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCwmSharedPermissionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmSharedPermissionManager.kt\ncom/intellij/cwm/plugin/permissions/CwmSharedPermissionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 util.kt\ncom/intellij/util/containers/UtilKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,316:1\n1#2:317\n174#3,18:318\n67#4,4:336\n67#4,4:340\n67#4,4:344\n13#4:349\n13#5:348\n*S KotlinDebug\n*F\n+ 1 CwmSharedPermissionManager.kt\ncom/intellij/cwm/plugin/permissions/CwmSharedPermissionManager\n*L\n121#1:318,18\n250#1:336,4\n260#1:340,4\n270#1:344,4\n55#1:349\n55#1:348\n*E\n"})
public final class CwmSharedPermissionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Object locker;
    @NotNull
    private final Map<ClientId, PermissionModel> userPermissions;
    @NotNull
    private final CopyOnWriteArrayList<SharedPermissionManagerListener> listeners;
    @NotNull
    private static final Logger logger;

    public CwmSharedPermissionManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.locker = new Object();
        this.userPermissions = new LinkedHashMap();
        this.listeners = new CopyOnWriteArrayList();
    }

    @NotNull
    public final PermissionModel getProjectPermissionModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PermissionModel unrestricted = PermissionStore.Companion.getInstance(project).getModel();
        return OsRegistryPermissionRestrictions.INSTANCE.restrict(unrestricted);
    }

    @NotNull
    public final PermissionModel getMaximumPossiblePermissionModel() {
        return OsRegistryPermissionRestrictions.INSTANCE.maximumAllowed$intellij_cwm_plugin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PermissionModel getClientPermissionModel(@NotNull ClientProjectSession session) {
        PermissionModel permissionModel;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object object = this.locker;
        synchronized (object) {
            boolean bl = false;
            permissionModel = this.getPermissionModelInternal(session.getClientId());
        }
        PermissionModel unrestricted = permissionModel;
        return OsRegistryPermissionRestrictions.INSTANCE.restrict(unrestricted);
    }

    public final void applyProjectPermissionModel(@NotNull Project project, @NotNull PermissionModel model2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.applyModel(project, null, model2);
    }

    public final void applyClientPermissionModel(@NotNull ClientProjectSession session, @NotNull PermissionModel model2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.applyModel(null, session, model2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyModel(Project project, ClientProjectSession session, PermissionModel model2) {
        Triple triple2;
        boolean bl;
        boolean bl2 = bl = project != null && session == null || project == null && session != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Project project2 = project;
        if (project2 == null) {
            ClientProjectSession clientProjectSession = session;
            Intrinsics.checkNotNull((Object)clientProjectSession);
            project2 = clientProjectSession.getProject();
        }
        Project project3 = project2;
        Object object = this.locker;
        synchronized (object) {
            ClientProjectSession clientProjectSession;
            block18: {
                block17: {
                    boolean triple2 = false;
                    clientProjectSession = session;
                    if (clientProjectSession == null) break block17;
                    ClientProjectSession it = clientProjectSession;
                    boolean bl3 = false;
                    PermissionModel permissionModel = this.userPermissions.get(it.getClientId());
                    clientProjectSession = permissionModel;
                    if (permissionModel != null) break block18;
                }
                clientProjectSession = PermissionStore.Companion.getInstance(project3).getModel();
            }
            ClientProjectSession oldPermissions = clientProjectSession;
            PermissionModel newPermissions = model2.combine(OsRegistryPermissionRestrictions.INSTANCE.maximumAllowed$intellij_cwm_plugin());
            this.logRestrictions(newPermissions, model2);
            if (session == null) {
                logger.debug("Set global permissions: " + newPermissions.dump());
                PermissionStore.Companion.getInstance(project3).setModel(newPermissions);
            } else {
                logger.debug("Set client " + session + " permissions: " + newPermissions.dump());
                this.userPermissions.put(session.getClientId(), newPermissions);
            }
            triple2 = new Triple((Object)oldPermissions, (Object)newPermissions, this.userPermissions.keySet());
        }
        Triple triple3 = triple2;
        PermissionModel oldPermissions = (PermissionModel)triple3.component1();
        PermissionModel newPermissions = (PermissionModel)triple3.component2();
        Set ignoredClients = (Set)triple3.component3();
        ClientPermissionListener publisher = (ClientPermissionListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(ClientPermissionListener.Companion.getTOPIC());
        if (session == null) {
            for (ClientAppSession appSession : ClientSessionsUtil.sessions((Application)ApplicationKt.getApplication(), (ClientKind)ClientKind.GUEST)) {
                if (ignoredClients.contains(appSession.getClientId())) continue;
                publisher.permissionsChanged(appSession, oldPermissions, newPermissions);
            }
        } else {
            publisher.permissionsChanged(session.getAppSession(), oldPermissions, newPermissions);
        }
        Collection $this$forEachGuaranteed$iv = this.listeners;
        boolean $i$f$forEachGuaranteed = false;
        Iterator $this$forEachGuaranteed$iv$iv = $this$forEachGuaranteed$iv.iterator();
        boolean $i$f$forEachGuaranteed2 = false;
        List errors$iv$iv = null;
        Iterator iterator = $this$forEachGuaranteed$iv$iv;
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            try {
                SharedPermissionManagerListener it = (SharedPermissionManagerListener)element$iv$iv;
                boolean bl4 = false;
                it.permissionsChanged();
            }
            catch (Throwable e$iv$iv) {
                if (errors$iv$iv == null) {
                    errors$iv$iv = (List)new SmartList();
                }
                errors$iv$iv.add(e$iv$iv);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty(errors$iv$iv);
    }

    public final void addListener(@NotNull Lifetime lifetime, @NotNull SharedPermissionManagerListener listener) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        CollectionExKt.addUnique((Collection)this.listeners, (Lifetime)lifetime, (Object)listener);
    }

    private final void logRestrictions(PermissionModel adjusted, PermissionModel model2) {
        block4: {
            String string;
            StringBuilder builder = new StringBuilder();
            if (adjusted.getFileAccess().compareTo((Enum)model2.getFileAccess()) < 0) {
                builder.append("File access was reduced to " + adjusted.getFileAccess().name() + ", ");
            }
            if (adjusted.getTerminalAccess().compareTo((Enum)model2.getTerminalAccess()) < 0) {
                builder.append("Terminal access was reduced to " + adjusted.getTerminalAccess().name() + ", ");
            }
            if (adjusted.getRunAccess().compareTo((Enum)model2.getRunAccess()) < 0) {
                builder.append("Run/Debug access was reduced to " + adjusted.getRunAccess().name() + ", ");
            }
            if (adjusted.getToolWindowAccess().compareTo((Enum)model2.getToolWindowAccess()) < 0) {
                builder.append("ToolWindow access was reduced to " + adjusted.getToolWindowAccess().name() + ".");
            }
            String it = string = builder.toString();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 == null) break block4;
            it = string2;
            boolean bl2 = false;
            logger.warn(it);
        }
    }

    public final boolean hasFullAccess(@NotNull ClientId client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (UserManagerKt.isOwner((ClientId)client)) {
            return true;
        }
        return this.hasFileWriteAccess(client) && this.getRunAccess(client) == RunAccessLevel.FullAccess && this.getTerminalAccess(client) == TerminalAccessLevel.FullAccess && this.getToolWindowAccess(client) == ToolWindowAccessLevel.FullAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasFileWriteAccess(@NotNull ClientId client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (UserManagerKt.isOwner((ClientId)client)) {
            return true;
        }
        Object object = this.locker;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.getPermissionModelInternal(client).getFileAccess() == FileAccessLevel.FullAccess;
            return bl2;
        }
    }

    public final boolean isVisible(@NotNull ClientId client, @NotNull VirtualFile virtualFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (UserManagerKt.isOwner((ClientId)client)) {
            return true;
        }
        Ref.ObjectRef file2 = new Ref.ObjectRef();
        file2.element = virtualFile;
        if (virtualFile instanceof LightVirtualFileBase) {
            VirtualFile virtualFile2 = ((LightVirtualFileBase)virtualFile).getOriginalFile();
            if (virtualFile2 == null) {
                return true;
            }
            file2.element = virtualFile2;
        }
        if (Registry.Companion.is("ide.permissions.api.enabled")) {
            bl = (Boolean)ClientId.Companion.withClientId(client, () -> CwmSharedPermissionManager.isVisible$lambda$0(this, file2));
        } else {
            Boolean bl2 = this.isVisibleInternal(client, virtualFile);
            bl = bl2 != null ? bl2 : false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Boolean isVisibleInternal(ClientId clientId, VirtualFile file2) {
        Object object;
        Object object2 = this.locker;
        synchronized (object2) {
            block15: {
                VirtualFile projectDirectory;
                PermissionModel permissions;
                block14: {
                    block13: {
                        boolean bl = false;
                        permissions = this.getPermissionModelInternal(clientId);
                        if (!this.isHiddenInPermissionSettings(file2, permissions)) break block13;
                        Boolean bl2 = false;
                        return bl2;
                    }
                    if (!file2.isDirectory()) break block14;
                    Boolean bl = true;
                    return bl;
                }
                if (permissions.getFileAccess() != FileAccessLevel.FullAccess || (projectDirectory = ProjectUtil.guessProjectDir((Project)this.project)) == null || !VfsUtil.isAncestor((VirtualFile)projectDirectory, (VirtualFile)file2, (boolean)false)) break block15;
                Boolean bl = true;
                return bl;
            }
            object = Unit.INSTANCE;
        }
        ClientProjectSession session = ClientSessionsUtil.session((Project)this.project, (ClientId)clientId);
        object2 = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-162397");
        object = null;
        try {
            AccessToken it = (AccessToken)object2;
            boolean bl = false;
            if (PermissionVisibility.Companion.getEP().findFirstSafe(arg_0 -> CwmSharedPermissionManager.isVisibleInternal$lambda$1$1(arg_0 -> CwmSharedPermissionManager.isVisibleInternal$lambda$1$0(session, file2, arg_0), arg_0)) != null) {
                Boolean bl3 = true;
                return bl3;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)object);
        }
        return null;
    }

    private final boolean isHiddenInPermissionSettings(VirtualFile virtualFile, PermissionModel permissions) {
        VirtualFile file2;
        VirtualFileSystem virtualFileSystem = virtualFile.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        VirtualFileSystem fileSystem = virtualFileSystem;
        VirtualFile virtualFile2 = file2 = fileSystem instanceof ArchiveFileSystem ? ((ArchiveFileSystem)fileSystem).getLocalByEntry(virtualFile) : virtualFile;
        if (file2 == null || !file2.isInLocalFileSystem()) {
            return false;
        }
        Path path = file2.getFileSystem().getNioPath(file2);
        if (path == null) {
            return false;
        }
        Path path2 = path;
        for (Path invisibleFile : permissions.getExcludedFiles()) {
            if (!path2.startsWith(invisibleFile)) continue;
            logger.debug("Request to invisible file " + virtualFile);
            return true;
        }
        return false;
    }

    public final boolean isVisible(@NotNull ClientId client, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (UserManagerKt.isOwner((ClientId)client)) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        return file2 == null || this.isVisible(client, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isWritable(@NotNull ClientId client, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (UserManagerKt.isOwner((ClientId)client)) {
            return true;
        }
        Object object = this.locker;
        synchronized (object) {
            boolean bl = false;
            PermissionModel permissions = this.getPermissionModelInternal(client);
            boolean bl2 = permissions.getFileAccess() == FileAccessLevel.FullAccess && this.isVisible(client, virtualFile);
            return bl2;
        }
    }

    public final boolean isWritable(@NotNull ClientId client, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (UserManagerKt.isOwner((ClientId)client)) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            return this.hasFileWriteAccess(client);
        }
        return this.isWritable(client, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final TerminalAccessLevel getTerminalAccess(@NotNull ClientId client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (UserManagerKt.isOwner((ClientId)client)) {
            return TerminalAccessLevel.FullAccess;
        }
        Object object = this.locker;
        synchronized (object) {
            TerminalAccessLevel terminalAccessLevel;
            boolean bl = false;
            TerminalAccessLevel it = terminalAccessLevel = this.getPermissionModelInternal(client).getTerminalAccess();
            boolean bl2 = false;
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl3 = false;
                logger.trace("Request terminal access for " + client + ": " + it);
            }
            TerminalAccessLevel terminalAccessLevel2 = terminalAccessLevel;
            return terminalAccessLevel2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RunAccessLevel getRunAccess(@NotNull ClientId client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (UserManagerKt.isOwner((ClientId)client)) {
            return RunAccessLevel.FullAccess;
        }
        Object object = this.locker;
        synchronized (object) {
            RunAccessLevel runAccessLevel;
            boolean bl = false;
            RunAccessLevel it = runAccessLevel = this.getPermissionModelInternal(client).getRunAccess();
            boolean bl2 = false;
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl3 = false;
                logger.trace("Request run access for " + client + ": " + it);
            }
            RunAccessLevel runAccessLevel2 = runAccessLevel;
            return runAccessLevel2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ToolWindowAccessLevel getToolWindowAccess(@NotNull ClientId client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (UserManagerKt.isOwner((ClientId)client)) {
            return ToolWindowAccessLevel.FullAccess;
        }
        Object object = this.locker;
        synchronized (object) {
            ToolWindowAccessLevel toolWindowAccessLevel;
            boolean bl = false;
            ToolWindowAccessLevel it = toolWindowAccessLevel = this.getPermissionModelInternal(client).getToolWindowAccess();
            boolean bl2 = false;
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl3 = false;
                logger.trace("Request tool window access for " + client + ": " + it);
            }
            ToolWindowAccessLevel toolWindowAccessLevel2 = toolWindowAccessLevel;
            return toolWindowAccessLevel2;
        }
    }

    public final boolean hasStatusBarWidgetAccess(@NotNull ClientId client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return UserManagerKt.isOwner((ClientId)client);
    }

    @NotNull
    public final FileAccessLevel getFileAccess(@NotNull ClientId client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return this.hasFileWriteAccess(client) ? FileAccessLevel.FullAccess : FileAccessLevel.Readonly;
    }

    private final PermissionModel getPermissionModelInternal(ClientId client) {
        if (UserManagerKt.isOwner((ClientId)client)) {
            logger.error("Non guest client is used for the permissions");
            return PermissionModel.Companion.getFULL_ACCESS();
        }
        PermissionModel permissionModel = this.userPermissions.get(client);
        if (permissionModel == null) {
            permissionModel = PermissionStore.Companion.getInstance(this.project).getModel();
        }
        return permissionModel;
    }

    private static final boolean isVisible$lambda$0(CwmSharedPermissionManager this$0, Ref.ObjectRef $file) {
        return FileVisibilityProvider.Companion.isVisible(this$0.project, (VirtualFile)$file.element, false);
    }

    private static final boolean isVisibleInternal$lambda$1$0(ClientProjectSession $session, VirtualFile $file, PermissionVisibility it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isVisible($session, $file);
    }

    private static final boolean isVisibleInternal$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CwmSharedPermissionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CwmSharedPermissionManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/permissions/CwmSharedPermissionManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/cwm/plugin/permissions/CwmSharedPermissionManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cwm.plugin"})
    @SourceDebugExtension(value={"SMAP\nCwmSharedPermissionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmSharedPermissionManager.kt\ncom/intellij/cwm/plugin/permissions/CwmSharedPermissionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,316:1\n30#2,2:317\n*S KotlinDebug\n*F\n+ 1 CwmSharedPermissionManager.kt\ncom/intellij/cwm/plugin/permissions/CwmSharedPermissionManager$Companion\n*L\n57#1:317,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CwmSharedPermissionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CwmSharedPermissionManager> serviceClass$iv = CwmSharedPermissionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CwmSharedPermissionManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/cwm/plugin/permissions/CwmSharedPermissionManager$MyFileVisibilityProvider;", "Lcom/intellij/openapi/vfs/FileVisibilityProvider;", "<init>", "()V", "isVisible", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Boolean;", "intellij.cwm.plugin"})
    private static final class MyFileVisibilityProvider
    implements FileVisibilityProvider {
        @Nullable
        public Boolean isVisible(@NotNull Project project, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            CwmSharedPermissionManager manager = Companion.getInstance(project);
            ClientId clientId = ClientId.Companion.getCurrent();
            return manager.isVisibleInternal(clientId, file2);
        }
    }
}

