/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.toolWindow;

import com.intellij.cwm.plugin.common.toolWindow.ToolwindowMirrorModeTracker;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.ide.model.uiautomation.BeToolWindowState;
import com.jetbrains.rd.platform.codeWithMe.permissions.ToolWindowAccessLevel;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rdserver.permissions.ClientPermissionListener;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.permissions.PermissionModel;
import com.jetbrains.rdserver.toolWindow.BackendToolWindowHost;
import com.jetbrains.rdserver.toolWindow.BackendToolWindowModeProvider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/toolWindow/BackendToolwindowMirrorModeTracker;", "Lcom/intellij/cwm/plugin/common/toolWindow/ToolwindowMirrorModeTracker;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "updateMirroredWindows", "", "intellij.cwm.plugin"})
public final class BackendToolwindowMirrorModeTracker
extends ToolwindowMirrorModeTracker {
    public BackendToolwindowMirrorModeTracker(@NotNull Lifetime lifetime, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null);
        MessageBusConnection connection = project.getMessageBus().connect(disposable);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ToolWindowManagerListener(){

            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ActionsKt.invokeLater$default(null, () -> 1.stateChanged$lambda$0(this), (int)1, null);
            }

            private static final Unit stateChanged$lambda$0(BackendToolwindowMirrorModeTracker this$0) {
                this$0.updateMirroredWindows();
                return Unit.INSTANCE;
            }
        });
        UserManager.Companion.getInstance(project).getUsers().getChange().advise(ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> BackendToolwindowMirrorModeTracker._init_$lambda$0(this, arg_0));
        ApplicationKt.getApplication().getMessageBus().connect(disposable).subscribe(ClientPermissionListener.Companion.getTOPIC(), (Object)new ClientPermissionListener(){

            public void permissionsChanged(ClientAppSession session, PermissionModel old, PermissionModel permissionModel) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                Intrinsics.checkNotNullParameter((Object)permissionModel, (String)"new");
                ActionsKt.invokeLater$default(null, () -> 3.permissionsChanged$lambda$0(this), (int)1, null);
            }

            private static final Unit permissionsChanged$lambda$0(BackendToolwindowMirrorModeTracker this$0) {
                this$0.updateMirroredWindows();
                return Unit.INSTANCE;
            }
        });
        this.updateMirroredWindows();
    }

    public void updateMirroredWindows() {
        if (this.getProject().isDisposed()) {
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.Companion.getInstance(this.getProject());
        for (String toolWindowId : windowManager.getToolWindowIds()) {
            if (!BackendToolWindowModeProvider.INSTANCE.getBackendToolWindowMode(toolWindowId, ClientSessionsUtil.getCurrentSession((Project)this.getProject())).isMirrorLike()) continue;
            int openCounter = 0;
            ToolWindow hostWindow = windowManager.getToolWindow(toolWindowId);
            if (hostWindow != null && hostWindow.isVisible()) {
                ++openCounter;
            }
            for (BackendToolWindowHost windowHost : BackendToolWindowHost.Companion.getAllInstances(this.getProject())) {
                BeToolWindowState clientWindowState = windowHost.getToolWindowState(toolWindowId);
                ToolWindowAccessLevel access = ClientPermissionManager.Companion.getInstance(windowHost.getSession()).getToolWindowAccess();
                if (clientWindowState == BeToolWindowState.Hidden || access == ToolWindowAccessLevel.Disabled) continue;
                ++openCounter;
            }
            boolean isSharedAccess = openCounter > 1;
            for (BackendToolWindowHost windowHost : BackendToolWindowHost.Companion.getAllInstances(this.getProject())) {
                windowHost.setSharedAccess(toolWindowId, isSharedAccess);
            }
            if (hostWindow == null) continue;
            this.updateWindowNotification(hostWindow, isSharedAccess);
        }
    }

    private static final Unit lambda$0$0(BackendToolwindowMirrorModeTracker this$0) {
        this$0.updateMirroredWindows();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(BackendToolwindowMirrorModeTracker this$0, IViewableList.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ActionsKt.invokeLater$default(null, () -> BackendToolwindowMirrorModeTracker.lambda$0$0(this$0), (int)1, null);
        return Unit.INSTANCE;
    }
}

