/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.wm.BaseFocusWatcher;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.SwingUndoUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class FocusWatcher
extends BaseFocusWatcher {
    private WeakReference<Component> focusedComponent;

    @Override
    protected void componentUnregistered(Component component, @Nullable AWTEvent cause) {
        if (this.getFocusedComponent() == component) {
            this.setFocusedComponentImpl(null, cause);
        }
    }

    @Override
    public final void focusGained(FocusEvent e) {
        JTextComponent textComponent;
        Component component = e.getComponent();
        if (e.isTemporary() || !component.isShowing()) {
            return;
        }
        if (component instanceof JTextComponent && (textComponent = (JTextComponent)component).isEditable()) {
            SwingUndoUtil.addUndoRedoActions(textComponent);
        }
        this.setFocusedComponentImpl(component, e);
    }

    @Override
    public final void focusLost(FocusEvent e) {
        Component component = e.getOppositeComponent();
        if (component != null && !SwingUtilities.isDescendingFrom(component, this.getTopComponent())) {
            this.focusLostImpl(e);
        }
    }

    public final Component getFocusedComponent() {
        return (Component)SoftReference.dereference(this.focusedComponent);
    }

    @ApiStatus.Internal
    public void setFocusedComponentImpl(Component component) {
        this.setFocusedComponentImpl(component, null);
    }

    private void setFocusedComponentImpl(Component component, @Nullable AWTEvent cause) {
        if (!this.isFocusedComponentChangeValid(component, cause)) {
            return;
        }
        if (ComponentUtil.isFocusProxy(component)) {
            this._setFocused(this.getFocusedComponent(), cause);
            return;
        }
        this._setFocused(component, cause);
    }

    private void _setFocused(Component component, AWTEvent cause) {
        this.focusedComponent = new WeakReference<Component>(component);
        this.focusedComponentChanged(component, cause);
    }

    protected boolean isFocusedComponentChangeValid(@Nullable Component component, @Nullable AWTEvent cause) {
        return component != null || cause != null;
    }

    protected void focusedComponentChanged(@Nullable Component component, @Nullable AWTEvent cause) {
    }

    @ApiStatus.Internal
    protected void focusLostImpl(FocusEvent e) {
    }
}

