/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.CacheKey;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.icons.ImageCache;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageDescriptorKt;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.svg.SvgAttributePatcher;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SVGLoader;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001an\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0000\u001aD\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\"\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001ah\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0010\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001aF\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006)"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "loadImageByClassLoader", "Ljava/awt/Image;", "path", "", "classLoader", "Ljava/lang/ClassLoader;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "loadImage", "resourceClass", "Ljava/lang/Class;", "isDark", "", "colorPatcherProvider", "Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "filters", "", "Ljava/awt/image/ImageFilter;", "isStroke", "useCache", "loadByDescriptorWithoutCache", "rawPathWithoutExt", "ext", "descriptor", "Lcom/intellij/ui/icons/ImageDescriptor;", "loadByDescriptor", "ioMissCache", "", "imageCache", "Lcom/intellij/ui/icons/ImageCache;", "ioMissCacheKey", "doLoadByDescriptor", "Ljava/awt/image/BufferedImage;", "colorPatcherDigest", "", "colorPatcher", "Lcom/intellij/ui/svg/SvgAttributePatcher;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nimageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 imageCache.kt\ncom/intellij/ui/icons/ImageCacheKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,277:1\n13#2:278\n*S KotlinDebug\n*F\n+ 1 imageCache.kt\ncom/intellij/ui/icons/ImageCacheKt\n*L\n32#1:278\n*E\n"})
public final class ImageCacheKt {
    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImageCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Image loadImageByClassLoader(@NotNull String path, @NotNull ClassLoader classLoader, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        return ImageCacheKt.loadImage$default(path, null, classLoader, scaleContext, StartupUiUtil.INSTANCE.isDarkTheme(), null, null, false, false, 226, null);
    }

    @Nullable
    public static final Image loadImage(@NotNull String path, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, @NotNull ScaleContext scaleContext, boolean isDark, @Nullable SVGLoader.SvgElementColorPatcherProvider colorPatcherProvider, @NotNull List<? extends ImageFilter> filters, boolean isStroke, boolean useCache) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        List<ImageDescriptor> descriptors = ImageDescriptorKt.createImageDescriptorList(path, isDark, isStroke, (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE));
        int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
        String rawPathWithoutExt = null;
        String ext = null;
        if (lastDotIndex == -1) {
            rawPathWithoutExt = path;
            ext = "svg";
        } else {
            String string = path.substring(0, lastDotIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            rawPathWithoutExt = string;
            String string2 = path.substring(lastDotIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            ext = string2;
        }
        Iterator iterator = ((Iterable)descriptors).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            ImageDescriptor descriptor = (ImageDescriptor)iterator.next();
            try {
                Image image = null;
                if (useCache) {
                    image = ImageCacheKt.loadByDescriptor(rawPathWithoutExt, ext, descriptor, resourceClass, classLoader, i == 0 ? ImageCache.ioMissCache : null, ImageCache.INSTANCE, path, colorPatcherProvider);
                } else {
                    if (i == 0 && ImageCache.ioMissCache.contains(path)) {
                        return null;
                    }
                    image = ImageCacheKt.loadByDescriptorWithoutCache(rawPathWithoutExt, ext, descriptor, resourceClass, classLoader, colorPatcherProvider);
                }
                if (image == null) continue;
                if (start != -1L) {
                    IconLoadMeasurer.INSTANCE.addLoading(descriptor.isSvg, start);
                }
                return IconUtilKt.convertImage(image, filters, scaleContext, !descriptor.isSvg, descriptor.scale);
            }
            catch (IOException e) {
                ImageCacheKt.getLOG().debug((Throwable)e);
            }
        }
        ImageCache.ioMissCache.add(path);
        return null;
    }

    public static /* synthetic */ Image loadImage$default(String string, Class clazz, ClassLoader classLoader, ScaleContext scaleContext, boolean bl, SVGLoader.SvgElementColorPatcherProvider svgElementColorPatcherProvider, List list, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            clazz = null;
        }
        if ((n & 8) != 0) {
            scaleContext = ScaleContext.Companion.create();
        }
        if ((n & 0x10) != 0) {
            bl = StartupUiUtil.INSTANCE.isDarkTheme();
        }
        if ((n & 0x20) != 0) {
            svgElementColorPatcherProvider = null;
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        return ImageCacheKt.loadImage(string, clazz, classLoader, scaleContext, bl, svgElementColorPatcherProvider, list, bl2, bl3);
    }

    private static final Image loadByDescriptorWithoutCache(String rawPathWithoutExt, String ext, ImageDescriptor descriptor, Class<?> resourceClass, ClassLoader classLoader, SVGLoader.SvgElementColorPatcherProvider colorPatcherProvider) {
        String path = (String)descriptor.pathTransform.invoke((Object)rawPathWithoutExt, (Object)ext);
        SVGLoader.SvgElementColorPatcherProvider svgElementColorPatcherProvider = colorPatcherProvider;
        return ImageCacheKt.doLoadByDescriptor(path, descriptor, resourceClass, classLoader, SvgKt.colorPatcherDigestShim(colorPatcherProvider), svgElementColorPatcherProvider != null ? svgElementColorPatcherProvider.attributeForPath(path) : null);
    }

    @Nullable
    public static final Image loadByDescriptor(@NotNull String rawPathWithoutExt, @NotNull String ext, @NotNull ImageDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)rawPathWithoutExt, (String)"rawPathWithoutExt");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ImageCache imageCache = ImageCache.INSTANCE;
        return ImageCacheKt.loadByDescriptor(rawPathWithoutExt, ext, descriptor, null, null, null, imageCache, null, null);
    }

    private static final Image loadByDescriptor(String rawPathWithoutExt, String ext, ImageDescriptor descriptor, Class<?> resourceClass, ClassLoader classLoader, Set<String> ioMissCache, ImageCache imageCache, String ioMissCacheKey, SVGLoader.SvgElementColorPatcherProvider colorPatcherProvider) {
        CacheKey cacheKey;
        BufferedImage bufferedImage;
        long[] digest = null;
        String path = (String)descriptor.pathTransform.invoke((Object)rawPathWithoutExt, (Object)ext);
        SvgAttributePatcher colorPatcher = null;
        if (colorPatcherProvider != null && (colorPatcher = colorPatcherProvider.attributeForPath(path)) != null) {
            digest = SvgKt.colorPatcherDigestShim(colorPatcherProvider);
        }
        if (digest == null) {
            Intrinsics.checkNotNull((Object)ArrayUtilRt.EMPTY_LONG_ARRAY);
            digest = ArrayUtilRt.EMPTY_LONG_ARRAY;
        }
        if ((bufferedImage = (BufferedImage)ImageCache.imageCache.getIfPresent((Object)(cacheKey = new CacheKey(path, descriptor.isSvg ? descriptor.scale : 0.0f, digest)))) != null) {
            BufferedImage it = bufferedImage;
            boolean bl = false;
            return it;
        }
        if (ioMissCache != null && ioMissCache.contains(ioMissCacheKey)) {
            return null;
        }
        BufferedImage bufferedImage2 = ImageCacheKt.doLoadByDescriptor(path, descriptor, resourceClass, classLoader, digest, colorPatcher);
        if (bufferedImage2 == null) {
            return null;
        }
        BufferedImage image = bufferedImage2;
        ImageCache.imageCache.put((Object)cacheKey, (Object)image);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BufferedImage doLoadByDescriptor(String path, ImageDescriptor descriptor, Class<?> resourceClass, ClassLoader classLoader, long[] colorPatcherDigest, SvgAttributePatcher colorPatcher) {
        BufferedImage image = null;
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        if (resourceClass == null && (classLoader == null || URLUtil.containsScheme((String)path)) && !StringsKt.startsWith$default((String)path, (String)"file:/", (boolean)false, (int)2, null)) {
            URLConnection connection = new URL(path).openConnection();
            HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
            if (httpURLConnection != null) {
                httpURLConnection.addRequestProperty("User-Agent", "IntelliJ");
            }
            Closeable closeable = connection.getInputStream();
            Throwable throwable = null;
            try {
                BufferedImage bufferedImage;
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                if (descriptor.isSvg) {
                    float f = descriptor.scale;
                    int n = descriptor.toSvgMapper-DHyELdI$intellij_platform_util_ui();
                    long[] lArray = colorPatcherDigest;
                    if (colorPatcherDigest == null) {
                        lArray = ArrayUtilRt.EMPTY_LONG_ARRAY;
                    }
                    long[] lArray2 = lArray;
                    Intrinsics.checkNotNull((Object)lArray2);
                    long[] lArray3 = lArray2;
                    bufferedImage = SvgKt.loadSvgAndCacheIfApplicable-F6nGey4(path, f, n, colorPatcher, lArray3, (Function0<byte[]>)((Function0)() -> ImageCacheKt.doLoadByDescriptor$lambda$0$0(stream)));
                } else {
                    Intrinsics.checkNotNull((Object)stream);
                    bufferedImage = IconUtilKt.loadRasterImage(stream);
                }
                image = bufferedImage;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (start != -1L) {
                IconLoadMeasurer.loadFromUrl.end(start);
            }
        } else {
            if (descriptor.isSvg) {
                float f = descriptor.scale;
                int n = descriptor.toSvgMapper-DHyELdI$intellij_platform_util_ui();
                long[] lArray = colorPatcherDigest;
                if (colorPatcherDigest == null) {
                    lArray = ArrayUtilRt.EMPTY_LONG_ARRAY;
                }
                long[] lArray4 = lArray;
                Intrinsics.checkNotNull((Object)lArray4);
                long[] lArray5 = lArray4;
                v4 = SvgKt.loadSvgAndCacheIfApplicable-F6nGey4(path, f, n, colorPatcher, lArray5, (Function0<byte[]>)((Function0)() -> ImageCacheKt.doLoadByDescriptor$lambda$1(path, resourceClass, classLoader)));
            } else {
                v4 = image = IconUtilKt.loadPngFromClassResource(path, classLoader, resourceClass);
            }
            if (start != -1L) {
                IconLoadMeasurer.loadFromResources.end(start);
            }
        }
        return image;
    }

    private static final byte[] doLoadByDescriptor$lambda$0$0(InputStream $stream) {
        return $stream.readAllBytes();
    }

    private static final byte[] doLoadByDescriptor$lambda$1(String $path, Class $resourceClass, ClassLoader $classLoader) {
        return IconUtilKt.getResourceData($path, $resourceClass, $classLoader);
    }
}

