/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.svg.JSvgDocumentFactoryKt;
import com.intellij.ui.svg.JsvgKt;
import com.intellij.ui.svg.SvgAttributePatcher;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.SVGLoaderKt;
import com.intellij.util.ui.ImageUtil;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0006\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ2\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007J\"\u0010\u0014\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0010H\u0007J\"\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R0\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c8\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001e\u0010\u0003\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lcom/intellij/util/SVGLoader;", "", "<init>", "()V", "ICON_DEFAULT_SIZE", "", "load", "Ljava/awt/Image;", "url", "Ljava/net/URL;", "scale", "", "stream", "Ljava/io/InputStream;", "Ljava/awt/image/BufferedImage;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "width", "", "height", "loadHiDPI", "context", "getMaxZoomFactor", "path", "", "data", "", "colorPatcher", "Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "colorPatcherProvider", "getColorPatcherProvider$annotations", "getColorPatcherProvider", "()Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "setColorPatcherProvider", "(Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;)V", "SvgElementColorPatcherProvider", "intellij.platform.util.ui"})
@ApiStatus.Internal
public final class SVGLoader {
    @NotNull
    public static final SVGLoader INSTANCE = new SVGLoader();
    public static final int ICON_DEFAULT_SIZE = 16;
    @Nullable
    private static SvgElementColorPatcherProvider colorPatcherProvider;

    private SVGLoader() {
    }

    @JvmStatic
    @NotNull
    public static final Image load(@NotNull URL url, float scale) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.getPath();
        InputStream inputStream = url.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
        return SvgKt.loadSvg-0e6sKCk$default(string, inputStream, scale, null, null, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final Image load(@NotNull InputStream stream, float scale) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return SvgKt.loadSvg-0e6sKCk$default(null, stream, scale, null, null, 8, null);
    }

    @NotNull
    public final BufferedImage load(@Nullable URL url, @NotNull InputStream stream, float scale) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        URL uRL = url;
        return SvgKt.loadSvg-0e6sKCk$default(uRL != null ? uRL.getPath() : null, stream, scale, null, null, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final Image load(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext scaleContext, double width, double height) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        double scale = scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        return JsvgKt.renderSvgWithSize$default(JSvgDocumentFactoryKt.createJSvgDocument(stream), (float)(width * scale), (float)(height * scale), 0.0f, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final Image loadHiDPI(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float scale = (float)context.getScale(DerivedScaleType.PIX_SCALE);
        URL uRL = url;
        BufferedImage image = SvgKt.loadSvg-0e6sKCk$default(uRL != null ? uRL.getPath() : null, stream, scale, null, null, 8, null);
        Image image2 = ImageUtil.ensureHiDPI(image, context);
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"ensureHiDPI(...)");
        return image2;
    }

    @JvmStatic
    public static final double getMaxZoomFactor(@Nullable String path, @NotNull InputStream stream, @NotNull ScaleContext scaleContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        byte[] byArray = stream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        return INSTANCE.getMaxZoomFactor(byArray, scaleContext);
    }

    public final double getMaxZoomFactor(@NotNull byte[] data, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        Rectangle2D.Float size = SvgKt.getSvgDocumentSize(data);
        float iconMaxSize = SVGLoaderKt.access$getIconMaxSize();
        double scale = scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        return RangesKt.coerceAtMost((double)((double)iconMaxSize / ((double)size.width * scale)), (double)((double)iconMaxSize / ((double)size.height * scale)));
    }

    @Nullable
    public static final SvgElementColorPatcherProvider getColorPatcherProvider() {
        return colorPatcherProvider;
    }

    public static final void setColorPatcherProvider(@Nullable SvgElementColorPatcherProvider colorPatcher) {
        colorPatcherProvider = colorPatcher;
        IconLoader.clearCache();
    }

    @JvmStatic
    public static /* synthetic */ void getColorPatcherProvider$annotations() {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0016\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "", "attributeForPath", "Lcom/intellij/ui/svg/SvgAttributePatcher;", "path", "", "digest", "", "intellij.platform.util.ui"})
    public static interface SvgElementColorPatcherProvider {
        @Nullable
        default public SvgAttributePatcher attributeForPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return null;
        }

        @NotNull
        public long[] digest();
    }
}

