/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DetectRetinaKit {
    private static final Map<GraphicsDevice, Boolean> devicesToRetinaSupportCacheMap = new WeakHashMap<GraphicsDevice, Boolean>();

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(DetectRetinaKit.class);
        if (logger == null) {
            DetectRetinaKit.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static boolean isOracleMacRetinaDevice(GraphicsDevice device) {
        Boolean isRetina = devicesToRetinaSupportCacheMap.get(device);
        if (isRetina != null) {
            return isRetina;
        }
        Method getScaleFactorMethod = null;
        try {
            getScaleFactorMethod = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            DetectRetinaKit.getLogger().debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
        }
        catch (Exception e) {
            DetectRetinaKit.getLogger().debug((Throwable)e);
            DetectRetinaKit.getLogger().debug("CGraphicsDevice.getScaleFactor(): probably it is Java 9");
        }
        try {
            isRetina = getScaleFactorMethod == null || (Integer)getScaleFactorMethod.invoke((Object)device, new Object[0]) != 1;
        }
        catch (IllegalAccessException e) {
            DetectRetinaKit.getLogger().debug("CGraphicsDevice.getScaleFactor(): Access issue");
            isRetina = false;
        }
        catch (InvocationTargetException e) {
            DetectRetinaKit.getLogger().debug("CGraphicsDevice.getScaleFactor(): Invocation issue");
            isRetina = false;
        }
        catch (IllegalArgumentException e) {
            DetectRetinaKit.getLogger().debug("object is not an instance of declaring class: " + device.getClass().getName());
            isRetina = false;
        }
        devicesToRetinaSupportCacheMap.put(device, isRetina);
        return isRetina;
    }

    static boolean isMacRetina(@NotNull Graphics2D g) {
        GraphicsConfiguration configuration;
        if (g == null) {
            DetectRetinaKit.$$$reportNull$$$0(1);
        }
        if ((configuration = g.getDeviceConfiguration()) == null) {
            return false;
        }
        GraphicsDevice device = configuration.getDevice();
        return DetectRetinaKit.isOracleMacRetinaDevice(device);
    }

    static boolean isRetina() {
        if (SystemInfo.isMac) {
            GraphicsDevice[] devices;
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice device : devices = e.getScreenDevices()) {
                if (!DetectRetinaKit.isOracleMacRetinaDevice(device)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/DetectRetinaKit";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/DetectRetinaKit";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMacRetina";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

