/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CSSFontResolver;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.StyleSheetUtil;
import com.intellij.util.ui.TextLayoutUtil;
import com.intellij.util.ui.html.SummaryView;
import com.intellij.util.ui.html.UtilsKt;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public class JBHtmlEditorKit
extends HTMLEditorKit {
    private static final Logger LOG = Logger.getInstance(JBHtmlEditorKit.class);
    @NotNull
    private final ViewFactory myViewFactory;
    @NotNull
    private final StyleSheet myStyle;
    @NotNull
    private final HTMLEditorKit.LinkController myLinkController;
    @NotNull
    private final HyperlinkListener myHyperlinkListener;
    @NotNull
    private final DetailsSummaryController myDetailsSummaryController;
    private final boolean myDisableLinkedCss;
    private boolean myUnderlineHoveredHyperlink;
    @Nullable
    private CSSFontResolver myFontResolver;

    @Deprecated
    public JBHtmlEditorKit() {
        this(ExtendableHTMLViewFactory.DEFAULT, StyleSheetUtil.getDefaultStyleSheet(), false);
        this.getStyleSheet().addStyleSheet(StyleSheetUtil.INSTANCE.getNO_GAPS_BETWEEN_PARAGRAPHS_STYLE());
    }

    JBHtmlEditorKit(@NotNull ViewFactory viewFactory, @NotNull StyleSheet defaultStyle, boolean disableLinkedCss) {
        if (viewFactory == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(0);
        }
        if (defaultStyle == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(1);
        }
        this.myLinkController = new MouseExitSupportLinkController();
        this.myHyperlinkListener = new LinkUnderlineListener();
        this.myDetailsSummaryController = new DetailsSummaryController();
        this.myUnderlineHoveredHyperlink = true;
        this.myViewFactory = viewFactory;
        this.myDisableLinkedCss = disableLinkedCss;
        this.myStyle = defaultStyle;
    }

    public void setUnderlineHoveredHyperlink(boolean underlineHoveredHyperlink) {
        this.myUnderlineHoveredHyperlink = underlineHoveredHyperlink;
    }

    public void setFontResolver(@Nullable CSSFontResolver fontResolver) {
        this.myFontResolver = fontResolver;
    }

    @Override
    public StyleSheet getStyleSheet() {
        return this.myStyle;
    }

    @Override
    public void setStyleSheet(StyleSheet style) {
    }

    @Override
    public Document createDefaultDocument() {
        StyleSheet styles = this.getStyleSheet();
        StyleSheetCompressionThreshold ss = new StyleSheetCompressionThreshold();
        ss.addStyleSheet(styles);
        JBHtmlDocument doc = new JBHtmlDocument((StyleSheet)ss);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    @Override
    public Cursor getDefaultCursor() {
        return null;
    }

    @Override
    public void install(final JEditorPane pane) {
        super.install(pane);
        pane.addPropertyChangeListener("editorKit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                pane.removePropertyChangeListener(this);
            }
        });
        if (this.myUnderlineHoveredHyperlink) {
            pane.addHyperlinkListener(this.myHyperlinkListener);
        }
        pane.addMouseListener(this.myDetailsSummaryController);
        List<HTMLEditorKit.LinkController> listeners1 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseListeners());
        List<HTMLEditorKit.LinkController> listeners2 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseMotionListeners());
        if (listeners1.size() == 1 && listeners1.equals(listeners2)) {
            HTMLEditorKit.LinkController oldLinkController = listeners1.get(0);
            pane.removeMouseListener(oldLinkController);
            pane.removeMouseMotionListener(oldLinkController);
            pane.addMouseListener(this.myLinkController);
            pane.addMouseMotionListener(this.myLinkController);
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.myViewFactory;
    }

    private static @Unmodifiable @NotNull List<HTMLEditorKit.LinkController> filterLinkControllerListeners(Object @NotNull [] listeners) {
        if (listeners == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.mapNotNull((Object[])listeners, o -> (HTMLEditorKit.LinkController)ObjectUtils.tryCast((Object)o, HTMLEditorKit.LinkController.class));
        if (list == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void deinstall(@NotNull JEditorPane c) {
        if (c == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(4);
        }
        c.removeMouseListener(this.myLinkController);
        c.removeMouseMotionListener(this.myLinkController);
        c.removeHyperlinkListener(this.myHyperlinkListener);
        super.deinstall(c);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultStyle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBHtmlEditorKit";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBHtmlEditorKit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLinkControllerListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterLinkControllerListeners";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deinstall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class MouseExitSupportLinkController
    extends HTMLEditorKit.LinkController {
        private MouseExitSupportLinkController() {
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MouseExitSupportLinkController.$$$reportNull$$$0(0);
            }
            this.mouseMoved(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), -1, -1, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/JBHtmlEditorKit$MouseExitSupportLinkController", "mouseExited"));
        }
    }

    private static final class LinkUnderlineListener
    implements HyperlinkListener {
        private LinkUnderlineListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            Element element = e.getSourceElement();
            if (element == null) {
                return;
            }
            if (element.getName().equals("img")) {
                return;
            }
            if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                LinkUnderlineListener.setUnderlined(true, element);
            } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                LinkUnderlineListener.setUnderlined(false, element);
            }
        }

        private static void setUnderlined(boolean underlined, @NotNull Element element) {
            AttributeSet attributes;
            Object attribute;
            if (element == null) {
                LinkUnderlineListener.$$$reportNull$$$0(0);
            }
            if ((attribute = (attributes = element.getAttributes()).getAttribute(HTML.Tag.A)) instanceof MutableAttributeSet) {
                MutableAttributeSet a = (MutableAttributeSet)attribute;
                Object href = a.getAttribute(HTML.Attribute.HREF);
                Pair<Integer, Integer> aRange = LinkUnderlineListener.findRangeOfParentTagWithGivenAttribute(element, href, HTML.Tag.A, HTML.Attribute.HREF);
                a.addAttribute(CSS.Attribute.TEXT_DECORATION, underlined ? "underline" : "none");
                ((StyledDocument)element.getDocument()).setCharacterAttributes((Integer)aRange.first, (Integer)aRange.second - (Integer)aRange.first, a, false);
            }
        }

        @NotNull
        private static Pair<Integer, Integer> findRangeOfParentTagWithGivenAttribute(@NotNull Element element, Object elementAttributeValue, @NotNull HTML.Tag tag, @NotNull HTML.Attribute attribute) {
            if (element == null) {
                LinkUnderlineListener.$$$reportNull$$$0(1);
            }
            if (tag == null) {
                LinkUnderlineListener.$$$reportNull$$$0(2);
            }
            if (attribute == null) {
                LinkUnderlineListener.$$$reportNull$$$0(3);
            }
            HtmlIteratorWrapper anchorTagIterator = new HtmlIteratorWrapper(((HTMLDocument)element.getDocument()).getIterator(tag));
            Pair pair = StreamSupport.stream(anchorTagIterator.spliterator(), false).filter(it -> Objects.equals(it.getAttributes().getAttribute(attribute), elementAttributeValue)).filter(it -> it.getStartOffset() <= element.getStartOffset() && element.getStartOffset() <= it.getEndOffset()).map(it -> new Pair((Object)it.getStartOffset(), (Object)it.getEndOffset())).findFirst().orElse(new Pair((Object)element.getStartOffset(), (Object)element.getEndOffset()));
            if (pair == null) {
                LinkUnderlineListener.$$$reportNull$$$0(4);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBHtmlEditorKit$LinkUnderlineListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBHtmlEditorKit$LinkUnderlineListener";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findRangeOfParentTagWithGivenAttribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setUnderlined";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findRangeOfParentTagWithGivenAttribute";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }

        private static final class HtmlIteratorWrapper
        implements Iterable<HTMLDocument.Iterator> {
            @NotNull
            private final HTMLDocument.Iterator myDelegate;

            private HtmlIteratorWrapper(@NotNull HTMLDocument.Iterator delegate) {
                if (delegate == null) {
                    HtmlIteratorWrapper.$$$reportNull$$$0(0);
                }
                this.myDelegate = delegate;
            }

            @Override
            @NotNull
            public Iterator<HTMLDocument.Iterator> iterator() {
                return new Iterator<HTMLDocument.Iterator>(){

                    @Override
                    public boolean hasNext() {
                        return myDelegate.isValid();
                    }

                    @Override
                    public HTMLDocument.Iterator next() {
                        final AttributeSet attributeSet = myDelegate.getAttributes();
                        final int startOffset = myDelegate.getStartOffset();
                        final int endOffset = myDelegate.getEndOffset();
                        final HTML.Tag tag = myDelegate.getTag();
                        HTMLDocument.Iterator current = new HTMLDocument.Iterator(this){

                            @Override
                            public AttributeSet getAttributes() {
                                return attributeSet;
                            }

                            @Override
                            public int getStartOffset() {
                                return startOffset;
                            }

                            @Override
                            public int getEndOffset() {
                                return endOffset;
                            }

                            @Override
                            public HTML.Tag getTag() {
                                return tag;
                            }

                            @Override
                            public void next() {
                                throw new IllegalStateException("Must not be called");
                            }

                            @Override
                            public boolean isValid() {
                                throw new IllegalStateException("Must not be called");
                            }
                        };
                        myDelegate.next();
                        return current;
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/util/ui/JBHtmlEditorKit$LinkUnderlineListener$HtmlIteratorWrapper", "<init>"));
            }
        }
    }

    private static final class DetailsSummaryController
    extends MouseAdapter {
        private DetailsSummaryController() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point pt;
            int pos;
            JEditorPane editor = (JEditorPane)e.getSource();
            if (!editor.isEditable() && editor.isEnabled() && SwingUtilities.isLeftMouseButton(e) && (pos = editor.viewToModel(pt = new Point(e.getX(), e.getY()))) >= 0) {
                DetailsSummaryController.clickSummary(pos, editor);
            }
        }

        private static void clickSummary(int pos, JEditorPane html) {
            Document doc = html.getDocument();
            if (doc instanceof HTMLDocument) {
                String name;
                HTMLDocument hdoc = (HTMLDocument)doc;
                for (Element e = hdoc.getCharacterElement(pos); e != null && !(name = e.getName()).equals("a"); e = e.getParentElement()) {
                    if (!name.equals("summary")) continue;
                    AttributeSet attributes = e.getAttributes();
                    Object attribute = attributes.getAttribute(UtilsKt.getHTML_Tag_DETAILS());
                    if (attribute instanceof MutableAttributeSet) {
                        MutableAttributeSet a;
                        a.addAttribute(SummaryView.EXPANDED, (a = (MutableAttributeSet)attribute).getAttribute(SummaryView.EXPANDED) != Boolean.TRUE);
                    }
                    View rootView = html.getUI().getRootView(html);
                    UtilsKt.reapplyCss(rootView);
                    rootView.setSize(1.0f, 1.0f);
                    html.revalidate();
                    html.doLayout();
                    return;
                }
            }
        }
    }

    private static final class StyleSheetCompressionThreshold
    extends StyleSheet {
        private StyleSheetCompressionThreshold() {
        }

        @Override
        protected int getCompressionThreshold() {
            return -1;
        }
    }

    @ApiStatus.Internal
    public final class JBHtmlDocument
    extends HTMLDocument {
        private JBHtmlDocument(StyleSheet styles) {
            super(styles);
            TextLayoutUtil.disableTextLayoutIfNeeded(this);
            UtilsKt.patchAttributes(styles);
        }

        @Override
        public Font getFont(AttributeSet a) {
            Font font = super.getFont(a);
            return JBHtmlEditorKit.this.myFontResolver == null ? font : JBHtmlEditorKit.this.myFontResolver.getFont(font, a);
        }

        @Override
        public HTMLEditorKit.ParserCallback getReader(int pos) {
            Object desc = this.getProperty("stream");
            if (desc instanceof URL) {
                this.setBase((URL)desc);
            }
            JBHtmlReader reader = new JBHtmlReader(this, pos);
            return JBHtmlEditorKit.this.myDisableLinkedCss ? new CallbackWrapper(reader) : reader;
        }

        @Override
        public HTMLEditorKit.ParserCallback getReader(int pos, int popDepth, int pushDepth, HTML.Tag insertTag) {
            Object desc = this.getProperty("stream");
            if (desc instanceof URL) {
                this.setBase((URL)desc);
            }
            JBHtmlReader reader = new JBHtmlReader(this, pos, popDepth, pushDepth, insertTag);
            return JBHtmlEditorKit.this.myDisableLinkedCss ? new CallbackWrapper(reader) : reader;
        }

        public void tryRunUnderWriteLock(Runnable runnable) {
            if (this.getCurrentWriter() == Thread.currentThread()) {
                runnable.run();
            } else {
                try {
                    this.writeLock();
                }
                catch (IllegalStateException e) {
                    return;
                }
                try {
                    runnable.run();
                }
                finally {
                    this.writeUnlock();
                }
            }
        }

        private final class JBHtmlReader
        extends HTMLDocument.HTMLReader {
            private JBHtmlReader(JBHtmlDocument jBHtmlDocument, int offset) {
                super(jBHtmlDocument, offset);
                this.registerAdditionalTags();
            }

            private JBHtmlReader(JBHtmlDocument jBHtmlDocument, int offset, int popDepth, int pushDepth, HTML.Tag insertTag) {
                super(jBHtmlDocument, offset, popDepth, pushDepth, insertTag);
                this.registerAdditionalTags();
            }

            private void registerAdditionalTags() {
                HTMLDocument.HTMLReader.BlockAction ba = new HTMLDocument.HTMLReader.BlockAction(this);
                for (HTML.Tag tag : UtilsKt.getHTML_Tag_CUSTOM_BLOCK_TAGS()) {
                    this.registerTag(tag, ba);
                }
            }

            @Override
            protected void addSpecialElement(HTML.Tag t, MutableAttributeSet a) {
                int lastSize = this.parseBuffer.size();
                super.addSpecialElement(t, a);
                if (lastSize != this.parseBuffer.size()) {
                    if (t == HTML.Tag.BR) {
                        DefaultStyledDocument.ElementSpec elementSpec = (DefaultStyledDocument.ElementSpec)this.parseBuffer.lastElement();
                        this.parseBuffer.set(this.parseBuffer.size() - 1, new DefaultStyledDocument.ElementSpec(elementSpec.getAttributes(), 3, new char[]{'\n'}, 0, 1));
                    } else if ("wbr".equals(t.toString())) {
                        DefaultStyledDocument.ElementSpec elementSpec = (DefaultStyledDocument.ElementSpec)this.parseBuffer.lastElement();
                        this.parseBuffer.set(this.parseBuffer.size() - 1, new DefaultStyledDocument.ElementSpec(elementSpec.getAttributes(), 3, new char[]{'\u200b'}, 0, 1));
                    }
                }
            }
        }

        private static final class CallbackWrapper
        extends HTMLEditorKit.ParserCallback {
            private final HTMLEditorKit.ParserCallback delegate;
            private int depth;

            private CallbackWrapper(HTMLEditorKit.ParserCallback delegate) {
                this.delegate = delegate;
            }

            @Override
            public void flush() throws BadLocationException {
                this.delegate.flush();
            }

            @Override
            public void handleText(char[] data, int pos) {
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleText(data, pos);
            }

            @Override
            public void handleComment(char[] data, int pos) {
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleComment(data, pos);
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.LINK) {
                    ++this.depth;
                }
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleStartTag(t, a, pos);
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (t == HTML.Tag.LINK) {
                    --this.depth;
                }
                LOG.assertTrue(this.depth >= 0);
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleEndTag(t, pos);
            }

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.LINK) {
                    return;
                }
                this.delegate.handleSimpleTag(t, a, pos);
            }

            @Override
            public void handleError(String errorMsg, int pos) {
                this.delegate.handleError(errorMsg, pos);
            }

            @Override
            public void handleEndOfLineString(String eol) {
                this.delegate.handleEndOfLineString(eol);
            }
        }
    }
}

