/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.html;

import com.intellij.icons.AllIcons;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.util.ui.html.DataUrlImageView;
import com.intellij.util.ui.html.ImageViewPreferredSpan;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.text.Element;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/ui/html/FitToWidthImageView;", "Lcom/intellij/util/ui/html/DataUrlImageView;", "element", "Ljavax/swing/text/Element;", "<init>", "(Ljavax/swing/text/Element;)V", "preferredSpan", "Lcom/intellij/util/ui/html/ImageViewPreferredSpan;", "getLoadingImageIcon", "Ljavax/swing/Icon;", "getResizeWeight", "", "axis", "getMaximumSpan", "", "getPreferredSpan", "paint", "", "g", "Ljava/awt/Graphics;", "a", "Ljava/awt/Shape;", "intellij.platform.util.ui"})
public final class FitToWidthImageView
extends DataUrlImageView {
    @NotNull
    private final ImageViewPreferredSpan preferredSpan;

    public FitToWidthImageView(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
        this.preferredSpan = new ImageViewPreferredSpan(this, (Function1<? super Integer, Float>)((Function1)arg_0 -> FitToWidthImageView.preferredSpan$lambda$0(this, arg_0)));
    }

    @Override
    @NotNull
    public Icon getLoadingImageIcon() {
        Icon icon = AllIcons.Process.Step_passive;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Step_passive");
        return icon;
    }

    @Override
    public int getResizeWeight(int axis) {
        return axis == 0 ? 1 : 0;
    }

    @Override
    public float getMaximumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public float getPreferredSpan(int axis) {
        return this.preferredSpan.get(axis);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull Shape a) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Rectangle targetRect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        Graphics scalingGraphics2 = new Graphics2DDelegate(g, targetRect){
            final /* synthetic */ Rectangle $targetRect;
            {
                this.$targetRect = $targetRect;
                Intrinsics.checkNotNull((Object)$g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                super((Graphics2D)$g);
            }

            public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
                Intrinsics.checkNotNullParameter((Object)img, (String)"img");
                Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                int paintWidth = width;
                int paintHeight = height;
                int maxWidth = (int)Math.max(0.0, (double)(this.$targetRect.width - 2 * (x - this.$targetRect.x)));
                int maxHeight = (int)Math.max(0.0, (double)(this.$targetRect.height - 2 * (y - this.$targetRect.y)));
                if (paintWidth > maxWidth) {
                    paintHeight = paintHeight * maxWidth / paintWidth;
                    paintWidth = maxWidth;
                }
                if (paintHeight > maxHeight) {
                    paintWidth = paintWidth * maxHeight / paintHeight;
                    paintHeight = maxHeight;
                }
                return super.drawImage(img, x, y, paintWidth, paintHeight, observer);
            }
        };
        super.paint(scalingGraphics2, a);
    }

    private static final float preferredSpan$lambda$0(FitToWidthImageView this$0, int axis) {
        return super.getPreferredSpan(axis);
    }
}

