/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.java.generate;

import com.intellij.codeInsight.intention.impl.AddOnDemandStaticImportAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastCommentSaver;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.java.generate.JavaUastCodeGenerationPluginKt;
import org.jetbrains.uast.java.generate.JavaUastElementFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J7\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u0002H\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020!H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001d\u001a\u00020%H\u0016J,\u0010&\u001a\u0004\u0018\u00010$2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00122\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u0012H\u0016J\u001a\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0016H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u00066"}, d2={"Lorg/jetbrains/uast/java/generate/JavaUastCodeGenerationPlugin;", "Lorg/jetbrains/uast/generate/UastCodeGenerationPlugin;", "<init>", "()V", "getElementFactory", "Lorg/jetbrains/uast/generate/UastElementFactory;", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "cleanupMethodCall", "Lcom/intellij/psi/PsiMethodCallExpression;", "methodCall", "adjustChainStyleToMethodCalls", "", "oldPsi", "Lcom/intellij/psi/PsiElement;", "newPsi", "replace", "T", "Lorg/jetbrains/uast/UElement;", "oldElement", "newElement", "elementType", "Ljava/lang/Class;", "(Lorg/jetbrains/uast/UElement;Lorg/jetbrains/uast/UElement;Ljava/lang/Class;)Lorg/jetbrains/uast/UElement;", "bindToElement", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "element", "shortenReference", "Lorg/jetbrains/uast/UDeclaration;", "uDeclaration", "importMemberOnDemand", "Lorg/jetbrains/uast/UExpression;", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "initializeField", "uField", "Lorg/jetbrains/uast/UField;", "uParameter", "Lorg/jetbrains/uast/UParameter;", "anchor", "addBefore", "", "changeLabel", "Lorg/jetbrains/uast/UReturnExpression;", "returnExpression", "context", "grabComments", "Lorg/jetbrains/uast/generate/UastCommentSaver;", "firstResultUElement", "lastResultUElement", "intellij.java.uast.ide"})
@SourceDebugExtension(value={"SMAP\nJavaUastCodeGenerationPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaUastCodeGenerationPlugin.kt\norg/jetbrains/uast/java/generate/JavaUastCodeGenerationPlugin\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,732:1\n176#2:733\n176#2:734\n176#2:736\n176#2:737\n455#3:735\n*S KotlinDebug\n*F\n+ 1 JavaUastCodeGenerationPlugin.kt\norg/jetbrains/uast/java/generate/JavaUastCodeGenerationPlugin\n*L\n184#1:733\n190#1:734\n204#1:736\n226#1:737\n202#1:735\n*E\n"})
public final class JavaUastCodeGenerationPlugin
implements UastCodeGenerationPlugin {
    @NotNull
    public UastElementFactory getElementFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new JavaUastElementFactory(project);
    }

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaLanguage, (String)"INSTANCE");
        return (Language)javaLanguage;
    }

    private final PsiMethodCallExpression cleanupMethodCall(PsiMethodCallExpression methodCall) {
        PsiType[] psiTypeArray = methodCall.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getTypeArguments(...)");
        if (!(((Object[])psiTypeArray).length == 0)) {
            PsiMethod psiMethod = methodCall.resolveMethod();
            if (psiMethod == null) {
                return methodCall;
            }
            PsiMethod resolved = psiMethod;
            if (methodCall.getTypeArguments().length == resolved.getTypeParameters().length && PsiDiamondTypeUtil.areTypeArgumentsRedundant((PsiType[])methodCall.getTypeArguments(), (PsiExpression)((PsiExpression)methodCall), (boolean)false, (PsiMethod)resolved, (PsiTypeParameter[])resolved.getTypeParameters())) {
                PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)methodCall.getProject()).createExpressionFromText("foo()", null);
                Intrinsics.checkNotNull((Object)psiExpression, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
                PsiMethodCallExpression emptyTypeArgumentsMethodCall = (PsiMethodCallExpression)psiExpression;
                methodCall.getTypeArgumentList().replace((PsiElement)emptyTypeArgumentsMethodCall.getTypeArgumentList());
            }
        }
        PsiElement psiElement = JavaCodeStyleManager.getInstance((Project)methodCall.getProject()).shortenClassReferences((PsiElement)methodCall);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        return (PsiMethodCallExpression)psiElement;
    }

    private final void adjustChainStyleToMethodCalls(PsiElement oldPsi, PsiElement newPsi) {
        if (oldPsi instanceof PsiMethodCallExpression && newPsi instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)oldPsi).getMethodExpression().getQualifierExpression() != null && ((PsiMethodCallExpression)newPsi).getMethodExpression().getQualifier() != null) {
            PsiElement[] psiElementArray = ((PsiMethodCallExpression)oldPsi).getMethodExpression().getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            if (ArraysKt.getOrNull((Object[])psiElementArray, (int)1) instanceof PsiWhiteSpace) {
                PsiElement[] psiElementArray2 = ((PsiMethodCallExpression)newPsi).getMethodExpression().getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
                if (!(ArraysKt.getOrNull((Object[])psiElementArray2, (int)1) instanceof PsiWhiteSpace)) {
                    ((PsiMethodCallExpression)newPsi).getMethodExpression().addAfter(((PsiMethodCallExpression)oldPsi).getMethodExpression().getChildren()[1], ((PsiMethodCallExpression)newPsi).getMethodExpression().getChildren()[0]);
                }
            }
        }
    }

    @Nullable
    public <T extends UElement> T replace(@NotNull UElement oldElement, @NotNull T newElement, @NotNull Class<T> elementType) {
        UElement uElement;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)oldElement, (String)"oldElement");
        Intrinsics.checkNotNullParameter(newElement, (String)"newElement");
        Intrinsics.checkNotNullParameter(elementType, (String)"elementType");
        PsiElement psiElement2 = oldElement.getSourcePsi();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement oldPsi = psiElement2;
        PsiElement psiElement3 = newElement.getSourcePsi();
        if (psiElement3 == null) {
            return null;
        }
        PsiElement newPsi = psiElement3;
        this.adjustChainStyleToMethodCalls(oldPsi, newPsi);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)oldPsi.getProject());
        PsiElement updOldPsi = (newPsi instanceof PsiCodeBlock || newPsi instanceof PsiStatement) && oldPsi.getParent() instanceof PsiExpressionStatement ? oldPsi.getParent() : oldPsi;
        if (updOldPsi instanceof PsiStatement && newPsi instanceof PsiExpression) {
            Intrinsics.checkNotNull((Object)factory);
            PsiStatement psiStatement = JavaUastCodeGenerationPluginKt.access$createExpressionStatement(factory, (PsiExpression)newPsi, oldElement);
            if (psiStatement == null) {
                return null;
            }
            psiElement = (PsiElement)psiStatement;
        } else if (updOldPsi instanceof PsiCodeBlock && newPsi instanceof PsiBlockStatement) {
            PsiCodeBlock psiCodeBlock = ((PsiBlockStatement)newPsi).getCodeBlock();
            Intrinsics.checkNotNullExpressionValue((Object)psiCodeBlock, (String)"getCodeBlock(...)");
            psiElement = (PsiElement)psiCodeBlock;
        } else {
            psiElement = newPsi;
        }
        PsiElement updNewPsi = psiElement;
        PsiElement replaced = updOldPsi.replace(updNewPsi);
        if (replaced instanceof PsiExpressionStatement) {
            Class[] classArray = new Class[]{elementType};
            uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)((PsiElement)((PsiExpressionStatement)replaced).getExpression()), (Class[])classArray);
        } else if (replaced instanceof PsiMethodCallExpression) {
            Class[] classArray = new Class[]{elementType};
            uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)((PsiElement)this.cleanupMethodCall((PsiMethodCallExpression)replaced)), (Class[])classArray);
        } else if (replaced instanceof PsiReferenceExpression) {
            Class[] classArray = new Class[]{elementType};
            uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)JavaCodeStyleManager.getInstance((Project)((PsiReferenceExpression)replaced).getProject()).shortenClassReferences(replaced), (Class[])classArray);
        } else {
            Class[] classArray = new Class[]{elementType};
            uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)replaced, (Class[])classArray);
        }
        return (T)uElement;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull UReferenceExpression reference, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = reference.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement sourceReference = psiElement;
        if (!(sourceReference instanceof PsiReference)) {
            return null;
        }
        return ((PsiReference)sourceReference).bindToElement(element);
    }

    @Nullable
    public UReferenceExpression shortenReference(@NotNull UReferenceExpression reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        PsiElement psiElement = reference.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement sourceReference = psiElement;
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)sourceReference.getProject());
        PsiElement $this$toUElementOfType$iv = styleManager.shortenClassReferences(sourceReference);
        boolean $i$f$toUElementOfType = false;
        return (UReferenceExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UReferenceExpression.class);
    }

    @Nullable
    public UDeclaration shortenReference(@NotNull UDeclaration uDeclaration) {
        Intrinsics.checkNotNullParameter((Object)uDeclaration, (String)"uDeclaration");
        PsiElement psiElement = uDeclaration.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement sourceReference = psiElement;
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)sourceReference.getProject());
        PsiElement $this$toUElementOfType$iv = styleManager.shortenClassReferences(sourceReference);
        boolean $i$f$toUElementOfType = false;
        return (UDeclaration)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UDeclaration.class);
    }

    @Nullable
    public UExpression importMemberOnDemand(@NotNull UQualifiedReferenceExpression reference) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        PsiElement psiElement = reference.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement source = psiElement;
        PsiElement psiElement2 = source;
        if (psiElement2 instanceof PsiMethodCallExpression) {
            pair = TuplesKt.to((Object)((PsiMethodCallExpression)source).getMethodExpression().getQualifierExpression(), (Object)((PsiMethodCallExpression)source).getMethodExpression());
        } else if (psiElement2 instanceof PsiReferenceExpression) {
            pair = TuplesKt.to((Object)((PsiReferenceExpression)source).getQualifier(), (Object)((PsiReferenceExpression)source).getReferenceNameElement());
        } else {
            return null;
        }
        Pair pair2 = pair;
        PsiElement qualifier = (PsiElement)pair2.component1();
        PsiElement selector = (PsiElement)pair2.component2();
        if (qualifier == null || selector == null) {
            return null;
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)selector);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        SmartPsiElementPointer ptr = smartPsiElementPointer;
        PsiElement $this$childrenOfType$iv = qualifier;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, PsiIdentifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        PsiIdentifier psiIdentifier = (PsiIdentifier)CollectionsKt.firstOrNull((List)list);
        if (psiIdentifier == null) {
            return null;
        }
        PsiIdentifier qualifierIdentifier = psiIdentifier;
        AddOnDemandStaticImportAction.invoke((Project)((PsiExpression)source).getProject(), (PsiFile)((PsiExpression)source).getContainingFile(), null, (PsiElement)((PsiElement)qualifierIdentifier));
        PsiElement psiElement3 = ptr.getElement();
        PsiElement $this$toUElementOfType$iv = psiElement3 != null ? psiElement3.getParent() : null;
        boolean $i$f$toUElementOfType = false;
        return (UExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UExpression.class);
    }

    @Nullable
    public UExpression initializeField(@NotNull UField uField, @NotNull UParameter uParameter, @Nullable PsiElement anchor, boolean addBefore) {
        PsiElement lastBodyElement;
        Intrinsics.checkNotNullParameter((Object)uField, (String)"uField");
        Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)uParameter), UMethod.class, (boolean)false);
        if (uMethod == null) {
            return null;
        }
        UMethod uMethod2 = uMethod;
        PsiElement psiElement = uMethod2.getSourcePsi();
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod psiMethod2 = psiMethod;
        PsiCodeBlock psiCodeBlock = psiMethod2.getBody();
        if (psiCodeBlock == null) {
            return null;
        }
        PsiCodeBlock body = psiCodeBlock;
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiMethod2.getProject()).getElementFactory();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
        PsiElementFactory elementFactory = psiElementFactory;
        String prefix = Intrinsics.areEqual((Object)uField.getName(), (Object)uParameter.getName()) ? "this." : "";
        PsiStatement psiStatement = elementFactory.createStatementFromText(prefix + uField.getName() + " = " + uParameter.getName() + ";", (PsiElement)psiMethod2);
        Intrinsics.checkNotNullExpressionValue((Object)psiStatement, (String)"createStatementFromText(...)");
        PsiStatement statement = psiStatement;
        PsiElement psiElement2 = anchor != null ? (addBefore ? body.addBefore((PsiElement)statement, anchor) : body.addAfter((PsiElement)statement, anchor)) : ((lastBodyElement = body.getLastBodyElement()) instanceof PsiWhiteSpace ? ((PsiWhiteSpace)lastBodyElement).replace((PsiElement)statement) : body.add((PsiElement)statement));
        PsiElement $this$toUElementOfType$iv = (PsiElement)statement;
        boolean $i$f$toUElementOfType = false;
        return (UExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UExpression.class);
    }

    @NotNull
    public UReturnExpression changeLabel(@NotNull UReturnExpression returnExpression, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)returnExpression, (String)"returnExpression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return returnExpression;
    }

    @Nullable
    public UastCommentSaver grabComments(@NotNull UElement firstResultUElement, @NotNull UElement lastResultUElement) {
        Intrinsics.checkNotNullParameter((Object)firstResultUElement, (String)"firstResultUElement");
        Intrinsics.checkNotNullParameter((Object)lastResultUElement, (String)"lastResultUElement");
        PsiElement psiElement = firstResultUElement.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement firstSourcePsiElement = psiElement;
        PsiElement psiElement2 = lastResultUElement.getSourcePsi();
        if (psiElement2 == null) {
            psiElement2 = firstSourcePsiElement;
        }
        PsiElement lastSourcePsiElement = psiElement2;
        CommentTracker commentTracker = new CommentTracker();
        PsiElement e = firstSourcePsiElement;
        commentTracker.grabComments(e);
        while (e != lastSourcePsiElement && e.getNextSibling() != null) {
            commentTracker.grabComments(e);
        }
        return new UastCommentSaver(commentTracker){
            final /* synthetic */ CommentTracker $commentTracker;
            {
                this.$commentTracker = $commentTracker;
            }

            public void restore(UElement firstResultUElement, UElement lastResultUElement) {
                Intrinsics.checkNotNullParameter((Object)firstResultUElement, (String)"firstResultUElement");
                Intrinsics.checkNotNullParameter((Object)lastResultUElement, (String)"lastResultUElement");
                PsiElement psiElement = firstResultUElement.getSourcePsi();
                if (psiElement == null) {
                    return;
                }
                PsiElement target = psiElement;
                while (true) {
                    PsiElement psiElement2 = target;
                    UElement uElement = UastContextKt.toUElement((PsiElement)(psiElement2 != null ? psiElement2.getParent() : null));
                    if (!Intrinsics.areEqual((Object)(uElement != null ? uElement.getSourcePsi() : null), (Object)firstResultUElement.getSourcePsi())) break;
                    PsiElement psiElement3 = target;
                    target = psiElement3 != null ? psiElement3.getParent() : null;
                }
                if (target != null) {
                    this.$commentTracker.insertCommentsBefore(target);
                }
            }

            public void markUnchanged(UElement firstResultUElement, UElement lastResultUElement) {
                UElement uElement = firstResultUElement;
                if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
                    return;
                }
                UElement firstPsiElement = uElement;
                UElement uElement2 = lastResultUElement;
                if (uElement2 == null || (uElement2 = uElement2.getSourcePsi()) == null) {
                    uElement2 = firstPsiElement;
                }
                UElement lastPsiElement = uElement2;
                this.$commentTracker.markRangeUnchanged((PsiElement)firstPsiElement, (PsiElement)lastPsiElement);
            }
        };
    }
}

