/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"getSpecifiedProperties", "Lorg/jetbrains/concurrency/Promise;", "", "Lorg/jetbrains/debugger/Variable;", "variables", "names", "", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "intellij.platform.scriptDebugger.backend"})
public final class ObjectValueBaseKt {
    @ApiStatus.Internal
    @NotNull
    public static final Promise<List<Variable>> getSpecifiedProperties(@NotNull List<? extends Variable> variables, @NotNull List<String> names, @NotNull EvaluateContext evaluateContext) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
        SmartList properties = new SmartList();
        int getterCount = 0;
        for (Variable iterator2 : variables) {
            if (!iterator2.isReadable() || !names.contains(iterator2.getName())) continue;
            if (!properties.isEmpty()) {
                Collections.sort((List)properties, (arg_0, arg_1) -> ObjectValueBaseKt.getSpecifiedProperties$lambda$1((arg_0, arg_1) -> ObjectValueBaseKt.getSpecifiedProperties$lambda$0(names, arg_0, arg_1), arg_0, arg_1));
            }
            properties.add((Object)iterator2);
            if (iterator2.getValue() != null) continue;
            ++getterCount;
        }
        if (getterCount == 0) {
            return Promises.resolvedPromise((Object)properties);
        }
        SmartList promises = new SmartList();
        Iterator iterator = properties.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ValueModifier valueModifier;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Variable variable = (Variable)e;
            if (variable.getValue() != null) continue;
            Intrinsics.checkNotNull((Object)variable.getValueModifier());
            promises.add(valueModifier.evaluateGet(variable, evaluateContext));
        }
        return Promises.all$default((Collection)((Collection)promises), (Object)properties, (boolean)false, (int)2, null);
    }

    private static final int getSpecifiedProperties$lambda$0(List $names, Variable o1, Variable o2) {
        return $names.indexOf(o1.getName()) - $names.indexOf(o2.getName());
    }

    private static final int getSpecifiedProperties$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

