/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefOverridable;
import com.intellij.psi.PsiClass;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.uast.UClass;

public interface RefClass
extends RefJavaElement,
RefOverridable {
    @NotNull
    public Set<RefClass> getBaseClasses();

    @NotNull
    public Set<RefClass> getSubClasses();

    @NotNull
    public List<RefMethod> getConstructors();

    default public @Unmodifiable List<RefField> getFields() {
        return Collections.emptyList();
    }

    @NotNull
    public Set<RefElement> getInTypeReferences();

    @Deprecated(forRemoval=true)
    @NotNull
    default public Set<RefElement> getInstanceReferences() {
        throw new UnsupportedOperationException();
    }

    public RefMethod getDefaultConstructor();

    @NotNull
    public List<RefMethod> getLibraryMethods();

    public boolean isAnonymous();

    public boolean isInterface();

    default public boolean isRecord() {
        return false;
    }

    default public boolean isAnnotationType() {
        return false;
    }

    public boolean isUtilityClass();

    public boolean isAbstract();

    public boolean isApplet();

    public boolean isServlet();

    public boolean isTestCase();

    public boolean isLocalClass();

    default public boolean isEnum() {
        return false;
    }

    @Deprecated(forRemoval=true)
    default public boolean isSelfInheritor(PsiClass psiClass) {
        throw new UnsupportedOperationException();
    }

    default public boolean isSelfInheritor(@NotNull UClass uClass) {
        if (uClass == null) {
            RefClass.$$$reportNull$$$0(0);
        }
        return this.isSelfInheritor(uClass.getJavaPsi());
    }

    default public UClass getUastElement() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public PsiClass getElement() {
        return (PsiClass)ObjectUtils.tryCast((Object)this.getPsiElement(), PsiClass.class);
    }

    @Override
    @NotNull
    default public Collection<? extends RefOverridable> getDerivedReferences() {
        Set<RefClass> set = this.getSubClasses();
        if (set == null) {
            RefClass.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    default public void addDerivedReference(@NotNull RefOverridable reference) {
        if (reference == null) {
            RefClass.$$$reportNull$$$0(2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelfInheritor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

