/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.uast.UastMetaLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UParameter;

public abstract class RefJavaManager
implements RefManagerExtension<RefJavaManager> {
    @NonNls
    public static final String CLASS = "class";
    @NonNls
    public static final String METHOD = "method";
    @ApiStatus.Internal
    @NonNls
    public static final String IMPLICIT_CONSTRUCTOR = "implicit.constructor";
    @NonNls
    public static final String FIELD = "field";
    @ApiStatus.Internal
    @NonNls
    public static final String PARAMETER = "parameter";
    @ApiStatus.Internal
    @NonNls
    public static final String JAVA_MODULE = "java.module";
    @NonNls
    public static final String PACKAGE = "package";
    @ApiStatus.Internal
    public static final String FUNCTIONAL_EXPRESSION = "functional.expression";
    public static final Key<RefJavaManager> MANAGER = Key.create((String)"RefJavaManager");
    private final List<Language> myLanguages;

    protected RefJavaManager() {
        ArrayList<Language> languages = new ArrayList<Language>(((UastMetaLanguage)Language.findInstance(UastMetaLanguage.class)).getMatchingLanguages());
        for (String lang : Registry.stringValue((String)"batch.inspections.ignored.jvm.languages").split(",")) {
            languages.removeIf(l -> l.isKindOf(lang));
        }
        this.myLanguages = Collections.unmodifiableList(languages);
    }

    public abstract RefImplicitConstructor getImplicitConstructor(String var1);

    public abstract RefPackage getPackage(String var1);

    public abstract RefParameter getParameterReference(UParameter var1, int var2, RefElement var3);

    public abstract RefPackage getDefaultPackage();

    public abstract PsiMethod getAppMainPattern();

    public abstract PsiMethod getAppPremainPattern();

    public abstract PsiMethod getAppAgentmainPattern();

    public abstract PsiClass getApplet();

    public abstract String getAppletQName();

    public abstract String getServletQName();

    public abstract EntryPointsManager getEntryPointsManager();

    @NotNull
    public Collection<Language> getLanguages() {
        List<Language> list = this.myLanguages;
        if (list == null) {
            RefJavaManager.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public Key<RefJavaManager> getID() {
        Key<RefJavaManager> key = MANAGER;
        if (key == null) {
            RefJavaManager.$$$reportNull$$$0(1);
        }
        return key;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/reference/RefJavaManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

