/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uast;

import com.intellij.lang.Language;
import com.intellij.psi.HintedPsiElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.uast.SimpleUastHintedVisitorAdapter;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/uast/UastHintedVisitorAdapter;", "Lcom/intellij/psi/PsiElementVisitor;", "Lcom/intellij/psi/HintedPsiElementVisitor;", "plugin", "Lorg/jetbrains/uast/UastLanguagePlugin;", "visitor", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "directOnly", "", "uElementTypesHint", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "<init>", "(Lorg/jetbrains/uast/UastLanguagePlugin;Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;Z[Ljava/lang/Class;)V", "[Ljava/lang/Class;", "getHintPsiElements", "", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.java.analysis"})
public final class UastHintedVisitorAdapter
extends PsiElementVisitor
implements HintedPsiElementVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UastLanguagePlugin plugin;
    @NotNull
    private final AbstractUastNonRecursiveVisitor visitor;
    private final boolean directOnly;
    @NotNull
    private final Class<? extends UElement>[] uElementTypesHint;

    public UastHintedVisitorAdapter(@NotNull UastLanguagePlugin plugin, @NotNull AbstractUastNonRecursiveVisitor visitor, boolean directOnly, @NotNull Class<? extends UElement>[] uElementTypesHint) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter(uElementTypesHint, (String)"uElementTypesHint");
        this.plugin = plugin;
        this.visitor = visitor;
        this.directOnly = directOnly;
        this.uElementTypesHint = uElementTypesHint;
    }

    @NotNull
    public List<Class<?>> getHintPsiElements() {
        if (this.uElementTypesHint.length == 0) {
            return CollectionsKt.emptyList();
        }
        Class<? extends UElement>[] classArray = this.uElementTypesHint;
        return this.plugin.getPossiblePsiSourceTypes((Class[])Arrays.copyOf(classArray, classArray.length)).toList();
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.visitElement(element);
        UElement uElement = this.plugin.convertElementWithParent(element, (Class[])this.uElementTypesHint);
        if (uElement == null) {
            return;
        }
        UElement uElement2 = uElement;
        if (this.directOnly && uElement2.getSourcePsi() != element) {
            return;
        }
        uElement2.accept((UastVisitor)this.visitor);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PsiElementVisitor create(@NotNull Language language, @NotNull AbstractUastNonRecursiveVisitor visitor, @NotNull Class<? extends UElement>[] uElementTypesHint, boolean directOnly) {
        return Companion.create(language, visitor, uElementTypesHint, directOnly);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PsiElementVisitor create(@NotNull Language language, @NotNull AbstractUastNonRecursiveVisitor visitor, @NotNull Class<? extends UElement>[] uElementTypesHint) {
        return Companion.create(language, visitor, uElementTypesHint);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/uast/UastHintedVisitorAdapter$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/psi/PsiElementVisitor;", "language", "Lcom/intellij/lang/Language;", "visitor", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "uElementTypesHint", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "directOnly", "", "(Lcom/intellij/lang/Language;Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;[Ljava/lang/Class;Z)Lcom/intellij/psi/PsiElementVisitor;", "intellij.java.analysis"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PsiElementVisitor create(@NotNull Language language, @NotNull AbstractUastNonRecursiveVisitor visitor, @NotNull Class<? extends UElement>[] uElementTypesHint, boolean directOnly) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter(uElementTypesHint, (String)"uElementTypesHint");
            UastLanguagePlugin uastLanguagePlugin = UastLanguagePlugin.Companion.byLanguage(language);
            if (uastLanguagePlugin == null) {
                PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
                Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
                return psiElementVisitor;
            }
            UastLanguagePlugin plugin = uastLanguagePlugin;
            if (uElementTypesHint.length == 1) {
                return new SimpleUastHintedVisitorAdapter(plugin, visitor, uElementTypesHint[0], directOnly);
            }
            return new UastHintedVisitorAdapter(plugin, visitor, directOnly, uElementTypesHint);
        }

        public static /* synthetic */ PsiElementVisitor create$default(Companion companion, Language language, AbstractUastNonRecursiveVisitor abstractUastNonRecursiveVisitor, Class[] classArray, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.create(language, abstractUastNonRecursiveVisitor, classArray, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PsiElementVisitor create(@NotNull Language language, @NotNull AbstractUastNonRecursiveVisitor visitor, @NotNull Class<? extends UElement>[] uElementTypesHint) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter(uElementTypesHint, (String)"uElementTypesHint");
            return com.intellij.uast.UastHintedVisitorAdapter$Companion.create$default(this, language, visitor, uElementTypesHint, false, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

