/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridPanel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.RemovableView;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000o\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0016\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001BB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010!H\u0016J\u000e\u0010*\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$J\b\u0010+\u001a\u00020$H\u0016J\u0012\u0010,\u001a\u00020\u00192\b\u0010-\u001a\u0004\u0018\u00010!H\u0016J\u0012\u0010.\u001a\u00020\u00192\b\u0010-\u001a\u0004\u0018\u00010!H\u0016J\n\u0010/\u001a\u0004\u0018\u00010$H\u0002J\u0012\u00100\u001a\u00020\u00192\b\u0010-\u001a\u0004\u0018\u00010$H\u0016J\n\u00101\u001a\u0004\u0018\u00010$H\u0016J\u0012\u00102\u001a\u00020\u00192\b\u0010-\u001a\u0004\u0018\u00010!H\u0016J\u0010\u00103\u001a\u00020\u00192\b\u00104\u001a\u0004\u0018\u00010!J\b\u00105\u001a\u00020\u0001H\u0016J\u0012\u00106\u001a\u0004\u0018\u00010\u00132\u0006\u00107\u001a\u000208H\u0016J\"\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u0002082\b\u0010<\u001a\u0004\u0018\u000108H\u0016J\u0010\u0010=\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u0013H\u0016J\u0012\u0010>\u001a\u0004\u0018\u0001082\u0006\u0010:\u001a\u00020\u0013H\u0016J\u0012\u0010?\u001a\u00020\u00192\b\u0010@\u001a\u0004\u0018\u00010AH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R(\u0010%\u001a\u0004\u0018\u00010$2\b\u0010#\u001a\u0004\u0018\u00010$8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006C"}, d2={"Lcom/intellij/database/run/ui/grid/GridMainPanel;", "Lcom/intellij/ui/components/JBLoadingPanel;", "Lcom/intellij/database/datagrid/GridPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "dataProvider", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/openapi/actionSystem/UiDataProvider;)V", "getGrid", "()Lcom/intellij/database/datagrid/DataGrid;", "myHorizontalSplitter", "Lcom/intellij/ui/OnePixelSplitter;", "myVerticalSplitterWrapper", "Ljavax/swing/JPanel;", "myVerticalSplitter", "myPanelWithFirstHeader", "myCentralPanel", "bottomView", "Lcom/intellij/database/datagrid/RemovableView;", "rightView", "sideView", "com/intellij/database/run/ui/grid/GridMainPanel$sideView$1", "Lcom/intellij/database/run/ui/grid/GridMainPanel$sideView$1;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getPreferredSize", "Ljava/awt/Dimension;", "getBackground", "Ljava/awt/Color;", "getTopComponent", "Ljava/awt/Component;", "getSecondTopComponent", "component", "Ljavax/swing/JComponent;", "secondBottomComponent", "getSecondBottomComponent", "()Ljavax/swing/JComponent;", "setSecondBottomComponent", "(Ljavax/swing/JComponent;)V", "setCenterComponent", "getCenterComponent", "setTopComponent", "topComponent", "setRightHeaderComponent", "getRightHeaderComponent", "setBottomHeaderComponent", "getBottomHeaderComponent", "setSecondTopComponent", "setBottomComponent", "bottomComponent", "getComponent", "getSideView", "viewPosition", "Lcom/intellij/database/datagrid/GridPanel$ViewPosition;", "putSideView", "view", "newPosition", "oldPosition", "removeSideView", "locateSideView", "globalSchemeChange", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Companion", "intellij.grid.impl"})
public final class GridMainPanel
extends JBLoadingPanel
implements GridPanel,
UiDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final UiDataProvider dataProvider;
    @NotNull
    private final OnePixelSplitter myHorizontalSplitter;
    @NotNull
    private final JPanel myVerticalSplitterWrapper;
    @NotNull
    private final OnePixelSplitter myVerticalSplitter;
    @NotNull
    private final JPanel myPanelWithFirstHeader;
    @NotNull
    private final JPanel myCentralPanel;
    @Nullable
    private RemovableView bottomView;
    @Nullable
    private RemovableView rightView;
    @NotNull
    private final sideView.1 sideView;

    public GridMainPanel(@NotNull DataGrid grid, @NotNull UiDataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        super((LayoutManager)new BorderLayout(), (Disposable)grid, 0, 4, null);
        this.grid = grid;
        this.dataProvider = dataProvider;
        this.myVerticalSplitterWrapper = new JPanel(new BorderLayout());
        this.myPanelWithFirstHeader = new JPanel(new BorderLayout());
        this.myCentralPanel = new JPanel(new BorderLayout());
        this.add(this.myPanelWithFirstHeader, "Center");
        this.myPanelWithFirstHeader.setOpaque(false);
        this.myVerticalSplitter = new OnePixelSplitter(true, 0.7f);
        this.myHorizontalSplitter = new OnePixelSplitter(false, 0.7f);
        this.myVerticalSplitterWrapper.add((Component)this.myVerticalSplitter, "Center");
        this.myPanelWithFirstHeader.add((Component)this.myVerticalSplitterWrapper, "Center");
        this.myVerticalSplitter.setFirstComponent((JComponent)this.myHorizontalSplitter);
        this.myHorizontalSplitter.setFirstComponent((JComponent)this.myCentralPanel);
        this.sideView = new Object(this){
            final /* synthetic */ GridMainPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public final RemovableView get(GridPanel.ViewPosition position) {
                Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
                return switch (sideView.WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
                    case 1 -> GridMainPanel.access$getRightView$p(this.this$0);
                    case 2 -> GridMainPanel.access$getBottomView$p(this.this$0);
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public final void set(GridPanel.ViewPosition position, RemovableView view) {
                Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
                switch (sideView.WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
                    case 1: {
                        GridMainPanel.access$setRightView$p(this.this$0, view);
                        RemovableView removableView = view;
                        GridMainPanel.access$getMyHorizontalSplitter$p(this.this$0).setSecondComponent(removableView != null ? removableView.getViewComponent() : null);
                        break;
                    }
                    case 2: {
                        GridMainPanel.access$setBottomView$p(this.this$0, view);
                        RemovableView removableView = view;
                        GridMainPanel.access$getMyVerticalSplitter$p(this.this$0).setSecondComponent(removableView != null ? removableView.getViewComponent() : null);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            public final GridPanel.ViewPosition locate(RemovableView view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                if (Intrinsics.areEqual((Object)GridMainPanel.access$getRightView$p(this.this$0), (Object)view)) {
                    return GridPanel.ViewPosition.RIGHT;
                }
                if (Intrinsics.areEqual((Object)GridMainPanel.access$getBottomView$p(this.this$0), (Object)view)) {
                    return GridPanel.ViewPosition.BOTTOM;
                }
                return null;
            }
        };
    }

    @NotNull
    public final DataGrid getGrid() {
        return this.grid;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.uiDataSnapshot(this.dataProvider);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension resultViewSize = this.grid.getMainResultViewComponent().getPreferredSize();
        Component toolbar = this.getTopComponent();
        JComponent verticalHeader = this.getRightHeaderComponent();
        Serializable serializable = verticalHeader;
        int verticalHeaderWidth = serializable != null && (serializable = serializable.getPreferredSize()) != null ? ((Dimension)serializable).width : 0;
        int bordersWidth = this.getInsets().left + this.getInsets().right;
        Serializable serializable2 = toolbar;
        double d = serializable2 != null && (serializable2 = serializable2.getPreferredSize()) != null ? ((Dimension)serializable2).width : 0;
        double d2 = resultViewSize.width;
        int width = (int)(Math.max(d, d2) + (double)bordersWidth + (double)verticalHeaderWidth);
        Serializable serializable3 = toolbar;
        int toolbarHeight = serializable3 != null && (serializable3 = serializable3.getPreferredSize()) != null ? ((Dimension)serializable3).height : 0;
        int bordersHeight = this.getInsets().top + this.getInsets().bottom;
        JComponent bottomHeader = this.getBottomHeaderComponent();
        Serializable serializable4 = bottomHeader;
        int bottomToolbarHeight = serializable4 != null && (serializable4 = serializable4.getPreferredSize()) != null ? ((Dimension)serializable4).height : 0;
        JComponent secondBottomComponent = this.getSecondBottomComponent();
        Serializable serializable5 = secondBottomComponent;
        int secondBottomComponentHeight = serializable5 != null && (serializable5 = serializable5.getPreferredSize()) != null ? ((Dimension)serializable5).height : 0;
        int height = resultViewSize.height + toolbarHeight + bordersHeight + bottomToolbarHeight + secondBottomComponentHeight;
        return new Dimension(width, height);
    }

    @NotNull
    public Color getBackground() {
        if (this.grid == null) {
            Color color = UIUtil.getTableBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTableBackground(...)");
            return color;
        }
        Color color = this.grid.getColorsScheme().getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        return color;
    }

    @Override
    @Nullable
    public Component getTopComponent() {
        return GridMainPanel.Companion.getComponentAt(this.myPanelWithFirstHeader, "North");
    }

    @Override
    @Nullable
    public Component getSecondTopComponent() {
        return GridMainPanel.Companion.getComponentAt(this.myCentralPanel, "North");
    }

    @Nullable
    public final JComponent getSecondBottomComponent() {
        Component component = GridMainPanel.Companion.getComponentAt(this.getContentPanel(), "South");
        return component instanceof JComponent ? (JComponent)component : null;
    }

    public final void setSecondBottomComponent(@Nullable JComponent component) {
        GridMainPanel.Companion.replaceComponentAt(this.getContentPanel(), "South", component);
    }

    public final void setCenterComponent(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        GridMainPanel.Companion.replaceComponentAt(this.myCentralPanel, "Center", component);
    }

    @Override
    @NotNull
    public JComponent getCenterComponent() {
        return this.myVerticalSplitterWrapper;
    }

    @Override
    public void setTopComponent(@Nullable Component topComponent) {
        GridMainPanel.Companion.replaceComponentAt(this.myPanelWithFirstHeader, "North", topComponent);
    }

    @Override
    public void setRightHeaderComponent(@Nullable Component topComponent) {
        GridMainPanel.Companion.replaceComponentAt(this.myPanelWithFirstHeader, "East", topComponent);
    }

    private final JComponent getRightHeaderComponent() {
        Component component = GridMainPanel.Companion.getComponentAt(this.myPanelWithFirstHeader, "East");
        return component instanceof JComponent ? (JComponent)component : null;
    }

    @Override
    public void setBottomHeaderComponent(@Nullable JComponent topComponent) {
        GridMainPanel.Companion.replaceComponentAt(this.myPanelWithFirstHeader, "South", topComponent);
    }

    @Override
    @Nullable
    public JComponent getBottomHeaderComponent() {
        Component component = GridMainPanel.Companion.getComponentAt(this.myPanelWithFirstHeader, "South");
        return component instanceof JComponent ? (JComponent)component : null;
    }

    @Override
    public void setSecondTopComponent(@Nullable Component topComponent) {
        GridMainPanel.Companion.replaceComponentAt(this.myCentralPanel, "North", topComponent);
    }

    public final void setBottomComponent(@Nullable Component bottomComponent) {
        GridMainPanel.Companion.replaceComponentAt(this.myCentralPanel, "South", bottomComponent);
    }

    @Override
    @NotNull
    public JBLoadingPanel getComponent() {
        return this;
    }

    @Override
    @Nullable
    public RemovableView getSideView(@NotNull GridPanel.ViewPosition viewPosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewPosition), (String)"viewPosition");
        return this.sideView.get(viewPosition);
    }

    @Override
    public void putSideView(@NotNull RemovableView view, @NotNull GridPanel.ViewPosition newPosition, @Nullable GridPanel.ViewPosition oldPosition) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)newPosition), (String)"newPosition");
        if (oldPosition != null) {
            this.sideView.set(oldPosition, null);
        }
        RemovableView removableView = this.sideView.get(newPosition);
        if (removableView != null) {
            removableView.onRemoved();
        }
        this.sideView.set(newPosition, view);
    }

    @Override
    public void removeSideView(@NotNull RemovableView view) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            GridPanel.ViewPosition viewPosition = this.sideView.locate(view);
            if (viewPosition == null) break block1;
            GridPanel.ViewPosition location = viewPosition;
            boolean bl = false;
            RemovableView removableView = this.sideView.get(location);
            if (removableView != null) {
                removableView.onRemoved();
            }
            this.sideView.set(location, null);
        }
    }

    @Override
    @Nullable
    public GridPanel.ViewPosition locateSideView(@NotNull RemovableView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return this.sideView.locate(view);
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        GridUtil.globalSchemeChange(this.grid, scheme);
    }

    public static final /* synthetic */ RemovableView access$getRightView$p(GridMainPanel $this) {
        return $this.rightView;
    }

    public static final /* synthetic */ RemovableView access$getBottomView$p(GridMainPanel $this) {
        return $this.bottomView;
    }

    public static final /* synthetic */ void access$setRightView$p(GridMainPanel $this, RemovableView removableView) {
        $this.rightView = removableView;
    }

    public static final /* synthetic */ OnePixelSplitter access$getMyHorizontalSplitter$p(GridMainPanel $this) {
        return $this.myHorizontalSplitter;
    }

    public static final /* synthetic */ void access$setBottomView$p(GridMainPanel $this, RemovableView removableView) {
        $this.bottomView = removableView;
    }

    public static final /* synthetic */ OnePixelSplitter access$getMyVerticalSplitter$p(GridMainPanel $this) {
        return $this.myVerticalSplitter;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/database/run/ui/grid/GridMainPanel$Companion;", "", "<init>", "()V", "replaceComponentAt", "", "panel", "Ljavax/swing/JPanel;", "location", "", "with", "Ljava/awt/Component;", "getComponentAt", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void replaceComponentAt(JPanel panel2, String location, Component with) {
            Component toReplace = this.getComponentAt(panel2, location);
            if (toReplace != null) {
                panel2.remove(toReplace);
            }
            if (with != null) {
                panel2.add(with, location);
            }
            panel2.revalidate();
            panel2.repaint();
        }

        private final Component getComponentAt(JPanel panel2, String location) {
            LayoutManager layoutManager = panel2.getLayout();
            Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
            return ((BorderLayout)layoutManager).getLayoutComponent(location);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

