/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.extensions.github.alerts;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.commonmark.parser.Parser;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.markdown.extensions.github.alerts.AlertParser;
import org.jetbrains.jewel.markdown.extensions.github.alerts.AlertTextContentNodeRenderer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/jewel/markdown/extensions/github/alerts/GitHubAlertCommonMarkExtension;", "Lorg/commonmark/parser/Parser$ParserExtension;", "Lorg/commonmark/renderer/text/TextContentRenderer$TextContentRendererExtension;", "<init>", "()V", "AlertStartRegex", "Lkotlin/text/Regex;", "extend", "", "parserBuilder", "Lorg/commonmark/parser/Parser$Builder;", "rendererBuilder", "Lorg/commonmark/renderer/text/TextContentRenderer$Builder;", "intellij.platform.jewel.markdown.extensions.gfmAlerts"})
final class GitHubAlertCommonMarkExtension
implements Parser.ParserExtension,
TextContentRenderer.TextContentRendererExtension {
    @NotNull
    public static final GitHubAlertCommonMarkExtension INSTANCE = new GitHubAlertCommonMarkExtension();
    @NotNull
    private static final Regex AlertStartRegex = new Regex(">\\s+\\[!(NOTE|TIP|IMPORTANT|WARNING|CAUTION)]\\s*", RegexOption.IGNORE_CASE);

    private GitHubAlertCommonMarkExtension() {
    }

    public void extend(@NotNull Parser.Builder parserBuilder) {
        Intrinsics.checkNotNullParameter((Object)parserBuilder, (String)"parserBuilder");
        parserBuilder.customBlockParserFactory(GitHubAlertCommonMarkExtension::extend$lambda$0);
    }

    public void extend(@NotNull TextContentRenderer.Builder rendererBuilder) {
        Intrinsics.checkNotNullParameter((Object)rendererBuilder, (String)"rendererBuilder");
        rendererBuilder.nodeRendererFactory(GitHubAlertCommonMarkExtension::extend$lambda$1);
    }

    private static final BlockStart extend$lambda$0(ParserState state, MatchedBlockParser matchedBlockParser) {
        BlockStart blockStart;
        CharSequence charSequence = state.getLine().getContent();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContent(...)");
        CharSequence charSequence2 = charSequence;
        int n = state.getColumn();
        int n2 = charSequence2.length();
        String line = ((Object)charSequence2.subSequence(n, n2)).toString();
        MatchResult matchResult = AlertStartRegex.matchEntire((CharSequence)line);
        if (matchResult != null) {
            String type = (String)matchResult.getGroupValues().get(1);
            BlockParser[] blockParserArray = new BlockParser[]{new AlertParser(type)};
            blockStart = BlockStart.of((BlockParser[])blockParserArray).atColumn(state.getColumn() + state.getIndent() + matchResult.getValue().length());
        } else {
            blockStart = BlockStart.none();
        }
        return blockStart;
    }

    private static final NodeRenderer extend$lambda$1(TextContentNodeRendererContext it) {
        Intrinsics.checkNotNull((Object)it);
        return new AlertTextContentNodeRenderer(it);
    }
}

