/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompileTaskBean;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.FileProcessingCompilerAdapterTask;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.impl.OneProjectItemCompileScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.server.BuildManager;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.ide.IdleTracker;
import com.intellij.java.JavaPluginDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilableFileTypesProvider;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerFactory;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.SourceInstrumentingCompiler;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.EDT;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.javac.CompilationPaths;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.ModulePath;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.ast.api.JavacFileData;

public class CompilerManagerImpl
extends CompilerManager {
    private static final ProjectExtensionPointName<CompilerFactory> COMPILER_FACTORY_EP = new ProjectExtensionPointName("com.intellij.compilerFactory");
    private static final ProjectExtensionPointName<CompileTaskBean> COMPILER_TASK_EP = new ProjectExtensionPointName("com.intellij.compiler.task");
    private static final ProjectExtensionPointName<CompilableFileTypesProvider> COMPILABLE_TYPE_EP = new ProjectExtensionPointName("com.intellij.compilableFileTypesProvider");
    private static final Logger LOG = Logger.getInstance(CompilerManagerImpl.class);
    private final Project myProject;
    private final Map<Compiler, String> myCompilers;
    private static final String NO_FACTORY_ID = "";
    private final List<CompileTask> myBeforeTasks;
    private final List<CompileTask> myAfterTasks;
    private final Set<FileType> myCompilableTypes;
    private volatile Set<FileType> myCachedCompilableTypes;
    private final CompilationStatusListener myEventPublisher;
    private final Semaphore myCompilationSemaphore;
    private final Set<ModuleType<?>> myValidationDisabledModuleTypes;
    private final Set<LocalFileSystem.WatchRequest> myWatchRoots;
    private volatile ExternalJavacManager myExternalJavacManager;
    private final Map<CompilationStatusListener, MessageBusConnection> myListenerAdapters;

    public CompilerManagerImpl(@NotNull Project project) {
        if (project == null) {
            CompilerManagerImpl.$$$reportNull$$$0(0);
        }
        this.myCompilers = new HashMap<Compiler, String>();
        this.myBeforeTasks = new ArrayList<CompileTask>();
        this.myAfterTasks = new ArrayList<CompileTask>();
        this.myCompilableTypes = new HashSet<FileType>();
        this.myCompilationSemaphore = new Semaphore(1, true);
        this.myValidationDisabledModuleTypes = new HashSet();
        this.myListenerAdapters = new HashMap<CompilationStatusListener, MessageBusConnection>();
        this.myProject = project;
        this.myEventPublisher = (CompilationStatusListener)project.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
        for (ProjectExtensionPointName ep : Arrays.asList(COMPILABLE_TYPE_EP, BackendCompiler.EP_NAME)) {
            ep.addChangeListener((AreaInstance)project, () -> {
                this.myCachedCompilableTypes = null;
            }, (Disposable)JavaPluginDisposable.getInstance((Project)project));
        }
        COMPILER_FACTORY_EP.getPoint((AreaInstance)project).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CompilerFactory>(){

            public void extensionAdded(@NotNull CompilerFactory factory, @NotNull PluginDescriptor pluginDescriptor) {
                Compiler[] compilers;
                if (factory == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((compilers = factory.createCompilers((CompilerManager)CompilerManagerImpl.this)) != null) {
                    String factoryId = CompilerManagerImpl.getFactoryId(factory);
                    for (Compiler compiler : compilers) {
                        CompilerManagerImpl.this.addCompiler(compiler, factoryId);
                    }
                }
            }

            public void extensionRemoved(@NotNull CompilerFactory factory, @NotNull PluginDescriptor pluginDescriptor) {
                if (factory == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                ArrayList<Compiler> compilersToRemove = new ArrayList<Compiler>();
                String factoryId = CompilerManagerImpl.getFactoryId(factory);
                for (Map.Entry<Compiler, String> entry : CompilerManagerImpl.this.myCompilers.entrySet()) {
                    if (!factoryId.equals(entry.getValue())) continue;
                    compilersToRemove.add(entry.getKey());
                }
                for (Compiler compiler : compilersToRemove) {
                    CompilerManagerImpl.this.removeCompiler(compiler);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/compiler/CompilerManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, null);
        File projectGeneratedSrcRoot = CompilerPaths.getGeneratedDataDirectory((Project)project);
        projectGeneratedSrcRoot.mkdirs();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        this.myWatchRoots = lfs.addRootsToWatch(Collections.singletonList(FileUtil.toCanonicalPath((String)projectGeneratedSrcRoot.getPath())), true);
        Disposer.register((Disposable)JavaPluginDisposable.getInstance((Project)project), () -> {
            ExternalJavacManager manager = this.myExternalJavacManager;
            this.myExternalJavacManager = null;
            if (manager != null) {
                manager.stop();
            }
            lfs.removeWatchedRoots(this.myWatchRoots);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                FileUtil.delete((File)CompilerPaths.getCompilerSystemDirectory((Project)project));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public boolean waitForExternalJavacToTerminate(long time, @NotNull TimeUnit timeUnit) {
        void unit;
        ExternalJavacManager externalJavacManager;
        if (timeUnit == null) {
            CompilerManagerImpl.$$$reportNull$$$0(1);
        }
        return (externalJavacManager = this.myExternalJavacManager) == null || externalJavacManager.waitForAllProcessHandlers(time, (TimeUnit)unit);
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public boolean awaitNettyThreadPoolTermination(long time, @NotNull TimeUnit timeUnit) {
        void unit;
        ExternalJavacManager externalJavacManager;
        if (timeUnit == null) {
            CompilerManagerImpl.$$$reportNull$$$0(2);
        }
        return (externalJavacManager = this.myExternalJavacManager) == null || externalJavacManager.awaitNettyThreadPoolTermination(time, (TimeUnit)unit);
    }

    public Semaphore getCompilationSemaphore() {
        return this.myCompilationSemaphore;
    }

    public boolean isCompilationActive() {
        return this.myCompilationSemaphore.availablePermits() == 0;
    }

    public final void addCompiler(@NotNull Compiler compiler) {
        if (compiler == null) {
            CompilerManagerImpl.$$$reportNull$$$0(3);
        }
        this.addCompiler(compiler, NO_FACTORY_ID);
    }

    private void addCompiler(@NotNull Compiler compiler, @NotNull String factoryId) {
        if (compiler == null) {
            CompilerManagerImpl.$$$reportNull$$$0(4);
        }
        if (factoryId == null) {
            CompilerManagerImpl.$$$reportNull$$$0(5);
        }
        this.myCompilers.put(compiler, factoryId);
        if (compiler instanceof SourceInstrumentingCompiler) {
            this.addBeforeTask(new FileProcessingCompilerAdapterTask((FileProcessingCompiler)compiler));
        } else if (compiler instanceof Validator) {
            this.addAfterTask(new FileProcessingCompilerAdapterTask((FileProcessingCompiler)compiler));
        }
    }

    private static String getFactoryId(@Nullable CompilerFactory factory) {
        return factory == null ? NO_FACTORY_ID : factory.getClass().getName();
    }

    public final void removeCompiler(@NotNull Compiler compiler) {
        if (compiler == null) {
            CompilerManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.myCompilers.remove(compiler) != null) {
            for (List tasks : Arrays.asList(this.myBeforeTasks, this.myAfterTasks)) {
                tasks.removeIf(task2 -> task2 instanceof FileProcessingCompilerAdapterTask && ((FileProcessingCompilerAdapterTask)task2).getCompiler() == compiler);
            }
        }
    }

    public <T extends Compiler> T @NotNull [] getCompilers(@NotNull Class<T> compilerClass) {
        if (compilerClass == null) {
            CompilerManagerImpl.$$$reportNull$$$0(7);
        }
        ArrayList<Compiler> compilers = new ArrayList<Compiler>(this.myCompilers.size());
        for (Compiler item : ContainerUtil.concat(this.myCompilers.keySet(), (Iterable)Compiler.EP_NAME.getExtensions((AreaInstance)this.myProject))) {
            Compiler concreteCompiler = (Compiler)ObjectUtils.tryCast((Object)item, compilerClass);
            if (concreteCompiler == null) continue;
            compilers.add(concreteCompiler);
        }
        if (compilerClass.isAssignableFrom(InspectionValidatorWrapper.class)) {
            for (InspectionValidator validator : InspectionValidator.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
                compilers.add((Compiler)compilerClass.cast(InspectionValidatorWrapper.create(this.myProject, validator)));
            }
        }
        Compiler[] compilerArray = compilers.toArray((Compiler[])ArrayUtil.newArray(compilerClass, (int)compilers.size()));
        if (compilerArray == null) {
            CompilerManagerImpl.$$$reportNull$$$0(8);
        }
        return compilerArray;
    }

    public void addCompilableFileType(@NotNull FileType type) {
        if (type == null) {
            CompilerManagerImpl.$$$reportNull$$$0(9);
        }
        this.myCompilableTypes.add(type);
    }

    public boolean isCompilableFileType(@NotNull FileType type) {
        if (type == null) {
            CompilerManagerImpl.$$$reportNull$$$0(10);
        }
        if (this.myCompilableTypes.contains(type)) {
            return true;
        }
        Set<FileType> types = this.myCachedCompilableTypes;
        if (types == null) {
            types = new HashSet<FileType>();
            for (CompilableFileTypesProvider extension : COMPILABLE_TYPE_EP.getExtensions((AreaInstance)this.myProject)) {
                types.addAll(extension.getCompilableFileTypes());
            }
            for (BackendCompiler compiler : BackendCompiler.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
                types.addAll(compiler.getCompilableFileTypes());
            }
            this.myCachedCompilableTypes = types;
        }
        return types.contains(type);
    }

    public final void addBeforeTask(@NotNull CompileTask task2) {
        if (task2 == null) {
            CompilerManagerImpl.$$$reportNull$$$0(11);
        }
        this.myBeforeTasks.add(task2);
    }

    public final void addAfterTask(@NotNull CompileTask task2) {
        if (task2 == null) {
            CompilerManagerImpl.$$$reportNull$$$0(12);
        }
        this.myAfterTasks.add(task2);
    }

    @NotNull
    public List<CompileTask> getBeforeTasks() {
        ArrayList<CompileTask> result = new ArrayList<CompileTask>();
        result.addAll(this.myBeforeTasks);
        for (Compiler compiler : Compiler.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            if (!(compiler instanceof SourceInstrumentingCompiler)) continue;
            FileProcessingCompilerAdapterTask task2 = new FileProcessingCompilerAdapterTask((FileProcessingCompiler)((SourceInstrumentingCompiler)compiler));
            result.add(task2);
        }
        this.collectExtensionTasks(CompileTaskBean.CompileTaskExecutionPhase.BEFORE, result);
        ArrayList<CompileTask> arrayList = result;
        if (arrayList == null) {
            CompilerManagerImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public List<CompileTask> getAfterTaskList() {
        FileProcessingCompilerAdapterTask task2;
        ArrayList<CompileTask> result = new ArrayList<CompileTask>();
        result.addAll(this.myAfterTasks);
        for (Compiler extCompiler : Compiler.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            if (!(extCompiler instanceof Validator)) continue;
            task2 = new FileProcessingCompilerAdapterTask((FileProcessingCompiler)((Validator)extCompiler));
            result.add(task2);
        }
        for (InspectionValidator validator : InspectionValidator.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            task2 = new FileProcessingCompilerAdapterTask((FileProcessingCompiler)InspectionValidatorWrapper.create(this.myProject, validator));
            result.add(task2);
        }
        this.collectExtensionTasks(CompileTaskBean.CompileTaskExecutionPhase.AFTER, result);
        ArrayList<CompileTask> arrayList = result;
        if (arrayList == null) {
            CompilerManagerImpl.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private void collectExtensionTasks(@NotNull CompileTaskBean.CompileTaskExecutionPhase phase, @NotNull List<CompileTask> to) {
        if (phase == null) {
            CompilerManagerImpl.$$$reportNull$$$0(15);
        }
        if (to == null) {
            CompilerManagerImpl.$$$reportNull$$$0(16);
        }
        ((ExtensionPointImpl)COMPILER_TASK_EP.getPoint((AreaInstance)this.myProject)).processWithPluginDescriptor((extension, pluginDescriptor) -> {
            if (extension.executionPhase == phase) {
                to.add((CompileTask)extension.getInstance((ComponentManager)this.myProject, pluginDescriptor));
            }
            return Unit.INSTANCE;
        });
    }

    public void compile(VirtualFile @NotNull [] files, CompileStatusNotification callback) {
        if (files == null) {
            CompilerManagerImpl.$$$reportNull$$$0(17);
        }
        this.compile(this.createFilesCompileScope(files), callback);
    }

    public void compile(@NotNull Module module, CompileStatusNotification callback) {
        if (module == null) {
            CompilerManagerImpl.$$$reportNull$$$0(18);
        }
        new CompileDriver(this.myProject).compile(this.createModuleCompileScope(module, false), new ListenerNotificator(callback));
    }

    public void compile(@NotNull CompileScope scope, CompileStatusNotification callback) {
        if (scope == null) {
            CompilerManagerImpl.$$$reportNull$$$0(19);
        }
        new CompileDriver(this.myProject).compile(scope, new ListenerNotificator(callback));
    }

    public void make(CompileStatusNotification callback) {
        new CompileDriver(this.myProject).make(this.createProjectCompileScope(this.myProject), new ListenerNotificator(callback));
    }

    public void make(@NotNull Module module, CompileStatusNotification callback) {
        if (module == null) {
            CompilerManagerImpl.$$$reportNull$$$0(20);
        }
        new CompileDriver(this.myProject).make(this.createModuleCompileScope(module, true), new ListenerNotificator(callback));
    }

    public void make(@NotNull Project project, Module @NotNull [] modules, CompileStatusNotification callback) {
        if (project == null) {
            CompilerManagerImpl.$$$reportNull$$$0(21);
        }
        if (modules == null) {
            CompilerManagerImpl.$$$reportNull$$$0(22);
        }
        new CompileDriver(this.myProject).make(this.createModuleGroupCompileScope(project, modules, true), new ListenerNotificator(callback));
    }

    public void make(@NotNull CompileScope scope, CompileStatusNotification callback) {
        if (scope == null) {
            CompilerManagerImpl.$$$reportNull$$$0(23);
        }
        new CompileDriver(this.myProject).make(scope, new ListenerNotificator(callback));
    }

    public void makeWithModalProgress(@NotNull CompileScope scope, @Nullable CompileStatusNotification callback) {
        if (scope == null) {
            CompilerManagerImpl.$$$reportNull$$$0(24);
        }
        new CompileDriver(this.myProject).make(scope, true, new ListenerNotificator(callback));
    }

    public boolean isUpToDate(@NotNull CompileScope scope) {
        if (scope == null) {
            CompilerManagerImpl.$$$reportNull$$$0(25);
        }
        ProgressIndicator progress = EDT.isCurrentThreadEdt() ? null : ProgressIndicatorProvider.getInstance().getProgressIndicator();
        return progress != null ? this.isUpToDate(scope, progress) : new CompileDriver(this.myProject).isUpToDate(scope, null);
    }

    public boolean isUpToDate(@NotNull CompileScope scope, @NotNull ProgressIndicator progress) {
        if (scope == null) {
            CompilerManagerImpl.$$$reportNull$$$0(26);
        }
        if (progress == null) {
            CompilerManagerImpl.$$$reportNull$$$0(27);
        }
        return new CompileDriver(this.myProject).isUpToDate(scope, progress);
    }

    public void rebuild(CompileStatusNotification callback) {
        new CompileDriver(this.myProject).rebuild(new ListenerNotificator(callback), false);
    }

    public void rebuildClean(@Nullable CompileStatusNotification callback) {
        new CompileDriver(this.myProject).rebuild(new ListenerNotificator(callback), true);
    }

    public void executeTask(@NotNull CompileTask task2, @NotNull CompileScope scope, @NlsContexts.TabTitle String contentName, Runnable onTaskFinished) {
        if (task2 == null) {
            CompilerManagerImpl.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            CompilerManagerImpl.$$$reportNull$$$0(29);
        }
        CompileDriver compileDriver = new CompileDriver(this.myProject);
        compileDriver.executeCompileTask(task2, scope, contentName, onTaskFinished);
    }

    public void addCompilationStatusListener(@NotNull CompilationStatusListener listener) {
        if (listener == null) {
            CompilerManagerImpl.$$$reportNull$$$0(30);
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        this.myListenerAdapters.put(listener, connection);
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)listener);
    }

    public void removeCompilationStatusListener(@NotNull CompilationStatusListener listener) {
        MessageBusConnection connection;
        if (listener == null) {
            CompilerManagerImpl.$$$reportNull$$$0(31);
        }
        if ((connection = this.myListenerAdapters.remove(listener)) != null) {
            connection.disconnect();
        }
    }

    public boolean isExcludedFromCompilation(@NotNull VirtualFile file) {
        if (file == null) {
            CompilerManagerImpl.$$$reportNull$$$0(32);
        }
        return CompilerConfiguration.getInstance((Project)this.myProject).isExcludedFromCompilation(file);
    }

    @NotNull
    public CompileScope createFilesCompileScope(VirtualFile @NotNull [] files) {
        if (files == null) {
            CompilerManagerImpl.$$$reportNull$$$0(33);
        }
        CompileScope[] scopes = new CompileScope[files.length];
        for (int i = 0; i < files.length; ++i) {
            scopes[i] = new OneProjectItemCompileScope(this.myProject, files[i]);
        }
        return new CompositeScope(scopes);
    }

    @NotNull
    public CompileScope createModulesCompileScope(Module @NotNull [] modules, boolean includeDependentModules, boolean includeRuntimeDependencies, boolean includeTests) {
        if (modules == null) {
            CompilerManagerImpl.$$$reportNull$$$0(34);
        }
        return new ModuleCompileScope(this.myProject, Arrays.asList(modules), Collections.emptyList(), includeDependentModules, includeRuntimeDependencies, includeTests);
    }

    @NotNull
    public CompileScope createModuleGroupCompileScope(@NotNull Project project, Module @NotNull [] modules, boolean includeDependentModules) {
        if (project == null) {
            CompilerManagerImpl.$$$reportNull$$$0(35);
        }
        if (modules == null) {
            CompilerManagerImpl.$$$reportNull$$$0(36);
        }
        return new ModuleCompileScope(project, modules, includeDependentModules);
    }

    @NotNull
    public CompileScope createProjectCompileScope(@NotNull Project project) {
        if (project == null) {
            CompilerManagerImpl.$$$reportNull$$$0(37);
        }
        return new ProjectCompileScope(project);
    }

    public void setValidationEnabled(ModuleType<?> moduleType, boolean enabled) {
        if (enabled) {
            this.myValidationDisabledModuleTypes.remove(moduleType);
        } else {
            this.myValidationDisabledModuleTypes.add(moduleType);
        }
    }

    public boolean isValidationEnabled(Module module) {
        if (this.myValidationDisabledModuleTypes.isEmpty()) {
            return true;
        }
        return !this.myValidationDisabledModuleTypes.contains(ModuleType.get((Module)module));
    }

    public Collection<ClassObject> compileJavaCode(List<String> options, Collection<? extends File> platformCp, Collection<? extends File> classpath, Collection<? extends File> upgradeModulePath, Collection<? extends File> modulePath, Collection<? extends File> sourcePath, Collection<? extends File> files, File outputDir) throws IOException, CompilationException {
        boolean compiledOk;
        Pair<Sdk, JavaSdkVersion> runtime = BuildManager.getJavacRuntimeSdk(this.myProject);
        Sdk sdk = (Sdk)runtime.getFirst();
        SdkTypeId type = sdk.getSdkType();
        String javaHome = null;
        if (type instanceof JavaSdkType && !CompilerManagerImpl.isJdkOrJre(javaHome = sdk.getHomePath())) {
            String binPath = ((JavaSdkType)type).getBinPath(sdk);
            String string = javaHome = binPath != null ? new File(binPath).getParent() : null;
            if (!CompilerManagerImpl.isJdkOrJre(javaHome)) {
                javaHome = null;
            }
        }
        if (javaHome == null) {
            throw new IOException("Was not able to determine JDK for project " + this.myProject.getName());
        }
        OutputCollector outputCollector = new OutputCollector();
        DiagnosticCollector diagnostic = new DiagnosticCollector();
        Set sourceRoots = FileCollectionFactory.createCanonicalFileSet();
        if (!sourcePath.isEmpty()) {
            sourceRoots.addAll(sourcePath);
        } else {
            for (File file : files) {
                File parentFile = file.getParentFile();
                if (parentFile == null) continue;
                sourceRoots.add(parentFile);
            }
        }
        Map<File, Set> outs = Collections.singletonMap(outputDir, sourceRoots);
        ExternalJavacManager externalJavacManager = this.getJavacManager();
        CompilationPaths paths = CompilationPaths.create(platformCp, classpath, upgradeModulePath, (ModulePath)ModulePath.create(modulePath), sourcePath);
        boolean bl = externalJavacManager != null && externalJavacManager.forkJavac(javaHome, -1, Collections.emptyList(), options, paths, files, outs, (DiagnosticOutputConsumer)diagnostic, (OutputFileConsumer)outputCollector, (JavaCompilingTool)new JavacCompilerTool(), CanceledStatus.NULL, !ApplicationManager.getApplication().isUnitTestMode()).get() != false ? true : (compiledOk = false);
        if (!compiledOk) {
            SmartList messages = new SmartList();
            for (Diagnostic<? extends JavaFileObject> d : diagnostic.getDiagnostics()) {
                JavaFileObject source = d.getSource();
                URI uri = source != null ? source.toUri() : null;
                messages.add(new CompilationException.Message(CompilerManagerImpl.kindToCategory(d.getKind()), d.getMessage(Locale.US), uri != null ? uri.toURL().toString() : null, (int)d.getLineNumber(), (int)d.getColumnNumber()));
            }
            throw new CompilationException("Compilation failed", (Collection)messages);
        }
        ArrayList<ClassObject> result = new ArrayList<ClassObject>();
        for (OutputFileObject fileObject : outputCollector.getCompiledClasses()) {
            BinaryContent content = fileObject.getContent();
            result.add(new CompiledClass(fileObject.getName(), fileObject.getClassName(), content != null ? content.toByteArray() : null));
        }
        return result;
    }

    private static boolean isJdkOrJre(@Nullable String path) {
        return path != null && (JdkUtil.checkForJre((String)path) || JdkUtil.checkForJdk((String)path));
    }

    private static CompilerMessageCategory kindToCategory(Diagnostic.Kind kind) {
        return switch (kind) {
            case Diagnostic.Kind.ERROR -> CompilerMessageCategory.ERROR;
            case Diagnostic.Kind.MANDATORY_WARNING, Diagnostic.Kind.WARNING -> CompilerMessageCategory.WARNING;
            default -> CompilerMessageCategory.INFORMATION;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ExternalJavacManager getJavacManager() throws IOException {
        ExternalJavacManager manager = this.myExternalJavacManager;
        if (manager == null) {
            CompilerManagerImpl compilerManagerImpl = this;
            synchronized (compilerManagerImpl) {
                manager = this.myExternalJavacManager;
                if (manager == null) {
                    File compilerWorkingDir = this.getJavacCompilerWorkingDir();
                    if (compilerWorkingDir == null) {
                        return null;
                    }
                    int listenPort = NetUtils.findAvailableSocketPort();
                    manager = new ExternalJavacManager(compilerWorkingDir, (Executor)ProcessIOExecutorService.INSTANCE, (long)Registry.intValue((String)"compiler.external.javac.keep.alive.timeout", (int)300000));
                    manager.setWslExecutablePath(WSLDistribution.findWslExe());
                    manager.start(listenPort);
                    this.myExternalJavacManager = manager;
                    IdleTask task2 = new IdleTask(manager);
                    task2.removeIdleListener = IdleTracker.getInstance().addIdleListener(10000, (Runnable)task2);
                }
            }
        }
        return manager;
    }

    @Nullable
    public File getJavacCompilerWorkingDir() {
        File projectBuildDir = BuildManager.getInstance().getProjectSystemDirectory(this.myProject);
        projectBuildDir.mkdirs();
        return projectBuildDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerClass";
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/CompilerManagerImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 12: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 22: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/CompilerManagerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeTasks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterTaskList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "waitForExternalJavacToTerminate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "awaitNettyThreadPoolTermination";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCompiler";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeCompiler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCompilers";
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCompilableFileType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCompilableFileType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeTask";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addAfterTask";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectExtensionTasks";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "make";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "makeWithModalProgress";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addCompilationStatusListener";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeCompilationStatusListener";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFromCompilation";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createFilesCompileScope";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createModulesCompileScope";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroupCompileScope";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createProjectCompileScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 13, 14 -> new IllegalStateException(string);
        };
    }

    private final class ListenerNotificator
    implements CompileStatusNotification {
        @Nullable
        private final CompileStatusNotification myDelegate;

        private ListenerNotificator(CompileStatusNotification delegate) {
            this.myDelegate = delegate;
        }

        public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
            if (compileContext == null) {
                ListenerNotificator.$$$reportNull$$$0(0);
            }
            if (!CompilerManagerImpl.this.myProject.isDisposed()) {
                CompilerManagerImpl.this.myEventPublisher.compilationFinished(aborted, errors, warnings, compileContext);
            }
            if (this.myDelegate != null) {
                this.myDelegate.finished(aborted, errors, warnings, compileContext);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/compiler/CompilerManagerImpl$ListenerNotificator", "finished"));
        }
    }

    private static class OutputCollector
    implements OutputFileConsumer {
        private final List<OutputFileObject> myClasses = new ArrayList<OutputFileObject>();

        private OutputCollector() {
        }

        public void save(@NotNull OutputFileObject fileObject) {
            if (fileObject == null) {
                OutputCollector.$$$reportNull$$$0(0);
            }
            this.myClasses.add(fileObject);
        }

        List<OutputFileObject> getCompiledClasses() {
            return this.myClasses;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/intellij/compiler/CompilerManagerImpl$OutputCollector", "save"));
        }
    }

    private static class DiagnosticCollector
    implements DiagnosticOutputConsumer {
        private final List<Diagnostic<? extends JavaFileObject>> myDiagnostics = new ArrayList<Diagnostic<? extends JavaFileObject>>();

        private DiagnosticCollector() {
        }

        public void outputLineAvailable(String line) {
            if (line != null && line.startsWith("JAVAC_PROCESS[STDERR]")) {
                LOG.info(line.trim());
            }
        }

        public void registerJavacFileData(JavacFileData data) {
        }

        public void javaFileLoaded(File file) {
        }

        public void customOutputData(String pluginId, String dataName, byte[] data) {
        }

        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.myDiagnostics.add(diagnostic);
        }

        public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
            return this.myDiagnostics;
        }
    }

    @ApiStatus.Internal
    public static final class CompiledClass
    implements ClassObject {
        private final String myPath;
        private final String myClassName;
        private final byte[] myBytes;

        public CompiledClass(String path, String className, byte[] bytes) {
            this.myPath = path;
            this.myClassName = className;
            this.myBytes = bytes;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public byte @Nullable [] getContent() {
            return this.myBytes;
        }

        public String toString() {
            return this.getClassName();
        }
    }

    private static final class IdleTask
    implements Runnable {
        private static final int CHECK_PERIOD = 10000;
        private final ExternalJavacManager myManager;
        AccessToken removeIdleListener;

        IdleTask(@NotNull ExternalJavacManager manager) {
            if (manager == null) {
                IdleTask.$$$reportNull$$$0(0);
            }
            this.myManager = manager;
        }

        @Override
        public void run() {
            if (this.myManager.isRunning()) {
                this.myManager.shutdownIdleProcesses();
            } else if (this.removeIdleListener != null) {
                this.removeIdleListener.close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/compiler/CompilerManagerImpl$IdleTask", "<init>"));
        }
    }
}

