/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a2\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0000\u001a$\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0011H\u0000\u00a8\u0006\u0012"}, d2={"getFilteredModuleNameList", "", "", "project", "Lcom/intellij/openapi/project/Project;", "map", "", "isExternal", "", "writeBytecodeTarget", "", "moduleNames", "element", "Lorg/jdom/Element;", "readByteTargetLevel", "parentNode", "result", "", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nExternalCompilerConfigurationStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalCompilerConfigurationStorage.kt\ncom/intellij/compiler/ExternalCompilerConfigurationStorageKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n777#2:102\n873#2,2:103\n*S KotlinDebug\n*F\n+ 1 ExternalCompilerConfigurationStorage.kt\ncom/intellij/compiler/ExternalCompilerConfigurationStorageKt\n*L\n76#1:102\n76#1:103,2\n*E\n"})
public final class ExternalCompilerConfigurationStorageKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getFilteredModuleNameList(@NotNull Project project, @NotNull Map<String, String> map, boolean isExternal) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (map.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (!ProjectUtilCore.isExternalStorageEnabled((Project)project)) {
            return CollectionsKt.toList((Iterable)map.keySet());
        }
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
        ExternalProjectSystemRegistry externalProjectSystemRegistry = ExternalProjectSystemRegistry.getInstance();
        Iterable $this$filter$iv = map.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Module module;
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = moduleManager.findModuleByName(it) == null ? !isExternal : externalProjectSystemRegistry.getExternalSource(module) != null == isExternal;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final void writeBytecodeTarget(@NotNull List<String> moduleNames, @NotNull Map<String, String> map, @NotNull Element element) {
        Intrinsics.checkNotNullParameter(moduleNames, (String)"moduleNames");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List sortedModuleNames = CollectionsKt.sortedWith((Iterable)moduleNames, (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        for (String name : sortedModuleNames) {
            Element moduleElement = new Element("module");
            moduleElement.setAttribute("name", name);
            String string = map.get(name);
            if (string == null) {
                string = "";
            }
            moduleElement.setAttribute("target", string);
            element.addContent(moduleElement);
        }
    }

    public static final void readByteTargetLevel(@NotNull Element parentNode, @NotNull Map<String, String> result) {
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Element element = parentNode.getChild("bytecodeTargetLevel");
        if (element == null) {
            return;
        }
        Element bytecodeTargetElement = element;
        for (Element element2 : bytecodeTargetElement.getChildren("module")) {
            String target;
            String name;
            if (element2.getAttributeValue("name") == null || element2.getAttributeValue("target") == null) continue;
            result.put(name, target);
        }
    }
}

