/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.CompilerRef;

public enum CompilerHierarchySearchType {
    DIRECT_INHERITOR{

        @Override
        PsiElement[] performSearchInFile(SearchId[] definitions, PsiNamedElement baseElement, PsiFileWithStubSupport file, LanguageCompilerRefAdapter adapter) {
            return adapter.findDirectInheritorCandidatesInFile(definitions, file);
        }

        @Override
        Class<? extends CompilerRef> getRequiredClass(LanguageCompilerRefAdapter adapter) {
            return adapter.getHierarchyObjectClass();
        }

        @Override
        @NotNull
        SearchId convertToId(@NotNull CompilerRef compilerRef, PersistentStringEnumerator nameEnumerator) throws IOException {
            if (compilerRef == null) {
                1.$$$reportNull$$$0(0);
            }
            return compilerRef instanceof CompilerRef.JavaCompilerAnonymousClassRef ? new SearchId(((CompilerRef.JavaCompilerAnonymousClassRef)compilerRef).getName()) : new SearchId(nameEnumerator.valueOf(((CompilerRef.CompilerClassHierarchyElementDef)compilerRef).getName()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerRef", "com/intellij/compiler/backwardRefs/CompilerHierarchySearchType$1", "convertToId"));
        }
    }
    ,
    FUNCTIONAL_EXPRESSION{

        @Override
        PsiElement[] performSearchInFile(SearchId[] definitions, PsiNamedElement baseElement, PsiFileWithStubSupport file, LanguageCompilerRefAdapter adapter) {
            return adapter.findFunExpressionsInFile(definitions, file);
        }

        @Override
        Class<? extends CompilerRef> getRequiredClass(LanguageCompilerRefAdapter adapter) {
            return adapter.getFunExprClass();
        }

        @Override
        @NotNull
        SearchId convertToId(@NotNull CompilerRef compilerRef, PersistentStringEnumerator nameEnumerator) {
            if (compilerRef == null) {
                2.$$$reportNull$$$0(0);
            }
            return new SearchId(((CompilerRef.CompilerFunExprDef)compilerRef).getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerRef", "com/intellij/compiler/backwardRefs/CompilerHierarchySearchType$2", "convertToId"));
        }
    };


    abstract PsiElement[] performSearchInFile(SearchId[] var1, PsiNamedElement var2, PsiFileWithStubSupport var3, LanguageCompilerRefAdapter var4);

    abstract Class<? extends CompilerRef> getRequiredClass(LanguageCompilerRefAdapter var1);

    @NotNull
    abstract SearchId convertToId(@NotNull CompilerRef var1, PersistentStringEnumerator var2) throws IOException;

    @NotNull
    @NotNull SearchId @NotNull [] convertToIds(Collection<? extends CompilerRef> compilerRef, PersistentStringEnumerator nameEnumerator) throws IOException {
        ArrayList<SearchId> list = new ArrayList<SearchId>(compilerRef.size());
        for (CompilerRef compilerRef2 : compilerRef) {
            list.add(this.convertToId(compilerRef2, nameEnumerator));
        }
        SearchId[] searchIdArray = list.toArray(new SearchId[0]);
        if (searchIdArray == null) {
            CompilerHierarchySearchType.$$$reportNull$$$0(0);
        }
        return searchIdArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerHierarchySearchType", "convertToIds"));
    }
}

