/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.CompilerReferenceReaderFactory;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceBase;
import com.intellij.compiler.backwardRefs.DirectInheritorProvider;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.OccurrenceCounter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.backwardRefs.SearchIdHolder;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.PersistentStringEnumerator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.JavaCompilerBackwardReferenceIndex;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompilerReferenceIndex;
import org.jetbrains.jps.backwardRefs.index.JavaCompilerIndices;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;

public final class JavaBackwardReferenceIndexReaderFactory
implements CompilerReferenceReaderFactory<BackwardReferenceReader> {
    public static final JavaBackwardReferenceIndexReaderFactory INSTANCE = new JavaBackwardReferenceIndexReaderFactory();
    private static final Logger LOG = Logger.getInstance(JavaBackwardReferenceIndexReaderFactory.class);

    @Override
    public int expectedIndexVersion() {
        return 8;
    }

    @Override
    @Nullable
    public BackwardReferenceReader create(Project project) {
        Path buildDir = BuildManager.getInstance().getProjectSystemDir(project);
        if (!CompilerReferenceIndex.exists((Path)buildDir) || CompilerReferenceIndex.versionDiffers((Path)buildDir, (int)this.expectedIndexVersion())) {
            return null;
        }
        try {
            return new BackwardReferenceReader(project, buildDir, CompilerReferenceServiceBase.isCaseSensitiveFS(project));
        }
        catch (RuntimeException e) {
            LOG.error("An exception while initialization of compiler reference index.", (Throwable)e);
            return null;
        }
    }

    public static class BackwardReferenceReader
    extends CompilerReferenceReader<JavaCompilerBackwardReferenceIndex> {
        private final Project myProject;

        protected BackwardReferenceReader(Project project, Path buildDir) {
            super(buildDir, new JavaCompilerBackwardReferenceIndex(buildDir, new PathRelativizerService(project.getBasePath()), true));
            this.myProject = project;
        }

        protected BackwardReferenceReader(Project project, Path buildDir, boolean isCaseSensitiveFS) {
            super(buildDir, new JavaCompilerBackwardReferenceIndex(buildDir, new PathRelativizerService(project.getBasePath(), Boolean.valueOf(isCaseSensitiveFS)), true, isCaseSensitiveFS));
            this.myProject = project;
        }

        @Override
        @Nullable
        public Set<VirtualFile> findReferentFileIds(@NotNull CompilerRef ref, boolean checkBaseClassAmbiguity) throws StorageException {
            CompilerRef.NamedCompilerRef[] hierarchy;
            if (ref == null) {
                BackwardReferenceReader.$$$reportNull$$$0(0);
            }
            if (ref instanceof CompilerRef.CompilerClassHierarchyElementDef) {
                hierarchy = new CompilerRef.NamedCompilerRef[]{(CompilerRef.NamedCompilerRef)ref};
            } else {
                CompilerRef.CompilerClassHierarchyElementDef hierarchyElement = ((CompilerRef.CompilerMember)ref).getOwner();
                hierarchy = this.getHierarchy(hierarchyElement, checkBaseClassAmbiguity, false, -1);
            }
            if (hierarchy == null) {
                return null;
            }
            VirtualFileSet set = VfsUtilCore.createCompactVirtualFileSet();
            for (CompilerRef.NamedCompilerRef aClass : hierarchy) {
                CompilerRef overriderUsage = ref.override(aClass.getName());
                this.addUsages(overriderUsage, (Set<VirtualFile>)set);
            }
            return set;
        }

        @Override
        @Nullable
        public Set<VirtualFile> findFileIdsWithImplicitToString(@NotNull CompilerRef ref) throws StorageException {
            if (ref == null) {
                BackwardReferenceReader.$$$reportNull$$$0(1);
            }
            VirtualFileSet result = VfsUtilCore.createCompactVirtualFileSet();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.IMPLICIT_TO_STRING).withData((Object)ref, arg_0 -> this.lambda$findFileIdsWithImplicitToString$1((Set)result, arg_0));
            return result;
        }

        @Override
        @NotNull
        public Map<VirtualFile, SearchId[]> getDirectInheritors(@NotNull CompilerRef searchElement, @NotNull GlobalSearchScope searchScope, @NotNull GlobalSearchScope dirtyScope, @NotNull FileType fileType, @NotNull CompilerHierarchySearchType searchType) throws StorageException {
            if (searchElement == null) {
                BackwardReferenceReader.$$$reportNull$$$0(2);
            }
            if (searchScope == null) {
                BackwardReferenceReader.$$$reportNull$$$0(3);
            }
            if (dirtyScope == null) {
                BackwardReferenceReader.$$$reportNull$$$0(4);
            }
            if (fileType == null) {
                BackwardReferenceReader.$$$reportNull$$$0(5);
            }
            if (searchType == null) {
                BackwardReferenceReader.$$$reportNull$$$0(6);
            }
            GlobalSearchScope effectiveSearchScope = GlobalSearchScope.notScope((GlobalSearchScope)dirtyScope).intersectWith(searchScope);
            LanguageCompilerRefAdapter adapter = LanguageCompilerRefAdapter.findAdapter(fileType);
            LOG.assertTrue(adapter != null, (Object)("adapter is null for file type: " + String.valueOf(fileType)));
            Class<? extends CompilerRef> requiredCompilerRefClass = searchType.getRequiredClass(adapter);
            HashMap candidatesPerFile = new HashMap();
            try {
                ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).withData((Object)searchElement, container -> container.process((fileId, defs) -> {
                    List requiredCandidates = ContainerUtil.filter((Collection)defs, requiredCompilerRefClass::isInstance);
                    if (requiredCandidates.isEmpty()) {
                        return true;
                    }
                    VirtualFile file = this.findFile(fileId);
                    if (file != null && effectiveSearchScope.contains(file)) {
                        candidatesPerFile.put(file, searchType.convertToIds(requiredCandidates, (PersistentStringEnumerator)((JavaCompilerBackwardReferenceIndex)this.myIndex).getByteSeqEum()));
                    }
                    return true;
                }));
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
            Map<Object, Object> map = candidatesPerFile.isEmpty() ? Collections.emptyMap() : candidatesPerFile;
            if (map == null) {
                BackwardReferenceReader.$$$reportNull$$$0(7);
            }
            return map;
        }

        @Override
        @Nullable
        public Integer getAnonymousCount(@NotNull CompilerRef.CompilerClassHierarchyElementDef classDef, boolean checkDefinitions) {
            if (classDef == null) {
                BackwardReferenceReader.$$$reportNull$$$0(8);
            }
            try {
                if (checkDefinitions && this.getDefinitionCount((CompilerRef)classDef) != DefCount.ONE) {
                    return null;
                }
                int[] count = new int[]{0};
                ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).withData((Object)classDef, container -> container.forEach((id, value) -> {
                    count[0] = count[0] + value.size();
                    return true;
                }));
                return count[0];
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int getOccurrenceCount(@NotNull CompilerRef element) {
            if (element == null) {
                BackwardReferenceReader.$$$reportNull$$$0(9);
            }
            try {
                int[] result = new int[]{0};
                ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_USAGES).withData((Object)element, container -> container.forEach((id, value) -> {
                    result[0] = result[0] + value;
                    return true;
                }));
                return result[0];
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        List<CompilerRef> getMembersFor(@NotNull SignatureData data) {
            ArrayList<CompilerRef> arrayList;
            if (data == null) {
                BackwardReferenceReader.$$$reportNull$$$0(10);
            }
            try {
                ArrayList<CompilerRef> result = new ArrayList<CompilerRef>();
                ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_MEMBER_SIGN).withData((Object)data, container -> container.forEach((id, refs) -> {
                    result.addAll((Collection<CompilerRef>)refs);
                    return true;
                }));
                arrayList = result;
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
            if (arrayList == null) {
                BackwardReferenceReader.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        @NotNull
        IntSet getAllContainingFileIds(@NotNull CompilerRef ref) throws StorageException {
            if (ref == null) {
                BackwardReferenceReader.$$$reportNull$$$0(12);
            }
            IntSet intSet = InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_USAGES), Collections.singletonList(ref), null, null);
            if (intSet == null) {
                BackwardReferenceReader.$$$reportNull$$$0(13);
            }
            return intSet;
        }

        @NotNull
        OccurrenceCounter<CompilerRef> getTypeCastOperands(@NotNull CompilerRef castType, @Nullable IntCollection fileIds) throws StorageException {
            if (castType == null) {
                BackwardReferenceReader.$$$reportNull$$$0(14);
            }
            OccurrenceCounter<CompilerRef> result = new OccurrenceCounter<CompilerRef>();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_CAST).withData((Object)castType, container -> container.forEach((id, values) -> {
                if (fileIds != null && !fileIds.contains(id)) {
                    return true;
                }
                for (CompilerRef ref : values) {
                    result.add(ref);
                }
                return true;
            }));
            OccurrenceCounter<CompilerRef> occurrenceCounter = result;
            if (occurrenceCounter == null) {
                BackwardReferenceReader.$$$reportNull$$$0(15);
            }
            return occurrenceCounter;
        }

        private void addUsages(CompilerRef usage, Set<VirtualFile> sink) throws StorageException {
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_USAGES).withData((Object)usage, container -> container.forEach((id, value) -> {
                VirtualFile file = this.findFile(id);
                if (file != null) {
                    sink.add(file);
                }
                return true;
            }));
        }

        private VirtualFile findFile(int id) {
            try {
                String path = ((JavaCompilerBackwardReferenceIndex)this.myIndex).getFilePathEnumerator().valueOf(id);
                assert (path != null);
                return VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        CompilerRef.CompilerClassHierarchyElementDef @Nullable(value="return null if the class hierarchy contains ambiguous qualified names") [] getHierarchy(CompilerRef.CompilerClassHierarchyElementDef hierarchyElement, boolean checkBaseClassAmbiguity, boolean includeAnonymous, int interruptNumber) {
            try {
                List directInheritorProviders = DirectInheritorProvider.EP_NAME.getExtensionList((AreaInstance)this.myProject);
                HashSet<CompilerRef.CompilerClassHierarchyElementDef> result = new HashSet<CompilerRef.CompilerClassHierarchyElementDef>();
                ArrayDeque<CompilerRef.CompilerClassHierarchyElementDef> q = new ArrayDeque<CompilerRef.CompilerClassHierarchyElementDef>(10);
                q.addLast(hierarchyElement);
                while (!q.isEmpty()) {
                    CompilerRef.CompilerClassHierarchyElementDef curClass = (CompilerRef.CompilerClassHierarchyElementDef)q.removeFirst();
                    if (interruptNumber != -1 && result.size() > interruptNumber) break;
                    if (!result.add(curClass)) continue;
                    if (result.size() % 100 == 0) {
                        ProgressManager.checkCanceled();
                    }
                    if (!(curClass instanceof CompilerRef.CompilerAnonymousClassDef) && (checkBaseClassAmbiguity || curClass != hierarchyElement) && this.hasMultipleDefinitions((CompilerRef.NamedCompilerRef)curClass)) {
                        return null;
                    }
                    ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).withData((Object)curClass, container -> container.forEach((id, children) -> {
                        for (CompilerRef child : children) {
                            if (!(child instanceof CompilerRef.CompilerClassHierarchyElementDef) || !includeAnonymous && child instanceof CompilerRef.CompilerAnonymousClassDef) continue;
                            q.addLast((CompilerRef.CompilerClassHierarchyElementDef)child);
                        }
                        return true;
                    }));
                    try {
                        SearchId searchId = curClass instanceof SearchIdHolder ? ((SearchIdHolder)curClass).getSearchId() : CompilerHierarchySearchType.DIRECT_INHERITOR.convertToId((CompilerRef)curClass, (PersistentStringEnumerator)((JavaCompilerBackwardReferenceIndex)this.myIndex).getByteSeqEum());
                        for (DirectInheritorProvider provider : directInheritorProviders) {
                            q.addAll(provider.findDirectInheritors(searchId, ((JavaCompilerBackwardReferenceIndex)this.myIndex).getByteSeqEum()));
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return result.toArray(CompilerRef.CompilerClassHierarchyElementDef.EMPTY_ARRAY);
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        Collection<CompilerRef.CompilerClassHierarchyElementDef> getDirectInheritors(CompilerRef hierarchyElement) throws StorageException {
            HashSet<CompilerRef.CompilerClassHierarchyElementDef> result = new HashSet<CompilerRef.CompilerClassHierarchyElementDef>();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).withData((Object)hierarchyElement, container -> container.forEach((id, children) -> {
                for (CompilerRef child : children) {
                    if (!(child instanceof CompilerRef.CompilerClassHierarchyElementDef) || child instanceof CompilerRef.CompilerAnonymousClassDef) continue;
                    result.add((CompilerRef.CompilerClassHierarchyElementDef)child);
                }
                return true;
            }));
            HashSet<CompilerRef.CompilerClassHierarchyElementDef> hashSet = result;
            if (hashSet == null) {
                BackwardReferenceReader.$$$reportNull$$$0(16);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public @NotNull SearchId @NotNull [] getDirectInheritorsNames(CompilerRef hierarchyElement) throws StorageException {
            SearchId[] searchIdArray;
            try {
                searchIdArray = CompilerHierarchySearchType.DIRECT_INHERITOR.convertToIds(this.getDirectInheritors(hierarchyElement), (PersistentStringEnumerator)((JavaCompilerBackwardReferenceIndex)this.myIndex).getByteSeqEum());
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
            if (searchIdArray == null) {
                BackwardReferenceReader.$$$reportNull$$$0(17);
            }
            return searchIdArray;
        }

        private boolean hasMultipleDefinitions(CompilerRef.NamedCompilerRef def) throws StorageException {
            return this.getDefinitionCount((CompilerRef)def) == DefCount.MANY;
        }

        @NotNull
        private DefCount getDefinitionCount(CompilerRef def) throws StorageException {
            DefCount[] result = new DefCount[]{DefCount.NONE};
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_CLASS_DEF).withData((Object)def, container -> container.forEach((id, value) -> {
                if (result[0] == DefCount.NONE) {
                    result[0] = DefCount.ONE;
                    return true;
                }
                if (result[0] == DefCount.ONE) {
                    result[0] = DefCount.MANY;
                    return true;
                }
                return false;
            }));
            DefCount defCount = result[0];
            if (defCount == null) {
                BackwardReferenceReader.$$$reportNull$$$0(18);
            }
            return defCount;
        }

        private /* synthetic */ boolean lambda$findFileIdsWithImplicitToString$1(Set result, ValueContainer container) throws RuntimeException {
            return container.forEach((id, value) -> {
                VirtualFile file = this.findFile(id);
                if (file != null) {
                    result.add(file);
                }
                return true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 11, 13, 15, 16, 17, 18 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirtyScope";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchType";
                    break;
                }
                case 7: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/backwardRefs/JavaBackwardReferenceIndexReaderFactory$BackwardReferenceReader";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classDef";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "castType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/backwardRefs/JavaBackwardReferenceIndexReaderFactory$BackwardReferenceReader";
                    break;
                }
                case 7: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectInheritors";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMembersFor";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllContainingFileIds";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeCastOperands";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectInheritorsNames";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefinitionCount";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findReferentFileIds";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findFileIdsWithImplicitToString";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirectInheritors";
                    break;
                }
                case 7: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnonymousCount";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getOccurrenceCount";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getMembersFor";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllContainingFileIds";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeCastOperands";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 11, 13, 15, 16, 17, 18 -> new IllegalStateException(string);
            };
        }

        private static enum DefCount {
            NONE,
            ONE,
            MANY;

        }
    }
}

