/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs.view;

import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompilerReferenceFindUsagesTestInfo {
    @Nullable
    private final Set<VirtualFile> myFiles;
    @NotNull
    private final DirtyScopeTestInfo myDirtyScopeInfo;

    public CompilerReferenceFindUsagesTestInfo(@Nullable Set<VirtualFile> occurrences, @NotNull DirtyScopeTestInfo dirtyScopeTestInfo) {
        if (dirtyScopeTestInfo == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(0);
        }
        this.myFiles = occurrences;
        this.myDirtyScopeInfo = dirtyScopeTestInfo;
    }

    @NotNull
    private List<VirtualFile> getFilesWithKnownOccurrences() {
        if (this.myFiles == null) {
            throw new IllegalStateException();
        }
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (VirtualFile f : this.myFiles) {
            if (f == null || this.myDirtyScopeInfo.getDirtyScope().contains(f)) continue;
            list.add(f);
        }
        ArrayList<VirtualFile> arrayList = list;
        if (arrayList == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private Module @NotNull [] getDirtyModules() {
        Module[] moduleArray = this.myDirtyScopeInfo.getDirtyModules();
        if (moduleArray == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(2);
        }
        return moduleArray;
    }

    private Module @NotNull [] getDirtyUnsavedModules() {
        Module[] moduleArray = this.myDirtyScopeInfo.getDirtyUnsavedModules();
        if (moduleArray == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(3);
        }
        return moduleArray;
    }

    private VirtualFile @NotNull [] getExcludedFiles() {
        VirtualFile[] virtualFileArray = this.myDirtyScopeInfo.getExcludedFiles();
        if (virtualFileArray == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    private boolean isEnabled() {
        return this.myFiles != null;
    }

    DefaultMutableTreeNode asTree() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        if (this.isEnabled()) {
            DefaultMutableTreeNode knownOccurrences = new DefaultMutableTreeNode("Known occurrence files");
            node.add(knownOccurrences);
            for (VirtualFile virtualFile : this.getFilesWithKnownOccurrences()) {
                knownOccurrences.add(new DefaultMutableTreeNode(virtualFile));
            }
            DefaultMutableTreeNode dirtyModules = new DefaultMutableTreeNode("Dirty modules");
            node.add(dirtyModules);
            for (Module module : this.getDirtyModules()) {
                dirtyModules.add(new DefaultMutableTreeNode(module));
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Unsaved dirty modules");
            node.add(defaultMutableTreeNode);
            for (Module module : this.getDirtyUnsavedModules()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(module));
            }
            DefaultMutableTreeNode excludedFiles = new DefaultMutableTreeNode("Current excluded files");
            node.add(excludedFiles);
            for (VirtualFile excludedFile : this.getExcludedFiles()) {
                excludedFiles.add(new DefaultMutableTreeNode(excludedFile));
            }
        } else {
            node.add(new DefaultMutableTreeNode("Service is not available"));
        }
        return node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScopeTestInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/view/CompilerReferenceFindUsagesTestInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/view/CompilerReferenceFindUsagesTestInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithKnownOccurrences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyUnsavedModules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

