/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.cache.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.compiler.cache.client.CompilerCacheServerAuthService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompilerCachesServerClient {
    private static final Logger LOG = Logger.getInstance(CompilerCachesServerClient.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @NotNull
    public static Map<String, Set<String>> getCacheKeysPerRemote(@NotNull Project project, @NotNull String serverUrl) {
        Map<String, List<String>> response;
        if (project == null) {
            CompilerCachesServerClient.$$$reportNull$$$0(0);
        }
        if (serverUrl == null) {
            CompilerCachesServerClient.$$$reportNull$$$0(1);
        }
        if ((response = CompilerCachesServerClient.doGetRequest(project, serverUrl)) == null) {
            Map<String, Set<String>> map = Collections.emptyMap();
            if (map == null) {
                CompilerCachesServerClient.$$$reportNull$$$0(2);
            }
            return map;
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        response.forEach((key, value) -> {
            String[] splittedRemoteUrl = key.split("/");
            result.put(splittedRemoteUrl[splittedRemoteUrl.length - 1], new HashSet(value));
        });
        HashMap<String, Set<String>> hashMap = result;
        if (hashMap == null) {
            CompilerCachesServerClient.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @Nullable
    private static Map<String, List<String>> doGetRequest(@NotNull Project project, @NotNull String serverUrl) {
        Map<String, String> headers;
        if (project == null) {
            CompilerCachesServerClient.$$$reportNull$$$0(4);
        }
        if (serverUrl == null) {
            CompilerCachesServerClient.$$$reportNull$$$0(5);
        }
        if ((headers = CompilerCacheServerAuthService.getInstance(project).getRequestHeaders()).isEmpty()) {
            return null;
        }
        try {
            return (Map)HttpRequests.request((String)(serverUrl + "/commit_history.json")).tuner(tuner -> headers.forEach((k, v) -> tuner.addRequestProperty((String)k, (String)v))).connect(it -> {
                URLConnection patt0$temp = it.getConnection();
                if (patt0$temp instanceof HttpURLConnection) {
                    HttpURLConnection httpConnection = (HttpURLConnection)patt0$temp;
                    if (httpConnection.getResponseCode() == 200) {
                        return (Map)OBJECT_MAPPER.readValue(CompilerCachesServerClient.getInputStream(httpConnection), (TypeReference)new TypeReference<Map<String, List<String>>>(){});
                    }
                    String statusLine = httpConnection.getResponseCode() + 32 + httpConnection.getRequestMethod();
                    String errorText = StreamUtil.readText((Reader)new InputStreamReader(httpConnection.getErrorStream(), StandardCharsets.UTF_8));
                    LOG.info("Request: " + httpConnection.getRequestMethod() + String.valueOf(httpConnection.getURL()) + " : Error " + statusLine + " body: " + errorText);
                }
                return null;
            });
        }
        catch (IOException e) {
            LOG.warn("Failed request to cache server", (Throwable)e);
            return null;
        }
    }

    private static InputStream getInputStream(HttpURLConnection httpConnection) throws IOException {
        String contentEncoding = httpConnection.getContentEncoding();
        InputStream inputStream = httpConnection.getInputStream();
        if (contentEncoding != null && StringUtil.toLowerCase((String)contentEncoding).contains("gzip")) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverUrl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/cache/client/CompilerCachesServerClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/cache/client/CompilerCachesServerClient";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheKeysPerRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCacheKeysPerRemote";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doGetRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

