/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch.completion.lookup;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PreferByKindWeigher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ChainCompletionNewVariableLookupElement
extends LookupElement {
    @NotNull
    private final PsiClass myQualifierClass;
    @NotNull
    private final String myNewVarName;
    private final boolean myField;

    public ChainCompletionNewVariableLookupElement(@NotNull PsiClass qualifierClass, @NotNull ChainCompletionContext context) {
        if (qualifierClass == null) {
            ChainCompletionNewVariableLookupElement.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ChainCompletionNewVariableLookupElement.$$$reportNull$$$0(1);
        }
        Project project = qualifierClass.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        this.myField = PsiTreeUtil.getParentOfType((PsiElement)context.getContextPsi(), PsiStatement.class, (boolean)false) == null;
        VariableKind variableKind = this.myField ? VariableKind.FIELD : VariableKind.LOCAL_VARIABLE;
        this.myNewVarName = Stream.of(codeStyleManager.suggestVariableName((VariableKind)variableKind, null, null, (PsiType)elementFactory.createType((PsiClass)qualifierClass)).names).max(Comparator.comparing(String::length)).orElseThrow(IllegalStateException::new);
        this.myQualifierClass = qualifierClass;
        this.putUserData(PreferByKindWeigher.INTRODUCED_VARIABLE, Boolean.TRUE);
    }

    @NotNull
    public AutoCompletionPolicy getAutoCompletionPolicy() {
        AutoCompletionPolicy autoCompletionPolicy = AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
        if (autoCompletionPolicy == null) {
            ChainCompletionNewVariableLookupElement.$$$reportNull$$$0(2);
        }
        return autoCompletionPolicy;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        PsiDeclarationStatement newVarDeclarationTemplate;
        PsiElement newVariablePlacementAnchor;
        if (context == null) {
            ChainCompletionNewVariableLookupElement.$$$reportNull$$$0(3);
        }
        PsiFile file = context.getFile();
        PsiElement caretElement = Objects.requireNonNull(file.findElementAt(context.getEditor().getCaretModel().getOffset()));
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        if (this.myField) {
            PsiField field = Objects.requireNonNull((PsiField)PsiTreeUtil.getParentOfType((PsiElement)caretElement.getPrevSibling(), PsiField.class, (boolean)false));
            newVariablePlacementAnchor = field;
            PsiField newField = elementFactory.createField(this.myNewVarName, (PsiType)elementFactory.createType(this.myQualifierClass));
            if (field.hasModifierProperty("static")) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)newField, (String)"static", (boolean)true);
            }
            newVarDeclarationTemplate = newField;
        } else {
            newVariablePlacementAnchor = (PsiElement)Objects.requireNonNull((PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)caretElement.getPrevSibling(), PsiStatement.class, (boolean)false));
            newVarDeclarationTemplate = elementFactory.createVariableDeclarationStatement(this.myNewVarName, (PsiType)elementFactory.createType(this.myQualifierClass), elementFactory.createExpressionFromText("null", null));
        }
        PsiElement varDeclaration = newVariablePlacementAnchor.getParent().addBefore((PsiElement)newVarDeclarationTemplate, newVariablePlacementAnchor);
        JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences(varDeclaration);
    }

    @NotNull
    public String getLookupString() {
        String string = this.myNewVarName;
        if (string == null) {
            ChainCompletionNewVariableLookupElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/chainsSearch/completion/lookup/ChainCompletionNewVariableLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/chainsSearch/completion/lookup/ChainCompletionNewVariableLookupElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoCompletionPolicy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

