/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.impl.BuildUsageCollector;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompileDriverNotifications;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerDriverHelperKt;
import com.intellij.compiler.impl.CompilerDriverUnknownSdkTracker;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.progress.CompilerMessagesService;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.java.JavaBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.DefaultModuleConfigurationEditorFactory;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompilerUtil;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.tracing.Tracer;
import com.intellij.util.Chunk;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.TaskFuture;
import org.jetbrains.jps.api.TaskFutureAdapter;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class CompileDriver {
    private static final Logger LOG = Logger.getInstance(CompileDriver.class);
    private static final Key<Boolean> COMPILATION_STARTED_AUTOMATICALLY = Key.create((String)"compilation_started_automatically");
    private static final Key<ExitStatus> COMPILE_SERVER_BUILD_STATUS = Key.create((String)"COMPILE_SERVER_BUILD_STATUS");
    private static final Key<Boolean> REBUILD_CLEAN = Key.create((String)"rebuild_clean_requested");
    private static final long ONE_MINUTE_MS = 60000L;
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static final Key<Boolean> SKIP_SAVE = Key.create((String)"SKIP_SAVE");
    @ApiStatus.Internal
    @ApiStatus.Experimental
    @TestOnly
    public static final Key<Long> TIMEOUT = Key.create((String)"TIMEOUT");
    private final Project myProject;
    private final Map<Module, String> myModuleOutputPaths = new HashMap<Module, String>();
    private final Map<Module, String> myModuleTestOutputPaths = new HashMap<Module, String>();

    public CompileDriver(Project project) {
        this.myProject = project;
    }

    public void setCompilerFilter(CompilerFilter compilerFilter) {
    }

    public void rebuild(CompileStatusNotification callback, boolean cleanSystemData) {
        ProjectCompileScope scope = new ProjectCompileScope(this.myProject);
        REBUILD_CLEAN.set((UserDataHolder)scope, (Object)cleanSystemData);
        this.startup(scope, true, false, false, callback, null);
    }

    public void make(CompileScope scope, CompileStatusNotification callback) {
        this.make(scope, false, callback);
    }

    public void make(CompileScope scope, boolean withModalProgress, CompileStatusNotification callback) {
        this.startup(scope, false, false, withModalProgress, callback, null);
    }

    public boolean isUpToDate(@NotNull CompileScope scope, @Nullable ProgressIndicator progress) {
        if (scope == null) {
            CompileDriver.$$$reportNull$$$0(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUpToDate operation started");
        }
        if (ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk() == null && !EelPathUtils.isProjectLocal((Project)this.myProject)) {
            return true;
        }
        CompilerTask task2 = new CompilerTask(this.myProject, JavaCompilerBundle.message((String)"classes.up.to.date.check", (Object[])new Object[0]), true, false, false, CompileDriver.isCompilationStartedAutomatically(scope));
        CompileContextImpl compileContext = new CompileContextImpl(this.myProject, task2, scope, true, false);
        Ref result = new Ref();
        Runnable compileWork = () -> {
            ProgressIndicator indicator = compileContext.getProgressIndicator();
            if (indicator.isCanceled() || this.myProject.isDisposed()) {
                return;
            }
            BuildManager buildManager = BuildManager.getInstance();
            try {
                buildManager.postponeBackgroundTasks();
                buildManager.cancelAutoMakeTasks(this.myProject);
                TaskFuture<?> future = this.compileInExternalProcess(compileContext, true);
                while (!future.waitFor(200L, TimeUnit.MILLISECONDS)) {
                    if (!indicator.isCanceled()) continue;
                    future.cancel(false);
                }
            }
            catch (ProcessCanceledException ignored) {
                compileContext.putUserDataIfAbsent(COMPILE_SERVER_BUILD_STATUS, ExitStatus.CANCELLED);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            finally {
                ExitStatus exitStatus = (ExitStatus)COMPILE_SERVER_BUILD_STATUS.get((UserDataHolder)compileContext);
                task2.setEndCompilationStamp(exitStatus, System.currentTimeMillis());
                result.set((Object)exitStatus);
                buildManager.allowBackgroundTasks(false);
                if (!this.myProject.isDisposed()) {
                    CompilerCacheManager.getInstance(this.myProject).flushCaches();
                }
            }
        };
        if (progress != null) {
            task2.run(compileWork, null, progress);
        } else {
            task2.start(compileWork, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUpToDate operation finished");
        }
        return ExitStatus.UP_TO_DATE.equals(result.get());
    }

    public void compile(CompileScope scope, CompileStatusNotification callback) {
        this.startup(scope, false, true, false, callback, null);
    }

    public static void setCompilationStartedAutomatically(CompileScope scope) {
        scope.putUserData(COMPILATION_STARTED_AUTOMATICALLY, (Object)true);
    }

    private static boolean isCompilationStartedAutomatically(CompileScope scope) {
        return Boolean.TRUE.equals(scope.getUserData(COMPILATION_STARTED_AUTOMATICALLY));
    }

    private List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildScopes(@NotNull CompileContextImpl compileContext, CompileScope scope, Collection<String> paths) {
        if (compileContext == null) {
            CompileDriver.$$$reportNull$$$0(1);
        }
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        boolean forceBuild = !compileContext.isMake();
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> explicitScopes = CompileScopeUtil.getBaseScopeForExternalBuild(scope);
        if (explicitScopes != null) {
            scopes.addAll(explicitScopes);
        } else if (!(compileContext.isRebuild() || paths.isEmpty() && CompileScopeUtil.allProjectModulesAffected(compileContext) && CompileDriver.allSourceTypesAffected(scope))) {
            CompileScopeUtil.addScopesForSourceSets(scope.getAffectedSourceSets(), scope.getAffectedUnloadedModules(), scopes, forceBuild);
        } else {
            Collection sourceSets = scope.getAffectedSourceSets();
            boolean includeTests = sourceSets.isEmpty();
            for (ModuleSourceSet sourceSet : sourceSets) {
                if (!sourceSet.getType().isTest()) continue;
                includeTests = true;
                break;
            }
            if (includeTests) {
                scopes.addAll(CmdlineProtoUtil.createAllModulesScopes((boolean)forceBuild));
            } else {
                scopes.add(CmdlineProtoUtil.createAllModulesProductionScope((boolean)forceBuild));
            }
        }
        if (paths.isEmpty()) {
            scopes = this.mergeScopesFromProviders(scope, scopes, forceBuild);
        }
        return scopes;
    }

    private static boolean allSourceTypesAffected(CompileScope scope) {
        HashMap<Module, Set> affectedSourceTypes = new HashMap<Module, Set>();
        for (ModuleSourceSet set : scope.getAffectedSourceSets()) {
            affectedSourceTypes.computeIfAbsent(set.getModule(), m -> EnumSet.noneOf(ModuleSourceSet.Type.class)).add(set.getType());
        }
        for (Set moduleSourceTypes : affectedSourceTypes.values()) {
            for (ModuleSourceSet.Type value : ModuleSourceSet.Type.values()) {
                if (moduleSourceTypes.contains(value)) continue;
                return false;
            }
        }
        return true;
    }

    private List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> mergeScopesFromProviders(CompileScope scope, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, boolean forceBuild) {
        for (BuildTargetScopeProvider provider : BuildTargetScopeProvider.EP_NAME.getExtensionList()) {
            List providerScopes = (List)ReadAction.compute(() -> this.myProject.isDisposed() ? Collections.emptyList() : provider.getBuildTargetScopes(scope, this.myProject, forceBuild));
            scopes = CompileScopeUtil.mergeScopes(scopes, (List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>)providerScopes);
        }
        return scopes;
    }

    @NotNull
    private TaskFuture<?> compileInExternalProcess(final @NotNull CompileContextImpl compileContext, final boolean onlyCheckUpToDate) {
        HashMap<String, String> builderParams;
        if (compileContext == null) {
            CompileDriver.$$$reportNull$$$0(2);
        }
        CompileScope scope = compileContext.getCompileScope();
        Collection paths = (Collection)ReadAction.compute(() -> CompileScopeUtil.fetchFiles(compileContext));
        List scopes = (List)ReadAction.compute(() -> this.getBuildScopes(compileContext, scope, paths));
        if (onlyCheckUpToDate) {
            builderParams = new HashMap<String, String>();
        } else {
            Map exported = scope.exportUserData();
            if (!exported.isEmpty()) {
                builderParams = new HashMap();
                for (Map.Entry entry : exported.entrySet()) {
                    String _key = ((Key)entry.getKey()).toString();
                    String _value = entry.getValue().toString();
                    builderParams.put(_key, _value);
                }
            } else {
                builderParams = new HashMap();
            }
        }
        if (!scope.getAffectedUnloadedModules().isEmpty()) {
            builderParams.put("load_unloaded_modules", Boolean.TRUE.toString());
        }
        final Map<String, List<Artifact>> outputToArtifact = ArtifactCompilerUtil.containsArtifacts(scopes) ? ArtifactCompilerUtil.createOutputToArtifactMap(this.myProject) : null;
        TaskFuture<?> taskFuture = BuildManager.getInstance().scheduleBuild(this.myProject, compileContext.isRebuild(), compileContext.isMake(), onlyCheckUpToDate, scopes, paths, builderParams, new DefaultMessageHandler(this.myProject){
            private final AtomicBoolean myFallbackSdkHintReported;
            {
                super(project);
                this.myFallbackSdkHintReported = new AtomicBoolean(false);
            }

            @Override
            public void buildStarted(@NotNull UUID sessionId) {
                ProblemsView view;
                if (sessionId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!onlyCheckUpToDate && compileContext.shouldUpdateProblemsView() && (view = ProblemsView.getInstanceIfCreated(CompileDriver.this.myProject)) != null) {
                    view.buildStarted(sessionId);
                }
            }

            @Override
            public void sessionTerminated(@NotNull UUID sessionId) {
                ProblemsView view;
                if (sessionId == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!onlyCheckUpToDate && compileContext.shouldUpdateProblemsView() && (view = ProblemsView.getInstanceIfCreated(CompileDriver.this.myProject)) != null) {
                    view.clearProgress();
                    view.clearOldMessages(compileContext.getCompileScope(), compileContext.getSessionId());
                }
            }

            @Override
            public void handleFailure(@NotNull UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
                String trace;
                if (sessionId == null) {
                    1.$$$reportNull$$$0(2);
                }
                compileContext.addMessage(CompilerMessageCategory.ERROR, failure.hasDescription() ? failure.getDescription() : "", null, -1, -1);
                String string = trace = failure.hasStacktrace() ? failure.getStacktrace() : null;
                if (trace != null) {
                    LOG.info(trace);
                }
                compileContext.putUserData(COMPILE_SERVER_BUILD_STATUS, ExitStatus.ERRORS);
            }

            @Override
            protected void handleCompileMessage(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message) {
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind = message.getKind();
                String messageText = message.getText();
                if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
                    ProgressIndicator indicator = compileContext.getProgressIndicator();
                    indicator.setText(messageText);
                    if (message.hasDone()) {
                        indicator.setFraction((double)message.getDone());
                    }
                } else {
                    String sourceFilePath;
                    CompilerMessageCategory category = CompileDriver.convertToCategory(kind, CompilerMessageCategory.INFORMATION);
                    String string = sourceFilePath = message.hasSourceFilePath() ? message.getSourceFilePath() : null;
                    if (sourceFilePath != null) {
                        sourceFilePath = FileUtil.toSystemIndependentName((String)sourceFilePath);
                    }
                    long line = message.hasLine() ? message.getLine() : -1L;
                    long column = message.hasColumn() ? message.getColumn() : -1L;
                    String srcUrl = sourceFilePath != null ? VirtualFileManager.constructUrl((String)"file", (String)sourceFilePath) : null;
                    compileContext.addMessage(category, messageText, srcUrl, (int)line, (int)column, null, message.getModuleNamesList());
                    if (compileContext.shouldUpdateProblemsView() && kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.JPS_INFO) {
                        Project project = compileContext.getProject();
                        ProblemsView.getInstance(project).addMessage(new CompilerMessageImpl(project, category, messageText), compileContext.getSessionId());
                    }
                }
            }

            @Override
            protected void handleBuildEvent(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event) {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type eventType = event.getEventType();
                switch (eventType) {
                    case FILES_GENERATED: {
                        List generated = event.getGeneratedFilesList();
                        CompilationStatusListener publisher = CompileDriver.this.myProject.isDisposed() ? null : (CompilationStatusListener)CompileDriver.this.myProject.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                        Set writtenArtifactOutputPaths = outputToArtifact != null ? CollectionFactory.createFilePathSet() : null;
                        for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : generated) {
                            Collection artifacts;
                            String root = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                            String relativePath = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                            if (publisher != null) {
                                publisher.fileGenerated(root, relativePath);
                            }
                            if (outputToArtifact == null || (artifacts = (Collection)outputToArtifact.get(root)) == null || artifacts.isEmpty()) continue;
                            writtenArtifactOutputPaths.add(FileUtil.toSystemDependentName((String)DeploymentUtil.appendToPath((String)root, (String)relativePath)));
                        }
                        if (writtenArtifactOutputPaths == null || writtenArtifactOutputPaths.isEmpty()) break;
                        ArtifactsCompiler.addWrittenPaths(compileContext, writtenArtifactOutputPaths);
                        break;
                    }
                    case BUILD_COMPLETED: {
                        ExitStatus exitStatus;
                        if (!event.hasCompletionStatus()) {
                            exitStatus = ExitStatus.SUCCESS;
                        } else {
                            switch (event.getCompletionStatus()) {
                                default: {
                                    throw new MatchException(null, null);
                                }
                                case CANCELED: {
                                    exitStatus = ExitStatus.CANCELLED;
                                    break;
                                }
                                case ERRORS: {
                                    exitStatus = ExitStatus.ERRORS;
                                    break;
                                }
                                case SUCCESS: {
                                    exitStatus = ExitStatus.SUCCESS;
                                    break;
                                }
                                case UP_TO_DATE: {
                                    exitStatus = ExitStatus.UP_TO_DATE;
                                }
                            }
                        }
                        ExitStatus status = exitStatus;
                        compileContext.putUserDataIfAbsent(COMPILE_SERVER_BUILD_STATUS, status);
                        break;
                    }
                    case CUSTOM_BUILDER_MESSAGE: {
                        CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage message;
                        if (!event.hasCustomBuilderMessage() || !"JPS".equals((message = event.getCustomBuilderMessage()).getBuilderId())) break;
                        if ("!unprocessed_fs_changes_detected!".equals(message.getMessageType())) {
                            String text = message.getMessageText();
                            if (StringUtil.isEmpty((String)text)) break;
                            compileContext.addMessage(CompilerMessageCategory.INFORMATION, text, null, -1, -1);
                            break;
                        }
                        if (!"!fallback_sdk_setup_required!".equals(message.getMessageType()) || this.myFallbackSdkHintReported.getAndSet(true)) break;
                        @NlsSafe String notificationContent = message.getMessageText();
                        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Unsupported JDK");
                        Notification notification = notificationGroup.createNotification(JavaBundle.message((String)"unsupported.jdk.notification.title", (Object[])new Object[0]), notificationContent, NotificationType.WARNING).setImportantSuggestion(true).setRemoveWhenExpired(true).addAction((AnAction)NotificationAction.createSimpleExpiring((String)ProjectBundle.message((String)"action.text.config.invalid.sdk.configure", (Object[])new Object[0]), () -> CompileDriver.this.openJdkConfigurationSettings(compileContext.getCompileScope())));
                        compileContext.getBuildSession().registerCloseAction(() -> ((Notification)notification).expire());
                        notification.notify(CompileDriver.this.myProject);
                    }
                }
            }

            @Override
            @NotNull
            public ProgressIndicator getProgressIndicator() {
                ProgressIndicator progressIndicator = compileContext.getProgressIndicator();
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(3);
                }
                return progressIndicator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sessionId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/compiler/impl/CompileDriver$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/compiler/impl/CompileDriver$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProgressIndicator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "buildStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "sessionTerminated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "handleFailure";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        });
        if (taskFuture == null) {
            CompileDriver.$$$reportNull$$$0(3);
        }
        return taskFuture;
    }

    private void openJdkConfigurationSettings(CompileScope compileScope) {
        for (Module module : compileScope.getAffectedModules()) {
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!(entry instanceof JdkOrderEntry)) continue;
                ProjectSettingsService.getInstance((Project)this.myProject).openLibraryOrSdkSettings(entry);
                return;
            }
        }
        ProjectSettingsService.getInstance((Project)this.myProject).openProjectSettings();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void startup(CompileScope compileScope, boolean bl, boolean bl2, boolean bl3, CompileStatusNotification compileStatusNotification, CompilerMessage compilerMessage) {
        void message;
        void callback;
        void withModalProgress;
        void forceCompile;
        void isRebuild;
        void scope;
        ThreadingAssertions.assertEventDispatchThread();
        ModalityState modalityState = scope.getUserData(SKIP_SAVE) == Boolean.TRUE ? null : ModalityState.current();
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        String name = JavaCompilerBundle.message((String)(isRebuild != false ? "compiler.content.name.rebuild" : (forceCompile != false ? "compiler.content.name.recompile" : "compiler.content.name.make")), (Object[])new Object[0]);
        Tracer.Span span = Tracer.start((String)(name + " preparation"));
        CompilerTask compileTask = new CompilerTask(this.myProject, name, isUnitTestMode, withModalProgress == false, true, CompileDriver.isCompilationStartedAutomatically((CompileScope)scope), (boolean)withModalProgress);
        StatusBar.Info.set((String)"", (Project)this.myProject, (String)"Compiler");
        if (modalityState != null) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            FileDocumentManager.getInstance().saveAllDocuments();
        }
        CompileContextImpl compileContext = new CompileContextImpl(this.myProject, compileTask, (CompileScope)scope, isRebuild == false && forceCompile == false, (boolean)isRebuild);
        span.complete();
        Runnable compileWork = () -> this.lambda$startup$6(compileContext, (CompileScope)scope, (CompileStatusNotification)callback, modalityState, isUnitTestMode, (CompilerMessage)message, (boolean)isRebuild);
        compileTask.start(compileWork, () -> this.lambda$startup$7((boolean)isRebuild, (CompileScope)scope, (CompileStatusNotification)callback, (boolean)forceCompile, (CompilerMessage)message));
    }

    @TestOnly
    @Nullable
    public static ExitStatus getExternalBuildExitStatus(CompileContext context) {
        return (ExitStatus)context.getUserData(COMPILE_SERVER_BUILD_STATUS);
    }

    private long notifyCompilationCompleted(CompileContextImpl compileContext, CompileStatusNotification callback, ExitStatus _status) {
        Collection affectedRoots;
        long endCompilationStamp = System.currentTimeMillis();
        compileContext.getBuildSession().setEndCompilationStamp(_status, endCompilationStamp);
        long duration = endCompilationStamp - compileContext.getStartCompilationStamp();
        if (!this.myProject.isDisposed() && _status != ExitStatus.UP_TO_DATE && _status != ExitStatus.CANCELLED && !(affectedRoots = (Collection)ReadAction.compute(() -> {
            Module[] affectedModules = compileContext.getCompileScope().getAffectedModules();
            return ContainerUtil.newHashSet((Object[])CompilerPaths.getOutputPaths((Module[])affectedModules));
        })).isEmpty()) {
            ProgressIndicator indicator = compileContext.getProgressIndicator();
            indicator.setText(JavaCompilerBundle.message((String)"synchronizing.output.directories", (Object[])new Object[0]));
            CompilerUtil.refreshOutputRoots(affectedRoots);
            indicator.setText("");
        }
        SwingUtilities.invokeLater(() -> {
            int errorCount = 0;
            int warningCount = 0;
            try {
                errorCount = compileContext.getMessageCount(CompilerMessageCategory.ERROR);
                warningCount = compileContext.getMessageCount(CompilerMessageCategory.WARNING);
                if (callback != null) {
                    callback.finished(_status == ExitStatus.CANCELLED, errorCount, warningCount, (CompileContext)compileContext);
                }
            }
            catch (Throwable throwable) {
                if (callback != null) {
                    callback.finished(_status == ExitStatus.CANCELLED, errorCount, warningCount, (CompileContext)compileContext);
                }
                throw throwable;
            }
            if (!this.myProject.isDisposed()) {
                MessageType messageType;
                String statusMessage = CompileDriver.createStatusMessage(_status, warningCount, errorCount, duration);
                MessageType messageType2 = errorCount > 0 ? MessageType.ERROR : (messageType = warningCount > 0 ? MessageType.WARNING : MessageType.INFO);
                if (duration > 60000L && CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).DISPLAY_NOTIFICATION_POPUP) {
                    String toolWindowId = CompileDriver.useBuildToolWindow() ? "Build" : "Messages";
                    ToolWindowManager.getInstance((Project)this.myProject).notifyByBalloon(toolWindowId, messageType, statusMessage);
                }
                String wrappedMessage = _status == ExitStatus.UP_TO_DATE ? statusMessage : HtmlChunk.link((String)"#", (String)statusMessage).toString();
                Notification notification = CompilerManager.getNotificationGroup().createNotification(wrappedMessage, messageType.toNotificationType()).setListener((NotificationListener)new BuildToolWindowActivationListener(compileContext)).setImportant(false);
                compileContext.getBuildSession().registerCloseAction(() -> ((Notification)notification).expire());
                notification.notify(this.myProject);
                if (_status != ExitStatus.UP_TO_DATE && compileContext.getMessageCount(null) > 0) {
                    String msg = DateFormatUtil.formatDateTime((Date)new Date()) + " - " + statusMessage;
                    compileContext.addMessage(CompilerMessageCategory.INFORMATION, msg, null, -1, -1);
                }
            }
        });
        return duration;
    }

    @Nls
    private static String createStatusMessage(ExitStatus status, int warningCount, int errorCount, long duration) {
        String message;
        if (status == ExitStatus.CANCELLED) {
            message = JavaCompilerBundle.message((String)"status.compilation.aborted", (Object[])new Object[0]);
        } else if (status == ExitStatus.UP_TO_DATE) {
            message = JavaCompilerBundle.message((String)"status.all.up.to.date", (Object[])new Object[0]);
        } else {
            String durationString = NlsMessages.formatDurationApproximate((long)duration);
            message = status == ExitStatus.SUCCESS ? (warningCount > 0 ? JavaCompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings", (Object[])new Object[]{warningCount, durationString}) : JavaCompilerBundle.message((String)"status.compilation.completed.successfully", (Object[])new Object[]{durationString})) : JavaCompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings.and.errors", (Object[])new Object[]{errorCount, warningCount, durationString});
        }
        return message;
    }

    private String getModuleOutputPath(Module module, boolean inTestSourceContent) {
        Map<Module, String> map = inTestSourceContent ? this.myModuleTestOutputPaths : this.myModuleOutputPaths;
        return map.computeIfAbsent(module, k -> CompilerPaths.getModuleOutputPath((Module)module, (boolean)inTestSourceContent));
    }

    public void executeCompileTask(CompileTask task2, CompileScope scope, @NlsContexts.TabTitle String contentName, Runnable onTaskFinished) {
        CompilerTask progressManagerTask = new CompilerTask(this.myProject, contentName, false, false, true, CompileDriver.isCompilationStartedAutomatically(scope));
        CompileContextImpl compileContext = new CompileContextImpl(this.myProject, progressManagerTask, scope, false, false);
        FileDocumentManager.getInstance().saveAllDocuments();
        progressManagerTask.start(() -> {
            try {
                task2.execute((CompileContext)compileContext);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            finally {
                if (onTaskFinished != null) {
                    onTaskFinished.run();
                }
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCompileTasks(@NotNull CompileContext context, boolean beforeTasks) {
        block11: {
            if (context == null) {
                CompileDriver.$$$reportNull$$$0(4);
            }
            if (this.myProject.isDisposed()) {
                return false;
            }
            CompilerManager manager = CompilerManager.getInstance((Project)this.myProject);
            ProgressIndicator progressIndicator = context.getProgressIndicator();
            progressIndicator.pushState();
            Project project = context.getProject();
            try {
                List tasks;
                List list = tasks = beforeTasks ? manager.getBeforeTasks() : manager.getAfterTaskList();
                if (tasks.isEmpty()) break block11;
                StructuredIdeActivity activity = BuildUsageCollector.logCompileTasksStarted(project, beforeTasks);
                progressIndicator.setText(JavaCompilerBundle.message((String)(beforeTasks ? "progress.executing.precompile.tasks" : "progress.executing.postcompile.tasks"), (Object[])new Object[0]));
                for (CompileTask task2 : tasks) {
                    try {
                        if (task2.execute(context)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        LOG.error("Error executing task", t);
                        context.addMessage(CompilerMessageCategory.INFORMATION, JavaCompilerBundle.message((String)"error.task.0.execution.failed", (Object[])new Object[]{task2.toString()}), null, -1, -1);
                    }
                }
                BuildUsageCollector.logCompileTasksCompleted(activity, beforeTasks);
            }
            finally {
                progressIndicator.popState();
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
                if (statusBar != null) {
                    statusBar.setInfo("");
                }
            }
        }
        return true;
    }

    private boolean validateCompilerConfiguration(@NotNull CompileScope scope, @NotNull ProgressIndicator progress) {
        if (scope == null) {
            CompileDriver.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            CompileDriver.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        try {
            Pair scopeModules = this.runWithReadAccess(progress, () -> {
                Object[] affectedModules = scope.getAffectedModules();
                CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
                return Pair.create(Arrays.asList(affectedModules), (Object)ContainerUtil.filter((Object[])affectedModules, module -> {
                    if (!compilerManager.isValidationEnabled(module)) {
                        return false;
                    }
                    boolean hasSources = CompileDriver.hasSources(module, JavaSourceRootType.SOURCE);
                    boolean hasTestSources = CompileDriver.hasSources(module, JavaSourceRootType.TEST_SOURCE);
                    return hasSources || hasTestSources;
                }));
            });
            List modulesWithSources = (List)scopeModules.second;
            if (!this.validateJdks(modulesWithSources, true)) {
                return false;
            }
            return this.runWithReadAccess(progress, () -> this.validateOutputs(modulesWithSources) && this.validateCyclicDependencies((List)scopeModules.first));
        }
        catch (ProcessCanceledException e) {
            return false;
        }
        catch (Throwable e) {
            LOG.error(e);
            return false;
        }
    }

    private <T> T runWithReadAccess(@NotNull ProgressIndicator progress, Callable<? extends T> task2) {
        if (progress == null) {
            CompileDriver.$$$reportNull$$$0(7);
        }
        return (T)ReadAction.nonBlocking(task2).expireWhen(() -> ((Project)this.myProject).isDisposed()).wrapProgress(progress).executeSynchronously();
    }

    private boolean validateJdks(@NotNull List<Module> scopeModules, boolean runUnknownSdkCheck) {
        if (scopeModules == null) {
            CompileDriver.$$$reportNull$$$0(8);
        }
        ArrayList<String> modulesWithoutJdkAssigned = new ArrayList<String>();
        boolean projectSdkNotSpecified = false;
        for (Module module : scopeModules) {
            Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (jdk != null) continue;
            projectSdkNotSpecified |= ModuleRootManager.getInstance((Module)module).isSdkInherited();
            modulesWithoutJdkAssigned.add(module.getName());
        }
        if (runUnknownSdkCheck) {
            CompilerDriverUnknownSdkTracker.Outcome result = CompilerDriverUnknownSdkTracker.getInstance(this.myProject).fixSdkSettings(projectSdkNotSpecified, scopeModules, CompileDriver.formatModulesList(modulesWithoutJdkAssigned));
            if (result == CompilerDriverUnknownSdkTracker.Outcome.STOP_COMPILE) {
                return false;
            }
            return this.validateJdks(scopeModules, false);
        }
        if (!modulesWithoutJdkAssigned.isEmpty()) {
            this.showNotSpecifiedError("error.jdk.not.specified", projectSdkNotSpecified, modulesWithoutJdkAssigned, JavaCompilerBundle.message((String)"modules.classpath.title", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateOutputs(@NotNull List<Module> scopeModules) {
        if (scopeModules == null) {
            CompileDriver.$$$reportNull$$$0(9);
        }
        ArrayList<String> modulesWithoutOutputPathSpecified = new ArrayList<String>();
        boolean projectOutputNotSpecified = false;
        for (Module module : scopeModules) {
            String outputPath = this.getModuleOutputPath(module, false);
            String testsOutputPath = this.getModuleOutputPath(module, true);
            if (outputPath == null && testsOutputPath == null) {
                CompilerModuleExtension compilerExtension = CompilerModuleExtension.getInstance((Module)module);
                projectOutputNotSpecified |= compilerExtension != null && compilerExtension.isCompilerOutputPathInherited();
                modulesWithoutOutputPathSpecified.add(module.getName());
                continue;
            }
            if (outputPath == null && CompileDriver.hasSources(module, JavaSourceRootType.SOURCE)) {
                modulesWithoutOutputPathSpecified.add(module.getName());
            }
            if (testsOutputPath != null || !CompileDriver.hasSources(module, JavaSourceRootType.TEST_SOURCE)) continue;
            modulesWithoutOutputPathSpecified.add(module.getName());
        }
        if (modulesWithoutOutputPathSpecified.isEmpty()) {
            return true;
        }
        this.showNotSpecifiedError("error.output.not.specified", projectOutputNotSpecified, modulesWithoutOutputPathSpecified, DefaultModuleConfigurationEditorFactory.getInstance().getOutputEditorDisplayName());
        return false;
    }

    private boolean validateCyclicDependencies(List<Module> scopeModules) {
        List chunks = ModuleCompilerUtil.getCyclicDependencies((Project)this.myProject, scopeModules);
        for (Chunk chunk : chunks) {
            Set sourceSets = chunk.getNodes();
            if (sourceSets.size() <= 1) continue;
            Sdk jdk = null;
            LanguageLevel languageLevel = null;
            for (ModuleSourceSet sourceSet : sourceSets) {
                Module module = sourceSet.getModule();
                Sdk moduleJdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (jdk == null) {
                    jdk = moduleJdk;
                } else if (!jdk.equals((Object)moduleJdk)) {
                    this.showCyclicModulesErrorNotification("error.chunk.modules.must.have.same.jdk", ModuleSourceSet.getModules((Collection)sourceSets));
                    return false;
                }
                LanguageLevel moduleLanguageLevel = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
                if (languageLevel == null) {
                    languageLevel = moduleLanguageLevel;
                    continue;
                }
                if (languageLevel.equals((Object)moduleLanguageLevel)) continue;
                this.showCyclicModulesErrorNotification("error.chunk.modules.must.have.same.language.level", ModuleSourceSet.getModules((Collection)sourceSets));
                return false;
            }
        }
        return true;
    }

    private void showCyclicModulesErrorNotification(@PropertyKey(resourceBundle="messages.JavaCompilerBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaCompilerBundle") @NotNull String messageId, @NotNull Set<? extends Module> modulesInChunk) {
        Module firstModule;
        if (messageId == null) {
            CompileDriver.$$$reportNull$$$0(10);
        }
        if (modulesInChunk == null) {
            CompileDriver.$$$reportNull$$$0(11);
        }
        LOG.assertTrue((firstModule = (Module)ContainerUtil.getFirstItem(modulesInChunk)) != null);
        CompileDriverNotifications.getInstance(this.myProject).createCannotStartNotification().withContent(JavaCompilerBundle.message((String)messageId, (Object[])new Object[]{CompileDriver.getModulesString(modulesInChunk)})).withOpenSettingsAction(firstModule.getName(), null).showNotification();
    }

    private static String getModulesString(Collection<? extends Module> modulesInChunk) {
        return StringUtil.join(modulesInChunk, module -> "\"" + module.getName() + "\"", (String)"\n");
    }

    private static boolean hasSources(Module module, JavaSourceRootType rootType) {
        return !ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType).isEmpty();
    }

    private void showNotSpecifiedError(@PropertyKey(resourceBundle="messages.JavaCompilerBundle") @NonNls @PropertyKey(resourceBundle="messages.JavaCompilerBundle") @NonNls String resourceId, boolean notSpecifiedValueInheritedFromProject, List<String> modules, String editorNameToSelect) {
        String nameToSelect = notSpecifiedValueInheritedFromProject ? null : (String)ContainerUtil.getFirstItem(modules);
        String message = JavaCompilerBundle.message((String)resourceId, (Object[])new Object[]{modules.size(), CompileDriver.formatModulesList(modules)});
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManagerEx.isInIntegrationTest()) {
            LOG.error(message);
        }
        CompileDriverNotifications.getInstance(this.myProject).createCannotStartNotification().withContent(message).withOpenSettingsAction(nameToSelect, editorNameToSelect).showNotification();
    }

    @NotNull
    private static String formatModulesList(@NotNull List<String> modules) {
        if (modules == null) {
            CompileDriver.$$$reportNull$$$0(12);
        }
        int maxModulesToShow = 10;
        ArrayList<String> actualNamesToInclude = new ArrayList<String>(ContainerUtil.getFirstItems(modules, (int)10));
        if (modules.size() > 10) {
            actualNamesToInclude.add(JavaCompilerBundle.message((String)"error.jdk.module.names.overflow.element.ellipsis", (Object[])new Object[0]));
        }
        String string = NlsMessages.formatNarrowAndList(actualNamesToInclude);
        if (string == null) {
            CompileDriver.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static CompilerMessageCategory convertToCategory(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind, CompilerMessageCategory defaultCategory) {
        return switch (kind) {
            case CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.ERROR, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.INTERNAL_BUILDER_ERROR -> CompilerMessageCategory.ERROR;
            case CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.WARNING -> CompilerMessageCategory.WARNING;
            case CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.INFO, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.JPS_INFO, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.OTHER -> CompilerMessageCategory.INFORMATION;
            default -> defaultCategory;
        };
    }

    private static boolean useBuildToolWindow() {
        return SystemProperties.getBooleanProperty((String)"ide.jps.use.build.tool.window", (boolean)true);
    }

    private /* synthetic */ void lambda$startup$7(boolean isRebuild, CompileScope scope, CompileStatusNotification callback, boolean forceCompile, CompilerMessage message) {
        int rv;
        if (isRebuild && (rv = Messages.showOkCancelDialog((Project)this.myProject, (String)JavaCompilerBundle.message((String)"you.are.about.to.rebuild.the.whole.project", (Object[])new Object[0]), (String)JavaCompilerBundle.message((String)"confirm.project.rebuild", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.build", (Object[])new Object[0]), (String)JavaCompilerBundle.message((String)"button.rebuild", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == 0) {
            this.startup(scope, false, false, false, callback, null);
            return;
        }
        this.startup(scope, isRebuild, forceCompile, false, callback, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$startup$6(CompileContextImpl compileContext, CompileScope scope, CompileStatusNotification callback, ModalityState modalityState, boolean isUnitTestMode, CompilerMessage message, boolean isRebuild) {
        ProgressIndicator indicator = compileContext.getProgressIndicator();
        if (indicator.isCanceled() || this.myProject.isDisposed() || !this.validateCompilerConfiguration(scope, indicator)) {
            if (callback != null) {
                callback.finished(true, 0, 0, (CompileContext)compileContext);
            }
            return;
        }
        if (modalityState != null) {
            CompilerDriverHelperKt.saveSettings(this.myProject, modalityState, isUnitTestMode);
        }
        Tracer.Span compileWorkSpan = Tracer.start((String)"compileWork");
        CompilerCacheManager compilerCacheManager = CompilerCacheManager.getInstance(this.myProject);
        BuildManager buildManager = BuildManager.getInstance();
        Ref buildSystemDataCleanupTask = new Ref(null);
        try {
            buildManager.postponeBackgroundTasks();
            buildManager.cancelAutoMakeTasks(this.myProject);
            LOG.info("COMPILATION STARTED (BUILD PROCESS)");
            if (message != null) {
                compileContext.addMessage(message);
            }
            if (isRebuild) {
                boolean cleanBuildRequested = Boolean.TRUE.equals(REBUILD_CLEAN.get((UserDataHolder)scope));
                boolean canCleanBuildSystemData = cleanBuildRequested && CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).CLEAR_OUTPUT_DIRECTORY;
                CompilerUtil.runInContext(compileContext, JavaCompilerBundle.message((String)"progress.text.clearing.build.system.data", (Object[])new Object[0]), () -> {
                    TaskFutureAdapter cancelPreload = canCleanBuildSystemData ? buildManager.cancelPreloadedBuilds(this.myProject) : new TaskFutureAdapter(CompletableFuture.completedFuture(Boolean.TRUE));
                    compilerCacheManager.clearCaches(compileContext);
                    if (canCleanBuildSystemData) {
                        cancelPreload.waitFor();
                        File[] systemFiles = buildManager.getProjectSystemDirectory(this.myProject).listFiles();
                        if (systemFiles != null && systemFiles.length > 0) {
                            buildSystemDataCleanupTask.set((Object)new TaskFutureAdapter(FileUtil.asyncDelete(Arrays.asList(systemFiles))));
                        }
                    } else if (cleanBuildRequested) {
                        compileContext.addMessage(CompilerMessageCategory.INFORMATION, JavaCompilerBundle.message((String)"error.clean.state.rebuild.not.possible", (Object[])new Object[0]), null, -1, -1);
                    }
                });
            }
            boolean beforeTasksOk = this.executeCompileTasks(compileContext, true);
            int errorCount = compileContext.getMessageCount(CompilerMessageCategory.ERROR);
            if (!beforeTasksOk || errorCount > 0) {
                COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)(errorCount > 0 ? ExitStatus.ERRORS : ExitStatus.CANCELLED));
                return;
            }
            TaskFuture<?> future = this.compileInExternalProcess(compileContext, false);
            Tracer.Span compileInExternalProcessSpan = Tracer.start((String)"compile in external process");
            long currentTimeMillis = System.currentTimeMillis();
            Long timeout = (Long)this.myProject.getUserData(TIMEOUT);
            while (!future.waitFor(200L, TimeUnit.MILLISECONDS)) {
                if (indicator.isCanceled()) {
                    future.cancel(false);
                }
                if (!isUnitTestMode || timeout == null || System.currentTimeMillis() <= currentTimeMillis + timeout) continue;
                LOG.error("CANCELLED BY TIMEOUT IN TESTS");
                future.cancel(true);
            }
            compileInExternalProcessSpan.complete();
            if (!this.executeCompileTasks(compileContext, false)) {
                COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)ExitStatus.CANCELLED);
            }
            if (compileContext.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)ExitStatus.ERRORS);
            }
        }
        catch (ProcessCanceledException ignored) {
            compileContext.putUserDataIfAbsent(COMPILE_SERVER_BUILD_STATUS, ExitStatus.CANCELLED);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        finally {
            TaskFutureAdapter cleanupTask;
            compileWorkSpan.complete();
            buildManager.allowBackgroundTasks(true);
            Tracer.Span flushCompilerCaches = Tracer.start((String)"flush compiler caches");
            compilerCacheManager.flushCaches();
            flushCompilerCaches.complete();
            ExitStatus status = (ExitStatus)COMPILE_SERVER_BUILD_STATUS.get((UserDataHolder)compileContext);
            long duration = this.notifyCompilationCompleted(compileContext, callback, status);
            CompilerUtil.logDuration("\tCOMPILATION FINISHED (BUILD PROCESS); Errors: " + compileContext.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContext.getMessageCount(CompilerMessageCategory.WARNING), duration);
            if (status == ExitStatus.SUCCESS) {
                BuildUsageCollector.logBuildCompleted(duration, isRebuild, false);
            }
            if ((cleanupTask = (TaskFutureAdapter)buildSystemDataCleanupTask.get()) != null) {
                cleanupTask.waitFor();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileContext";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/CompileDriver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeModules";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesInChunk";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/CompileDriver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compileInExternalProcess";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatModulesList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBuildScopes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compileInExternalProcess";
                break;
            }
            case 3: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeCompileTasks";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateCompilerConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runWithReadAccess";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateJdks";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateOutputs";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showCyclicModulesErrorNotification";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatModulesList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 13 -> new IllegalStateException(string);
        };
    }

    private static final class BuildToolWindowActivationListener
    extends NotificationListener.Adapter {
        private final WeakReference<Project> myProjectRef;
        private final Object myContentId;

        BuildToolWindowActivationListener(CompileContextImpl compileContext) {
            this.myProjectRef = new WeakReference<Project>(compileContext.getProject());
            this.myContentId = compileContext.getBuildSession().getContentId();
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            String toolWindowId;
            if (notification == null) {
                BuildToolWindowActivationListener.$$$reportNull$$$0(0);
            }
            if (e == null) {
                BuildToolWindowActivationListener.$$$reportNull$$$0(1);
            }
            Project project = (Project)this.myProjectRef.get();
            boolean useBuildToolwindow = CompileDriver.useBuildToolWindow();
            String string = toolWindowId = useBuildToolwindow ? "Build" : "Messages";
            if (project != null && !project.isDisposed() && (useBuildToolwindow || CompilerMessagesService.showCompilerContent(project, this.myContentId))) {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId);
                if (toolWindow != null) {
                    toolWindow.activate(null, false);
                }
            } else {
                notification.expire();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/impl/CompileDriver$BuildToolWindowActivationListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

