/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompilerUtil {
    private static final Logger LOG = Logger.getInstance(CompilerUtil.class);

    @Deprecated(forRemoval=true)
    public static void refreshIOFiles(@NotNull Collection<? extends File> files) {
        if (files == null) {
            CompilerUtil.$$$reportNull$$$0(0);
        }
        if (!files.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(files);
        }
    }

    public static void refreshOutputRoots(@NotNull Collection<String> outputRoots) {
        if (outputRoots == null) {
            CompilerUtil.$$$reportNull$$$0(1);
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        HashSet<VirtualFile> toRefresh = new HashSet<VirtualFile>();
        for (String outputRoot : outputRoots) {
            Path outputPath = null;
            BasicFileAttributes attributes = null;
            try {
                outputPath = Path.of(outputRoot, new String[0]);
                attributes = Files.readAttributes(outputPath, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (NoSuchFileException e) {
                LOG.debug((Throwable)e);
            }
            catch (IOException | InvalidPathException e) {
                LOG.info(e.getClass().getName() + ": " + e.getMessage());
                LOG.debug((Throwable)e);
            }
            VirtualFile vFile = fs.findFileByPath(outputRoot);
            if (attributes != null && vFile == null) {
                VirtualFile parent = fs.refreshAndFindFileByNioFile(outputPath.getParent());
                if (parent == null || !toRefresh.add(parent)) continue;
                parent.getChildren();
                continue;
            }
            if ((attributes != null || vFile == null) && (attributes == null || attributes.isDirectory() == vFile.isDirectory())) continue;
            toRefresh.add(vFile);
        }
        if (!toRefresh.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, false, null, toRefresh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void runInContext(@NotNull CompileContext context, @NlsContexts.ProgressText @Nullable String title, @NotNull ThrowableRunnable<T> action) throws T {
        if (context == null) {
            CompilerUtil.$$$reportNull$$$0(2);
        }
        if (action == null) {
            CompilerUtil.$$$reportNull$$$0(3);
        }
        ProgressIndicator indicator = context.getProgressIndicator();
        if (title != null) {
            indicator.pushState();
            indicator.setText(title);
        }
        try {
            action.run();
        }
        finally {
            if (title != null) {
                indicator.popState();
            }
        }
    }

    public static void logDuration(String activityName, long duration) {
        LOG.info(activityName + " took " + duration + " ms: " + duration / 60000L + " min " + duration % 60000L / 1000L + "sec");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/impl/CompilerUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshIOFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshOutputRoots";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runInContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

