/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.impl.FileIndexCompileScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleCompileScope
extends FileIndexCompileScope {
    private final Project myProject;
    private final Set<Module> myTestSourcesModules;
    private final Set<Module> myScopeModules;
    private final Module[] myModules;
    private final Collection<String> myIncludedUnloadedModules;
    private final Map<Module, String[]> myContentUrlsCache = new HashMap<Module, String[]>();

    public ModuleCompileScope(Module module, boolean includeDependentModules) {
        this(module.getProject(), Collections.singleton(module), Collections.emptyList(), includeDependentModules, false);
    }

    public ModuleCompileScope(Project project, Module[] modules, boolean includeDependentModules) {
        this(project, modules, includeDependentModules, false);
    }

    public ModuleCompileScope(Project project, Module[] modules, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        this(project, Arrays.asList(modules), Collections.emptyList(), includeDependentModules, includeRuntimeDependencies);
    }

    public ModuleCompileScope(Project project, Collection<? extends Module> modules, Collection<String> includedUnloadedModules, boolean includeDependentModules, boolean includeRuntimeDeps) {
        this(project, modules, includedUnloadedModules, includeDependentModules, includeRuntimeDeps, true);
    }

    public ModuleCompileScope(Project project, Collection<? extends Module> modules, Collection<String> includedUnloadedModules, boolean includeDependentModules, boolean includeRuntimeDeps, boolean includeTests) {
        this.myProject = project;
        this.myIncludedUnloadedModules = includedUnloadedModules;
        this.myTestSourcesModules = new HashSet<Module>();
        this.myScopeModules = new HashSet<Module>();
        for (Module module : modules) {
            if (module == null) continue;
            if (includeTests) {
                this.myTestSourcesModules.add(module);
            }
            if (includeDependentModules) {
                OrderEnumerator enumerator = ModuleRootManager.getInstance((Module)module).orderEntries().recursively();
                if (!includeRuntimeDeps) {
                    enumerator = enumerator.compileOnly();
                }
                boolean collectTestModules = includeTests && ModuleCompileScope.shouldIncludeTestsFromDependentModulesToTestClasspath(module);
                enumerator.forEachModule(m -> {
                    this.myScopeModules.add((Module)m);
                    if (collectTestModules) {
                        this.myTestSourcesModules.add((Module)m);
                    }
                    return true;
                });
                enumerator.forEach(orderEntry -> {
                    ModuleOrderEntry moduleEntry;
                    if (orderEntry instanceof ModuleOrderEntry && (moduleEntry = (ModuleOrderEntry)orderEntry).isProductionOnTestDependency() && this.myScopeModules.contains(moduleEntry.getModule())) {
                        this.myTestSourcesModules.add(moduleEntry.getModule());
                    }
                    return true;
                });
                continue;
            }
            this.myScopeModules.add(module);
        }
        this.myModules = ModuleManager.getInstance((Project)this.myProject).getModules();
    }

    public Module @NotNull [] getAffectedModules() {
        Module[] moduleArray = this.myScopeModules.toArray(Module.EMPTY_ARRAY);
        if (moduleArray == null) {
            ModuleCompileScope.$$$reportNull$$$0(0);
        }
        return moduleArray;
    }

    public Collection<ModuleSourceSet> getAffectedSourceSets() {
        return ContainerUtil.filter((Collection)super.getAffectedSourceSets(), set -> !set.getType().isTest() || this.myTestSourcesModules.contains(set.getModule()));
    }

    public static boolean shouldIncludeTestsFromDependentModulesToTestClasspath(@NotNull Module module) {
        if (module == null) {
            ModuleCompileScope.$$$reportNull$$$0(1);
        }
        for (OrderEnumerationHandler.Factory factory : OrderEnumerationHandler.EP_NAME.getExtensionList()) {
            if (!factory.isApplicable(module) || factory.createHandler(module).shouldIncludeTestsFromDependentModulesToTestClasspath()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Collection<String> getAffectedUnloadedModules() {
        Collection<String> collection = Collections.unmodifiableCollection(this.myIncludedUnloadedModules);
        if (collection == null) {
            ModuleCompileScope.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    protected FileIndex[] getFileIndices() {
        FileIndex[] indices = new FileIndex[this.myScopeModules.size()];
        int idx = 0;
        for (Module module : this.myScopeModules) {
            indices[idx++] = ModuleRootManager.getInstance((Module)module).getFileIndex();
        }
        return indices;
    }

    public boolean belongs(@NotNull String url) {
        if (url == null) {
            ModuleCompileScope.$$$reportNull$$$0(3);
        }
        if (this.myScopeModules.isEmpty() && this.myIncludedUnloadedModules.isEmpty()) {
            return false;
        }
        Module candidateModule = null;
        int maxUrlLength = 0;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (Module module : this.myModules) {
            String[] contentRootUrls;
            for (String contentRootUrl : contentRootUrls = this.getModuleContentUrls(module)) {
                if (contentRootUrl.length() < maxUrlLength || !ModuleCompileScope.isUrlUnderRoot(url, contentRootUrl)) continue;
                if (contentRootUrl.length() == maxUrlLength) {
                    if (candidateModule == null) {
                        candidateModule = module;
                        continue;
                    }
                    if (candidateModule.equals((Object)module)) continue;
                    candidateModule = (Module)ReadAction.compute(() -> {
                        VirtualFile contentRootFile = VirtualFileManager.getInstance().findFileByUrl(contentRootUrl);
                        if (contentRootFile != null) {
                            return projectFileIndex.getModuleForFile(contentRootFile);
                        }
                        return null;
                    });
                    continue;
                }
                maxUrlLength = contentRootUrl.length();
                candidateModule = module;
            }
        }
        if (candidateModule != null && this.myScopeModules.contains(candidateModule)) {
            Module sourceRootUrls;
            String[] excludeRootUrls;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(candidateModule);
            for (String excludeRootUrl : excludeRootUrls = moduleRootManager.getExcludeRootUrls()) {
                if (!ModuleCompileScope.isUrlUnderRoot(url, excludeRootUrl)) continue;
                return false;
            }
            for (String sourceRootUrl : sourceRootUrls = moduleRootManager.getSourceRootUrls()) {
                if (!ModuleCompileScope.isUrlUnderRoot(url, sourceRootUrl)) continue;
                return true;
            }
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (String unloadedModule : this.myIncludedUnloadedModules) {
            UnloadedModuleDescription moduleDescription = moduleManager.getUnloadedModuleDescription(unloadedModule);
            if (moduleDescription == null) continue;
            for (VirtualFilePointer pointer : moduleDescription.getContentRoots()) {
                if (!ModuleCompileScope.isUrlUnderRoot(url, pointer.getUrl())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUrlUnderRoot(String url, String root) {
        return url.length() > root.length() && url.charAt(root.length()) == '/' && FileUtil.startsWith((String)url, (String)root);
    }

    private String[] getModuleContentUrls(Module module) {
        String[] contentRootUrls = this.myContentUrlsCache.get(module);
        if (contentRootUrls == null) {
            contentRootUrls = ModuleRootManager.getInstance((Module)module).getContentRootUrls();
            this.myContentUrlsCache.put(module, contentRootUrls);
        }
        return contentRootUrls;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/ModuleCompileScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/ModuleCompileScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldIncludeTestsFromDependentModulesToTestClasspath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "belongs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

