/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.impl.CompilerContentIterator;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class OneProjectItemCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private static final Logger LOG = Logger.getInstance(OneProjectItemCompileScope.class);
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myUrl;

    public OneProjectItemCompileScope(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            OneProjectItemCompileScope.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myFile = file;
        String url = file.getUrl();
        this.myUrl = file.isDirectory() ? url + "/" : url;
    }

    public VirtualFile @NotNull [] getFiles(FileType fileType, boolean inSourceOnly) {
        ArrayList files = new ArrayList(1);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        CompilerContentIterator iterator = new CompilerContentIterator(fileType, (FileIndex)projectFileIndex, inSourceOnly, files);
        if (this.myFile.isDirectory()) {
            projectFileIndex.iterateContentUnderDirectory(this.myFile, (ContentIterator)iterator);
        } else {
            iterator.processFile(this.myFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files);
        if (virtualFileArray == null) {
            OneProjectItemCompileScope.$$$reportNull$$$0(1);
        }
        return virtualFileArray;
    }

    public boolean belongs(@NotNull String url) {
        if (url == null) {
            OneProjectItemCompileScope.$$$reportNull$$$0(2);
        }
        if (this.myFile.isDirectory()) {
            return FileUtil.startsWith((String)url, (String)this.myUrl);
        }
        return FileUtil.pathsEqual((String)url, (String)this.myUrl);
    }

    public Module @NotNull [] getAffectedModules() {
        Collection<ModuleSourceSet> sets = this.getAffectedSourceSets();
        if (sets.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Module is null for file " + this.myFile.getPresentableUrl());
            }
            if (Module.EMPTY_ARRAY == null) {
                OneProjectItemCompileScope.$$$reportNull$$$0(3);
            }
            return Module.EMPTY_ARRAY;
        }
        Module[] moduleArray = new Module[]{sets.iterator().next().getModule()};
        if (moduleArray == null) {
            OneProjectItemCompileScope.$$$reportNull$$$0(4);
        }
        return moduleArray;
    }

    public Collection<ModuleSourceSet> getAffectedSourceSets() {
        if (this.myProject.isDefault()) {
            return Collections.emptyList();
        }
        @NotNull ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        Module module = fileIndex.getModuleForFile(this.myFile);
        if (module == null || !fileIndex.isInSourceContent(this.myFile)) {
            return Collections.emptyList();
        }
        JpsModuleSourceRootType rootType = fileIndex.getContainingSourceRootType(this.myFile);
        if (rootType == null) {
            return Collections.emptyList();
        }
        boolean isResource = rootType instanceof JavaResourceRootType;
        ModuleSourceSet.Type type = rootType.isForTests() ? (isResource ? ModuleSourceSet.Type.RESOURCES_TEST : ModuleSourceSet.Type.TEST) : (isResource ? ModuleSourceSet.Type.RESOURCES : ModuleSourceSet.Type.PRODUCTION);
        return Collections.singleton(new ModuleSourceSet(module, type));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/OneProjectItemCompileScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/OneProjectItemCompileScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "belongs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

