/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.InternedPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.ex.temp.TempFileSystemMarker;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TranslatingCompilerFilesMonitor
implements AsyncFileListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.TranslatingCompilerFilesMonitor");

    public static TranslatingCompilerFilesMonitor getInstance() {
        return (TranslatingCompilerFilesMonitor)ApplicationManager.getApplication().getComponent(TranslatingCompilerFilesMonitor.class);
    }

    private static void processRecursively(final @NotNull VirtualFile fromFile, final boolean dbOnly, final @NotNull Consumer<? super VirtualFile> processor) {
        if (fromFile == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(1);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)fromFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (TranslatingCompilerFilesMonitor.isIgnoredByBuild(file)) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                if (!file.isDirectory()) {
                    processor.accept(file);
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                return result;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (dbOnly) {
                    return file.isDirectory() ? ((NewVirtualFile)file).iterInDbChildren() : null;
                }
                if (file.equals(fromFile) || !file.isDirectory()) {
                    return null;
                }
                return TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file) ? null : ((NewVirtualFile)file).iterInDbChildren();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getChildrenIterable";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static boolean isToProcess(VFileEvent event) {
        VirtualFileSystem fileSystem = event.getFileSystem();
        return fileSystem instanceof LocalFileSystem && !(fileSystem instanceof TempFileSystemMarker);
    }

    private static boolean isInContentOfOpenedProject(@NotNull VirtualFile file) {
        if (file == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(2);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!project.isInitialized() || !BuildManager.getInstance().isProjectWatched(project) || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) continue;
            return true;
        }
        return false;
    }

    public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(3);
        }
        if (events.isEmpty()) {
            return null;
        }
        final ChangeSession session = new ChangeSession();
        try {
            for (VFileEvent vFileEvent : events) {
                block12: {
                    block11: {
                        if (!TranslatingCompilerFilesMonitor.isToProcess(vFileEvent)) continue;
                        if (TranslatingCompilerFilesMonitor.isAfterProcessEvent(vFileEvent)) {
                            session.processLater(vFileEvent);
                        }
                        if (vFileEvent instanceof VFileDeleteEvent) break block11;
                        if (!(vFileEvent instanceof VFileMoveEvent)) break block12;
                    }
                    TranslatingCompilerFilesMonitor.collectPaths(vFileEvent.getFile(), session::addDeleted, true);
                    continue;
                }
                if (vFileEvent instanceof VFileContentChangeEvent) {
                    TranslatingCompilerFilesMonitor.collectPaths(vFileEvent.getFile(), session::addChanged, true);
                    continue;
                }
                TranslatingCompilerFilesMonitor.handleFileRename(vFileEvent, e -> TranslatingCompilerFilesMonitor.collectDeletedPathsOnFileRename(e, session));
            }
        }
        catch (ProcessCanceledException e2) {
            session.finish();
            BuildManager.getInstance().notifyChanges(() -> BuildManager.Changes.createIncomplete());
            throw e2;
        }
        if (!session.hasChanges()) {
            session.finish();
            return null;
        }
        return new AsyncFileListener.ChangeApplier(){

            public void afterVfsChange() {
                TranslatingCompilerFilesMonitor.after(session);
            }
        };
    }

    private static boolean isAfterProcessEvent(VFileEvent e) {
        return e instanceof VFileMoveEvent || e instanceof VFileCreateEvent || e instanceof VFileCopyEvent || TranslatingCompilerFilesMonitor.isRenameEvent(e);
    }

    private static boolean isRenameEvent(@NotNull VFileEvent e) {
        VFilePropertyChangeEvent propChangeEvent;
        if (e == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(4);
        }
        if (e instanceof VFilePropertyChangeEvent && "name".equals((propChangeEvent = (VFilePropertyChangeEvent)e).getPropertyName())) {
            String newName;
            String oldName = (String)propChangeEvent.getOldValue();
            return !Objects.equals(oldName, newName = (String)propChangeEvent.getNewValue());
        }
        return false;
    }

    private static void after(final ChangeSession session) {
        final var changedFilesCollector = new Consumer<VirtualFile>(){
            private final Set<VirtualFile> dirsToTraverse = new SmartHashSet();

            @Override
            public void accept(VirtualFile file) {
                if (file != null) {
                    if (file.isDirectory()) {
                        this.dirsToTraverse.add(file);
                    } else {
                        TranslatingCompilerFilesMonitor.collectPaths(file, session::addChanged, false);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean traverseDirs() throws ProcessCanceledException {
                SmartHashSet processed = new SmartHashSet();
                try {
                    for (VirtualFile root : this.dirsToTraverse) {
                        if (!root.isValid()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("File invalidated while processing VFS events, clearing build state: " + root.getPath());
                            }
                            boolean bl = false;
                            return bl;
                        }
                        TranslatingCompilerFilesMonitor.collectPaths(root, session::addChanged, true);
                        processed.add(root);
                    }
                }
                finally {
                    this.dirsToTraverse.removeAll((Collection<?>)processed);
                }
                return true;
            }
        };
        try {
            for (VFileEvent event : session.processLaterEvents) {
                if (event instanceof VFileMoveEvent || event instanceof VFileCreateEvent) {
                    changedFilesCollector.accept(event.getFile());
                    continue;
                }
                if (event instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)event;
                    changedFilesCollector.accept(copyEvent.findCreatedFile());
                    continue;
                }
                TranslatingCompilerFilesMonitor.handleFileRename(event, e -> changedFilesCollector.accept(e.getFile()));
            }
            BuildManager.getInstance().notifyChanges((Supplier<? extends BuildManager.Changes>)new Supplier<BuildManager.Changes>(){
                BuildManager.Changes data = null;

                @Override
                public BuildManager.Changes get() {
                    return this.data != null ? this.data : (this.data = this.calculate());
                }

                private BuildManager.Changes calculate() {
                    try {
                        block9: {
                            block8: {
                                if (changedFilesCollector.dirsToTraverse.isEmpty()) break block8;
                                if (!((Boolean)ReadAction.nonBlocking(changedFilesCollector::traverseDirs).executeSynchronously()).booleanValue()) break block9;
                            }
                            BuildManager.Changes changes = session.getResult();
                            return changes;
                        }
                        BuildManager.Changes changes = BuildManager.Changes.createIncomplete();
                        return changes;
                    }
                    catch (ProcessCanceledException e) {
                        BuildManager.Changes changes = BuildManager.Changes.createIncomplete();
                        return changes;
                    }
                    finally {
                        session.finish();
                    }
                }
            });
        }
        catch (ProcessCanceledException e2) {
            session.finish();
            BuildManager.getInstance().notifyChanges(() -> BuildManager.Changes.createIncomplete());
            throw e2;
        }
    }

    private static void handleFileRename(@NotNull VFileEvent e, Consumer<VFilePropertyChangeEvent> action) {
        VFilePropertyChangeEvent propChangeEvent;
        if (e == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(5);
        }
        if (TranslatingCompilerFilesMonitor.isRenameEvent(e) && TranslatingCompilerFilesMonitor.isInContentOfOpenedProject((propChangeEvent = (VFilePropertyChangeEvent)e).getFile())) {
            action.accept(propChangeEvent);
        }
    }

    private static void collectDeletedPathsOnFileRename(@NotNull VFilePropertyChangeEvent event, final ChangeSession session) {
        VirtualFile eventFile;
        VirtualFile parent;
        if (event == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(6);
        }
        if ((parent = (eventFile = event.getFile()).getParent()) != null) {
            String oldName = (String)event.getOldValue();
            final String root = parent.getPath() + "/" + oldName;
            if (eventFile.isDirectory()) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)eventFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
                    private final StringBuilder filePath;
                    {
                        super(arg0);
                        this.filePath = new StringBuilder(root);
                    }

                    public boolean visitFile(@NotNull VirtualFile child) {
                        if (child == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        ProgressManager.checkCanceled();
                        if (child.isDirectory()) {
                            if (!child.equals(eventFile)) {
                                this.filePath.append("/").append(child.getName());
                            }
                        } else {
                            Object childPath = this.filePath.toString();
                            if (!child.equals(eventFile)) {
                                childPath = (String)childPath + "/" + child.getName();
                            }
                            session.addDeletedPath((String)childPath);
                        }
                        return true;
                    }

                    public void afterChildrenVisited(@NotNull VirtualFile file) {
                        if (file == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        if (file.isDirectory() && !file.equals(eventFile)) {
                            this.filePath.delete(this.filePath.length() - file.getName().length() - 1, this.filePath.length());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "child";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$5";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitFile";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "afterChildrenVisited";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                session.addDeletedPath(root);
            }
        }
    }

    private static void collectPaths(@Nullable VirtualFile file, @NotNull Consumer<? super VirtualFile> consumer, boolean recursive) throws ProcessCanceledException {
        if (consumer == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(7);
        }
        if (file != null && !TranslatingCompilerFilesMonitor.isIgnoredOrUnderIgnoredDirectory(file)) {
            if (recursive) {
                TranslatingCompilerFilesMonitor.processRecursively(file, !TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file), consumer);
            } else {
                consumer.accept((VirtualFile)file);
            }
        }
    }

    private static boolean isIgnoredOrUnderIgnoredDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(8);
        }
        if (TranslatingCompilerFilesMonitor.isIgnoredByBuild(file)) {
            return true;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (VirtualFile current = file.getParent(); current != null; current = current.getParent()) {
            if (!fileTypeManager.isFileIgnored(current)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIgnoredByBuild(@NotNull VirtualFile file) {
        if (file == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(9);
        }
        return FileTypeManager.getInstance().isFileIgnored(file) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file) || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)file.getPath(), (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processRecursively";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContentOfOpenedProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareChange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenameEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleFileRename";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDeletedPathsOnFileRename";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "collectPaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredOrUnderIgnoredDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredByBuild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ChangeSession {
        private final Set<InternedPath> filesChanged = CollectionFactory.createSmallMemoryFootprintSet();
        private final Set<InternedPath> filesDeleted = CollectionFactory.createSmallMemoryFootprintSet();
        final List<VFileEvent> processLaterEvents = new SmartList();
        private final LowMemoryWatcher myMemWatcher = LowMemoryWatcher.register(this::clearState, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC);
        private boolean myLowMemorySignalled = false;

        ChangeSession() {
        }

        synchronized BuildManager.Changes getResult() {
            return this.myLowMemorySignalled ? BuildManager.Changes.createIncomplete() : new BuildManager.Changes.Paths(List.copyOf(this.filesDeleted), List.copyOf(this.filesChanged));
        }

        synchronized boolean hasChanges() {
            return this.myLowMemorySignalled || !this.processLaterEvents.isEmpty() || !this.filesDeleted.isEmpty() || !this.filesChanged.isEmpty();
        }

        void addDeleted(VirtualFile vFile) {
            this.addDeletedPath(vFile.getPath());
        }

        synchronized void addDeletedPath(String path) {
            this.checkMemory();
            this.filesDeleted.add(InternedPath.create(path));
        }

        void addChanged(VirtualFile vFile) {
            this.addChangedPath(vFile.getPath());
        }

        synchronized void addChangedPath(String path) {
            this.checkMemory();
            this.filesChanged.add(InternedPath.create(path));
        }

        void processLater(VFileEvent event) {
            this.processLaterEvents.add(event);
        }

        void finish() {
            this.myMemWatcher.stop();
        }

        private void checkMemory() {
            if (this.myLowMemorySignalled) {
                throw new ProcessCanceledException();
            }
        }

        private synchronized void clearState() {
            this.myLowMemorySignalled = true;
            this.filesChanged.clear();
            this.filesDeleted.clear();
            this.processLaterEvents.clear();
        }
    }
}

