/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.util.containers.Interner;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeBasedMap<T> {
    private Node<T> myRoot = new Node();
    private final Interner<String> myInterner;
    private final char mySeparator;
    private int mySize = 0;

    public TreeBasedMap(Interner<String> table, char separator) {
        this.myInterner = table;
        this.mySeparator = separator;
    }

    public void put(String key, T value) {
        Node<T> node = this.myRoot.findRelative(key, true, this.myInterner);
        assert (node != null);
        boolean mappingExisted = node.mappingExists();
        node.setValue(value);
        if (!mappingExisted) {
            ++this.mySize;
        }
    }

    public void remove(String key) {
        Node<T> node = this.myRoot.findRelative(key, false, this.myInterner);
        if (node != null && node.mappingExists()) {
            node.removeValue();
            --this.mySize;
        }
    }

    public int size() {
        return this.mySize;
    }

    public T get(String key) {
        Node<T> node = this.myRoot.findRelative(key, false, this.myInterner);
        return node != null && node.mappingExists() ? (T)node.getValue() : null;
    }

    public boolean containsKey(String key) {
        Node<T> node = this.myRoot.findRelative(key, false, this.myInterner);
        return node != null && node.mappingExists();
    }

    public void removeAll() {
        this.myRoot = new Node();
    }

    public Iterator<String> getKeysIterator() {
        return new KeysIterator();
    }

    private class Node<T> {
        private boolean myMappingExists = false;
        private T myValue = null;
        @Nullable
        private HashMap<String, Node<T>> myChildren = null;

        private Node() {
        }

        public void setValue(T value) {
            this.myValue = value;
            this.myMappingExists = true;
        }

        public T getValue() {
            return this.myValue;
        }

        public void removeValue() {
            this.myValue = null;
            this.myMappingExists = false;
        }

        public boolean mappingExists() {
            return this.myMappingExists;
        }

        @Nullable
        public Node<T> findRelative(String text, boolean create, Interner<String> table) {
            return this.findRelative(text, 0, create, table);
        }

        @Nullable
        private Node<T> findRelative(String text, int nameStartIndex, boolean create, Interner<String> table) {
            Node<T> child;
            int childNameEnd;
            if (this.myChildren == null && !create) {
                return null;
            }
            int textLen = text.length();
            int separatorIdx = text.indexOf(TreeBasedMap.this.mySeparator, nameStartIndex);
            int n = childNameEnd = separatorIdx >= 0 ? separatorIdx : textLen;
            if (this.myChildren != null && (child = this.myChildren.get(text.substring(nameStartIndex, childNameEnd))) != null) {
                if (separatorIdx < 0) {
                    return child;
                }
                return child.findRelative(text, childNameEnd + 1, create, table);
            }
            if (create) {
                return this.addChild(table, text, nameStartIndex, childNameEnd);
            }
            return null;
        }

        @NotNull
        private Node<T> addChild(Interner<String> table, String text, int nameStartIndex, int nameEndIndex) {
            if (this.myChildren == null) {
                this.myChildren = new HashMap(3, 0.95f);
            }
            Node<T> newChild = new Node<T>();
            String key = (String)table.intern((Object)text.substring(nameStartIndex, nameEndIndex));
            this.myChildren.put(key, newChild);
            if (nameEndIndex == text.length()) {
                Node<T> node = newChild;
                if (node == null) {
                    Node.$$$reportNull$$$0(0);
                }
                return node;
            }
            Node<T> restNodes = newChild.findRelative(text, nameEndIndex + 1, true, table);
            assert (restNodes != null);
            Node<T> node = restNodes;
            if (node == null) {
                Node.$$$reportNull$$$0(1);
            }
            return node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TreeBasedMap$Node", "addChild"));
        }
    }

    private class KeysIterator
    implements Iterator<String> {
        private final Deque<PathElement<T>> myCurrentNodePath = new ArrayDeque();
        private final StringBuilder myCurrentName = new StringBuilder();

        KeysIterator() {
            this.pushNode("", TreeBasedMap.this.myRoot);
            this.findNextNode();
        }

        @Override
        public boolean hasNext() {
            return !this.myCurrentNodePath.isEmpty();
        }

        @Override
        public String next() {
            String key = this.myCurrentName.toString();
            this.popNode();
            this.findNextNode();
            return key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }

        private boolean pushNode(@NotNull String name, @NotNull Node<T> node) {
            HashMap childrenMap;
            boolean hasChildren;
            if (name == null) {
                KeysIterator.$$$reportNull$$$0(0);
            }
            if (node == null) {
                KeysIterator.$$$reportNull$$$0(1);
            }
            boolean bl = hasChildren = (childrenMap = node.myChildren) != null && !childrenMap.isEmpty();
            if (hasChildren || node.mappingExists()) {
                this.myCurrentNodePath.push(new PathElement(TreeBasedMap.this, node, hasChildren ? childrenMap.keySet().iterator() : Collections.emptyIterator()));
                if (this.myCurrentNodePath.size() > 2) {
                    this.myCurrentName.append(TreeBasedMap.this.mySeparator);
                }
                this.myCurrentName.append(name);
                return true;
            }
            return false;
        }

        private void popNode() {
            this.myCurrentNodePath.pop();
            int separatorIndex = this.myCurrentName.lastIndexOf(String.valueOf(TreeBasedMap.this.mySeparator));
            if (separatorIndex >= 0) {
                this.myCurrentName.replace(separatorIndex, this.myCurrentName.length(), "");
            } else {
                this.myCurrentName.setLength(0);
            }
        }

        private void findNextNode() {
            block0: while (!this.myCurrentNodePath.isEmpty()) {
                PathElement element = this.myCurrentNodePath.peek();
                Iterator<String> childrenIterator = element.iterator;
                Node currentNode = element.node;
                while (childrenIterator.hasNext()) {
                    Node childNode;
                    String name = childrenIterator.next();
                    if (!this.pushNode(name, childNode = currentNode.myChildren.get(name))) continue;
                    continue block0;
                }
                if (currentNode.mappingExists()) break;
                this.popNode();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/impl/TreeBasedMap$KeysIterator";
            objectArray[2] = "pushNode";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PathElement<T> {
        @NotNull
        final Iterator<String> iterator;
        @NotNull
        final Node<T> node;

        PathElement(@NotNull TreeBasedMap treeBasedMap, Node<T> node, Iterator<String> iterator) {
            if (node == null) {
                PathElement.$$$reportNull$$$0(0);
            }
            this.node = node;
            this.iterator = iterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/compiler/impl/TreeBasedMap$PathElement", "<init>"));
        }
    }
}

