/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.options.ModuleOptionsTableModel;
import com.intellij.compiler.options.ModuleTableCellRenderer;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class CompilerModuleOptionsComponent
extends JPanel {
    private final JBTable myTable;
    private final Project myProject;

    public CompilerModuleOptionsComponent(@NotNull Project project) {
        if (project == null) {
            CompilerModuleOptionsComponent.$$$reportNull$$$0(0);
        }
        super(new GridBagLayout());
        this.myProject = project;
        this.myTable = new JBTable((TableModel)new ModuleOptionsTableModel());
        this.myTable.setShowGrid(false);
        this.myTable.setRowHeight(JBUIScale.scale((int)22));
        this.myTable.getEmptyText().setText(JavaCompilerBundle.message((String)"settings.additional.compilation.options", (Object[])new Object[0]));
        TableColumn moduleColumn = this.myTable.getColumnModel().getColumn(0);
        moduleColumn.setHeaderValue(JavaCompilerBundle.message((String)"settings.override.module.column", (Object[])new Object[0]));
        moduleColumn.setCellRenderer(new ModuleTableCellRenderer());
        TableColumn optionsColumn = this.myTable.getColumnModel().getColumn(1);
        String columnTitle = JavaCompilerBundle.message((String)"settings.override.compilation.options.column", (Object[])new Object[0]);
        optionsColumn.setHeaderValue(columnTitle);
        int width = this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth(columnTitle) + 10;
        optionsColumn.setPreferredWidth(width);
        optionsColumn.setMinWidth(width);
        ExpandableTextField editor = new ExpandableTextField();
        InsertPathAction.addTo((JTextComponent)editor, null, (boolean)false);
        optionsColumn.setCellEditor(new DefaultCellEditor((JTextField)editor));
        TableSpeedSearch.installOn((JTable)this.myTable);
        JPanel table = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpAction().disableDownAction().setAddAction(b -> this.addModules()).setRemoveAction(b -> this.removeSelectedModules()).createPanel();
        table.setPreferredSize(new Dimension(this.myTable.getWidth(), 150));
        JLabel header = new JLabel(JavaCompilerBundle.message((String)"settings.override.compiler.parameters.per.module", (Object[])new Object[0]));
        GridBag gridBag = new GridBag().setDefaultAnchor(17).setDefaultWeightX(1.0).setDefaultWeightY(1.0).setDefaultInsets(6, 0, 0, 0);
        this.add((Component)header, gridBag.nextLine().weighty(0.0));
        this.add((Component)table, gridBag.nextLine().fillCell());
    }

    private void addModules() {
        int i = ((ModuleOptionsTableModel)this.myTable.getModel()).addModulesToModel(this.myProject, this);
        if (i >= 0) {
            TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{i});
            TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        }
    }

    private void removeSelectedModules() {
        if (this.myTable.getSelectedRows().length > 0) {
            TableUtil.removeSelectedItems((JTable)this.myTable);
        }
    }

    @NotNull
    public Map<String, String> getModuleOptionsMap() {
        Map<String, String> map = ((ModuleOptionsTableModel)this.myTable.getModel()).getModuleOptions();
        if (map == null) {
            CompilerModuleOptionsComponent.$$$reportNull$$$0(1);
        }
        return map;
    }

    public void setModuleOptionsMap(@NotNull Map<String, String> moduleOptions) {
        if (moduleOptions == null) {
            CompilerModuleOptionsComponent.$$$reportNull$$$0(2);
        }
        ((ModuleOptionsTableModel)this.myTable.getModel()).setModuleOptions(this.myProject, moduleOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/javaCompiler/CompilerModuleOptionsComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/javaCompiler/CompilerModuleOptionsComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleOptionsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModuleOptionsMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

