/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.javac;

import com.intellij.compiler.impl.javaCompiler.javac.JavacConfigurableUi;
import com.intellij.compiler.options.ComparingUtils;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class JavacConfigurable
implements Configurable {
    private final Project myProject;
    private JavacConfigurableUi myUi;
    private final JpsJavaCompilerOptions myJavacSettings;

    public JavacConfigurable(Project project, JpsJavaCompilerOptions javacSettings) {
        this.myJavacSettings = javacSettings;
        this.myProject = project;
    }

    public String getDisplayName() {
        return null;
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        this.myUi = new JavacConfigurableUi(this.myProject);
        return this.myUi.getPanel();
    }

    public boolean isModified() {
        boolean isModified = false;
        isModified |= ComparingUtils.isModified((JCheckBox)this.myUi.preferTargetJdkCompilerCb, this.myJavacSettings.PREFER_TARGET_JDK_COMPILER);
        isModified |= ComparingUtils.isModified(this.myUi.deprecationCb, this.myJavacSettings.DEPRECATION);
        isModified |= ComparingUtils.isModified(this.myUi.debuggingInfoCb, this.myJavacSettings.DEBUGGING_INFO);
        isModified |= ComparingUtils.isModified(this.myUi.generateNoWarningsCb, this.myJavacSettings.GENERATE_NO_WARNINGS);
        isModified |= ComparingUtils.isModified(this.myUi.additionalOptionsField, this.myJavacSettings.ADDITIONAL_OPTIONS_STRING);
        return isModified |= !this.myUi.optionsOverrideComponent.getModuleOptionsMap().equals(this.myJavacSettings.ADDITIONAL_OPTIONS_OVERRIDE);
    }

    public void apply() throws ConfigurationException {
        this.myJavacSettings.PREFER_TARGET_JDK_COMPILER = this.myUi.preferTargetJdkCompilerCb.isSelected();
        this.myJavacSettings.DEPRECATION = this.myUi.deprecationCb.isSelected();
        this.myJavacSettings.DEBUGGING_INFO = this.myUi.debuggingInfoCb.isSelected();
        this.myJavacSettings.GENERATE_NO_WARNINGS = this.myUi.generateNoWarningsCb.isSelected();
        this.myJavacSettings.ADDITIONAL_OPTIONS_STRING = this.myUi.additionalOptionsField.getText();
        this.myJavacSettings.ADDITIONAL_OPTIONS_OVERRIDE.clear();
        this.myJavacSettings.ADDITIONAL_OPTIONS_OVERRIDE.putAll(this.myUi.optionsOverrideComponent.getModuleOptionsMap());
    }

    public void reset() {
        this.myUi.preferTargetJdkCompilerCb.setSelected(this.myJavacSettings.PREFER_TARGET_JDK_COMPILER);
        this.myUi.deprecationCb.setSelected(this.myJavacSettings.DEPRECATION);
        this.myUi.debuggingInfoCb.setSelected(this.myJavacSettings.DEBUGGING_INFO);
        this.myUi.generateNoWarningsCb.setSelected(this.myJavacSettings.GENERATE_NO_WARNINGS);
        this.myUi.additionalOptionsField.setText(this.myJavacSettings.ADDITIONAL_OPTIONS_STRING);
        this.myUi.optionsOverrideComponent.setModuleOptionsMap(this.myJavacSettings.ADDITIONAL_OPTIONS_OVERRIDE);
    }

    public void disposeUIResources() {
        this.myUi = null;
    }
}

