/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.options.ProcessorProfilePanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EditableTreeModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;

public class AnnotationProcessorsPanel
extends JPanel {
    private final ProcessorConfigProfile myDefaultProfile = new ProcessorConfigProfileImpl("");
    private final List<ProcessorConfigProfile> myModuleProfiles = new ArrayList<ProcessorConfigProfile>();
    private final Map<String, Module> myAllModulesMap = new HashMap<String, Module>();
    private final Project myProject;
    private final Tree myTree;
    private final ProcessorProfilePanel myProfilePanel;
    private ProcessorConfigProfile mySelectedProfile = null;

    public AnnotationProcessorsPanel(Project project) {
        super(new BorderLayout());
        Splitter splitter = new Splitter(false, 0.3f);
        this.add((Component)splitter, "Center");
        this.myProject = project;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            this.myAllModulesMap.put(module.getName(), module);
        }
        this.myTree = new Tree((TreeModel)new MyTreeModel());
        this.myTree.setRootVisible(false);
        JPanel treePanel = ToolbarDecorator.createDecorator((JTree)this.myTree).addExtraAction((AnAction)new MoveProfileAction()).createPanel();
        splitter.setFirstComponent((JComponent)treePanel);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyCellRenderer()));
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = AnnotationProcessorsPanel.this.myTree.getSelectionPath();
                if (path != null) {
                    ProcessorConfigProfile selectedProfile;
                    ProcessorConfigProfile nodeProfile;
                    Object node = path.getLastPathComponent();
                    if (node instanceof MyModuleNode) {
                        node = ((MyModuleNode)node).getParent();
                    }
                    if (node instanceof ProfileNode && (nodeProfile = ((ProfileNode)node).myProfile) != (selectedProfile = AnnotationProcessorsPanel.this.mySelectedProfile)) {
                        if (selectedProfile != null) {
                            AnnotationProcessorsPanel.this.myProfilePanel.saveTo(selectedProfile);
                        }
                        AnnotationProcessorsPanel.this.mySelectedProfile = nodeProfile;
                        AnnotationProcessorsPanel.this.myProfilePanel.setProfile(nodeProfile);
                    }
                }
            }
        });
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.myTree, path -> {
            Object node = path.getLastPathComponent();
            if (node instanceof MyModuleNode) {
                MyModuleNode moduleNode = (MyModuleNode)node;
                return moduleNode.getModule().getName();
            }
            if (node instanceof ProfileNode) {
                ProfileNode profileNode = (ProfileNode)node;
                return profileNode.myProfile.getName();
            }
            return "";
        }, false);
        this.myProfilePanel = new ProcessorProfilePanel(project);
        this.myProfilePanel.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        splitter.setSecondComponent((JComponent)this.myProfilePanel);
    }

    public void initProfiles(ProcessorConfigProfile defaultProfile, Collection<? extends ProcessorConfigProfile> moduleProfiles) {
        this.myDefaultProfile.initFrom(defaultProfile);
        this.myModuleProfiles.clear();
        for (ProcessorConfigProfile processorConfigProfile : moduleProfiles) {
            ProcessorConfigProfileImpl copy = new ProcessorConfigProfileImpl("");
            copy.initFrom(processorConfigProfile);
            this.myModuleProfiles.add((ProcessorConfigProfile)copy);
        }
        RootNode root = (RootNode)this.myTree.getModel().getRoot();
        root.sync();
        DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)this.myDefaultProfile);
        if (defaultMutableTreeNode != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)defaultMutableTreeNode);
        }
    }

    public ProcessorConfigProfile getDefaultProfile() {
        ProcessorConfigProfile selectedProfile = this.mySelectedProfile;
        if (this.myDefaultProfile == selectedProfile) {
            this.myProfilePanel.saveTo(selectedProfile);
        }
        return this.myDefaultProfile;
    }

    public List<ProcessorConfigProfile> getModuleProfiles() {
        ProcessorConfigProfile selectedProfile = this.mySelectedProfile;
        if (this.myDefaultProfile != selectedProfile) {
            this.myProfilePanel.saveTo(selectedProfile);
        }
        return Collections.unmodifiableList(this.myModuleProfiles);
    }

    private class MyTreeModel
    extends DefaultTreeModel
    implements EditableTreeModel {
        MyTreeModel() {
            super(new RootNode());
        }

        public TreePath addNode(TreePath parentOrNeighbour) {
            String newProfileName = Messages.showInputDialog((Project)AnnotationProcessorsPanel.this.myProject, (String)JavaCompilerBundle.message((String)"dialog.message.profile.name", (Object[])new Object[0]), (String)JavaCompilerBundle.message((String)"title.create.new.profile", (Object[])new Object[0]), null, (String)"", (InputValidator)new InputValidatorEx(){

                public boolean checkInput(String inputString) {
                    if (StringUtil.isEmpty((String)inputString) || Objects.equals(inputString, AnnotationProcessorsPanel.this.myDefaultProfile.getName())) {
                        return false;
                    }
                    for (ProcessorConfigProfile profile : AnnotationProcessorsPanel.this.myModuleProfiles) {
                        if (!Objects.equals(inputString, profile.getName())) continue;
                        return false;
                    }
                    return true;
                }

                public boolean canClose(String inputString) {
                    return this.checkInput(inputString);
                }

                public String getErrorText(String inputString) {
                    if (this.checkInput(inputString)) {
                        return null;
                    }
                    return StringUtil.isEmpty((String)inputString) ? JavaCompilerBundle.message((String)"text.empty.profile", (Object[])new Object[0]) : JavaCompilerBundle.message((String)"text.profile.exists", (Object[])new Object[]{inputString});
                }
            });
            if (newProfileName != null) {
                ProcessorConfigProfileImpl profile = new ProcessorConfigProfileImpl(newProfileName);
                AnnotationProcessorsPanel.this.myModuleProfiles.add((ProcessorConfigProfile)profile);
                ((DataSynchronizable)this.getRoot()).sync();
                DefaultMutableTreeNode object = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.getRoot()), (Object)profile);
                if (object != null) {
                    TreeUtil.selectNode((JTree)AnnotationProcessorsPanel.this.myTree, (TreeNode)object);
                }
            }
            return null;
        }

        public void removeNode(TreePath nodePath) {
            this.removeNodes(Collections.singleton(nodePath));
        }

        public void removeNodes(Collection<? extends TreePath> paths) {
            SmartList toRemove = new SmartList();
            for (TreePath treePath : paths) {
                ProcessorConfigProfile nodeProfile;
                Object node = treePath.getLastPathComponent();
                if (!(node instanceof ProfileNode) || (nodeProfile = ((ProfileNode)node).myProfile) == AnnotationProcessorsPanel.this.myDefaultProfile) continue;
                toRemove.add(nodeProfile);
            }
            if (!toRemove.isEmpty()) {
                boolean changed = false;
                for (ProcessorConfigProfile nodeProfile : toRemove) {
                    if (AnnotationProcessorsPanel.this.mySelectedProfile == nodeProfile) {
                        AnnotationProcessorsPanel.this.mySelectedProfile = null;
                    }
                    changed |= AnnotationProcessorsPanel.this.myModuleProfiles.remove(nodeProfile);
                }
                if (changed) {
                    ((DataSynchronizable)this.getRoot()).sync();
                    DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.getRoot()), (Object)AnnotationProcessorsPanel.this.myDefaultProfile);
                    if (defaultMutableTreeNode != null) {
                        TreeUtil.selectNode((JTree)AnnotationProcessorsPanel.this.myTree, (TreeNode)defaultMutableTreeNode);
                    }
                }
            }
        }

        public void moveNodeTo(TreePath parentOrNeighbour) {
        }
    }

    private class MoveProfileAction
    extends DumbAwareAction {
        MoveProfileAction() {
            super(JavaCompilerBundle.messagePointer((String)"action.text.move.to", (Object[])new Object[0]), AllIcons.Actions.Forward);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Move"));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveProfileAction.$$$reportNull$$$0(0);
            }
            MyModuleNode node = (MyModuleNode)AnnotationProcessorsPanel.this.myTree.getSelectionPath().getLastPathComponent();
            TreePath[] selectedNodes = AnnotationProcessorsPanel.this.myTree.getSelectionPaths();
            ProcessorConfigProfile nodeProfile = ((ProfileNode)node.getParent()).myProfile;
            ArrayList<ProcessorConfigProfile> profiles = new ArrayList<ProcessorConfigProfile>();
            profiles.add(AnnotationProcessorsPanel.this.myDefaultProfile);
            profiles.addAll(AnnotationProcessorsPanel.this.myModuleProfiles);
            profiles.remove(nodeProfile);
            JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(profiles).setTitle(JavaCompilerBundle.message((String)"action.text.move.to", (Object[])new Object[0])).setItemChosenCallback(chosenProfile -> {
                Module toSelect = node.getModule();
                if (selectedNodes != null) {
                    for (TreePath selectedNode : selectedNodes) {
                        Object node1 = selectedNode.getLastPathComponent();
                        if (!(node1 instanceof MyModuleNode)) continue;
                        Module module = ((MyModuleNode)node1).getModule();
                        if (nodeProfile != AnnotationProcessorsPanel.this.myDefaultProfile) {
                            nodeProfile.removeModuleName(module.getName());
                        }
                        if (chosenProfile == AnnotationProcessorsPanel.this.myDefaultProfile) continue;
                        chosenProfile.addModuleName(module.getName());
                    }
                }
                RootNode root = (RootNode)AnnotationProcessorsPanel.this.myTree.getModel().getRoot();
                root.sync();
                DefaultMutableTreeNode node1 = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)toSelect);
                if (node1 != null) {
                    TreeUtil.selectNode((JTree)AnnotationProcessorsPanel.this.myTree, (TreeNode)node1);
                }
            }).createPopup();
            popup.show(JBPopupFactory.getInstance().guessBestPopupLocation((AnAction)this, e));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MoveProfileAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveProfileAction.$$$reportNull$$$0(2);
            }
            TreePath selectionPath = AnnotationProcessorsPanel.this.myTree.getSelectionPath();
            e.getPresentation().setEnabled(!AnnotationProcessorsPanel.this.myModuleProfiles.isEmpty() && selectionPath != null && selectionPath.getLastPathComponent() instanceof MyModuleNode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/options/AnnotationProcessorsPanel$MoveProfileAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/options/AnnotationProcessorsPanel$MoveProfileAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyCellRenderer
    extends ColoredTreeCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyCellRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof ProfileNode) {
                this.append(((ProfileNode)value).myProfile.getName());
            } else if (value instanceof MyModuleNode) {
                Module module = ((MyModuleNode)value).getModule();
                this.setIcon(AllIcons.Nodes.Module);
                this.append(module.getName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/compiler/options/AnnotationProcessorsPanel$MyCellRenderer", "customizeCellRenderer"));
        }
    }

    private class RootNode
    extends DefaultMutableTreeNode
    implements DataSynchronizable {
        private RootNode() {
        }

        @Override
        public DataSynchronizable sync() {
            Vector<DataSynchronizable> newKids = new Vector<DataSynchronizable>();
            newKids.add(new ProfileNode(AnnotationProcessorsPanel.this.myDefaultProfile, this, true).sync());
            for (ProcessorConfigProfile profile : AnnotationProcessorsPanel.this.myModuleProfiles) {
                newKids.add(new ProfileNode(profile, this, false).sync());
            }
            this.children = newKids;
            ((DefaultTreeModel)AnnotationProcessorsPanel.this.myTree.getModel()).reload();
            TreeUtil.expandAll((JTree)AnnotationProcessorsPanel.this.myTree);
            return this;
        }
    }

    private static interface DataSynchronizable
    extends TreeNode {
        public DataSynchronizable sync();
    }

    private static class MyModuleNode
    extends DefaultMutableTreeNode {
        MyModuleNode(Module module, ProfileNode parent) {
            super(module);
            this.setParent(parent);
            this.setAllowsChildren(false);
        }

        Module getModule() {
            return (Module)this.getUserObject();
        }
    }

    private class ProfileNode
    extends DefaultMutableTreeNode
    implements DataSynchronizable {
        private final ProcessorConfigProfile myProfile;
        private final boolean myIsDefault;

        ProfileNode(ProcessorConfigProfile profile, RootNode parent, boolean isDefault) {
            super(profile);
            this.setParent(parent);
            this.myIsDefault = isDefault;
            this.myProfile = profile;
        }

        @Override
        public DataSynchronizable sync() {
            ArrayList<Module> nodeModules = new ArrayList<Module>();
            if (this.myIsDefault) {
                HashSet nonDefaultProfileModules = new HashSet();
                for (ProcessorConfigProfile processorConfigProfile : AnnotationProcessorsPanel.this.myModuleProfiles) {
                    nonDefaultProfileModules.addAll(processorConfigProfile.getModuleNames());
                }
                for (Map.Entry entry : AnnotationProcessorsPanel.this.myAllModulesMap.entrySet()) {
                    if (nonDefaultProfileModules.contains(entry.getKey())) continue;
                    nodeModules.add((Module)entry.getValue());
                }
            } else {
                for (String moduleName : this.myProfile.getModuleNames()) {
                    Module module = AnnotationProcessorsPanel.this.myAllModulesMap.get(moduleName);
                    if (module == null) continue;
                    nodeModules.add(module);
                }
            }
            nodeModules.sort(ModuleComparator.INSTANCE);
            Vector<MyModuleNode> vector = new Vector<MyModuleNode>();
            for (Module module : nodeModules) {
                vector.add(new MyModuleNode(module, this));
            }
            this.children = vector;
            return this;
        }
    }

    private static class ModuleComparator
    implements Comparator<Module> {
        static final ModuleComparator INSTANCE = new ModuleComparator();

        private ModuleComparator() {
        }

        @Override
        public int compare(Module o1, Module o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

