/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public class ProcessorProfilePanel
extends JPanel {
    private final Project myProject;
    private final JRadioButton myRbClasspath;
    private final JRadioButton myRbProcessorsPath;
    private final JCheckBox myCbProcessorModulePath;
    private final TextFieldWithBrowseButton myProcessorPathField;
    private final JTextField myGeneratedProductionDirField;
    private final JTextField myGeneratedTestsDirField;
    private final JRadioButton myRbRelativeToOutputRoot;
    private final JRadioButton myRbRelativeToContentRoot;
    private final ProcessorTableModel myProcessorsModel;
    private final JCheckBox myCbEnableProcessing;
    private final JBTable myProcessorTable;
    private final JBTable myOptionsTable;
    private final JPanel myProcessorPanel;
    private final JPanel myOptionsPanel;
    private final OptionsTableModel myOptionsModel;
    private final JLabel myStoreGenSourcesLabel;
    private final JLabel myProductionLabel;
    private final JLabel myTestLabel;
    private final JPanel myProcessorTablePanel;
    private final JPanel myOptionsTablePanel;
    private final JCheckBox myCbProcOnly;

    public ProcessorProfilePanel(Project project) {
        super(new GridBagLayout());
        this.myProject = project;
        this.myCbEnableProcessing = new JCheckBox(JavaCompilerBundle.message((String)"settings.enable.annotation.processing", (Object[])new Object[0]));
        this.myCbProcOnly = new JCheckBox(JavaCompilerBundle.message((String)"settings.annotation.processing.proc.only", (Object[])new Object[0]));
        this.myRbClasspath = new JRadioButton(JavaCompilerBundle.message((String)"settings.obtain.processors.from.project.classpath", (Object[])new Object[0]));
        this.myRbProcessorsPath = new JRadioButton(JavaCompilerBundle.message((String)"settings.processor.path", (Object[])new Object[0]));
        this.myCbProcessorModulePath = new JCheckBox(JavaCompilerBundle.message((String)"settings.use.processor.module.path.compiler.option.for.java.9.and.later", (Object[])new Object[0]));
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbClasspath);
        group.add(this.myRbProcessorsPath);
        this.myRbRelativeToContentRoot = new JRadioButton(JavaCompilerBundle.message((String)"settings.module.content.root", (Object[])new Object[0]));
        this.myRbRelativeToOutputRoot = new JRadioButton(JavaCompilerBundle.message((String)"settings.module.output.directory", (Object[])new Object[0]));
        group = new ButtonGroup();
        group.add(this.myRbRelativeToContentRoot);
        group.add(this.myRbRelativeToOutputRoot);
        this.myProcessorPathField = new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
                VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Component)ProcessorProfilePanel.this.myProcessorPathField, (Project)ProcessorProfilePanel.this.myProject, null);
                if (files.length > 0) {
                    ProcessorProfilePanel.this.myProcessorPathField.setText(1.getPathString(files));
                }
            }

            @NotNull
            @NlsSafe
            private static String getPathString(VirtualFile[] files) {
                StringBuilder builder = new StringBuilder();
                for (VirtualFile file : files) {
                    if (!builder.isEmpty()) {
                        builder.append(File.pathSeparator);
                    }
                    builder.append(FileUtil.toSystemDependentName((String)file.getPath()));
                }
                String string = builder.toString();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/options/ProcessorProfilePanel$1", "getPathString"));
            }
        });
        this.myProcessorTablePanel = new JPanel(new BorderLayout());
        this.myProcessorsModel = new ProcessorTableModel();
        this.myProcessorTablePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaCompilerBundle.message((String)"settings.annotation.processors", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myProcessorTable = new JBTable((TableModel)this.myProcessorsModel);
        this.myProcessorTable.setShowGrid(false);
        this.myProcessorTable.getEmptyText().setText(JavaCompilerBundle.message((String)"settings.compiler.will.run.all.automatically.discovered.processors", (Object[])new Object[0]));
        this.myProcessorPanel = ProcessorProfilePanel.createTablePanel(this.myProcessorTable);
        this.myProcessorTablePanel.add((Component)this.myProcessorPanel, "Center");
        this.myOptionsTablePanel = new JPanel(new BorderLayout());
        this.myOptionsModel = new OptionsTableModel();
        this.myOptionsTablePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaCompilerBundle.message((String)"settings.annotation.processor.options", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)13)).setShowLine(false));
        this.myOptionsTable = new JBTable((TableModel)this.myOptionsModel);
        this.myOptionsTable.setShowGrid(false);
        this.myOptionsTable.getEmptyText().setText(JavaCompilerBundle.message((String)"settings.no.processor.specific.options.configured", (Object[])new Object[0]));
        this.myOptionsPanel = ProcessorProfilePanel.createTablePanel(this.myOptionsTable);
        this.myOptionsTablePanel.add((Component)this.myOptionsPanel, "Center");
        this.myGeneratedProductionDirField = new JTextField();
        this.myGeneratedTestsDirField = new JTextField();
        this.add((Component)this.myCbEnableProcessing, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 18, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.add((Component)this.myRbClasspath, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)10), 0, 0));
        this.add((Component)this.myRbProcessorsPath, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)5), 0, 0));
        this.add((Component)this.myProcessorPathField, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myCbProcessorModulePath, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)2, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)ContextHelpLabel.create((String)JavaCompilerBundle.message((String)"settings.module.path.warning", (Object[])new Object[0])), new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)2, (int)2, (int)0, (int)0), 0, 0));
        this.myStoreGenSourcesLabel = new JLabel(JavaCompilerBundle.message((String)"settings.store.generated.sources.relative.to", (Object[])new Object[0]));
        this.add((Component)this.myStoreGenSourcesLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)15, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myRbRelativeToOutputRoot, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)15, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myRbRelativeToContentRoot, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)15, (int)5, (int)0, (int)0), 0, 0));
        this.myProductionLabel = new JLabel(JavaCompilerBundle.message((String)"settings.production.sources.directory", (Object[])new Object[0]));
        this.myProductionLabel.setLabelFor(this.myGeneratedProductionDirField);
        this.add((Component)this.myProductionLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myGeneratedProductionDirField, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.myTestLabel = new JLabel(JavaCompilerBundle.message((String)"settings.test.sources.directory", (Object[])new Object[0]));
        this.myTestLabel.setLabelFor(this.myGeneratedTestsDirField);
        this.add((Component)this.myTestLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myGeneratedTestsDirField, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myCbProcOnly, new GridBagConstraints(0, -1, 3, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.myProcessorTablePanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 18, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.add((Component)this.myOptionsTablePanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 18, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myRbClasspath.addItemListener(e -> this.updateEnabledState());
        this.myProcessorTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateEnabledState();
            }
        });
        this.myCbEnableProcessing.addItemListener(e -> this.updateEnabledState());
        this.updateEnabledState();
    }

    public void setProfile(ProcessorConfigProfile config) {
        this.myCbEnableProcessing.setSelected(config.isEnabled());
        this.myCbProcOnly.setSelected(config.isProcOnly());
        (config.isObtainProcessorsFromClasspath() ? this.myRbClasspath : this.myRbProcessorsPath).setSelected(true);
        this.myCbProcessorModulePath.setSelected(config.isUseProcessorModulePath());
        this.myProcessorPathField.setText(FileUtil.toSystemDependentName((String)config.getProcessorPath()));
        String productionDirName = config.getGeneratedSourcesDirectoryName(false);
        this.myGeneratedProductionDirField.setText(productionDirName.trim());
        String testsDirName = config.getGeneratedSourcesDirectoryName(true);
        this.myGeneratedTestsDirField.setText(testsDirName.trim());
        if (config.isOutputRelativeToContentRoot()) {
            this.myRbRelativeToContentRoot.setSelected(true);
        } else {
            this.myRbRelativeToOutputRoot.setSelected(true);
        }
        this.myProcessorsModel.setProcessors(config.getProcessors());
        this.myOptionsModel.setOptions(config.getProcessorOptions());
        this.updateEnabledState();
    }

    public void saveTo(ProcessorConfigProfile profile) {
        profile.setEnabled(this.myCbEnableProcessing.isSelected());
        profile.setObtainProcessorsFromClasspath(this.myRbClasspath.isSelected());
        profile.setProcessorPath(this.myProcessorPathField.getText().trim());
        profile.setUseProcessorModulePath(this.myCbProcessorModulePath.isSelected());
        profile.setProcOnly(this.myCbProcOnly.isSelected());
        String productionDir = this.myGeneratedProductionDirField.getText().trim();
        profile.setGeneratedSourcesDirectoryName(StringUtil.isEmpty((String)productionDir) ? null : productionDir, false);
        String testsDir = this.myGeneratedTestsDirField.getText().trim();
        profile.setGeneratedSourcesDirectoryName(StringUtil.isEmpty((String)testsDir) ? null : testsDir, true);
        profile.setOutputRelativeToContentRoot(this.myRbRelativeToContentRoot.isSelected());
        profile.clearProcessors();
        for (String string : this.myProcessorsModel.getProcessors()) {
            profile.addProcessor(string);
        }
        profile.clearProcessorOptions();
        for (Map.Entry entry : this.myOptionsModel.getOptions().entrySet()) {
            profile.setOption((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static JPanel createTablePanel(final JBTable table) {
        return ToolbarDecorator.createDecorator((JTable)table).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TableCellEditor cellEditor = table.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
                TableModel model = table.getModel();
                ((EditableModel)model).addRow();
                TableUtil.editCellAt((JTable)table, (int)(model.getRowCount() - 1), (int)0);
            }
        }).createPanel();
    }

    private void updateEnabledState() {
        boolean enabled = this.myCbEnableProcessing.isSelected();
        boolean useProcessorPath = !this.myRbClasspath.isSelected();
        this.myRbClasspath.setEnabled(enabled);
        this.myRbProcessorsPath.setEnabled(enabled);
        this.myCbProcessorModulePath.setEnabled(enabled && useProcessorPath);
        this.myProcessorPathField.setEnabled(enabled && useProcessorPath);
        ProcessorProfilePanel.updateTable(this.myProcessorPanel, this.myProcessorTable, enabled);
        ProcessorProfilePanel.updateTable(this.myOptionsPanel, this.myOptionsTable, enabled);
        this.myGeneratedProductionDirField.setEnabled(enabled);
        this.myGeneratedTestsDirField.setEnabled(enabled);
        this.myRbRelativeToOutputRoot.setEnabled(enabled);
        this.myRbRelativeToContentRoot.setEnabled(enabled);
        this.myStoreGenSourcesLabel.setEnabled(enabled);
        this.myProductionLabel.setEnabled(enabled);
        this.myTestLabel.setEnabled(enabled);
        this.myCbProcOnly.setEnabled(enabled);
        this.myProcessorTablePanel.setEnabled(enabled);
        this.myOptionsTablePanel.setEnabled(enabled);
    }

    private static void updateTable(JPanel tablePanel, JBTable table, boolean enabled) {
        AnActionButton removeButton;
        AnActionButton addButton = ToolbarDecorator.findAddButton((JComponent)tablePanel);
        if (addButton != null) {
            addButton.setEnabled(enabled);
        }
        if ((removeButton = ToolbarDecorator.findRemoveButton((JComponent)tablePanel)) != null) {
            removeButton.setEnabled(enabled && table.getSelectedRow() >= 0);
        }
        table.setEnabled(enabled);
        JTableHeader header = table.getTableHeader();
        if (header != null) {
            header.repaint();
        }
    }

    private static class ProcessorTableModel
    extends AbstractTableModel
    implements EditableModel {
        private final List<String> myRows = new ArrayList<String>();

        private ProcessorTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return JavaCompilerBundle.message((String)"settings.processor.fq.name", (Object[])new Object[0]);
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.myRows.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.myRows.get(rowIndex);
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue != null && columnIndex == 0) {
                this.myRows.set(rowIndex, (String)aValue);
            }
        }

        public void removeRow(int idx) {
            this.myRows.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        public void addRow() {
            this.myRows.add("");
            int index = this.myRows.size() - 1;
            this.fireTableRowsInserted(index, index);
        }

        public void setProcessors(Collection<String> processors) {
            this.clear();
            if (!processors.isEmpty()) {
                this.myRows.addAll(processors);
                this.fireTableRowsInserted(0, processors.size() - 1);
            }
        }

        public void clear() {
            int count = this.myRows.size();
            if (count > 0) {
                this.myRows.clear();
                this.fireTableRowsDeleted(0, count - 1);
            }
        }

        public Collection<String> getProcessors() {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (String row : this.myRows) {
                if (row == null) continue;
                set.add(row.trim());
            }
            set.remove("");
            return set;
        }
    }

    private static class OptionsTableModel
    extends AbstractTableModel
    implements EditableModel {
        private final List<KeyValuePair> myRows = new ArrayList<KeyValuePair>();

        private OptionsTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return switch (column) {
                case 0 -> JavaCompilerBundle.message((String)"settings.column.option.name", (Object[])new Object[0]);
                case 1 -> JavaCompilerBundle.message((String)"settings.column.value", (Object[])new Object[0]);
                default -> super.getColumnName(column);
            };
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.myRows.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return switch (columnIndex) {
                case 0 -> this.myRows.get((int)rowIndex).key;
                case 1 -> this.myRows.get((int)rowIndex).value;
                default -> null;
            };
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue != null) {
                switch (columnIndex) {
                    case 0: {
                        this.myRows.get((int)rowIndex).key = (String)aValue;
                        break;
                    }
                    case 1: {
                        this.myRows.get((int)rowIndex).value = (String)aValue;
                    }
                }
            }
        }

        public void removeRow(int idx) {
            this.myRows.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        public void addRow() {
            this.myRows.add(new KeyValuePair());
            int index = this.myRows.size() - 1;
            this.fireTableRowsInserted(index, index);
        }

        public void setOptions(Map<String, String> options) {
            this.clear();
            if (!options.isEmpty()) {
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    this.myRows.add(new KeyValuePair(entry.getKey(), entry.getValue()));
                }
                this.myRows.sort((o1, o2) -> o1.key.compareToIgnoreCase(o2.key));
                this.fireTableRowsInserted(0, options.size() - 1);
            }
        }

        public void clear() {
            int count = this.myRows.size();
            if (count > 0) {
                this.myRows.clear();
                this.fireTableRowsDeleted(0, count - 1);
            }
        }

        public Map<String, String> getOptions() {
            HashMap<String, String> map = new HashMap<String, String>();
            for (KeyValuePair pair : this.myRows) {
                map.put(pair.key.trim(), pair.value.trim());
            }
            map.remove("");
            return map;
        }

        private static final class KeyValuePair {
            String key;
            String value;

            KeyValuePair() {
                this("", "");
            }

            KeyValuePair(String key, String value) {
                this.key = key;
                this.value = value;
            }
        }
    }
}

