/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.progress;

import com.intellij.build.BuildBundle;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.FilePosition;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.progress.BuildProgress;
import com.intellij.build.progress.BuildProgressDescriptor;
import com.intellij.compiler.impl.CompilerPropertiesAction;
import com.intellij.compiler.impl.ExcludeFromCompileAction;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.options.ExcludeFromValidationAction;
import com.intellij.compiler.progress.BuildIssueContributor;
import com.intellij.compiler.progress.BuildViewService;
import com.intellij.compiler.progress.CompilerMessagesService;
import com.intellij.compiler.progress.ModuleLinkFilter;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BuildOutputService
implements BuildViewService {
    private static final ExtensionPointName<BuildIssueContributor> BUILD_ISSUE_EP = ExtensionPointName.create((String)"com.intellij.compiler.buildIssueContributor");
    @NonNls
    private static final String ANSI_RESET = "\u001b[0m";
    @NonNls
    private static final String ANSI_RED = "\u001b[31m";
    @NonNls
    private static final String ANSI_YELLOW = "\u001b[33m";
    @NonNls
    private static final String ANSI_BOLD = "\u001b[1m";
    @NotNull
    private final Project myProject;
    @NotNull
    private final BuildProgress<BuildProgressDescriptor> myBuildProgress;
    @NlsContexts.TabTitle
    @NotNull
    private final String myContentName;
    private final boolean myCompilationStartedAutomatically;
    private final ConsolePrinter myConsolePrinter;

    public BuildOutputService(@NotNull Project project, @NlsContexts.TabTitle @NotNull String contentName) {
        if (project == null) {
            BuildOutputService.$$$reportNull$$$0(0);
        }
        if (contentName == null) {
            BuildOutputService.$$$reportNull$$$0(1);
        }
        this(project, contentName, false);
    }

    public BuildOutputService(@NotNull Project project, @NlsContexts.TabTitle @NotNull String contentName, boolean compilationStartedAutomatically) {
        if (project == null) {
            BuildOutputService.$$$reportNull$$$0(2);
        }
        if (contentName == null) {
            BuildOutputService.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myContentName = contentName;
        this.myCompilationStartedAutomatically = compilationStartedAutomatically;
        this.myBuildProgress = BuildViewManager.createBuildProgress((Project)project);
        this.myConsolePrinter = new ConsolePrinter(this.myBuildProgress);
    }

    @Override
    public void registerCloseAction(Runnable onClose) {
    }

    @Override
    public void onProgressChange(Object sessionId, ProgressIndicator indicator) {
    }

    @Override
    public void onStart(Object sessionId, long startCompilationStamp, Runnable restartWork, ProgressIndicator indicator) {
        List<AnAction> restartActions = this.getRestartActions(restartWork, indicator);
        List<AnAction> contextActions = BuildOutputService.getContextActions();
        String title = this.myContentName.equals(JavaCompilerBundle.message((String)"compiler.content.name.rebuild", (Object[])new Object[0])) || this.myContentName.equals(JavaCompilerBundle.message((String)"compiler.content.name.recompile", (Object[])new Object[0])) || this.myContentName.equals(JavaCompilerBundle.message((String)"compiler.content.name.make", (Object[])new Object[0])) ? this.myProject.getName() : StringUtil.capitalize((String)StringUtil.wordsToBeginFromLowerCase((String)this.myContentName));
        final DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor(sessionId, title, StringUtil.notNullize((String)this.myProject.getBasePath()), startCompilationStamp).withRestartActions(restartActions.toArray(AnAction.EMPTY_ARRAY)).withAction((AnAction)new CompilerPropertiesAction()).withExecutionFilter((Filter)new ModuleLinkFilter(this.myProject)).withExecutionFilter((Filter)new RegexpFilter(this.myProject, "$FILE_PATH$:$LINE$:$COLUMN$")).withExecutionFilter((Filter)new UrlFilter(this.myProject)).withContextAction(node -> new ExcludeFromCompileAction(this, this.myProject, (ExecutionNode)node){
            final /* synthetic */ ExecutionNode val$node;
            {
                this.val$node = executionNode;
                super(project);
            }

            @Override
            @Nullable
            protected VirtualFile getFile() {
                List navigatables = this.val$node.getNavigatables();
                if (navigatables.size() != 1) {
                    return null;
                }
                Navigatable navigatable = (Navigatable)navigatables.getFirst();
                return ExcludeFromValidationAction.getTargetFile(navigatable);
            }
        }).withContextActions(contextActions.toArray(AnAction.EMPTY_ARRAY));
        if (this.myCompilationStartedAutomatically) {
            buildDescriptor.setActivateToolWindowWhenFailed(false);
        }
        this.myBuildProgress.start(new BuildProgressDescriptor(){

            @NotNull
            public String getTitle() {
                String string = buildDescriptor.getTitle();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public BuildDescriptor getBuildDescriptor() {
                DefaultBuildDescriptor defaultBuildDescriptor = buildDescriptor;
                if (defaultBuildDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                return defaultBuildDescriptor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/compiler/progress/BuildOutputService$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTitle";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBuildDescriptor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
        this.addIndicatorDelegate(indicator);
    }

    @Override
    public void onEnd(Object sessionId, ExitStatus exitStatus, long endBuildStamp) {
        if (exitStatus == ExitStatus.ERRORS) {
            String message = BuildBundle.message((String)"build.messages.failed", (Object[])new Object[]{StringUtil.wordsToBeginFromLowerCase((String)this.myContentName)});
            this.myBuildProgress.fail(endBuildStamp, message);
        } else if (exitStatus == ExitStatus.CANCELLED) {
            String message = BuildBundle.message((String)"build.messages.cancelled", (Object[])new Object[]{StringUtil.wordsToBeginFromLowerCase((String)this.myContentName)});
            this.myBuildProgress.cancel(endBuildStamp, message);
        } else {
            boolean isUpToDate;
            boolean bl = isUpToDate = exitStatus == ExitStatus.UP_TO_DATE;
            if (JavaCompilerBundle.message((String)"classes.up.to.date.check", (Object[])new Object[0]).equals(this.myContentName)) {
                if (isUpToDate) {
                    this.myConsolePrinter.print(JavaCompilerBundle.message((String)"compiler.build.messages.classes.check.uptodate", (Object[])new Object[0]), MessageEvent.Kind.SIMPLE);
                } else {
                    this.myConsolePrinter.print(JavaCompilerBundle.message((String)"compiler.build.messages.classes.check.outdated", (Object[])new Object[0]), MessageEvent.Kind.SIMPLE);
                }
            }
            String message = BuildBundle.message((String)"build.messages.finished", (Object[])new Object[]{StringUtil.wordsToBeginFromLowerCase((String)this.myContentName)});
            this.myBuildProgress.finish(endBuildStamp, isUpToDate, message);
        }
    }

    @Override
    public void addMessage(Object sessionId, CompilerMessage compilerMessage) {
        MessageEvent.Kind kind = BuildOutputService.convertCategory(compilerMessage.getCategory());
        VirtualFile virtualFile = compilerMessage.getVirtualFile();
        Navigatable navigatable = compilerMessage.getNavigatable();
        String title = BuildOutputService.getMessageTitle(compilerMessage);
        BuildIssue issue = this.buildIssue(compilerMessage.getModuleNames(), title, compilerMessage.getMessage(), kind, virtualFile, navigatable);
        if (issue != null) {
            this.myBuildProgress.buildIssue(issue, kind);
        } else if (virtualFile != null) {
            FilePosition filePosition;
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            if (navigatable instanceof OpenFileDescriptor) {
                OpenFileDescriptor fileDescriptor = (OpenFileDescriptor)navigatable;
                int column = fileDescriptor.getColumn();
                int line = fileDescriptor.getLine();
                filePosition = new FilePosition(file, line, column);
            } else {
                filePosition = new FilePosition(file, 0, 0);
            }
            this.myBuildProgress.fileMessage(title, compilerMessage.getMessage(), kind, filePosition);
        } else {
            if (kind == MessageEvent.Kind.ERROR || kind == MessageEvent.Kind.WARNING) {
                this.myBuildProgress.message(title, compilerMessage.getMessage(), kind, navigatable);
            }
            this.myConsolePrinter.print(compilerMessage.getMessage(), kind);
        }
    }

    @Nullable
    private BuildIssue buildIssue(@NotNull Collection<String> moduleNames, @NotNull String title, @NotNull String message, @NotNull MessageEvent.Kind kind, @Nullable VirtualFile virtualFile, @Nullable Navigatable navigatable) {
        if (moduleNames == null) {
            BuildOutputService.$$$reportNull$$$0(4);
        }
        if (title == null) {
            BuildOutputService.$$$reportNull$$$0(5);
        }
        if (message == null) {
            BuildOutputService.$$$reportNull$$$0(6);
        }
        if (kind == null) {
            BuildOutputService.$$$reportNull$$$0(7);
        }
        return (BuildIssue)BUILD_ISSUE_EP.computeSafeIfAny(contributor -> contributor.createBuildIssue(this.myProject, moduleNames, title, message, kind, virtualFile, navigatable));
    }

    @NotNull
    private List<AnAction> getRestartActions(final Runnable restartWork, final ProgressIndicator indicator) {
        SmartList restartActions = new SmartList();
        if (restartWork != null) {
            DumbAwareAction restartAction = new DumbAwareAction(this, ExecutionBundle.messagePointer((String)"rerun.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)this.myContentName)}), Presentation.NULL_STRING, AllIcons.Actions.Compile){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    restartWork.run();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(!indicator.isRunning());
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                    if (actionUpdateThread == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return actionUpdateThread;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/compiler/progress/BuildOutputService$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/compiler/progress/BuildOutputService$3";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            };
            restartActions.add(restartAction);
        }
        DumbAwareAction stopAction = new DumbAwareAction(this, IdeBundle.messagePointer((String)"action.stop", (Object[])new Object[0]), AllIcons.Actions.Suspend){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                indicator.cancel();
            }

            public void update(@NotNull AnActionEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                event.getPresentation().setEnabled(indicator.isRunning());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    4.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/compiler/progress/BuildOutputService$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/compiler/progress/BuildOutputService$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        restartActions.add(stopAction);
        SmartList smartList = restartActions;
        if (smartList == null) {
            BuildOutputService.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    private void addIndicatorDelegate(final ProgressIndicator indicator) {
        if (!(indicator instanceof ProgressIndicatorEx)) {
            return;
        }
        ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new CompilerMessagesService.DummyProgressIndicator(){
            private final Map<String, Set<String>> mySeenMessages = new HashMap<String, Set<String>>();
            @NlsSafe
            private String lastMessage = null;
            private Stack<@NlsContexts.ProgressText String> myTextStack;

            @Override
            public void setText(@Nls(capitalization=Nls.Capitalization.Sentence) String text) {
                this.addIndicatorNewMessagesAsBuildOutput(text);
            }

            @Override
            public void pushState() {
                this.getTextStack().push((Object)indicator.getText());
            }

            @Override
            public void setFraction(double fraction) {
                BuildOutputService.this.myBuildProgress.progress(this.lastMessage, 100L, (long)(fraction * 100.0), "%");
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            private @NotNull Stack<@NlsContexts.ProgressText String> getTextStack() {
                @NlsContexts.ProgressText Stack stack = this.myTextStack;
                if (stack == null) {
                    this.myTextStack = stack = new Stack(2);
                }
                Stack stack2 = stack;
                if (stack2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                return stack2;
            }

            private void addIndicatorNewMessagesAsBuildOutput(@Nls String msg) {
                int end;
                Stack<@NlsContexts.ProgressText String> textStack = this.getTextStack();
                if (!textStack.isEmpty() && msg.equals(textStack.peek())) {
                    textStack.pop();
                    return;
                }
                if (StringUtil.isEmptyOrSpaces((String)msg) || msg.equals(this.lastMessage)) {
                    return;
                }
                this.lastMessage = msg;
                int start2 = msg.indexOf("[");
                if (start2 >= 1 && (end = msg.indexOf(93, start2 + 1)) != -1) {
                    boolean isSeenMessage;
                    String buildTargetNameCandidate = msg.substring(start2 + 1, end);
                    Set targets = this.mySeenMessages.computeIfAbsent(buildTargetNameCandidate, unused -> new HashSet());
                    boolean bl = isSeenMessage = !targets.add(msg.substring(0, start2));
                    if (isSeenMessage) {
                        return;
                    }
                }
                BuildOutputService.this.myConsolePrinter.print(msg, MessageEvent.Kind.SIMPLE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/progress/BuildOutputService$5", "getTextStack"));
            }
        });
    }

    @NotNull
    private static List<AnAction> getContextActions() {
        SmartList contextActions = new SmartList();
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup compilerErrorsViewPopupGroup = (DefaultActionGroup)actionManager.getAction("CompilerErrorViewPopupMenu");
        if (compilerErrorsViewPopupGroup != null) {
            Collections.addAll(contextActions, compilerErrorsViewPopupGroup.getChildren(actionManager));
        }
        SmartList smartList = contextActions;
        if (smartList == null) {
            BuildOutputService.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @Nls
    private static String getMessageTitle(@NotNull CompilerMessage compilerMessage) {
        if (compilerMessage == null) {
            BuildOutputService.$$$reportNull$$$0(10);
        }
        Object message = null;
        String[] messages = StringUtil.splitByLines((String)compilerMessage.getMessage());
        if (messages.length > 1) {
            String part1;
            String line0 = messages[0];
            String line1 = messages[1];
            int colonIndex = line1.indexOf(58);
            if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
                String symbol = line1.substring(colonIndex + 1).trim();
                message = line0 + " " + symbol;
            }
        }
        if (message == null) {
            message = messages[0];
        }
        return StringUtil.trimEnd((String)StringUtil.trimStart(message, (String)"java: "), (char)'.');
    }

    @NotNull
    private static MessageEvent.Kind convertCategory(@NotNull CompilerMessageCategory category) {
        if (category == null) {
            BuildOutputService.$$$reportNull$$$0(11);
        }
        MessageEvent.Kind kind = switch (category) {
            default -> throw new MatchException(null, null);
            case CompilerMessageCategory.ERROR -> MessageEvent.Kind.ERROR;
            case CompilerMessageCategory.WARNING -> MessageEvent.Kind.WARNING;
            case CompilerMessageCategory.INFORMATION -> MessageEvent.Kind.INFO;
            case CompilerMessageCategory.STATISTICS -> MessageEvent.Kind.STATISTICS;
        };
        if (kind == null) {
            BuildOutputService.$$$reportNull$$$0(12);
        }
        return kind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/progress/BuildOutputService";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerMessage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/progress/BuildOutputService";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildIssue";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMessageTitle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertCategory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 12 -> new IllegalStateException(string);
        };
    }

    private static class ConsolePrinter {
        @NotNull
        private final BuildProgress<BuildProgressDescriptor> progress;
        private volatile boolean isNewLinePosition;

        private ConsolePrinter(@NotNull BuildProgress<BuildProgressDescriptor> progress) {
            if (progress == null) {
                ConsolePrinter.$$$reportNull$$$0(0);
            }
            this.isNewLinePosition = true;
            this.progress = progress;
        }

        private void print(@NotNull @Nls String message, @NotNull MessageEvent.Kind kind) {
            if (message == null) {
                ConsolePrinter.$$$reportNull$$$0(1);
            }
            if (kind == null) {
                ConsolePrinter.$$$reportNull$$$0(2);
            }
            Object text = ConsolePrinter.wrapWithAnsiColor(kind, message);
            if (!this.isNewLinePosition && !StringUtil.startsWithChar((CharSequence)message, (char)'\r')) {
                text = "\n" + (String)text;
            }
            this.isNewLinePosition = StringUtil.endsWithLineBreak((CharSequence)message);
            this.progress.output((String)text, kind != MessageEvent.Kind.ERROR);
        }

        @Nls
        private static String wrapWithAnsiColor(MessageEvent.Kind kind, @Nls String message) {
            if (kind == MessageEvent.Kind.SIMPLE) {
                return message;
            }
            @NlsSafe String color = kind == MessageEvent.Kind.ERROR ? BuildOutputService.ANSI_RED : (kind == MessageEvent.Kind.WARNING ? BuildOutputService.ANSI_YELLOW : BuildOutputService.ANSI_BOLD);
            @NlsSafe String ansiReset = BuildOutputService.ANSI_RESET;
            return color + message + BuildOutputService.ANSI_RESET;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/progress/BuildOutputService$ConsolePrinter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

