/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.YourKitProfilerService;
import com.intellij.compiler.server.BuildCommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.system.OS;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class LocalBuildCommandLineBuilder
implements BuildCommandLineBuilder {
    private final GeneralCommandLine myCommandLine = new GeneralCommandLine();

    LocalBuildCommandLineBuilder(String vmExecutablePath) {
        this.myCommandLine.withExePath(vmExecutablePath);
    }

    @Override
    public void addParameter(@NotNull String parameter) {
        if (parameter == null) {
            LocalBuildCommandLineBuilder.$$$reportNull$$$0(0);
        }
        this.myCommandLine.addParameter(parameter);
    }

    @Override
    public void addPathParameter(@NotNull String prefix, @NotNull String path) {
        if (prefix == null) {
            LocalBuildCommandLineBuilder.$$$reportNull$$$0(1);
        }
        if (path == null) {
            LocalBuildCommandLineBuilder.$$$reportNull$$$0(2);
        }
        this.myCommandLine.addParameter(prefix + path);
    }

    @Override
    public void addClasspathParameter(List<String> classpathInHost, List<String> classpathInTarget) {
        StringBuilder builder = new StringBuilder();
        for (String file : classpathInHost) {
            if (!builder.isEmpty()) {
                builder.append(File.pathSeparator);
            }
            builder.append(FileUtil.toCanonicalPath((String)file));
        }
        for (String s : classpathInTarget) {
            if (!builder.isEmpty()) {
                builder.append(File.pathSeparator);
            }
            builder.append(this.getHostWorkingDirectory().resolve(s));
        }
        this.myCommandLine.addParameter(builder.toString());
    }

    @Override
    @NotNull
    public String getWorkingDirectory() {
        String string = FileUtil.toSystemIndependentName((String)this.getHostWorkingDirectory().toString());
        if (string == null) {
            LocalBuildCommandLineBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public Path getHostWorkingDirectory() {
        return LocalBuildCommandLineBuilder.getLocalBuildSystemDirectory();
    }

    @Override
    public String getYjpAgentPath(YourKitProfilerService yourKitProfilerService) {
        return LocalBuildCommandLineBuilder.getLocalBuildSystemDirectory().resolve(yourKitProfilerService.getYKAgentFullName()).toAbsolutePath().toString();
    }

    @Override
    public void setCharset(Charset charset) {
        this.myCommandLine.withCharset(charset);
    }

    @Override
    public GeneralCommandLine buildCommandLine() {
        return this.myCommandLine.withWorkingDirectory(this.getHostWorkingDirectory());
    }

    @Override
    public void setUnixProcessPriority(int priority) {
        if (OS.CURRENT == OS.Windows) {
            throw new IllegalArgumentException("'setUnixProcessPriority' must be used only on Unix operating systems");
        }
        LocalBuildCommandLineBuilder.setUnixProcessPriority(this.myCommandLine, priority);
    }

    @Override
    public void setStartNewSession() {
        if (OS.CURRENT != OS.Linux) {
            throw new IllegalArgumentException("'setNewProcessGroup' must be used only on Linux");
        }
        this.myCommandLine.withWrappingCommand("setsid", new String[0]);
    }

    @NotNull
    static Path getLocalBuildSystemDirectory() {
        Path path = PathManager.getSystemDir().resolve("compile-server");
        if (path == null) {
            LocalBuildCommandLineBuilder.$$$reportNull$$$0(4);
        }
        return path;
    }

    static void setUnixProcessPriority(GeneralCommandLine commandLine, int priority) {
        if (priority < 0 || priority > 19) {
            throw new IllegalArgumentException("priority must be in the [0..19] range: " + priority);
        }
        commandLine.withWrappingCommand("nice", new String[]{"-n", Integer.toString(priority)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/server/LocalBuildCommandLineBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/server/LocalBuildCommandLineBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalBuildSystemDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPathParameter";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

