/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelMachine;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.path.CopyActionContext;
import kotlin.io.path.CopyActionResult;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001aQ\u0010\r\u001a=\u0012\u0004\u0012\u00020\u000f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000e\u00a2\u0006\u0002\b\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"ENVIRONMENT_ASSOCIATED_FILENAMES", "", "", "transferOptionsToRemote", "Ljava/nio/file/Path;", "optionsDir", "project", "Lcom/intellij/openapi/project/Project;", "prepareOptionsDirForEnvironment", "", "originalOptionsDir", "parentForProcessedOptionsDir", "internalEnvironmentName", "copyAction", "Lkotlin/Function3;", "Lkotlin/io/path/CopyActionContext;", "Lkotlin/ParameterName;", "name", "source", "target", "Lkotlin/io/path/CopyActionResult;", "Lkotlin/ExtensionFunctionType;", "skipFiles", "intellij.java.compiler.impl"})
@JvmName(name="OptionsDirectoryProcessor")
@SourceDebugExtension(value={"SMAP\nOptionsDirectoryProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionsDirectoryProcessor.kt\ncom/intellij/compiler/server/OptionsDirectoryProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class OptionsDirectoryProcessor {
    @NotNull
    private static final Set<String> ENVIRONMENT_ASSOCIATED_FILENAMES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path transferOptionsToRemote(@NotNull Path optionsDir, @NotNull Project project) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)optionsDir, (String)"optionsDir");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Project)project);
        EelMachine machine = EelProviderUtil.getEelMachine((Project)project);
        if (!Registry.Companion.is("ide.workspace.model.per.environment.model.separation", false)) {
            return EelPathUtils.transferLocalContentToRemote$default((Path)optionsDir, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Temporary(eelDescriptor)), null, null, (int)12, null);
        }
        String internalName = machine.getInternalName();
        if (Intrinsics.areEqual((Object)internalName, (Object)LocalEelMachine.INSTANCE.getInternalName())) {
            return EelPathUtils.transferLocalContentToRemote$default((Path)optionsDir, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Temporary(eelDescriptor)), null, null, (int)12, null);
        }
        Path parentForProcessedOptionsDir = Files.createTempDirectory(internalName, new FileAttribute[0]);
        try {
            Intrinsics.checkNotNull((Object)parentForProcessedOptionsDir);
            OptionsDirectoryProcessor.prepareOptionsDirForEnvironment(optionsDir, parentForProcessedOptionsDir, internalName);
            path = EelPathUtils.transferLocalContentToRemote$default((Path)parentForProcessedOptionsDir, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Temporary(eelDescriptor)), null, null, (int)12, null);
        }
        catch (Throwable throwable) {
            try {
                boolean bl = false;
                Intrinsics.checkNotNull((Object)parentForProcessedOptionsDir);
                PathsKt.deleteRecursively((Path)parentForProcessedOptionsDir);
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            throw throwable;
        }
        try {
            boolean bl = false;
            PathsKt.deleteRecursively((Path)parentForProcessedOptionsDir);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return path;
    }

    private static final void prepareOptionsDirForEnvironment(Path originalOptionsDir, Path parentForProcessedOptionsDir, String internalEnvironmentName) {
        Path processedOptionsDir = PathsKt.copyToRecursively$default((Path)originalOptionsDir, (Path)parentForProcessedOptionsDir, null, (boolean)false, OptionsDirectoryProcessor.copyAction(ENVIRONMENT_ASSOCIATED_FILENAMES), (int)2, null);
        for (String filename : ENVIRONMENT_ASSOCIATED_FILENAMES) {
            Path path;
            Path originalFile = originalOptionsDir.resolve(internalEnvironmentName).resolve(filename);
            if (!Files.exists(originalFile, new LinkOption[0])) continue;
            Intrinsics.checkNotNull((Object)originalFile);
            Path path2 = originalFile;
            Intrinsics.checkNotNullExpressionValue((Object)processedOptionsDir.resolve(filename), (String)"resolve(...)");
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
        }
    }

    private static final Function3<CopyActionContext, Path, Path, CopyActionResult> copyAction(Set<String> skipFiles) {
        return (arg_0, arg_1, arg_2) -> OptionsDirectoryProcessor.copyAction$lambda$0(skipFiles, arg_0, arg_1, arg_2);
    }

    private static final CopyActionResult copyAction$lambda$0(Set $skipFiles, CopyActionContext copyActionContext, Path src, Path dst) {
        Intrinsics.checkNotNullParameter((Object)copyActionContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        return !$skipFiles.contains(PathsKt.getName((Path)src)) ? copyActionContext.copyToIgnoringExistingDirectory(src, dst, false) : CopyActionResult.CONTINUE;
    }

    static {
        Object[] objectArray = new String[]{"jdk.table.xml", "applicationLibraries.xml"};
        ENVIRONMENT_ASSOCIATED_FILENAMES = SetsKt.setOf((Object[])objectArray);
    }
}

