/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.YourKitProfilerService;
import com.intellij.compiler.server.BuildCommandLineBuilder;
import com.intellij.compiler.server.LocalBuildCommandLineBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.system.OS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WslBuildCommandLineBuilder
implements BuildCommandLineBuilder {
    private static final Logger LOG = Logger.getInstance(WslBuildCommandLineBuilder.class);
    private final Project myProject;
    @NotNull
    private final WSLDistribution myDistribution;
    @Nullable
    private final ProgressIndicator myProgressIndicator;
    private final GeneralCommandLine myCommandLine;
    @NotNull
    private final String myWorkingDirectory;
    @NotNull
    private final String myHostWorkingDirectory;
    @Nullable
    private final String myClasspathDirectory;
    @Nullable
    private final Path myHostClasspathDirectory;
    private static boolean CURRENT_SNAPSHOT_COPIED = false;
    private boolean myReportedProgress;

    WslBuildCommandLineBuilder(@NotNull Project project, @NotNull WSLDistribution distribution, @NotNull String sdkPath, @Nullable ProgressIndicator progressIndicator) {
        if (project == null) {
            WslBuildCommandLineBuilder.$$$reportNull$$$0(0);
        }
        if (distribution == null) {
            WslBuildCommandLineBuilder.$$$reportNull$$$0(1);
        }
        if (sdkPath == null) {
            WslBuildCommandLineBuilder.$$$reportNull$$$0(2);
        }
        this.myCommandLine = new GeneralCommandLine();
        this.myProject = project;
        this.myDistribution = distribution;
        this.myProgressIndicator = progressIndicator;
        this.myCommandLine.setExePath(sdkPath);
        Path buildDirectory = WslBuildCommandLineBuilder.getWslBuildSystemDirectory(distribution);
        if (buildDirectory == null) {
            LOG.warn("Cannot determine build directory for " + String.valueOf(distribution) + ", rolling back to LocalBuildSystemDirectory");
            this.myHostWorkingDirectory = LocalBuildCommandLineBuilder.getLocalBuildSystemDirectory().toString();
            this.myWorkingDirectory = this.myDistribution.getWslPath(this.myHostWorkingDirectory);
            LOG.warn("ClasspathDirectory and myHostClasspathDirectory set to null!");
            this.myClasspathDirectory = null;
            this.myHostClasspathDirectory = null;
        } else {
            this.myHostWorkingDirectory = buildDirectory.toString();
            this.myWorkingDirectory = this.myDistribution.getWslPath(this.myHostWorkingDirectory);
            this.myClasspathDirectory = this.myWorkingDirectory + "/jps-" + ApplicationInfo.getInstance().getBuild().asString();
            this.myHostClasspathDirectory = Path.of(this.myDistribution.getWindowsPath(this.myClasspathDirectory), new String[0]);
            if (ApplicationInfo.getInstance().getBuild().isSnapshot() && !CURRENT_SNAPSHOT_COPIED) {
                CURRENT_SNAPSHOT_COPIED = true;
                if (this.myProgressIndicator != null) {
                    this.myProgressIndicator.setText(JavaCompilerBundle.message((String)"progress.preparing.wsl.build.environment", (Object[])new Object[0]));
                    this.myReportedProgress = true;
                }
                try {
                    FileUtil.delete((Path)this.myHostClasspathDirectory);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void addParameter(@NotNull String parameter) {
        if (parameter == null) {
            WslBuildCommandLineBuilder.$$$reportNull$$$0(3);
        }
        this.myCommandLine.addParameter(parameter);
    }

    @Override
    public void addPathParameter(@NotNull String prefix, @NotNull String path) {
        if (prefix == null) {
            WslBuildCommandLineBuilder.$$$reportNull$$$0(4);
        }
        if (path == null) {
            WslBuildCommandLineBuilder.$$$reportNull$$$0(5);
        }
        this.myCommandLine.addParameter(prefix + this.myDistribution.getWslPath(path));
    }

    @Override
    public void addClasspathParameter(List<String> classpathInHost, List<String> classpathInTarget) {
        StringBuilder builder = new StringBuilder();
        this.myReportedProgress = false;
        for (String pathName : classpathInHost) {
            if (!builder.isEmpty()) {
                builder.append(":");
            }
            Path path = Path.of(pathName, new String[0]);
            if (this.myClasspathDirectory == null || this.myHostClasspathDirectory == null) continue;
            Path targetPath = this.copyProjectAgnosticPathToTargetIfRequired(path);
            if (!this.myReportedProgress && !targetPath.equals(path) && this.myProgressIndicator != null) {
                this.myProgressIndicator.setText(JavaCompilerBundle.message((String)"progress.preparing.wsl.build.environment", (Object[])new Object[0]));
                this.myReportedProgress = true;
            }
            builder.append(this.myDistribution.getWslPath(targetPath));
        }
        for (String s : classpathInTarget) {
            if (!builder.isEmpty()) {
                builder.append(":");
            }
            builder.append(this.myWorkingDirectory).append("/").append(s);
        }
        this.myCommandLine.addParameter(builder.toString());
    }

    @Override
    @NotNull
    public Path copyProjectAgnosticPathToTargetIfRequired(@NotNull Path path) {
        if (path == null) {
            WslBuildCommandLineBuilder.$$$reportNull$$$0(6);
        }
        if (this.myClasspathDirectory == null || this.myHostClasspathDirectory == null) {
            Path path2 = path;
            if (path2 == null) {
                WslBuildCommandLineBuilder.$$$reportNull$$$0(7);
            }
            return path2;
        }
        Path targetFile = this.myHostClasspathDirectory.resolve(path.getFileName());
        try {
            FileTime targetFileTimestamp;
            FileTime originalFileTimestamp = Files.getLastModifiedTime(path, new LinkOption[0]);
            try {
                targetFileTimestamp = Files.getLastModifiedTime(targetFile, new LinkOption[0]);
            }
            catch (FileNotFoundException | NoSuchFileException ignored) {
                targetFileTimestamp = null;
            }
            if (targetFileTimestamp == null || targetFileTimestamp.compareTo(originalFileTimestamp) < 0) {
                FileUtil.copyFileOrDir((File)path.toFile(), (File)targetFile.toFile());
            }
        }
        catch (IOException ignored) {
            Path path3 = path;
            if (path3 == null) {
                WslBuildCommandLineBuilder.$$$reportNull$$$0(8);
            }
            return path3;
        }
        Path path4 = targetFile;
        if (path4 == null) {
            WslBuildCommandLineBuilder.$$$reportNull$$$0(9);
        }
        return path4;
    }

    @Override
    @NotNull
    public Path getHostWorkingDirectory() {
        Path path = Path.of(this.myHostWorkingDirectory, new String[0]);
        if (path == null) {
            WslBuildCommandLineBuilder.$$$reportNull$$$0(10);
        }
        return path;
    }

    @Override
    @NotNull
    public String getWorkingDirectory() {
        String string = this.myWorkingDirectory;
        if (string == null) {
            WslBuildCommandLineBuilder.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public String getYjpAgentPath(YourKitProfilerService yourKitProfilerService) {
        return this.myWorkingDirectory + "/" + yourKitProfilerService.getYKAgentFullNameForWSL();
    }

    @Override
    public void setCharset(Charset charset) {
        this.myCommandLine.setCharset(charset);
    }

    @Override
    public void setupAdditionalVMOptions() {
        this.addParameter("-Djps.in.wsl=true");
    }

    @Override
    public GeneralCommandLine buildCommandLine() throws ExecutionException {
        WSLCommandLineOptions options = new WSLCommandLineOptions();
        options.setRemoteWorkingDirectory(this.myWorkingDirectory);
        this.myDistribution.patchCommandLine(this.myCommandLine, this.myProject, options);
        return this.myCommandLine;
    }

    @Override
    public void setUnixProcessPriority(int priority) {
        LocalBuildCommandLineBuilder.setUnixProcessPriority(this.myCommandLine, priority);
    }

    @Nullable
    public static Path getWslBuildSystemDirectory(WSLDistribution distribution) {
        Object pathsSelector = PathManager.getPathsSelector();
        String wslUserHome = distribution.getUserHome();
        if (wslUserHome == null) {
            return null;
        }
        String windowsUserHomePath = distribution.getWindowsPath(wslUserHome);
        if (pathsSelector == null) {
            pathsSelector = "." + ApplicationNamesInfo.getInstance().getScriptName();
        }
        String workingDirectory = PathManager.getDefaultSystemPathFor((OS)OS.Linux, (String)windowsUserHomePath, (String)pathsSelector) + "/compile-server";
        return Path.of(workingDirectory, new String[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/server/WslBuildCommandLineBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/server/WslBuildCommandLineBuilder";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyProjectAgnosticPathToTargetIfRequired";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostWorkingDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPathParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyProjectAgnosticPathToTargetIfRequired";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

