/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server.impl;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.google.common.collect.HashBiMap;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.CompileServerPlugin;
import com.intellij.compiler.server.impl.BuildProcessClasspathManagerKt;
import com.intellij.diagnostic.Activity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.diagnostic.telemetry.TracerLevel;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializers;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.full.NoSuchPropertyException;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/compiler/server/impl/BuildProcessClasspathManager;", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "compileServerPluginsClasspath", "", "", "lastClasspathLock", "lastRawClasspath", "lastFilteredClasspath", "getBuildProcessClasspath", "project", "Lcom/intellij/openapi/project/Project;", "getAdditionalApplicationClasspath", "getBuildProcessPluginsClasspath", "staticClasspath", "getStaticClasspath", "()Ljava/util/List;", "Companion", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nBuildProcessClasspathManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildProcessClasspathManager.kt\ncom/intellij/compiler/server/impl/BuildProcessClasspathManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1480#2,2:280\n1915#2,2:282\n1482#2,3:284\n*S KotlinDebug\n*F\n+ 1 BuildProcessClasspathManager.kt\ncom/intellij/compiler/server/impl/BuildProcessClasspathManager\n*L\n99#1:280,2\n102#1:282,2\n99#1:284,3\n*E\n"})
public final class BuildProcessClasspathManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile List<String> compileServerPluginsClasspath;
    @NotNull
    private final Object lastClasspathLock;
    @Nullable
    private List<String> lastRawClasspath;
    @Nullable
    private List<String> lastFilteredClasspath;

    public BuildProcessClasspathManager(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.lastClasspathLock = new Object();
        CompileServerPlugin.EP_NAME.addChangeListener(() -> BuildProcessClasspathManager._init_$lambda$0(this), parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> getBuildProcessClasspath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection collection = ClasspathBootstrap.getBuildProcessApplicationClasspath();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getBuildProcessApplicationClasspath(...)");
        List appClassPath = CollectionsKt.plus((Collection)collection, (Iterable)this.getAdditionalApplicationClasspath());
        List<String> pluginClassPath = this.getBuildProcessPluginsClasspath(project);
        List rawClasspath = CollectionsKt.plus((Collection)appClassPath, (Iterable)pluginClassPath);
        Object object = this.lastClasspathLock;
        synchronized (object) {
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)rawClasspath, this.lastRawClasspath)) {
                if (BuildProcessClasspathManagerKt.access$getLOG$p().isDebugEnabled()) {
                    BuildProcessClasspathManagerKt.access$getLOG$p().debug("buildProcessAppClassPath: " + appClassPath);
                    BuildProcessClasspathManagerKt.access$getLOG$p().debug("buildProcessPluginClassPath: " + pluginClassPath);
                }
                this.lastRawClasspath = rawClasspath;
                this.lastFilteredClasspath = BuildProcessClasspathManagerKt.access$filterOutOlderVersions(rawClasspath);
                if (BuildProcessClasspathManagerKt.access$getLOG$p().isDebugEnabled() && !Intrinsics.areEqual(this.lastRawClasspath, this.lastFilteredClasspath)) {
                    BuildProcessClasspathManagerKt.access$getLOG$p().debug("older versions of libraries were removed from classpath:");
                    BuildProcessClasspathManagerKt.access$getLOG$p().debug("original classpath: " + this.lastRawClasspath);
                    BuildProcessClasspathManagerKt.access$getLOG$p().debug("actual classpath: " + this.lastFilteredClasspath);
                }
            }
            List<String> list = this.lastFilteredClasspath;
            Intrinsics.checkNotNull(list);
            List<String> list2 = list;
            return list2;
        }
    }

    private final List<String> getAdditionalApplicationClasspath() {
        List list;
        if (Registry.Companion.is("jps.build.use.workspace.model")) {
            Object[] objectArray = new String[10];
            Intrinsics.checkNotNull((Object)PathManager.getJarPathForClass(WorkspaceEntity.class));
            Intrinsics.checkNotNull((Object)PathManager.getJarPathForClass(JpsProjectSerializers.class));
            Intrinsics.checkNotNull((Object)PathManager.getJarPathForClass(TracerLevel.class));
            Intrinsics.checkNotNull((Object)PathManager.getJarPathForClass(Activity.class));
            Intrinsics.checkNotNull((Object)PathManager.getJarPathForClass(HashBiMap.class));
            Intrinsics.checkNotNull((Object)PathManager.getJarPathForClass(CoroutineScope.class));
            Intrinsics.checkNotNull((Object)PathManager.getJarPathForClass(NoSuchPropertyException.class));
            Intrinsics.checkNotNull((Object)PathManager.getJarPathForClass(OpenTelemetry.class));
            Intrinsics.checkNotNull((Object)PathManager.getJarPathForClass(ContextPropagators.class));
            Intrinsics.checkNotNull((Object)PathManager.getJarPathForClass(Kryo.class));
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public final List<String> getBuildProcessPluginsClasspath(@NotNull Project project) {
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = BuildProcessParametersProvider.EP_NAME.getExtensions((AreaInstance)project);
        Collection destination$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Iterable<String> classPath;
            BuildProcessParametersProvider parametersProvider = (BuildProcessParametersProvider)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(parametersProvider.getClassPath(), (String)"getClassPath(...)");
            if (BuildProcessClasspathManagerKt.access$getLOG$p().isTraceEnabled()) {
                Iterable<String> $this$forEach$iv = classPath;
                boolean $i$f$forEach = false;
                Iterator<String> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    String element$iv2;
                    String path = element$iv2 = iterator.next();
                    boolean bl2 = false;
                    BuildProcessClasspathManagerKt.access$getLOG$p().trace(path + " added to classpath from " + parametersProvider.getClass().getName());
                }
            }
            Iterable<String> list$iv = classPath;
            CollectionsKt.addAll((Collection)destination$iv, list$iv);
        }
        ArrayList dynamicClasspath = (ArrayList)destination$iv;
        if (dynamicClasspath.isEmpty()) {
            return this.getStaticClasspath();
        }
        dynamicClasspath.addAll((Collection)this.getStaticClasspath());
        return dynamicClasspath;
    }

    private final List<String> getStaticClasspath() {
        List classpath = this.compileServerPluginsClasspath;
        if (classpath == null) {
            this.compileServerPluginsClasspath = classpath = BuildProcessClasspathManagerKt.access$computeCompileServerPluginsClasspath();
        }
        return classpath;
    }

    private static final void _init_$lambda$0(BuildProcessClasspathManager this$0) {
        this$0.compileServerPluginsClasspath = null;
    }

    @JvmStatic
    @NotNull
    public static final List<String> getLauncherClasspath(@NotNull Project project) {
        return Companion.getLauncherClasspath(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/compiler/server/impl/BuildProcessClasspathManager$Companion;", "", "<init>", "()V", "filterOutOlderVersionsForTests", "", "", "classpath", "getLauncherClasspath", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.compiler.impl"})
    @SourceDebugExtension(value={"SMAP\nBuildProcessClasspathManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildProcessClasspathManager.kt\ncom/intellij/compiler/server/impl/BuildProcessClasspathManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1391#2:280\n1480#2,5:281\n*S KotlinDebug\n*F\n+ 1 BuildProcessClasspathManager.kt\ncom/intellij/compiler/server/impl/BuildProcessClasspathManager$Companion\n*L\n133#1:280\n133#1:281,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @NotNull
        public final List<String> filterOutOlderVersionsForTests(@NotNull List<String> classpath) {
            Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
            return BuildProcessClasspathManagerKt.access$filterOutOlderVersions(classpath);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<String> getLauncherClasspath(@NotNull Project project) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable $this$flatMap$iv = BuildProcessParametersProvider.EP_NAME.getExtensions((AreaInstance)project);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Iterable<String> list$iv$iv;
                BuildProcessParametersProvider it = (BuildProcessParametersProvider)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it.getLauncherClassPath(), (String)"getLauncherClassPath(...)");
                CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

