/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectionValidatorUtil {
    private InspectionValidatorUtil() {
    }

    public static void addDescriptor(@NotNull Collection<? super VirtualFile> result, @Nullable ConfigFile configFile) {
        if (result == null) {
            InspectionValidatorUtil.$$$reportNull$$$0(0);
        }
        if (configFile != null) {
            ContainerUtil.addIfNotNull(result, (Object)configFile.getVirtualFile());
        }
    }

    public static void addFile(@NotNull Collection<? super VirtualFile> result, @Nullable PsiFile psiFile) {
        if (result == null) {
            InspectionValidatorUtil.$$$reportNull$$$0(1);
        }
        if (psiFile != null) {
            ContainerUtil.addIfNotNull(result, (Object)psiFile.getVirtualFile());
        }
    }

    public static Collection<VirtualFile> expandCompileScopeIfNeeded(Collection<VirtualFile> result, CompileContext context) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        HashSet<VirtualFile> set = new HashSet<VirtualFile>();
        HashSet modules = new HashSet();
        for (VirtualFile file : result) {
            if (index.getSourceRootForFile(file) != null) continue;
            set.add(file);
            ContainerUtil.addIfNotNull(modules, (Object)index.getModuleForFile(file));
        }
        if (!set.isEmpty()) {
            ((CompileContextEx)context).addScope(new FileSetCompileScope(set, modules.toArray(Module.EMPTY_ARRAY)));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "result";
        objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidatorUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

