/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.project.PackagingModifiableModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleSourcePackagingElement;
import com.intellij.packaging.impl.elements.TestModuleOutputPackagingElement;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JN\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u00130\u0012H\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/ArtifactsImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "<init>", "()V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "populateArtifact", "element", "Lcom/intellij/packaging/elements/CompositePackagingElement;", "config", "", "postponedOps", "", "Lkotlin/Function1;", "Lcom/intellij/packaging/artifacts/ModifiableArtifactModel;", "findLibraryByNameSuffix", "Lcom/intellij/openapi/roots/libraries/Library;", "nameSuffix", "", "Companion", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nArtifactsImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactsImporter.kt\ncom/intellij/openapi/externalSystem/service/project/settings/ArtifactsImporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1915#2:213\n1916#2:215\n1915#2,2:216\n1915#2,2:218\n1915#2,2:220\n1915#2,2:222\n1915#2,2:224\n1915#2,2:226\n1#3:214\n*S KotlinDebug\n*F\n+ 1 ArtifactsImporter.kt\ncom/intellij/openapi/externalSystem/service/project/settings/ArtifactsImporter\n*L\n50#1:213\n50#1:215\n63#1:216,2\n114#1:218,2\n134#1:220,2\n143#1:222,2\n152#1:224,2\n94#1:226,2\n*E\n"})
public final class ArtifactsImporter
implements ConfigurationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    /*
     * Unable to fully structure code
     */
    public void apply(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        var6_4 = configuration.find("ideArtifacts");
        v0 = var6_4 instanceof List != false ? (List)var6_4 : null;
        if (v0 == null) {
            return;
        }
        artifacts = v0;
        if (artifacts.isEmpty()) {
            return;
        }
        v1 = modelsProvider.getModifiableModel(PackagingModifiableModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getModifiableModel(...)");
        packagingModifiableModel = (PackagingModifiableModel)v1;
        v2 = packagingModifiableModel.getModifiableArtifactModel();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getModifiableArtifactModel(...)");
        modifiableModel = v2;
        postponedOps = new ArrayList<E>();
        $this$forEach$iv = artifacts;
        $i$f$forEach = false;
        var10_10 = $this$forEach$iv.iterator();
        while (var10_10.hasNext()) {
            value = element$iv = var10_10.next();
            $i$a$-forEach-ArtifactsImporter$apply$1 = false;
            v3 = value instanceof Map != false ? (Map)value : null;
            if (v3 == null || !((name = (artifactConfig = v3).get("name")) instanceof String)) continue;
            v4 = PlainArtifactType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getInstance(...)");
            type = v4;
            var17_17 = modifiableModel.findArtifact((String)name);
            if (var17_17 == null) ** GOTO lbl-1000
            it = var17_17;
            $i$a$-let-ArtifactsImporter$apply$1$artifact$1 = false;
            var20_20 = modifiableModel.getOrCreateModifiableArtifact(it);
            if (var20_20 != null) {
                v5 = var20_20;
            } else lbl-1000:
            // 2 sources

            {
                v6 = modifiableModel.addArtifact((String)name, type);
                v5 = v6;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"addArtifact(...)");
            }
            artifact = v5;
            Intrinsics.checkNotNullExpressionValue((Object)type.createRootElement((String)name), (String)"createRootElement(...)");
            this.populateArtifact(project, modelsProvider, rootElement, artifactConfig, postponedOps);
            artifact.setRootElement(rootElement);
        }
        $this$forEach$iv = postponedOps;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (Function1)element$iv;
            $i$a$-forEach-ArtifactsImporter$apply$2 = false;
            it.invoke((Object)modifiableModel);
        }
    }

    private final void populateArtifact(Project project, IdeModifiableModelsProvider modelsProvider, CompositePackagingElement<?> element, Map<?, ?> config, List<Function1<ModifiableArtifactModel, Unit>> postponedOps) {
        ObjectUtils.consumeIfCast(config.get("children"), List.class, arg_0 -> ArtifactsImporter.populateArtifact$lambda$1(arg_0 -> ArtifactsImporter.populateArtifact$lambda$0(this, project, modelsProvider, postponedOps, element, arg_0), arg_0));
    }

    private final Library findLibraryByNameSuffix(Project $this$findLibraryByNameSuffix, String nameSuffix) {
        Object object;
        block1: {
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable($this$findLibraryByNameSuffix);
            Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
            LibraryTable libraryTable2 = libraryTable;
            Library[] libraryArray = libraryTable2.getLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getLibraries(...)");
            for (Object object2 : (Object[])libraryArray) {
                Library it = (Library)object2;
                boolean bl = false;
                String string = it.getName();
                if (!(string != null ? StringsKt.endsWith$default((String)string, (String)nameSuffix, (boolean)false, (int)2, null) : false)) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (Library)object;
    }

    private static final Unit populateArtifact$lambda$0$0$0$0$0$0(ArtifactsImporter this$0, Project $project, CompositePackagingElement $element, Map library) {
        block0: {
            Intrinsics.checkNotNull((Object)library);
            String nameSuffix = library.get("group") + ":" + library.get("artifact") + ":" + library.get("version");
            Library library2 = this$0.findLibraryByNameSuffix($project, nameSuffix);
            if (library2 == null) break block0;
            Library it = library2;
            boolean bl = false;
            LibraryPackagingElement libraryClasses = new LibraryPackagingElement("project", it.getName(), null);
            $element.addOrFindChild((PackagingElement)libraryClasses);
        }
        return Unit.INSTANCE;
    }

    private static final void populateArtifact$lambda$0$0$0$0$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit populateArtifact$lambda$0$0$0$0(ArtifactsImporter this$0, Project $project, CompositePackagingElement $element, List it) {
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$forEach$iv = it;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object libraryCoordinates = element$iv = iterator.next();
            boolean bl = false;
            ObjectUtils.consumeIfCast(libraryCoordinates, Map.class, arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$0$0$1(arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$0$0$0(this$0, $project, $element, arg_0), arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final void populateArtifact$lambda$0$0$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final PackagingElement populateArtifact$lambda$0$0$0$2(Project $project, ModulePointer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProductionModuleOutputPackagingElement($project, it);
    }

    private static final PackagingElement populateArtifact$lambda$0$0$0$3(Project $project, ModulePointer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new TestModuleOutputPackagingElement($project, it);
    }

    private static final PackagingElement populateArtifact$lambda$0$0$0$4(Project $project, ModulePointer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProductionModuleSourcePackagingElement($project, it);
    }

    private static final Unit populateArtifact$lambda$0$0$0$5(CompositePackagingElement $element, List it) {
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$forEach$iv = CollectionsKt.filterIsInstance((Iterable)it, String.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path = (String)element$iv;
            boolean bl = false;
            FileCopyPackagingElement fileCopy = new FileCopyPackagingElement(path);
            $element.addOrFindChild((PackagingElement)fileCopy);
        }
        return Unit.INSTANCE;
    }

    private static final void populateArtifact$lambda$0$0$0$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit populateArtifact$lambda$0$0$0$7(CompositePackagingElement $element, List it) {
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$forEach$iv = CollectionsKt.filterIsInstance((Iterable)it, String.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path = (String)element$iv;
            boolean bl = false;
            DirectoryCopyPackagingElement dirCopy = new DirectoryCopyPackagingElement(path);
            $element.addOrFindChild((PackagingElement)dirCopy);
        }
        return Unit.INSTANCE;
    }

    private static final void populateArtifact$lambda$0$0$0$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit populateArtifact$lambda$0$0$0$9(CompositePackagingElement $element, List it) {
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$forEach$iv = CollectionsKt.filterIsInstance((Iterable)it, String.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path = (String)element$iv;
            boolean bl = false;
            ExtractedDirectoryPackagingElement fileCopy = new ExtractedDirectoryPackagingElement(path, "/");
            $element.addOrFindChild((PackagingElement)fileCopy);
        }
        return Unit.INSTANCE;
    }

    private static final void populateArtifact$lambda$0$0$0$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit populateArtifact$lambda$0$0$0$11(String $artifactName, Project $project, CompositePackagingElement $element, ModifiableArtifactModel model) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Artifact artifact = model.findArtifact($artifactName);
            if (artifact == null) break block0;
            Artifact it = artifact;
            boolean bl = false;
            ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)$project).createPointer(it);
            ArtifactPackagingElement artifactRef = new ArtifactPackagingElement($project, pointer);
            $element.addOrFindChild((PackagingElement)artifactRef);
        }
        return Unit.INSTANCE;
    }

    private static final Unit populateArtifact$lambda$0$0$0(ArtifactsImporter this$0, Project $project, IdeModifiableModelsProvider $modelsProvider, List $postponedOps, CompositePackagingElement $element, Map config) {
        String type;
        Intrinsics.checkNotNull((Object)config);
        Object v = config.get("type");
        String string = v instanceof String ? (String)v : null;
        if (string == null) {
            return Unit.INSTANCE;
        }
        switch (type = string) {
            case "DIR": {
                Object v2 = config.get("name");
                String string2 = v2 instanceof String ? (String)v2 : null;
                if (string2 == null) {
                    string2 = "no_name";
                }
                DirectoryPackagingElement directory = new DirectoryPackagingElement(string2);
                this$0.populateArtifact($project, $modelsProvider, directory, config, $postponedOps);
                $element.addOrFindChild((PackagingElement)directory);
                break;
            }
            case "ARCHIVE": {
                Object v3 = config.get("name");
                String string3 = v3 instanceof String ? (String)v3 : null;
                if (string3 == null) {
                    string3 = "no_name";
                }
                ArchivePackagingElement archive = new ArchivePackagingElement(string3);
                this$0.populateArtifact($project, $modelsProvider, archive, config, $postponedOps);
                $element.addOrFindChild((PackagingElement)archive);
                break;
            }
            case "LIBRARY_FILES": {
                ObjectUtils.consumeIfCast(config.get("libraries"), List.class, arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$1(arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$0(this$0, $project, $element, arg_0), arg_0));
                break;
            }
            case "MODULE_OUTPUT": {
                ArtifactsImporter.populateArtifact$addModuleElement($element, $modelsProvider, $project, config, arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$2($project, arg_0));
                break;
            }
            case "MODULE_TEST_OUTPUT": {
                ArtifactsImporter.populateArtifact$addModuleElement($element, $modelsProvider, $project, config, arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$3($project, arg_0));
                break;
            }
            case "MODULE_SRC": {
                ArtifactsImporter.populateArtifact$addModuleElement($element, $modelsProvider, $project, config, arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$4($project, arg_0));
                break;
            }
            case "FILE": {
                ObjectUtils.consumeIfCast(config.get("sourceFiles"), List.class, arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$6(arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$5($element, arg_0), arg_0));
                break;
            }
            case "DIR_CONTENT": {
                ObjectUtils.consumeIfCast(config.get("sourceFiles"), List.class, arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$8(arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$7($element, arg_0), arg_0));
                break;
            }
            case "EXTRACTED_DIR": {
                ObjectUtils.consumeIfCast(config.get("sourceFiles"), List.class, arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$10(arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$9($element, arg_0), arg_0));
                break;
            }
            case "ARTIFACT_REF": {
                Object v4 = config.get("artifactName");
                String string4 = v4 instanceof String ? (String)v4 : null;
                if (string4 == null) {
                    return Unit.INSTANCE;
                }
                String artifactName = string4;
                $postponedOps.add(arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0$11(artifactName, $project, $element, arg_0));
                break;
            }
            default: {
                LOG.warn("Artifact `" + $element.getName() + "`: unsupported artifact type `" + type + "` in " + config);
            }
            case "ARTIFACT": 
        }
        return Unit.INSTANCE;
    }

    private static final void populateArtifact$lambda$0$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final ModulePointer populateArtifact$createModulePointer(IdeModifiableModelsProvider $modelsProvider, Project $project, CompositePackagingElement<?> $element, String moduleName) {
        ModulePointer modulePointer;
        Module module = $modelsProvider.findIdeModule(moduleName);
        if (module != null) {
            ModulePointer modulePointer2 = ModulePointerManager.getInstance((Project)$project).create(module);
            Intrinsics.checkNotNull((Object)modulePointer2);
            modulePointer = modulePointer2;
        } else {
            LOG.warn("Artifact `" + $element.getName() + "`: unable to find module `" + moduleName + "`");
            ModulePointer modulePointer3 = ModulePointerManager.getInstance((Project)$project).create(moduleName);
            Intrinsics.checkNotNull((Object)modulePointer3);
            modulePointer = modulePointer3;
        }
        return modulePointer;
    }

    private static final void populateArtifact$addModuleElement(CompositePackagingElement<?> $element, IdeModifiableModelsProvider $modelsProvider, Project $project, Map<?, ?> config, Function1<? super ModulePointer, ? extends PackagingElement<?>> provider) {
        String moduleName;
        Object obj = config.get("moduleName");
        String string = moduleName = obj instanceof String ? (String)obj : null;
        if (moduleName == null) {
            LOG.warn("Artifact `" + $element.getName() + "`: moduleName missed for " + config);
            return;
        }
        ModulePointer modulePointer = ArtifactsImporter.populateArtifact$createModulePointer($modelsProvider, $project, $element, moduleName);
        PackagingElement child = (PackagingElement)provider.invoke((Object)modulePointer);
        $element.addOrFindChild(child);
    }

    private static final Unit populateArtifact$lambda$0(ArtifactsImporter this$0, Project $project, IdeModifiableModelsProvider $modelsProvider, List $postponedOps, CompositePackagingElement $element, List children) {
        Intrinsics.checkNotNull((Object)children);
        Iterable $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object child = element$iv = iterator.next();
            boolean bl = false;
            ObjectUtils.consumeIfCast(child, Map.class, arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$1(arg_0 -> ArtifactsImporter.populateArtifact$lambda$0$0$0(this$0, $project, $modelsProvider, $postponedOps, $element, arg_0), arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final void populateArtifact$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(ArtifactsImporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/ArtifactsImporter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.java.compiler.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

